/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.webview;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.webview.MacWebView;
import gov.nasa.worldwind.util.webview.WebView;
import gov.nasa.worldwind.util.webview.WebViewFactory;
import gov.nasa.worldwind.util.webview.WindowsWebView;
import java.awt.Dimension;

public class BasicWebViewFactory
implements WebViewFactory {
    @Override
    public WebView createWebView(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (Configuration.isLinuxOS()) {
            return this.createLinuxWebView(dimension);
        }
        if (Configuration.isMacOS()) {
            return this.createMacWebView(dimension);
        }
        if (Configuration.isWindowsOS()) {
            return this.createWindowsWebView(dimension);
        }
        return this.createUnknownOSWebView(dimension);
    }

    protected WebView createLinuxWebView(Dimension dimension) {
        return this.createUnknownOSWebView(dimension);
    }

    protected WebView createMacWebView(Dimension dimension) {
        return new MacWebView(dimension);
    }

    protected WebView createWindowsWebView(Dimension dimension) {
        return new WindowsWebView(dimension);
    }

    protected WebView createUnknownOSWebView(Dimension dimension) {
        String string = Logging.getMessage("NativeLib.UnsupportedOperatingSystem", "WebView", System.getProperty("os.name"));
        Logging.logger().severe(string);
        throw new UnsupportedOperationException(string);
    }
}

