/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.gdal;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.gdal.GDALAbstractFileFilter;
import java.io.File;

class GDALLibraryFinder
extends GDALAbstractFileFilter {
    protected final String libExtension = Configuration.isWindowsOS() ? ".dll" : (Configuration.isMacOS() ? ".jnilib" : ".so");

    public GDALLibraryFinder() {
        super("gdal");
    }

    public GDALLibraryFinder(String string) {
        super(string);
    }

    @Override
    public boolean accept(File file) {
        String string;
        String string2;
        if (null != file && !this.isHidden(file.getAbsolutePath()) && null != (string2 = file.getParent()) && !this.listFolders.contains(string2) && null != (string = file.getName()) && !string.startsWith(".") && null != (string = string.toLowerCase()) && string.contains(this.searchPattern) && string.endsWith(this.libExtension)) {
            this.listFolders.add(string2);
            return true;
        }
        Thread.yield();
        return false;
    }

    protected boolean canLoad(String string) {
        try {
            System.load(string);
            return true;
        }
        catch (Throwable throwable) {
            Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
            return false;
        }
    }
}

