/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.ScreenCredit;
import gov.nasa.worldwind.render.ScreenCreditImage;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class WWXML {
    public static final String XLINK_URI = "http://www.w3.org/1999/xlink";

    public static DocumentBuilder createDocumentBuilder(boolean bl) {
        String string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(bl);
        if ((double)Configuration.getJavaVersion() >= 1.6) {
            try {
                documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                string = Logging.getMessage("XML.NonvalidatingNotSupported");
                Logging.logger().finest(string);
            }
        }
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            string = Logging.getMessage("XML.ParserConfigurationException");
            Logging.logger().finest(string);
            throw new WWRuntimeException(parserConfigurationException);
        }
    }

    public static Transformer createTransformer() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            return transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string = Logging.getMessage("XML.TransformerConfigurationException");
            Logging.logger().finest(string);
            throw new WWRuntimeException(transformerConfigurationException);
        }
    }

    public static Document openDocument(Object object) {
        if (object == null || WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            throw new IllegalArgumentException(string);
        }
        if (object instanceof URL) {
            return WWXML.openDocumentURL((URL)object);
        }
        if (object instanceof InputStream) {
            return WWXML.openDocumentStream((InputStream)object);
        }
        if (object instanceof File) {
            return WWXML.openDocumentFile(((File)object).getPath(), null);
        }
        if (!(object instanceof String)) {
            String string = Logging.getMessage("generic.UnrecognizedSourceType", object.toString());
            throw new IllegalArgumentException(string);
        }
        String string = (String)object;
        URL uRL = WWIO.makeURL(string);
        if (uRL != null) {
            return WWXML.openDocumentURL(uRL);
        }
        return WWXML.openDocumentFile(string, null);
    }

    public static Document openDocumentFile(String string, Class clazz) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            throw new IllegalArgumentException(string2);
        }
        InputStream inputStream = WWIO.openFileOrResourceStream(string, clazz);
        return inputStream != null ? WWXML.openDocumentStream(inputStream) : null;
    }

    public static Document openDocumentURL(URL uRL) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            throw new IllegalArgumentException(string);
        }
        try {
            InputStream inputStream = uRL.openStream();
            return WWXML.openDocumentStream(inputStream);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToParseXml", uRL.toString());
            throw new WWRuntimeException(string, iOException);
        }
    }

    public static Document openDocumentStream(InputStream inputStream) {
        return WWXML.openDocumentStream(inputStream, true);
    }

    public static Document openDocumentStream(InputStream inputStream, boolean bl) {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            throw new IllegalArgumentException(string);
        }
        try {
            return WWXML.createDocumentBuilder(bl).parse(inputStream);
        }
        catch (SAXException sAXException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToParseXml", inputStream);
            throw new WWRuntimeException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToParseXml", inputStream);
            throw new WWRuntimeException(string, iOException);
        }
    }

    public static void saveDocumentToFile(Document document, String string) {
        if (document == null) {
            String string2 = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            WWXML.saveDocumentToStream(document, fileOutputStream);
        }
        catch (IOException iOException) {
            String string4 = Logging.getMessage("generic.ExceptionAttemptingToWriteXml", string);
            Logging.logger().severe(string4);
            throw new WWRuntimeException(iOException);
        }
    }

    public static void saveDocumentToStream(Document document, OutputStream outputStream) {
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (outputStream == null) {
            String string = Logging.getMessage("nullValue.OutputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        try {
            Transformer transformer = WWXML.createTransformer();
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToWriteXml", outputStream);
            Logging.logger().severe(string);
            throw new WWRuntimeException(transformerException);
        }
    }

    public static XMLEventReader openEventReaderStream(InputStream inputStream, boolean bl) {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isNamespaceAware", bl);
        xMLInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            return xMLInputFactory.createXMLEventReader(inputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToParseXml", inputStream);
            throw new WWRuntimeException(string, xMLStreamException);
        }
    }

    public static XMLEventReader openEventReaderStream(InputStream inputStream) {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWXML.openEventReaderStream(inputStream, true);
    }

    public static XMLEventReader openEventReaderFile(String string, Class clazz, boolean bl) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        InputStream inputStream = WWIO.openFileOrResourceStream(string, clazz);
        return inputStream != null ? WWXML.openEventReaderStream(inputStream, bl) : null;
    }

    public static XMLEventReader openEventReaderURL(URL uRL, boolean bl) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            InputStream inputStream = uRL.openStream();
            return WWXML.openEventReaderStream(inputStream, bl);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToParseXml", uRL.toString());
            throw new WWRuntimeException(string, iOException);
        }
    }

    public static XMLEventReader openEventReader(Object object) {
        return WWXML.openEventReader(object, true);
    }

    public static XMLEventReader openEventReader(Object object, boolean bl) {
        if (object == null || WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object instanceof URL) {
            return WWXML.openEventReaderURL((URL)object, bl);
        }
        if (object instanceof InputStream) {
            return WWXML.openEventReaderStream((InputStream)object, bl);
        }
        if (object instanceof File) {
            return WWXML.openEventReaderFile(((File)object).getPath(), null, bl);
        }
        if (object instanceof ByteBuffer) {
            InputStream inputStream = WWIO.getInputStreamFromByteBuffer((ByteBuffer)object);
            return WWXML.openEventReaderStream(inputStream, bl);
        }
        if (!(object instanceof String)) {
            String string = Logging.getMessage("generic.UnrecognizedSourceType", object.toString());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = (String)object;
        URL uRL = WWIO.makeURL(string);
        if (uRL != null) {
            return WWXML.openEventReaderURL(uRL, bl);
        }
        return WWXML.openEventReaderFile(string, null, bl);
    }

    public static void closeEventReader(XMLEventReader xMLEventReader, String string) {
        if (xMLEventReader == null) {
            return;
        }
        try {
            xMLEventReader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            String string2 = Logging.getMessage("generic.ExceptionClosingXmlEventReader", string != null ? string : "Unknown");
            Logging.logger().severe(string2);
        }
    }

    public static XMLStreamWriter openStreamWriter(Object object) throws XMLStreamException {
        if (object == null) {
            String string = Logging.getMessage("nullValue.OutputIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object instanceof OutputStream) {
            return XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)object);
        }
        if (object instanceof Writer) {
            return XMLOutputFactory.newInstance().createXMLStreamWriter((Writer)object);
        }
        return null;
    }

    public static StartElement nextStartElementEvent(XMLEventReader xMLEventReader) {
        if (xMLEventReader == null) {
            String string = Logging.getMessage("nullValue.EventReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            XMLEvent xMLEvent = null;
            while (xMLEventReader.hasNext() && ((xMLEvent = xMLEventReader.nextEvent()) == null || !xMLEvent.isStartElement())) {
            }
            return xMLEvent != null && xMLEvent.isStartElement() ? (StartElement)xMLEvent : null;
        }
        catch (XMLStreamException xMLStreamException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToParseXml", xMLEventReader);
            Logging.logger().finest(string);
            return null;
        }
    }

    public static String readCharacters(XMLEventReader xMLEventReader) {
        if (xMLEventReader == null) {
            String string = Logging.getMessage("nullValue.EventReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n = 0;
            while (xMLEventReader.hasNext()) {
                XMLEvent xMLEvent = xMLEventReader.peek();
                if (xMLEvent.isStartElement()) {
                    ++n;
                    xMLEventReader.nextEvent();
                    continue;
                }
                if (xMLEvent.isEndElement()) {
                    if (--n > 0) {
                        xMLEventReader.nextEvent();
                        continue;
                    }
                    break;
                }
                if (xMLEvent.isCharacters()) {
                    Characters characters = xMLEventReader.nextEvent().asCharacters();
                    if (characters.isWhiteSpace()) continue;
                    stringBuilder.append(characters.getData());
                    continue;
                }
                xMLEventReader.nextEvent();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToParseXml", xMLEventReader);
            Logging.logger().finest(string);
        }
        return stringBuilder.toString();
    }

    public static XPath makeXPath() {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        return xPathFactory.newXPath();
    }

    public static String checkOGCException(Document document) {
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            XPath xPath = WWXML.makeXPath();
            String string = xPath.evaluate("ServiceExceptionReport", document);
            if (string == null || string.length() == 0) {
                return null;
            }
            return xPath.evaluate("ServiceExceptionReport/ServiceException/text()", document);
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("XML.XPathExpressionException");
            Logging.logger().warning(string);
            return null;
        }
    }

    public static String extractOGCServiceException(ByteBuffer byteBuffer) {
        return null;
    }

    public static String getUnqualifiedName(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return element.getLocalName() != null ? element.getLocalName() : element.getTagName();
    }

    public static String getUnqalifiedName(StartElement startElement) {
        if (startElement == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return startElement.getName() != null ? startElement.getName().getLocalPart() : null;
    }

    public static String getText(Element element, String string) {
        return WWXML.getText(element, string, null);
    }

    public static String getText(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        try {
            return xPath.evaluate(string, element);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String[] getTextArray(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        try {
            NodeList nodeList = (NodeList)xPath.evaluate(string, element, XPathConstants.NODESET);
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            String[] stringArray = new String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                stringArray[i] = nodeList.item(i).getTextContent();
            }
            return stringArray;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String[] getUniqueText(Element element, String string, XPath xPath) {
        String[] stringArray;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        if ((stringArray = WWXML.getTextArray(element, string, xPath)) == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : stringArray) {
            if (arrayList.contains(string4)) continue;
            arrayList.add(string4);
        }
        return arrayList.toArray(new String[1]);
    }

    public static Element getElement(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        try {
            Node node = (Node)xPath.evaluate(string, element, XPathConstants.NODE);
            if (node == null) {
                return null;
            }
            return node instanceof Element ? (Element)node : null;
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string4 = Logging.getMessage("XML.InvalidXPathExpression", "internal expression");
            Logging.logger().log(Level.WARNING, string4, xPathExpressionException);
            return null;
        }
    }

    public static Element[] getElements(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        try {
            NodeList nodeList = (NodeList)xPath.evaluate(string, element, XPathConstants.NODESET);
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            Element[] elementArray = new Element[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                elementArray[i] = (Element)node;
            }
            return elementArray;
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string4 = Logging.getMessage("XML.InvalidXPathExpression", "internal expression");
            Logging.logger().log(Level.WARNING, string4, xPathExpressionException);
            return null;
        }
    }

    public static Element[] getUniqueElements(Element element, String string, String string2, XPath xPath) {
        Element[] elementArray;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            String string5 = Logging.getMessage("nullValue.UniqueTagIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        if ((elementArray = WWXML.getElements(element, string, xPath)) == null) {
            return null;
        }
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        for (Element element2 : elementArray) {
            String string6 = WWXML.getText(element2, string2, xPath);
            if (string6 == null) continue;
            hashMap.put(string6, element2);
        }
        return hashMap.values().toArray(new Element[1]);
    }

    public static Double getDouble(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = null;
        try {
            string4 = WWXML.getText(element, string, xPath);
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            return Double.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static Integer getInteger(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = null;
        try {
            string4 = WWXML.getText(element, string, xPath);
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            return Integer.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static Long getLong(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = null;
        try {
            string4 = WWXML.getText(element, string, xPath);
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            return Long.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static Boolean getBoolean(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = null;
        try {
            string4 = WWXML.getText(element, string, xPath);
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            return Boolean.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static LatLon getLatLon(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            Element element2;
            Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
            if (element2 == null) {
                return null;
            }
            String string3 = WWXML.getText(element2, "@units", xPath);
            Double d = WWXML.getDouble(element2, "@latitude", xPath);
            Double d2 = WWXML.getDouble(element2, "@longitude", xPath);
            if (d == null || d2 == null) {
                return null;
            }
            if (string3 == null || string3.equals("degrees")) {
                return LatLon.fromDegrees(d, d2);
            }
            if (string3.equals("radians")) {
                return LatLon.fromRadians(d, d2);
            }
            String string4 = Logging.getMessage("XML.UnitsUnrecognized", string3);
            Logging.logger().warning(string4);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static Color getColor(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            Element element2;
            Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
            if (element2 == null) {
                return null;
            }
            Integer n = WWXML.getInteger(element2, "@red", xPath);
            Integer n2 = WWXML.getInteger(element2, "@green", xPath);
            Integer n3 = WWXML.getInteger(element2, "@blue", xPath);
            Integer n4 = WWXML.getInteger(element2, "@alpha", xPath);
            return new Color(n != null ? n : 0, n2 != null ? n2 : 0, n3 != null ? n3 : 0, n4 != null ? n4 : 255);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
    }

    public static Sector getSector(Element element, String string, XPath xPath) {
        Element element2;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
        if (element2 == null) {
            return null;
        }
        LatLon latLon = WWXML.getLatLon(element2, "SouthWest/LatLon", xPath);
        LatLon latLon2 = WWXML.getLatLon(element2, "NorthEast/LatLon", xPath);
        if (latLon == null || latLon2 == null) {
            return null;
        }
        return new Sector(latLon.latitude, latLon2.latitude, latLon.longitude, latLon2.longitude);
    }

    public static LevelSet.SectorResolution getSectorResolutionLimit(Element element, String string, XPath xPath) {
        Element element2;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
        if (element2 == null) {
            return null;
        }
        Integer n = WWXML.getInteger(element2, "@maxLevelNum", xPath);
        Sector sector = WWXML.getSector(element2, "Sector", xPath);
        if (n == null || sector == null) {
            return null;
        }
        return new LevelSet.SectorResolution(sector, n);
    }

    public static Long getTimeInMillis(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            Element element2;
            Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
            if (element2 == null) {
                return null;
            }
            String string3 = WWXML.getText(element2, "@units", xPath);
            Double d = WWXML.getDouble(element2, "@value", xPath);
            if (d == null) {
                return null;
            }
            if (string3 == null || string3.equals("milliseconds")) {
                return d.longValue();
            }
            if (string3.equals("seconds")) {
                return (long)WWMath.convertSecondsToMillis(d);
            }
            if (string3.equals("minutes")) {
                return (long)WWMath.convertMinutesToMillis(d);
            }
            if (string3.equals("hours")) {
                return (long)WWMath.convertHoursToMillis(d);
            }
            String string4 = Logging.getMessage("XML.UnitsUnrecognized", string3);
            Logging.logger().warning(string4);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static Long getDateTimeInMillis(Element element, String string, String string2, XPath xPath) {
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (WWUtil.isEmpty(string2)) {
            String string4 = Logging.getMessage("nullValue.PatternIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        try {
            Element element2;
            Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
            if (element2 == null) {
                return null;
            }
            String string5 = WWXML.getText(element, string, xPath);
            if (string5 == null || string5.length() == 0) {
                return null;
            }
            Long l = WWUtil.makeLong(string5);
            if (l != null) {
                return l;
            }
            return new SimpleDateFormat(string2).parse(string5).getTime();
        }
        catch (ParseException parseException) {
            String string6 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string6, parseException);
            return null;
        }
    }

    public static ScreenCredit getScreenCredit(Element element, String string, XPath xPath) {
        Element element2;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
        if (element2 == null) {
            return null;
        }
        String string3 = WWXML.getText(element2, "@creditType", xPath);
        if (string3 != null && string3.equals("ScreenImage")) {
            String string4 = WWXML.getText(element2, "FileName", xPath);
            if (string4 != null && string4.length() > 0) {
                ScreenCreditImage screenCreditImage = new ScreenCreditImage(WWIO.getFilename(string4), string4);
                String string5 = WWXML.getText(element2, "Link", xPath);
                if (string5 != null && string5.length() > 0) {
                    screenCreditImage.setLink(string5);
                }
                return screenCreditImage;
            }
            String string6 = Logging.getMessage("generic.FileNameIsMissing");
            Logging.logger().warning(string6);
            return null;
        }
        String string7 = Logging.getMessage("generic.UnrecognizedScreenCreditType", string3);
        Logging.logger().warning(string7);
        return null;
    }

    public static Element setDocumentElement(Document document, String string) {
        if (document == null) {
            String string2 = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (WWUtil.isEmpty(string)) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Element element = document.createElementNS(null, string);
        if (document.getDocumentElement() != null) {
            document.replaceChild(element, document.getDocumentElement());
        } else {
            document.appendChild(element);
        }
        return element;
    }

    public static Element appendElement(Element element, String string) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (WWUtil.isEmpty(string)) {
            return element;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, string);
        element.appendChild(element2);
        return element2;
    }

    public static Element appendElementPath(Element element, String string) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (WWUtil.isEmpty(string)) {
            return element;
        }
        String[] stringArray = string.split("/");
        if (stringArray == null || stringArray.length == 0) {
            return element;
        }
        Document document = element.getOwnerDocument();
        Element element2 = element;
        for (String string3 : stringArray) {
            if (string3 == null || string3.length() <= 0) continue;
            Element element3 = document.createElementNS(null, string3);
            element2.appendChild(element3);
            element2 = element3;
        }
        return element2;
    }

    public static Element appendText(Element element, String string, String string2) {
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        Element element2 = WWXML.appendElementPath(element, string);
        Document document = element.getOwnerDocument();
        Text text = document.createTextNode(string2);
        element2.appendChild(text);
        return element2;
    }

    public static Element[] appendTextArray(Element element, String string, String[] stringArray) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (stringArray == null) {
            String string3 = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Element[] elementArray = new Element[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4 == null || string4.length() <= 0) continue;
            elementArray[i] = WWXML.appendText(element, string, string4);
        }
        return elementArray;
    }

    public static Element appendDouble(Element element, String string, double d) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return WWXML.appendText(element, string, Double.toString(d));
    }

    public static Element appendInteger(Element element, String string, int n) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return WWXML.appendText(element, string, Integer.toString(n));
    }

    public static Element appendLong(Element element, String string, long l) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return WWXML.appendText(element, string, Long.toString(l));
    }

    public static Element appendBoolean(Element element, String string, boolean bl) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return WWXML.appendText(element, string, Boolean.toString(bl));
    }

    public static Element appendLatLon(Element element, String string, LatLon latLon) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (latLon == null) {
            String string3 = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Element element2 = WWXML.appendElementPath(element, string);
        WWXML.setTextAttribute(element2, "units", "degrees");
        WWXML.setDoubleAttribute(element2, "latitude", latLon.getLatitude().degrees);
        WWXML.setDoubleAttribute(element2, "longitude", latLon.getLongitude().degrees);
        return element2;
    }

    public static Element appendSector(Element element, String string, Sector sector) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (sector == null) {
            String string3 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Element element2 = WWXML.appendElementPath(element, string);
        WWXML.appendLatLon(element2, "SouthWest/LatLon", new LatLon(sector.getMinLatitude(), sector.getMinLongitude()));
        WWXML.appendLatLon(element2, "NorthEast/LatLon", new LatLon(sector.getMaxLatitude(), sector.getMaxLongitude()));
        return element2;
    }

    public static Element appendSectorResolutionLimit(Element element, String string, LevelSet.SectorResolution sectorResolution) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (sectorResolution == null) {
            String string3 = Logging.getMessage("nullValue.LevelSet.SectorResolutionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Element element2 = WWXML.appendElementPath(element, string);
        WWXML.setIntegerAttribute(element2, "maxLevelNum", sectorResolution.getLevelNumber());
        WWXML.appendSector(element2, "Sector", sectorResolution.getSector());
        return element2;
    }

    public static Element appendTimeInMillis(Element element, String string, long l) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Element element2 = WWXML.appendElementPath(element, string);
        WWXML.setTextAttribute(element2, "units", "milliseconds");
        WWXML.setLongAttribute(element2, "value", l);
        return element2;
    }

    public static Element appendScreenCredit(Element element, String string, ScreenCredit screenCredit) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (screenCredit == null) {
            String string3 = Logging.getMessage("nullValue.ScreenCreditIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (screenCredit instanceof ScreenCreditImage) {
            Object object;
            Element element2 = WWXML.appendElementPath(element, string);
            WWXML.setTextAttribute(element2, "creditType", "ScreenImage");
            String string4 = screenCredit.getLink();
            if (string4 != null && string4.length() > 0) {
                WWXML.appendText(element2, "Link", string4);
            }
            if ((object = ((ScreenCreditImage)screenCredit).getImageSource()) != null && object instanceof String) {
                WWXML.appendText(element2, "FileName", (String)object);
            } else {
                String string5 = Logging.getMessage("generic.UnrecognizedImageSourceType", object != null ? object.getClass().getName() : null);
                Logging.logger().warning(string5);
            }
            return element2;
        }
        String string6 = Logging.getMessage("generic.UnrecognizedScreenCreditType", screenCredit);
        Logging.logger().warning(string6);
        return null;
    }

    public static void setTextAttribute(Element element, String string, String string2) {
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (WWUtil.isEmpty(string)) {
            String string4 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        element.setAttributeNS(null, string, string2);
    }

    public static void setDoubleAttribute(Element element, String string, double d) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        WWXML.setTextAttribute(element, string, Double.toString(d));
    }

    public static void setIntegerAttribute(Element element, String string, int n) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        WWXML.setTextAttribute(element, string, Integer.toString(n));
    }

    public static void setLongAttribute(Element element, String string, long l) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        WWXML.setTextAttribute(element, string, Long.toString(l));
    }

    public static void setBooleanAttribute(Element element, String string, boolean bl) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        WWXML.setTextAttribute(element, string, Boolean.toString(bl));
    }

    public static void checkAndSetStringParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        String string7 = aVList.getStringValue(string);
        if (string7 == null && (string7 = WWXML.getText(element, string2, xPath)) != null && string7.length() > 0) {
            aVList.setValue(string, string7.trim());
        }
    }

    public static void checkAndSetStringArrayParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        String[] stringArray;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (stringArray = WWXML.getTextArray(element, string2, xPath)) != null && stringArray.length > 0) {
            aVList.setValue(string, stringArray);
        }
    }

    public static void checkAndSetUniqueStringsParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        String[] stringArray;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (stringArray = WWXML.getUniqueText(element, string2, xPath)) != null && stringArray.length > 0) {
            aVList.setValue(string, stringArray);
        }
    }

    public static void checkAndSetDoubleParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Double d;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (d = WWXML.getDouble(element, string2, xPath)) != null) {
            aVList.setValue(string, d);
        }
    }

    public static void checkAndSetIntegerParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Integer n;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (n = WWXML.getInteger(element, string2, xPath)) != null) {
            aVList.setValue(string, n);
        }
    }

    public static void checkAndSetLongParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Long l;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (l = WWXML.getLong(element, string2, xPath)) != null) {
            aVList.setValue(string, l);
        }
    }

    public static void checkAndSetBooleanParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Boolean bl;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (bl = WWXML.getBoolean(element, string2, xPath)) != null) {
            aVList.setValue(string, bl);
        }
    }

    public static void checkAndSetLatLonParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        LatLon latLon;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (latLon = WWXML.getLatLon(element, string2, xPath)) != null) {
            aVList.setValue(string, latLon);
        }
    }

    public static void checkAndSetColorParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Color color;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (color = WWXML.getColor(element, string2, xPath)) != null) {
            aVList.setValue(string, color);
        }
    }

    public static void checkAndSetColorArrayParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null) {
            Element[] elementArray = WWXML.getElements(element, string2, xPath);
            if (elementArray == null || elementArray.length == 0) {
                return;
            }
            int[] nArray = new int[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                Color color = WWXML.getColor(element, string2, xPath);
                if (color == null) continue;
                nArray[i] = color.getRGB();
            }
            aVList.setValue(string, nArray);
        }
    }

    public static void checkAndSetSectorParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Sector sector;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (sector = WWXML.getSector(element, string2, xPath)) != null) {
            aVList.setValue(string, sector);
        }
    }

    public static void checkAndSetSectorResolutionParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null) {
            Element[] elementArray = WWXML.getElements(element, string2, xPath);
            if (elementArray == null || elementArray.length == 0) {
                return;
            }
            LevelSet.SectorResolution[] sectorResolutionArray = new LevelSet.SectorResolution[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                LevelSet.SectorResolution sectorResolution = WWXML.getSectorResolutionLimit(elementArray[i], null, xPath);
                if (sectorResolution == null) continue;
                sectorResolutionArray[i] = sectorResolution;
            }
            aVList.setValue(string, sectorResolutionArray);
        }
    }

    public static void checkAndSetTimeParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Long l;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (l = WWXML.getTimeInMillis(element, string2, xPath)) != null) {
            aVList.setValue(string, l);
        }
    }

    public static void checkAndSetTimeParamAsInteger(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Long l;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (l = WWXML.getTimeInMillis(element, string2, xPath)) != null) {
            aVList.setValue(string, l.intValue());
        }
    }

    public static void checkAndSetDateTimeParam(Element element, AVList aVList, String string, String string2, String string3, XPath xPath) {
        Long l;
        if (element == null) {
            String string4 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (aVList == null) {
            String string5 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string == null) {
            String string6 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        if (string2 == null) {
            String string7 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        if (WWUtil.isEmpty(string3)) {
            String string8 = Logging.getMessage("nullValue.PatternIsNull");
            Logging.logger().severe(string8);
            throw new IllegalArgumentException(string8);
        }
        Object object = aVList.getValue(string);
        if (object == null && (l = WWXML.getDateTimeInMillis(element, string2, string3, xPath)) != null) {
            aVList.setValue(string, l);
        }
    }

    public static void checkAndSetScreenCreditParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        ScreenCredit screenCredit;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (screenCredit = WWXML.getScreenCredit(element, string2, xPath)) != null) {
            aVList.setValue(string, screenCredit);
        }
    }

    public static void checkAndAppendTextElement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        String string6 = aVList.getStringValue(string);
        if (string6 != null && string6.length() > 0) {
            WWXML.appendText(element, string2, string6.trim());
        }
    }

    public static void checkAndAppendTextArrayElement(AVList aVList, String string, Element element, String string2) {
        String[] stringArray;
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Object object = aVList.getValue(string);
        if (object != null && object instanceof String[] && (stringArray = (String[])object).length > 0) {
            WWXML.appendTextArray(element, string2, (String[])object);
        }
    }

    public static void checkAndAppendDoubleElement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Double d = AVListImpl.getDoubleValue(aVList, string);
        if (d != null) {
            WWXML.appendDouble(element, string2, d);
        }
    }

    public static void checkAndAppendIntegerlement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Integer n = AVListImpl.getIntegerValue(aVList, string);
        if (n != null) {
            WWXML.appendInteger(element, string2, n);
        }
    }

    public static void checkAndAppendLongElement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Long l = AVListImpl.getLongValue(aVList, string);
        if (l != null) {
            WWXML.appendLong(element, string2, l);
        }
    }

    public static void checkAndAppendBooleanElement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Object object = aVList.getValue(string);
        if (object != null && object instanceof Boolean) {
            WWXML.appendBoolean(element, string2, (Boolean)object);
        }
    }

    public static void checkAndAppendLatLonElement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Object object = aVList.getValue(string);
        if (object != null && object instanceof LatLon) {
            WWXML.appendLatLon(element, string2, (LatLon)object);
        }
    }

    public static void checkAndAppendSectorElement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Object object = aVList.getValue(string);
        if (object != null && object instanceof Sector) {
            WWXML.appendSector(element, string2, (Sector)object);
        }
    }

    public static void checkAndAppendSectorResolutionElement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Object object = aVList.getValue(string);
        if (object != null && object instanceof LevelSet.SectorResolution[]) {
            LevelSet.SectorResolution[] sectorResolutionArray;
            for (LevelSet.SectorResolution sectorResolution : sectorResolutionArray = (LevelSet.SectorResolution[])object) {
                if (sectorResolution == null) continue;
                WWXML.appendSectorResolutionLimit(element, string2, sectorResolution);
            }
        }
    }

    public static void checkAndAppendTimeElement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Object object = aVList.getValue(string);
        if (object != null && object instanceof Number) {
            Number number = (Number)object;
            WWXML.appendTimeInMillis(element, string2, number.longValue());
        }
    }

    public static void checkAndAppendScreenCreditElement(AVList aVList, String string, Element element, String string2) {
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (element == null) {
            String string5 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        Object object = aVList.getValue(string);
        if (object != null && object instanceof ScreenCredit) {
            WWXML.appendScreenCredit(element, string2, (ScreenCredit)object);
        }
    }

    public static String fixGetMapString(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        int n = (string = string.trim()).indexOf("?");
        if (n < 0) {
            string = string + "?";
        } else if (n != string.length() - 1 && string.lastIndexOf("&") != string.length() - 1) {
            string = string + "&";
        }
        return string;
    }

    public static String parseByteOrder(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if ((string = string.trim().toLowerCase()).startsWith("little")) {
            return "gov.nasa.worldwind.avkey.LittleEndian";
        }
        if (string.startsWith("big")) {
            return "gov.nasa.worldwind.avkey.BigEndian";
        }
        String string3 = Logging.getMessage("generic.UnrecognizedByteOrder", string);
        Logging.logger().warning(string3);
        return null;
    }

    public static String byteOrderAsText(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ByteOrderIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.equals("gov.nasa.worldwind.avkey.LittleEndian")) {
            return "LittleEndian";
        }
        if (string.equals("gov.nasa.worldwind.avkey.BigEndian")) {
            return "BigEndian";
        }
        String string3 = Logging.getMessage("generic.UnrecognizedByteOrder", string);
        Logging.logger().warning(string3);
        return null;
    }

    public static String parseDataType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.equals("Float32")) {
            return "gov.nasa.worldwind.avkey.Float32";
        }
        if (string.equals("Int32")) {
            return "gov.nasa.worldwind.avkey.Int32";
        }
        if (string.equals("Int16")) {
            return "gov.nasa.worldwind.avkey.Int16";
        }
        if (string.equals("Int8")) {
            return "gov.nasa.worldwind.avkey.Int8";
        }
        String string3 = Logging.getMessage("generic.UnrecognizedDataType", string);
        Logging.logger().warning(string3);
        return null;
    }

    public static String dataTypeAsText(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.DataTypeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.equals("gov.nasa.worldwind.avkey.Float32")) {
            return "Float32";
        }
        if (string.equals("gov.nasa.worldwind.avkey.Int32")) {
            return "Int32";
        }
        if (string.equals("gov.nasa.worldwind.avkey.Int16")) {
            return "Int16";
        }
        if (string.equals("gov.nasa.worldwind.avkey.Int8")) {
            return "Int8";
        }
        String string3 = Logging.getMessage("generic.UnrecognizedDataType", string);
        Logging.logger().warning(string3);
        return null;
    }

    public static AVList copyProperties(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            XPath xPath = WWXML.makeXPath();
            Element[] elementArray = WWXML.getElements(element, "Property", xPath);
            if (elementArray == null || elementArray.length == 0) {
                return aVList;
            }
            if (aVList == null) {
                aVList = new AVListImpl();
            }
            for (Element element2 : elementArray) {
                String string = xPath.evaluate("@name", element2);
                String string2 = xPath.evaluate("@value", element2);
                if (WWUtil.isEmpty(string) || WWUtil.isEmpty(string2)) continue;
                aVList.setValue(string, string2);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("XML.InvalidXPathExpression", "internal expression");
            Logging.logger().log(Level.WARNING, string, xPathExpressionException);
        }
        return aVList;
    }

    public static void invokePropertySetters(Object object, Element element) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.nullValue.ParentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentElementIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Element[] elementArray = WWXML.getElements(element, "Property", null);
        if (elementArray == null || elementArray.length == 0) {
            return;
        }
        for (Element element2 : elementArray) {
            String string;
            String string2 = element2.getAttribute("name");
            if (WWUtil.isEmpty(string2)) continue;
            String string3 = element2.getAttribute("value");
            try {
                WWUtil.invokePropertyMethod(object, string2, string3);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!(object instanceof AVList)) continue;
                ((AVList)object).setValue(string2, string3);
            }
            catch (InvocationTargetException invocationTargetException) {
                string = Logging.getMessage("generic.ExceptionInvokingPropertyMethod", string2, invocationTargetException);
                Logging.logger().warning(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                string = Logging.getMessage("generic.ExceptionInvokingPropertyMethod", string2, illegalAccessException);
                Logging.logger().warning(string);
            }
        }
    }
}

