/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.awt.Rectangle;

public class SurfaceTileDrawContext {
    protected Sector sector;
    protected Rectangle viewport;
    protected Matrix modelview;

    public SurfaceTileDrawContext(Sector sector, Rectangle rectangle) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.ViewportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle.width <= 0) {
            String string = Logging.getMessage("Geom.WidthInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle.height <= 0) {
            String string = Logging.getMessage("Geom.HeightInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.viewport = rectangle;
        this.modelview = Matrix.fromGeographicToViewport(sector, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public SurfaceTileDrawContext(Sector sector, int n, int n2) {
        this(sector, new Rectangle(n, n2));
    }

    public Sector getSector() {
        return this.sector;
    }

    public Rectangle getViewport() {
        return this.viewport;
    }

    public Matrix getModelviewMatrix() {
        return this.modelview;
    }

    public Matrix getModelviewMatrix(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.modelview.multiply(Matrix.fromTranslation(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0));
    }
}

