/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.NetworkCheckThread;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class StatusBar
extends JPanel
implements PositionListener,
RenderingListener {
    public static final String UNIT_METRIC = "gov.nasa.worldwind.StatusBar.Metric";
    public static final String UNIT_IMPERIAL = "gov.nasa.worldwind.StatusBar.Imperial";
    protected static final int MAX_ALPHA = 254;
    private WorldWindow eventSource;
    private String elevationUnit = "gov.nasa.worldwind.StatusBar.Metric";
    private String angleFormat = "gov.nasa.worldwind.Geom.AngleDD";
    protected final JLabel latDisplay = new JLabel("");
    protected final JLabel lonDisplay = new JLabel(Logging.getMessage("term.OffGlobe"));
    protected final JLabel altDisplay = new JLabel("");
    protected final JLabel eleDisplay = new JLabel("");
    protected AtomicBoolean showNetworkStatus = new AtomicBoolean(true);
    protected AtomicBoolean isNetworkAvailable = new AtomicBoolean(true);
    protected Thread netCheckThread;

    public StatusBar() {
        super(new GridLayout(1, 0));
        final JLabel jLabel = new JLabel(Logging.getMessage("term.Downloading"));
        this.altDisplay.setHorizontalAlignment(0);
        this.latDisplay.setHorizontalAlignment(0);
        this.lonDisplay.setHorizontalAlignment(0);
        this.eleDisplay.setHorizontalAlignment(0);
        this.add(this.altDisplay);
        this.add(this.latDisplay);
        this.add(this.lonDisplay);
        this.add(this.eleDisplay);
        this.add(jLabel);
        jLabel.setHorizontalAlignment(0);
        jLabel.setForeground(new Color(255, 0, 0, 0));
        Timer timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!StatusBar.this.showNetworkStatus.get()) {
                    if (jLabel.getText().length() > 0) {
                        jLabel.setText("");
                    }
                    return;
                }
                if (!StatusBar.this.isNetworkAvailable.get()) {
                    jLabel.setText(Logging.getMessage("term.NoNetwork"));
                    jLabel.setForeground(new Color(255, 0, 0, 254));
                    return;
                }
                Color color = jLabel.getForeground();
                int n = color.getAlpha();
                if (StatusBar.this.isNetworkAvailable.get() && WorldWind.getRetrievalService().hasActiveTasks()) {
                    jLabel.setText(Logging.getMessage("term.Downloading"));
                    n = n >= 254 ? 254 : (n < 16 ? 16 : Math.min(254, n + 20));
                } else {
                    n = Math.max(0, n - 20);
                }
                jLabel.setForeground(new Color(255, 0, 0, n));
            }
        });
        timer.start();
        this.netCheckThread = this.startNetCheckThread();
        WorldWind.getNetworkStatus().addPropertyChangeListener("gov.nasa.worldwind.util.NetworkStatus.HostUnavailable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                String string = Logging.getMessage("NetworkStatus.UnavailableHost", object != null && object instanceof URL ? ((URL)object).getHost() : "Unknown");
                Logging.logger().info(string);
            }
        });
        WorldWind.getNetworkStatus().addPropertyChangeListener("gov.nasa.worldwind.util.NetworkStatus.HostAvailable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                String string = Logging.getMessage("NetworkStatus.HostNowAvailable", object != null && object instanceof URL ? ((URL)object).getHost() : "Unknown");
                Logging.logger().info(string);
            }
        });
    }

    protected NetworkCheckThread startNetCheckThread() {
        NetworkCheckThread networkCheckThread = new NetworkCheckThread(this.showNetworkStatus, this.isNetworkAvailable, null);
        networkCheckThread.setDaemon(true);
        networkCheckThread.start();
        return networkCheckThread;
    }

    public void setEventSource(WorldWindow worldWindow) {
        if (this.eventSource != null) {
            this.eventSource.removePositionListener(this);
            this.eventSource.removeRenderingListener(this);
        }
        if (worldWindow != null) {
            worldWindow.addPositionListener(this);
            worldWindow.addRenderingListener(this);
        }
        this.eventSource = worldWindow;
    }

    public boolean isShowNetworkStatus() {
        return this.showNetworkStatus.get();
    }

    public void setShowNetworkStatus(boolean bl) {
        this.showNetworkStatus.set(bl);
        if (bl) {
            if (this.netCheckThread != null) {
                this.netCheckThread.interrupt();
            }
            this.netCheckThread = this.startNetCheckThread();
        } else {
            if (this.netCheckThread != null) {
                this.netCheckThread.interrupt();
            }
            this.netCheckThread = null;
        }
    }

    @Override
    public void moved(PositionEvent positionEvent) {
        this.handleCursorPositionChange(positionEvent);
    }

    public WorldWindow getEventSource() {
        return this.eventSource;
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.elevationUnit = string;
    }

    public String getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.angleFormat = string;
    }

    protected String makeCursorElevationDescription(double d) {
        String string = Logging.getMessage("term.Elev");
        String string2 = UNIT_IMPERIAL.equals(this.elevationUnit) ? String.format(string + " %,7d feet", (int)WWMath.convertMetersToFeet(d)) : String.format(string + " %,7d meters", (int)d);
        return string2;
    }

    protected String makeEyeAltitudeDescription(double d) {
        double d2;
        String string = Logging.getMessage("term.Altitude");
        String string2 = UNIT_IMPERIAL.equals(this.elevationUnit) ? (Math.abs(d2 = WWMath.convertMetersToMiles(d)) >= 1.0 ? String.format(string + " %,7d mi", (int)Math.round(d2)) : String.format(string + " %,7d ft", (int)Math.round(WWMath.convertMetersToFeet(d)))) : (Math.abs(d) >= 1000.0 ? String.format(string + " %,7d km", (int)Math.round(d / 1000.0)) : String.format(string + " %,7d m", (int)Math.round(d)));
        return string2;
    }

    protected String makeAngleDescription(String string, Angle angle) {
        String string2 = "gov.nasa.worldwind.Geom.AngleDMS".equals(this.angleFormat) ? String.format("%s %s", string, angle.toDMSString()) : String.format("%s %7.4f\u00b0", string, angle.degrees);
        return string2;
    }

    protected void handleCursorPositionChange(PositionEvent positionEvent) {
        Position position = positionEvent.getPosition();
        if (position != null) {
            String string = this.makeAngleDescription("Lat", position.getLatitude());
            String string2 = this.makeAngleDescription("Lon", position.getLongitude());
            String string3 = this.makeCursorElevationDescription(this.eventSource.getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude()));
            this.latDisplay.setText(string);
            this.lonDisplay.setText(string2);
            this.eleDisplay.setText(string3);
        } else {
            this.latDisplay.setText("");
            this.lonDisplay.setText(Logging.getMessage("term.OffGlobe"));
            this.eleDisplay.setText("");
        }
    }

    @Override
    public void stageChanged(RenderingEvent renderingEvent) {
        if (!renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.BeforeBufferSwap")) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (StatusBar.this.eventSource.getView() != null && StatusBar.this.eventSource.getView().getEyePosition() != null) {
                    StatusBar.this.altDisplay.setText(StatusBar.this.makeEyeAltitudeDescription(StatusBar.this.eventSource.getView().getEyePosition().getElevation()));
                } else {
                    StatusBar.this.altDisplay.setText(Logging.getMessage("term.Altitude"));
                }
            }
        });
    }
}

