/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.util.PerformanceStatistic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class StatisticsPanel
extends JPanel {
    private JPanel statsPanel;
    private JPanel outerPanel;
    private JScrollPane scrollPane;
    private WorldWindow wwd;
    private int updateInterval = 500;
    private long lastUpdate;

    public StatisticsPanel(WorldWindow worldWindow) {
        super(new BorderLayout());
        this.makePanel(new Dimension(200, 400));
    }

    public StatisticsPanel(WorldWindow worldWindow, Dimension dimension) {
        super(new BorderLayout());
        this.wwd = worldWindow;
        this.makePanel(dimension);
        worldWindow.setPerFrameStatisticsKeys(PerformanceStatistic.ALL_STATISTICS_SET);
        worldWindow.addRenderingListener(new RenderingListener(){

            @Override
            public void stageChanged(RenderingEvent renderingEvent) {
                long l = System.currentTimeMillis();
                if (renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.AfterBufferSwap") && renderingEvent.getSource() instanceof WorldWindow && l - StatisticsPanel.this.lastUpdate > (long)StatisticsPanel.this.updateInterval) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StatisticsPanel.this.update();
                        }
                    });
                    StatisticsPanel.this.lastUpdate = l;
                }
            }
        });
    }

    private void makePanel(Dimension dimension) {
        this.statsPanel = new JPanel(new GridLayout(0, 1, 0, 15));
        this.statsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.statsPanel, "North");
        this.scrollPane = new JScrollPane(jPanel);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (dimension != null) {
            this.scrollPane.setPreferredSize(dimension);
        }
        this.outerPanel = new JPanel(new GridLayout(0, 1, 0, 10));
        this.outerPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Statistics")));
        this.outerPanel.setToolTipText("Runtime Statistics");
        this.outerPanel.add(this.scrollPane);
        this.add((Component)this.outerPanel, "Center");
    }

    private void fill(WorldWindow worldWindow) {
        if (worldWindow.getSceneController().getPerFrameStatistics().size() < 1) {
            return;
        }
        Object[] objectArray = new PerformanceStatistic[worldWindow.getPerFrameStatistics().size()];
        objectArray = worldWindow.getSceneController().getPerFrameStatistics().toArray(objectArray);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            JLabel jLabel = new JLabel(((PerformanceStatistic)object).toString());
            this.statsPanel.add(jLabel);
        }
    }

    public void update(WorldWindow worldWindow) {
        this.statsPanel.removeAll();
        this.fill(worldWindow);
        this.outerPanel.revalidate();
        this.outerPanel.repaint();
    }

    public void update() {
        this.statsPanel.removeAll();
        this.fill(this.wwd);
        this.outerPanel.revalidate();
        this.outerPanel.repaint();
    }

    @Override
    public void setToolTipText(String string) {
        this.scrollPane.setToolTipText(string);
    }
}

