/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.OffsetsList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestorableSupport {
    protected static final String DEFAULT_DOCUMENT_ELEMENT_TAG_NAME = "restorableState";
    protected static final String DEFAULT_STATE_OBJECT_TAG_NAME = "stateObject";
    protected Document doc;
    protected XPath xpath;
    protected String stateObjectTagName;

    protected RestorableSupport(Document document) {
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doc = document;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        this.xpath = xPathFactory.newXPath();
        this.stateObjectTagName = DEFAULT_STATE_OBJECT_TAG_NAME;
    }

    public static RestorableSupport newRestorableSupport(String string) {
        if (WWUtil.isEmpty(string)) {
            String string2 = Logging.getMessage("nullValue.DocumentElementNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            RestorableSupport.createDocumentElement(document, string);
            return new RestorableSupport(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string3 = Logging.getMessage("generic.ExceptionCreatingParser");
            Logging.logger().severe(string3);
            throw new IllegalStateException(string3, parserConfigurationException);
        }
    }

    public static RestorableSupport newRestorableSupport() {
        return RestorableSupport.newRestorableSupport(DEFAULT_DOCUMENT_ELEMENT_TAG_NAME);
    }

    public static RestorableSupport parse(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            return new RestorableSupport(document);
        }
        catch (IOException iOException) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, iOException);
        }
        catch (SAXException sAXException) {
            String string4 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4, sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string5 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string5);
            throw new IllegalStateException(string5, parserConfigurationException);
        }
    }

    protected Element getDocumentElement() {
        return this.doc.getDocumentElement();
    }

    protected static void createDocumentElement(Document document, String string) {
        if (document == null) {
            String string2 = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (document.getDocumentElement() != null) {
            return;
        }
        Element element = document.createElement(string);
        document.appendChild(element);
    }

    public String getStateAsXml() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(this.doc), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string = Logging.getMessage("generic.ExceptionWritingXml");
            Logging.logger().severe(string);
            return null;
        }
        catch (TransformerException transformerException) {
            String string = Logging.getMessage("generic.ExceptionWritingXml");
            Logging.logger().severe(string);
            return null;
        }
    }

    public String toString() {
        return this.getStateAsXml();
    }

    public String getDocumentElementTagName() {
        return this.getDocumentElement().getTagName();
    }

    public String getStateObjectTagName() {
        return this.stateObjectTagName;
    }

    public void setStateObjectTagName(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.stateObjectTagName = string;
    }

    protected StateObject findStateObject(Node node, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = String.format("%s[@name=\"%s\"]", this.getStateObjectTagName(), string);
        try {
            Object object = this.xpath.evaluate(string3, node != null ? node : this.getDocumentElement(), XPathConstants.NODE);
            if (object == null) {
                return null;
            }
            return object instanceof Element ? new StateObject((Element)object) : null;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    protected StateObject[] findAllStateObjects(Node node, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = string.length() != 0 ? String.format("%s[@name=\"%s\"]", this.getStateObjectTagName(), string) : String.format("%s//.", this.getStateObjectTagName());
        try {
            Object object = this.xpath.evaluate(string3, node != null ? node : this.getDocumentElement(), XPathConstants.NODESET);
            if (object == null || !(object instanceof NodeList) || ((NodeList)object).getLength() == 0) {
                return null;
            }
            NodeList nodeList = (NodeList)object;
            ArrayList<StateObject> arrayList = new ArrayList<StateObject>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!(node2 instanceof Element)) continue;
                arrayList.add(new StateObject((Element)node2));
            }
            StateObject[] stateObjectArray = new StateObject[arrayList.size()];
            arrayList.toArray(stateObjectArray);
            return stateObjectArray;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    protected StateObject[] extractStateObjects(Element element) {
        NodeList nodeList = (element != null ? element : this.getDocumentElement()).getChildNodes();
        ArrayList<StateObject> arrayList = new ArrayList<StateObject>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || node.getNodeName() == null || !node.getNodeName().equals(this.getStateObjectTagName())) continue;
                arrayList.add(new StateObject((Element)node));
            }
        }
        StateObject[] stateObjectArray = new StateObject[arrayList.size()];
        arrayList.toArray(stateObjectArray);
        return stateObjectArray;
    }

    protected StateObject createStateObject(Element element, String string, String string2) {
        return this.createStateObject(element, string, string2, false);
    }

    protected StateObject createStateObject(Element element, String string, String string2, boolean bl) {
        Element element2 = this.doc.createElement(this.getStateObjectTagName());
        if (string != null) {
            element2.setAttribute("name", string);
        }
        if (string2 != null) {
            if (bl) {
                element2.appendChild(this.doc.createCDATASection(string2));
            } else {
                element2.setTextContent(string2);
            }
        }
        (element != null ? element : this.getDocumentElement()).appendChild(element2);
        return new StateObject(element2);
    }

    protected boolean containsElement(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return element.getOwnerDocument().equals(this.doc);
    }

    public StateObject getStateObject(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getStateObject(null, string);
    }

    public StateObject getStateObject(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return this.findStateObject(stateObject != null ? stateObject.elem : null, string);
    }

    public StateObject[] getAllStateObjects(StateObject stateObject) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.extractStateObjects(stateObject != null ? stateObject.elem : null);
    }

    public StateObject[] getAllStateObjects(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getAllStateObjects(null, string);
    }

    public StateObject[] getAllStateObjects(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return this.findAllStateObjects(stateObject != null ? stateObject.elem : null, string);
    }

    public StateObject addStateObject(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.addStateObject(null, string);
    }

    public StateObject addStateObject(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return this.createStateObject(stateObject != null ? stateObject.elem : null, string, null);
    }

    public String getStateObjectAsString(StateObject stateObject) {
        if (stateObject == null) {
            String string = Logging.getMessage("nullValue.StateObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return stateObject.getValue();
    }

    public String getStateValueAsString(String string) {
        return this.getStateValueAsString(null, string);
    }

    public String getStateValueAsString(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsString(stateObject2);
    }

    public Integer getStateObjectAsInteger(StateObject stateObject) {
        String string = this.getStateObjectAsString(stateObject);
        if (string == null) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string2, numberFormatException);
            return null;
        }
    }

    public Integer getStateValueAsInteger(String string) {
        return this.getStateValueAsInteger(null, string);
    }

    public Integer getStateValueAsInteger(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsInteger(stateObject2);
    }

    public Double getStateObjectAsDouble(StateObject stateObject) {
        String string = this.getStateObjectAsString(stateObject);
        if (string == null) {
            return null;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string2, numberFormatException);
            return null;
        }
    }

    public Double getStateValueAsDouble(String string) {
        return this.getStateValueAsDouble(null, string);
    }

    public Double getStateValueAsDouble(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsDouble(stateObject2);
    }

    public Long getStateObjectAsLong(StateObject stateObject) {
        String string = this.getStateObjectAsString(stateObject);
        if (string == null) {
            return null;
        }
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string2, numberFormatException);
            return null;
        }
    }

    public Long getStateValueAsLong(String string) {
        return this.getStateValueAsLong(null, string);
    }

    public Long getStateValueAsLong(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsLong(stateObject2);
    }

    public Float getStateObjectAsFloat(StateObject stateObject) {
        String string = this.getStateObjectAsString(stateObject);
        if (string == null) {
            return null;
        }
        try {
            return Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string2, numberFormatException);
            return null;
        }
    }

    public Float getStateValueAsFloat(String string) {
        return this.getStateValueAsFloat(null, string);
    }

    public Float getStateValueAsFloat(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsFloat(stateObject2);
    }

    public Boolean getStateObjectAsBoolean(StateObject stateObject) {
        String string = this.getStateObjectAsString(stateObject);
        if (string == null) {
            return null;
        }
        try {
            return Boolean.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string2, numberFormatException);
            return null;
        }
    }

    public Boolean getStateValueAsBoolean(String string) {
        return this.getStateValueAsBoolean(null, string);
    }

    public Boolean getStateValueAsBoolean(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsBoolean(stateObject2);
    }

    public LatLon getStateObjectAsLatLon(StateObject stateObject) {
        if (stateObject == null) {
            String string = Logging.getMessage("nullValue.StateObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Double d = this.getStateValueAsDouble(stateObject, "latitudeDegrees");
        Double d2 = this.getStateValueAsDouble(stateObject, "longitudeDegrees");
        if (d == null || d2 == null) {
            String string = Logging.getMessage("generic.ConversionError", stateObject.getName());
            Logging.logger().log(Level.SEVERE, string);
            return null;
        }
        return LatLon.fromDegrees(d, d2);
    }

    public LatLon getStateValueAsLatLon(String string) {
        return this.getStateValueAsLatLon(null, string);
    }

    public LatLon getStateValueAsLatLon(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsLatLon(stateObject2);
    }

    public Position getStateObjectAsPosition(StateObject stateObject) {
        if (stateObject == null) {
            String string = Logging.getMessage("nullValue.StateObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Double d = this.getStateValueAsDouble(stateObject, "latitudeDegrees");
        Double d2 = this.getStateValueAsDouble(stateObject, "longitudeDegrees");
        Double d3 = this.getStateValueAsDouble(stateObject, "elevation");
        if (d == null || d2 == null || d3 == null) {
            String string = Logging.getMessage("generic.ConversionError", stateObject.getName());
            Logging.logger().log(Level.SEVERE, string);
            return null;
        }
        return Position.fromDegrees(d, d2, d3);
    }

    public Position getStateValueAsPosition(String string) {
        return this.getStateValueAsPosition(null, string);
    }

    public Position getStateValueAsPosition(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsPosition(stateObject2);
    }

    public List<LatLon> getStateObjectAsLatLonList(StateObject stateObject) {
        if (stateObject == null) {
            String string = Logging.getMessage("nullValue.StateObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StateObject[] stateObjectArray = this.getAllStateObjects(stateObject, "location");
        if (stateObjectArray == null || stateObjectArray.length == 0) {
            return null;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(stateObjectArray.length);
        for (StateObject stateObject2 : stateObjectArray) {
            LatLon latLon;
            if (stateObject2 == null || (latLon = this.getStateObjectAsLatLon(stateObject2)) == null) continue;
            arrayList.add(latLon);
        }
        return arrayList;
    }

    public List<LatLon> getStateValueAsLatLonList(String string) {
        return this.getStateValueAsLatLonList(null, string);
    }

    public List<LatLon> getStateValueAsLatLonList(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsLatLonList(stateObject2);
    }

    public HashMap<Integer, OffsetsList> getStateObjectAsOffsetsList(StateObject stateObject) {
        if (stateObject == null) {
            String string = Logging.getMessage("nullValue.StateObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StateObject[] stateObjectArray = this.getAllStateObjects(stateObject, "face");
        if (stateObjectArray == null || stateObjectArray.length == 0) {
            return null;
        }
        HashMap<Integer, OffsetsList> hashMap = new HashMap<Integer, OffsetsList>();
        int n = 0;
        for (StateObject stateObject2 : stateObjectArray) {
            OffsetsList offsetsList;
            if (stateObject2 != null && (offsetsList = this.getStateObjectAsOffsets(stateObject2)) != null) {
                hashMap.put(n, offsetsList);
            }
            ++n;
        }
        return hashMap;
    }

    public HashMap<Integer, OffsetsList> getStateValueAsOffsetsList(String string) {
        return this.getStateValueAsOffsetsList(null, string);
    }

    public HashMap<Integer, OffsetsList> getStateValueAsOffsetsList(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsOffsetsList(stateObject2);
    }

    public OffsetsList getStateObjectAsOffsets(StateObject stateObject) {
        if (stateObject == null) {
            String string = Logging.getMessage("nullValue.StateObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = this.getStateValueAsOffsetPair(stateObject, "upperLeftOffset");
        float[] fArray2 = this.getStateValueAsOffsetPair(stateObject, "upperRightOffset");
        float[] fArray3 = this.getStateValueAsOffsetPair(stateObject, "lowerLeftOffset");
        float[] fArray4 = this.getStateValueAsOffsetPair(stateObject, "lowerRightOffset");
        if (fArray == null || fArray2 == null || fArray3 == null || fArray4 == null) {
            String string = Logging.getMessage("generic.ConversionError", stateObject.getName());
            Logging.logger().log(Level.SEVERE, string);
            return null;
        }
        OffsetsList offsetsList = new OffsetsList();
        offsetsList.setOffset(0, fArray[0], fArray[1]);
        offsetsList.setOffset(1, fArray2[0], fArray2[1]);
        offsetsList.setOffset(2, fArray3[0], fArray3[1]);
        offsetsList.setOffset(3, fArray4[0], fArray4[1]);
        return offsetsList;
    }

    public OffsetsList getStateValueAsOffsets(String string) {
        return this.getStateValueAsOffsets(null, string);
    }

    public OffsetsList getStateValueAsOffsets(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsOffsets(stateObject2);
    }

    public float[] getStateObjectAsOffsetPair(StateObject stateObject) {
        if (stateObject == null) {
            String string = Logging.getMessage("nullValue.StateObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Float f = this.getStateValueAsFloat(stateObject, "uOffset");
        Float f2 = this.getStateValueAsFloat(stateObject, "vOffset");
        if (f == null || f2 == null) {
            String string = Logging.getMessage("generic.ConversionError", stateObject.getName());
            Logging.logger().log(Level.SEVERE, string);
            return null;
        }
        float[] fArray = new float[]{f.floatValue(), f2.floatValue()};
        return fArray;
    }

    public float[] getStateValueAsOffsetPair(String string) {
        return this.getStateValueAsOffsetPair(null, string);
    }

    public float[] getStateValueAsOffsetPair(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsOffsetPair(stateObject2);
    }

    public HashMap<Integer, Object> getStateObjectAsImageSourceList(StateObject stateObject) {
        if (stateObject == null) {
            String string = Logging.getMessage("nullValue.StateObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StateObject[] stateObjectArray = this.getAllStateObjects(stateObject, "imageSource");
        if (stateObjectArray == null || stateObjectArray.length == 0) {
            return null;
        }
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        int n = 0;
        for (StateObject stateObject2 : stateObjectArray) {
            if (stateObject2 != null) {
                String string = this.getStateObjectAsString(stateObject2);
                if (string != null) {
                    hashMap.put(n, string);
                } else {
                    hashMap.put(n, null);
                }
            }
            ++n;
        }
        return hashMap;
    }

    public HashMap<Integer, Object> getStateValueAsImageSourceList(String string) {
        return this.getStateValueAsImageSourceList(null, string);
    }

    public HashMap<Integer, Object> getStateValueAsImageSourceList(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsImageSourceList(stateObject2);
    }

    public Sector getStateObjectAsSector(StateObject stateObject) {
        if (stateObject == null) {
            String string = Logging.getMessage("nullValue.StateObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Double d = this.getStateValueAsDouble(stateObject, "minLatitudeDegrees");
        Double d2 = this.getStateValueAsDouble(stateObject, "maxLatitudeDegrees");
        Double d3 = this.getStateValueAsDouble(stateObject, "minLongitudeDegrees");
        Double d4 = this.getStateValueAsDouble(stateObject, "maxLongitudeDegrees");
        if (d == null || d2 == null || d3 == null || d4 == null) {
            String string = Logging.getMessage("generic.ConversionError", stateObject.getName());
            Logging.logger().log(Level.SEVERE, string);
            return null;
        }
        return Sector.fromDegrees(d, d2, d3, d4);
    }

    public Sector getStateValueAsSector(String string) {
        return this.getStateValueAsSector(null, string);
    }

    public Sector getStateValueAsSector(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsSector(stateObject2);
    }

    public Color getStateObjectAsColor(StateObject stateObject) {
        String string = this.getStateObjectAsString(stateObject);
        if (string == null) {
            return null;
        }
        return RestorableSupport.decodeColor(string);
    }

    public Color getStateValueAsColor(StateObject stateObject, String string) {
        StateObject stateObject2 = this.getStateObject(stateObject, string);
        if (stateObject2 == null) {
            return null;
        }
        return this.getStateObjectAsColor(stateObject2);
    }

    public void addStateValueAsString(String string, String string2) {
        this.addStateValueAsString(null, string, string2, false);
    }

    public void addStateValueAsString(String string, String string2, boolean bl) {
        this.addStateValueAsString(null, string, string2, bl);
    }

    public void addStateValueAsString(StateObject stateObject, String string, String string2) {
        this.addStateValueAsString(stateObject, string, string2, false);
    }

    public void addStateValueAsString(StateObject stateObject, String string, String string2, boolean bl) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string3 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null || string2 == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.createStateObject(stateObject != null ? stateObject.elem : null, string, string2, bl);
    }

    public void addStateValueAsInteger(String string, int n) {
        this.addStateValueAsInteger(null, string, n);
    }

    public void addStateValueAsInteger(StateObject stateObject, String string, int n) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.addStateValueAsString(stateObject, string, Integer.toString(n));
    }

    public void addStateValueAsDouble(String string, double d) {
        this.addStateValueAsDouble(null, string, d);
    }

    public void addStateValueAsDouble(StateObject stateObject, String string, double d) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.addStateValueAsString(stateObject, string, Double.toString(d));
    }

    public void addStateValueAsBoolean(String string, boolean bl) {
        this.addStateValueAsBoolean(null, string, bl);
    }

    public void addStateValueAsBoolean(StateObject stateObject, String string, boolean bl) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.addStateValueAsString(stateObject, string, Boolean.toString(bl));
    }

    public void addStateValueAsLatLon(String string, LatLon latLon) {
        this.addStateValueAsLatLon(null, string, latLon);
    }

    public void addStateValueAsLatLon(StateObject stateObject, String string, LatLon latLon) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (latLon == null) {
            String string4 = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        StateObject stateObject2 = this.addStateObject(stateObject, string);
        if (stateObject2 != null) {
            this.addStateValueAsDouble(stateObject2, "latitudeDegrees", latLon.getLatitude().degrees);
            this.addStateValueAsDouble(stateObject2, "longitudeDegrees", latLon.getLongitude().degrees);
        }
    }

    public void addStateValueAsPosition(String string, Position position) {
        this.addStateValueAsPosition(null, string, position);
    }

    public void addStateValueAsPosition(StateObject stateObject, String string, Position position) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (position == null) {
            String string4 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        StateObject stateObject2 = this.addStateObject(stateObject, string);
        if (stateObject2 != null) {
            this.addStateValueAsDouble(stateObject2, "latitudeDegrees", position.getLatitude().degrees);
            this.addStateValueAsDouble(stateObject2, "longitudeDegrees", position.getLongitude().degrees);
            this.addStateValueAsDouble(stateObject2, "elevation", position.getElevation());
        }
    }

    public void addStateValueAsLatLonList(StateObject stateObject, String string, Iterable<? extends LatLon> iterable) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (iterable == null) {
            String string4 = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        StateObject stateObject2 = this.addStateObject(stateObject, string);
        if (stateObject2 != null) {
            for (LatLon latLon : iterable) {
                this.addStateValueAsLatLon(stateObject2, "location", latLon);
            }
        }
    }

    public void addStateValueAsOffsetsList(StateObject stateObject, String string, Map<Integer, OffsetsList> map) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (map == null) {
            String string4 = Logging.getMessage("nullValue.OffsetListIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        StateObject stateObject2 = this.addStateObject(stateObject, string);
        for (Integer n : map.keySet()) {
            this.addStateValueAsOffsets(stateObject2, "face", map.get(n));
        }
    }

    public void addStateValueAsOffsets(String string, OffsetsList offsetsList) {
        this.addStateValueAsOffsets(null, string, offsetsList);
    }

    public void addStateValueAsOffsets(StateObject stateObject, String string, OffsetsList offsetsList) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (offsetsList == null) {
            String string4 = Logging.getMessage("nullValue.OffsetsIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        StateObject stateObject2 = this.addStateObject(stateObject, string);
        if (stateObject2 != null) {
            this.addStateValueAsOffsetPair(stateObject2, "upperLeftOffset", offsetsList.getOffset(0));
            this.addStateValueAsOffsetPair(stateObject2, "upperRightOffset", offsetsList.getOffset(1));
            this.addStateValueAsOffsetPair(stateObject2, "lowerLeftOffset", offsetsList.getOffset(2));
            this.addStateValueAsOffsetPair(stateObject2, "lowerRightOffset", offsetsList.getOffset(3));
        }
    }

    public void addStateValueAsOffsetPair(StateObject stateObject, String string, float[] fArray) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (fArray == null) {
            String string4 = Logging.getMessage("nullValue.OffsetPairIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        StateObject stateObject2 = this.addStateObject(stateObject, string);
        if (stateObject2 != null) {
            this.addStateValueAsDouble(stateObject2, "uOffset", fArray[0]);
            this.addStateValueAsDouble(stateObject2, "vOffset", fArray[1]);
        }
    }

    public void addStateValueAsImageSourceList(String string, Map<Integer, Object> map, int n) {
        this.addStateValueAsImageSourceList(null, string, map, n);
    }

    public void addStateValueAsImageSourceList(StateObject stateObject, String string, Map<Integer, Object> map, int n) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (map == null) {
            String string4 = Logging.getMessage("nullValue.ImageSourcesIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        StateObject stateObject2 = this.addStateObject(stateObject, string);
        for (int i = 0; i < n; ++i) {
            if (map.get(i) == null) {
                this.addStateValueAsString(stateObject2, "imageSource", "null");
                continue;
            }
            this.addStateValueAsString(stateObject2, "imageSource", map.get(i).toString());
        }
    }

    public void addStateValueAsSector(String string, Sector sector) {
        this.addStateValueAsSector(null, string, sector);
    }

    public void addStateValueAsSector(StateObject stateObject, String string, Sector sector) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (sector == null) {
            String string4 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        StateObject stateObject2 = this.addStateObject(stateObject, string);
        if (stateObject2 != null) {
            this.addStateValueAsDouble(stateObject2, "minLatitudeDegrees", sector.getMinLatitude().degrees);
            this.addStateValueAsDouble(stateObject2, "maxLatitudeDegrees", sector.getMaxLatitude().degrees);
            this.addStateValueAsDouble(stateObject2, "minLongitudeDegrees", sector.getMinLongitude().degrees);
            this.addStateValueAsDouble(stateObject2, "maxLongitudeDegrees", sector.getMaxLongitude().degrees);
        }
    }

    public void addStateValueAsColor(String string, Color color) {
        this.addStateValueAsColor(null, string, color);
    }

    public void addStateValueAsColor(StateObject stateObject, String string, Color color) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (color == null) {
            String string4 = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        String string5 = RestorableSupport.encodeColor(color);
        this.addStateValueAsString(stateObject, string, string5);
    }

    public static String encodeColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = (color.getRed() & 0xFF) << 24 | (color.getGreen() & 0xFF) << 16 | (color.getBlue() & 0xFF) << 8 | color.getAlpha() & 0xFF;
        return String.format("%#08X", n);
    }

    public static Color decodeColor(String string) {
        Long l;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!string.startsWith("0x") && !string.startsWith("0X")) {
            return null;
        }
        try {
            l = Long.parseLong(string.substring(2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
        int n = (int)(l & 0xFFFFFFFFL);
        return new Color(n >> 24 & 0xFF, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static void adjustTitleAndDisplayName(AVList aVList) {
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
        if (string == null && aVList.getValue("gov.nasa.worldwind.avkey.Title") != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", aVList.getValue("gov.nasa.worldwind.avkey.Title"));
        }
    }

    public static class StateObject {
        final Element elem;

        public StateObject(Element element) {
            if (element == null) {
                String string = Logging.getMessage("nullValue.ElementIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.elem = element;
        }

        public String getName() {
            return this.elem.getAttribute("name");
        }

        public void setName(String string) {
            if (string == null) {
                String string2 = Logging.getMessage("nullValue.StringIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            this.elem.setAttribute("name", string);
        }

        public String getValue() {
            return this.elem.getTextContent();
        }

        public void setValue(String string) {
            if (string == null) {
                String string2 = Logging.getMessage("nullValue.StringIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            this.elem.setTextContent(string);
        }
    }
}

