/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.LatLon;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class RasterControlPointList
extends ArrayList<ControlPoint>
implements AVList {
    private AVList avList = new AVListImpl();

    public RasterControlPointList(Collection<? extends ControlPoint> collection) {
        super(collection);
    }

    public RasterControlPointList() {
    }

    @Override
    public Object setValue(String string, Object object) {
        return this.avList.setValue(string, object);
    }

    @Override
    public AVList setValues(AVList aVList) {
        return this.avList.setValues(aVList);
    }

    @Override
    public Object getValue(String string) {
        return this.avList.getValue(string);
    }

    @Override
    public Collection<Object> getValues() {
        return this.avList.getValues();
    }

    @Override
    public String getStringValue(String string) {
        return this.avList.getStringValue(string);
    }

    @Override
    public Set<Map.Entry<String, Object>> getEntries() {
        return this.avList.getEntries();
    }

    @Override
    public boolean hasKey(String string) {
        return this.avList.hasKey(string);
    }

    @Override
    public Object removeKey(String string) {
        return this.avList.removeKey(string);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.avList.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.avList.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.avList.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.avList.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        this.avList.firePropertyChange(string, object, object2);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.avList.firePropertyChange(propertyChangeEvent);
    }

    @Override
    public AVList copy() {
        return this.avList.copy();
    }

    @Override
    public AVList clearList() {
        return this.avList.clearList();
    }

    public static class ControlPoint
    extends AVListImpl {
        private final double wx;
        private final double wy;
        private final double rx;
        private final double ry;

        public ControlPoint(double d, double d2, double d3, double d4) {
            this.wx = d;
            this.wy = d2;
            this.rx = d3;
            this.ry = d4;
        }

        public Point2D getWorldPoint() {
            return new Point2D.Double(this.wx, this.wy);
        }

        public LatLon getWorldPointAsLatLon() {
            return LatLon.fromDegrees(this.wy, this.wx);
        }

        public Point2D getRasterPoint() {
            return new Point2D.Double(this.rx, this.ry);
        }
    }
}

