/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.util.Logging;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class NetworkCheckThread
extends Thread {
    protected static final long DEFAULT_NET_CHECK_INTERVAL = 1000L;
    protected AtomicBoolean showNetStatus;
    protected AtomicBoolean isNetAvailable;
    protected AtomicLong netChecInterval = new AtomicLong(1000L);

    public NetworkCheckThread(AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2, Long l) {
        if (atomicBoolean == null) {
            String string = Logging.getMessage("nullValue.StatusReferenceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (atomicBoolean2 == null) {
            String string = Logging.getMessage("nullValue.ReturnReferenceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.showNetStatus = atomicBoolean;
        this.isNetAvailable = atomicBoolean2;
        if (l != null && l > 0L) {
            this.netChecInterval.set(l);
        }
    }

    @Override
    public void run() {
        while (this.showNetStatus.get() && !Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(1000L);
                this.isNetAvailable.set(!WorldWind.getNetworkStatus().isNetworkUnavailable());
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

