/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWBufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public abstract class BufferWrapper {
    protected static final BufferWrapper EMPTY_BUFFER_WRAPPER = new EmptyBufferWrapper();

    public abstract int length();

    public abstract int getGLDataType();

    public abstract long getSizeInBytes();

    public abstract byte getByte(int var1);

    public abstract void putByte(int var1, byte var2);

    public abstract short getShort(int var1);

    public abstract void putShort(int var1, short var2);

    public abstract int getInt(int var1);

    public abstract void putInt(int var1, int var2);

    public abstract float getFloat(int var1);

    public abstract void putFloat(int var1, float var2);

    public abstract double getDouble(int var1);

    public abstract void putDouble(int var1, double var2);

    public abstract void getByte(int var1, byte[] var2, int var3, int var4);

    public abstract void putByte(int var1, byte[] var2, int var3, int var4);

    public abstract void getShort(int var1, short[] var2, int var3, int var4);

    public abstract void putShort(int var1, short[] var2, int var3, int var4);

    public abstract void getInt(int var1, int[] var2, int var3, int var4);

    public abstract void putInt(int var1, int[] var2, int var3, int var4);

    public abstract void getFloat(int var1, float[] var2, int var3, int var4);

    public abstract void putFloat(int var1, float[] var2, int var3, int var4);

    public abstract void getDouble(int var1, double[] var2, int var3, int var4);

    public abstract void putDouble(int var1, double[] var2, int var3, int var4);

    public abstract BufferWrapper getSubBuffer(int var1, int var2);

    public abstract void putSubBuffer(int var1, BufferWrapper var2);

    public abstract void putSubBuffer(int var1, BufferWrapper var2, int var3, int var4);

    public abstract BufferWrapper copyOf(int var1);

    public abstract Buffer getBackingBuffer();

    public static BufferWrapper emptyBufferWrapper() {
        return EMPTY_BUFFER_WRAPPER;
    }

    public static BufferWrapper wrap(ByteBuffer byteBuffer, Object object, Object object2) {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object == null) {
            String string = Logging.getMessage("nullValue.DataTypeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object2 != null) {
            byteBuffer.order("gov.nasa.worldwind.avkey.LittleEndian".equals(object2) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
        if ("gov.nasa.worldwind.avkey.Int8".equals(object)) {
            return new ByteBufferWrapper(byteBuffer.slice());
        }
        if ("gov.nasa.worldwind.avkey.Int16".equals(object)) {
            return new ShortBufferWrapper(byteBuffer.asShortBuffer());
        }
        if ("gov.nasa.worldwind.avkey.Int32".equals(object)) {
            return new IntBufferWrapper(byteBuffer.asIntBuffer());
        }
        if ("gov.nasa.worldwind.avkey.Float32".equals(object)) {
            return new FloatBufferWrapper(byteBuffer.asFloatBuffer());
        }
        if ("gov.nasa.worldwind.avkey.Float64".equals(object)) {
            return new DoubleBufferWrapper(byteBuffer.asDoubleBuffer());
        }
        return null;
    }

    public static BufferWrapper wrap(ByteBuffer byteBuffer, Object object) {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object == null) {
            String string = Logging.getMessage("nullValue.DataTypeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return BufferWrapper.wrap(byteBuffer, object, null);
    }

    public static BufferWrapper wrap(ByteBuffer byteBuffer, AVList aVList) {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == null) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", Logging.getMessage("term.dataType"));
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return BufferWrapper.wrap(byteBuffer, aVList.getValue("gov.nasa.worldwind.avkey.DataType"), aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder"));
    }

    protected static class EmptyBufferWrapper
    extends BufferWrapper {
        protected EmptyBufferWrapper() {
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public int getGLDataType() {
            return 0;
        }

        @Override
        public long getSizeInBytes() {
            return 0L;
        }

        @Override
        public byte getByte(int n) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putByte(int n, byte by) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public short getShort(int n) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putShort(int n, short s) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public int getInt(int n) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putInt(int n, int n2) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public float getFloat(int n) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putFloat(int n, float f) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public double getDouble(int n) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putDouble(int n, double d) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void getByte(int n, byte[] byArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putByte(int n, byte[] byArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void getShort(int n, short[] sArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putShort(int n, short[] sArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void getInt(int n, int[] nArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putInt(int n, int[] nArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void getFloat(int n, float[] fArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putFloat(int n, float[] fArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void getDouble(int n, double[] dArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putDouble(int n, double[] dArray, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public BufferWrapper getSubBuffer(int n, int n2) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putSubBuffer(int n, BufferWrapper bufferWrapper) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public void putSubBuffer(int n, BufferWrapper bufferWrapper, int n2, int n3) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }

        @Override
        public BufferWrapper copyOf(int n) {
            return new EmptyBufferWrapper();
        }

        @Override
        public Buffer getBackingBuffer() {
            return null;
        }
    }

    public static class DoubleBufferWrapper
    extends AbstractBufferWrapper<DoubleBuffer> {
        public DoubleBufferWrapper(DoubleBuffer doubleBuffer) {
            super(doubleBuffer);
        }

        public DoubleBuffer getBackingDoubleBuffer() {
            return (DoubleBuffer)this.buffer;
        }

        @Override
        public int getGLDataType() {
            return 5130;
        }

        @Override
        public long getSizeInBytes() {
            return 8 * ((DoubleBuffer)this.buffer).capacity();
        }

        @Override
        public byte getByte(int n) {
            return (byte)((DoubleBuffer)this.buffer).get(n);
        }

        @Override
        public void putByte(int n, byte by) {
            ((DoubleBuffer)this.buffer).put(n, by);
        }

        @Override
        public short getShort(int n) {
            return (short)((DoubleBuffer)this.buffer).get(n);
        }

        @Override
        public void putShort(int n, short s) {
            ((DoubleBuffer)this.buffer).put(n, s);
        }

        @Override
        public int getInt(int n) {
            return (int)((DoubleBuffer)this.buffer).get(n);
        }

        @Override
        public void putInt(int n, int n2) {
            ((DoubleBuffer)this.buffer).put(n, n2);
        }

        @Override
        public float getFloat(int n) {
            return (float)((DoubleBuffer)this.buffer).get(n);
        }

        @Override
        public void putFloat(int n, float f) {
            ((DoubleBuffer)this.buffer).put(n, f);
        }

        @Override
        public double getDouble(int n) {
            return ((DoubleBuffer)this.buffer).get(n);
        }

        @Override
        public void putDouble(int n, double d) {
            ((DoubleBuffer)this.buffer).put(n, d);
        }

        @Override
        public BufferWrapper copyOf(int n) {
            if (n < this.length()) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            DoubleBuffer doubleBuffer = WWBufferUtil.copyOf((DoubleBuffer)this.buffer, n);
            return new DoubleBufferWrapper(doubleBuffer);
        }

        @Override
        protected void doGetByte(byte[] byArray, int n, int n2) {
            double[] dArray = new double[n2];
            ((DoubleBuffer)this.buffer).get(dArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                byArray[i + n] = (byte)dArray[i];
            }
        }

        @Override
        protected void doPutByte(byte[] byArray, int n, int n2) {
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = byArray[i + n];
            }
            ((DoubleBuffer)this.buffer).put(dArray, 0, n2);
        }

        @Override
        protected void doGetShort(short[] sArray, int n, int n2) {
            double[] dArray = new double[n2];
            ((DoubleBuffer)this.buffer).get(dArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                sArray[i + n] = (short)dArray[i];
            }
        }

        @Override
        protected void doPutShort(short[] sArray, int n, int n2) {
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = sArray[i + n];
            }
            ((DoubleBuffer)this.buffer).put(dArray, 0, n2);
        }

        @Override
        protected void doGetInt(int[] nArray, int n, int n2) {
            double[] dArray = new double[n2];
            ((DoubleBuffer)this.buffer).get(dArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                nArray[i + n] = (int)dArray[i];
            }
        }

        @Override
        protected void doPutInt(int[] nArray, int n, int n2) {
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = nArray[i + n];
            }
            ((DoubleBuffer)this.buffer).put(dArray, 0, n2);
        }

        @Override
        protected void doGetFloat(float[] fArray, int n, int n2) {
            double[] dArray = new double[n2];
            ((DoubleBuffer)this.buffer).get(dArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                fArray[i + n] = (float)dArray[i];
            }
        }

        @Override
        protected void doPutFloat(float[] fArray, int n, int n2) {
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = fArray[i + n];
            }
            ((DoubleBuffer)this.buffer).put(dArray, 0, n2);
        }

        @Override
        protected void doGetDouble(double[] dArray, int n, int n2) {
            ((DoubleBuffer)this.buffer).get(dArray, n, n2);
        }

        @Override
        protected void doPutDouble(double[] dArray, int n, int n2) {
            ((DoubleBuffer)this.buffer).put(dArray, n, n2);
        }

        @Override
        protected BufferWrapper doGetSubBuffer() {
            return new DoubleBufferWrapper(((DoubleBuffer)this.buffer).slice());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doPutSubBuffer(int n, BufferWrapper bufferWrapper, int n2, int n3) {
            Buffer buffer = bufferWrapper.getBackingBuffer();
            if (buffer instanceof DoubleBuffer) {
                int n4 = ((DoubleBuffer)this.buffer).position();
                int n5 = buffer.limit();
                int n6 = buffer.position();
                try {
                    buffer.limit(n2 + n3);
                    buffer.position(n2);
                    ((DoubleBuffer)this.buffer).position(n);
                    ((DoubleBuffer)this.buffer).put((DoubleBuffer)buffer);
                }
                finally {
                    ((DoubleBuffer)this.buffer).position(n4);
                    buffer.limit(n5);
                    buffer.position(n6);
                }
                return true;
            }
            return false;
        }
    }

    public static class FloatBufferWrapper
    extends AbstractBufferWrapper<FloatBuffer> {
        public FloatBufferWrapper(FloatBuffer floatBuffer) {
            super(floatBuffer);
        }

        public FloatBuffer getBackingFloatBuffer() {
            return (FloatBuffer)this.buffer;
        }

        @Override
        public int getGLDataType() {
            return 5126;
        }

        @Override
        public long getSizeInBytes() {
            return 4 * ((FloatBuffer)this.buffer).capacity();
        }

        @Override
        public byte getByte(int n) {
            return (byte)((FloatBuffer)this.buffer).get(n);
        }

        @Override
        public void putByte(int n, byte by) {
            ((FloatBuffer)this.buffer).put(n, by);
        }

        @Override
        public short getShort(int n) {
            return (short)((FloatBuffer)this.buffer).get(n);
        }

        @Override
        public void putShort(int n, short s) {
            ((FloatBuffer)this.buffer).put(n, s);
        }

        @Override
        public int getInt(int n) {
            return (int)((FloatBuffer)this.buffer).get(n);
        }

        @Override
        public void putInt(int n, int n2) {
            ((FloatBuffer)this.buffer).put(n, n2);
        }

        @Override
        public float getFloat(int n) {
            return ((FloatBuffer)this.buffer).get(n);
        }

        @Override
        public void putFloat(int n, float f) {
            ((FloatBuffer)this.buffer).put(n, f);
        }

        @Override
        public double getDouble(int n) {
            return ((FloatBuffer)this.buffer).get(n);
        }

        @Override
        public void putDouble(int n, double d) {
            ((FloatBuffer)this.buffer).put(n, (float)d);
        }

        @Override
        public BufferWrapper copyOf(int n) {
            if (n < this.length()) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            FloatBuffer floatBuffer = WWBufferUtil.copyOf((FloatBuffer)this.buffer, n);
            return new FloatBufferWrapper(floatBuffer);
        }

        @Override
        protected void doGetByte(byte[] byArray, int n, int n2) {
            float[] fArray = new float[n2];
            ((FloatBuffer)this.buffer).get(fArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                byArray[i + n] = (byte)fArray[i];
            }
        }

        @Override
        protected void doPutByte(byte[] byArray, int n, int n2) {
            float[] fArray = new float[n2];
            for (int i = 0; i < n2; ++i) {
                fArray[i] = byArray[i + n];
            }
            ((FloatBuffer)this.buffer).put(fArray, 0, n2);
        }

        @Override
        protected void doGetShort(short[] sArray, int n, int n2) {
            float[] fArray = new float[n2];
            ((FloatBuffer)this.buffer).get(fArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                sArray[i + n] = (short)fArray[i];
            }
        }

        @Override
        protected void doPutShort(short[] sArray, int n, int n2) {
            float[] fArray = new float[n2];
            for (int i = 0; i < n2; ++i) {
                fArray[i] = sArray[i + n];
            }
            ((FloatBuffer)this.buffer).put(fArray, 0, n2);
        }

        @Override
        protected void doGetInt(int[] nArray, int n, int n2) {
            float[] fArray = new float[n2];
            ((FloatBuffer)this.buffer).get(fArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                nArray[i + n] = (int)fArray[i];
            }
        }

        @Override
        protected void doPutInt(int[] nArray, int n, int n2) {
            float[] fArray = new float[n2];
            for (int i = 0; i < n2; ++i) {
                fArray[i] = nArray[i + n];
            }
            ((FloatBuffer)this.buffer).put(fArray, 0, n2);
        }

        @Override
        protected void doGetFloat(float[] fArray, int n, int n2) {
            ((FloatBuffer)this.buffer).get(fArray, n, n2);
        }

        @Override
        protected void doPutFloat(float[] fArray, int n, int n2) {
            ((FloatBuffer)this.buffer).put(fArray, n, n2);
        }

        @Override
        protected void doGetDouble(double[] dArray, int n, int n2) {
            float[] fArray = new float[n2];
            ((FloatBuffer)this.buffer).get(fArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                dArray[i + n] = fArray[i];
            }
        }

        @Override
        protected void doPutDouble(double[] dArray, int n, int n2) {
            float[] fArray = new float[n2];
            for (int i = 0; i < n2; ++i) {
                fArray[i] = (float)dArray[i + n];
            }
            ((FloatBuffer)this.buffer).put(fArray, 0, n2);
        }

        @Override
        protected BufferWrapper doGetSubBuffer() {
            return new FloatBufferWrapper(((FloatBuffer)this.buffer).slice());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doPutSubBuffer(int n, BufferWrapper bufferWrapper, int n2, int n3) {
            Buffer buffer = bufferWrapper.getBackingBuffer();
            if (buffer instanceof FloatBuffer) {
                int n4 = ((FloatBuffer)this.buffer).position();
                int n5 = buffer.limit();
                int n6 = buffer.position();
                try {
                    buffer.limit(n2 + n3);
                    buffer.position(n2);
                    ((FloatBuffer)this.buffer).position(n);
                    ((FloatBuffer)this.buffer).put((FloatBuffer)buffer);
                }
                finally {
                    ((FloatBuffer)this.buffer).position(n4);
                    buffer.limit(n5);
                    buffer.position(n6);
                }
                return true;
            }
            return false;
        }
    }

    public static class IntBufferWrapper
    extends AbstractBufferWrapper<IntBuffer> {
        public IntBufferWrapper(IntBuffer intBuffer) {
            super(intBuffer);
        }

        public IntBuffer getBackingIntBuffer() {
            return (IntBuffer)this.buffer;
        }

        @Override
        public int getGLDataType() {
            return 5124;
        }

        @Override
        public long getSizeInBytes() {
            return 4 * ((IntBuffer)this.buffer).capacity();
        }

        @Override
        public byte getByte(int n) {
            return (byte)((IntBuffer)this.buffer).get(n);
        }

        @Override
        public void putByte(int n, byte by) {
            ((IntBuffer)this.buffer).put(n, by);
        }

        @Override
        public short getShort(int n) {
            return (short)((IntBuffer)this.buffer).get(n);
        }

        @Override
        public void putShort(int n, short s) {
            ((IntBuffer)this.buffer).put(n, s);
        }

        @Override
        public int getInt(int n) {
            return ((IntBuffer)this.buffer).get(n);
        }

        @Override
        public void putInt(int n, int n2) {
            ((IntBuffer)this.buffer).put(n, n2);
        }

        @Override
        public float getFloat(int n) {
            return ((IntBuffer)this.buffer).get(n);
        }

        @Override
        public void putFloat(int n, float f) {
            ((IntBuffer)this.buffer).put(n, (int)f);
        }

        @Override
        public double getDouble(int n) {
            return ((IntBuffer)this.buffer).get(n);
        }

        @Override
        public void putDouble(int n, double d) {
            ((IntBuffer)this.buffer).put(n, (int)d);
        }

        @Override
        public BufferWrapper copyOf(int n) {
            if (n < this.length()) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            IntBuffer intBuffer = WWBufferUtil.copyOf((IntBuffer)this.buffer, n);
            return new IntBufferWrapper(intBuffer);
        }

        @Override
        protected void doGetByte(byte[] byArray, int n, int n2) {
            int[] nArray = new int[n2];
            ((IntBuffer)this.buffer).get(nArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                byArray[i + n] = (byte)nArray[i];
            }
        }

        @Override
        protected void doPutByte(byte[] byArray, int n, int n2) {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = byArray[i + n];
            }
            ((IntBuffer)this.buffer).put(nArray, 0, n2);
        }

        @Override
        protected void doGetShort(short[] sArray, int n, int n2) {
            int[] nArray = new int[n2];
            ((IntBuffer)this.buffer).get(nArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                sArray[i + n] = (short)nArray[i];
            }
        }

        @Override
        protected void doPutShort(short[] sArray, int n, int n2) {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = sArray[i + n];
            }
            ((IntBuffer)this.buffer).put(nArray, 0, n2);
        }

        @Override
        protected void doGetInt(int[] nArray, int n, int n2) {
            ((IntBuffer)this.buffer).get(nArray, n, n2);
        }

        @Override
        protected void doPutInt(int[] nArray, int n, int n2) {
            ((IntBuffer)this.buffer).put(nArray, n, n2);
        }

        @Override
        protected void doGetFloat(float[] fArray, int n, int n2) {
            int[] nArray = new int[n2];
            ((IntBuffer)this.buffer).get(nArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                fArray[i + n] = nArray[i];
            }
        }

        @Override
        protected void doPutFloat(float[] fArray, int n, int n2) {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = (int)fArray[i + n];
            }
            ((IntBuffer)this.buffer).put(nArray, 0, n2);
        }

        @Override
        protected void doGetDouble(double[] dArray, int n, int n2) {
            int[] nArray = new int[n2];
            ((IntBuffer)this.buffer).get(nArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                dArray[i + n] = nArray[i];
            }
        }

        @Override
        protected void doPutDouble(double[] dArray, int n, int n2) {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = (int)dArray[i + n];
            }
            ((IntBuffer)this.buffer).put(nArray, 0, n2);
        }

        @Override
        protected BufferWrapper doGetSubBuffer() {
            return new IntBufferWrapper(((IntBuffer)this.buffer).slice());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doPutSubBuffer(int n, BufferWrapper bufferWrapper, int n2, int n3) {
            Buffer buffer = bufferWrapper.getBackingBuffer();
            if (buffer instanceof IntBuffer) {
                int n4 = ((IntBuffer)this.buffer).position();
                int n5 = buffer.limit();
                int n6 = buffer.position();
                try {
                    buffer.limit(n2 + n3);
                    buffer.position(n2);
                    ((IntBuffer)this.buffer).position(n);
                    ((IntBuffer)this.buffer).put((IntBuffer)buffer);
                }
                finally {
                    ((IntBuffer)this.buffer).position(n4);
                    buffer.limit(n5);
                    buffer.position(n6);
                }
                return true;
            }
            return false;
        }
    }

    public static class ShortBufferWrapper
    extends AbstractBufferWrapper<ShortBuffer> {
        public ShortBufferWrapper(ShortBuffer shortBuffer) {
            super(shortBuffer);
        }

        public ShortBuffer getBackingShortBuffer() {
            return (ShortBuffer)this.buffer;
        }

        @Override
        public int getGLDataType() {
            return 5122;
        }

        @Override
        public long getSizeInBytes() {
            return 2 * ((ShortBuffer)this.buffer).capacity();
        }

        @Override
        public byte getByte(int n) {
            return (byte)((ShortBuffer)this.buffer).get(n);
        }

        @Override
        public void putByte(int n, byte by) {
            ((ShortBuffer)this.buffer).put(n, by);
        }

        @Override
        public short getShort(int n) {
            return ((ShortBuffer)this.buffer).get(n);
        }

        @Override
        public void putShort(int n, short s) {
            ((ShortBuffer)this.buffer).put(n, s);
        }

        @Override
        public int getInt(int n) {
            return ((ShortBuffer)this.buffer).get(n);
        }

        @Override
        public void putInt(int n, int n2) {
            ((ShortBuffer)this.buffer).put(n, (short)n2);
        }

        @Override
        public float getFloat(int n) {
            return ((ShortBuffer)this.buffer).get(n);
        }

        @Override
        public void putFloat(int n, float f) {
            ((ShortBuffer)this.buffer).put(n, (short)f);
        }

        @Override
        public double getDouble(int n) {
            return ((ShortBuffer)this.buffer).get(n);
        }

        @Override
        public void putDouble(int n, double d) {
            ((ShortBuffer)this.buffer).put(n, (short)d);
        }

        @Override
        public BufferWrapper copyOf(int n) {
            if (n < this.length()) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            ShortBuffer shortBuffer = WWBufferUtil.copyOf((ShortBuffer)this.buffer, n);
            return new ShortBufferWrapper(shortBuffer);
        }

        @Override
        protected void doGetByte(byte[] byArray, int n, int n2) {
            short[] sArray = new short[n2];
            ((ShortBuffer)this.buffer).get(sArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                byArray[i + n] = (byte)sArray[i];
            }
        }

        @Override
        protected void doPutByte(byte[] byArray, int n, int n2) {
            short[] sArray = new short[n2];
            for (int i = 0; i < n2; ++i) {
                sArray[i] = byArray[i + n];
            }
            ((ShortBuffer)this.buffer).put(sArray, 0, n2);
        }

        @Override
        protected void doGetShort(short[] sArray, int n, int n2) {
            ((ShortBuffer)this.buffer).get(sArray, n, n2);
        }

        @Override
        protected void doPutShort(short[] sArray, int n, int n2) {
            ((ShortBuffer)this.buffer).put(sArray, n, n2);
        }

        @Override
        protected void doGetInt(int[] nArray, int n, int n2) {
            short[] sArray = new short[n2];
            ((ShortBuffer)this.buffer).get(sArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                nArray[i + n] = sArray[i];
            }
        }

        @Override
        protected void doPutInt(int[] nArray, int n, int n2) {
            short[] sArray = new short[n2];
            for (int i = 0; i < n2; ++i) {
                sArray[i] = (short)nArray[i + n];
            }
            ((ShortBuffer)this.buffer).put(sArray, 0, n2);
        }

        @Override
        protected void doGetFloat(float[] fArray, int n, int n2) {
            short[] sArray = new short[n2];
            ((ShortBuffer)this.buffer).get(sArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                fArray[i + n] = sArray[i];
            }
        }

        @Override
        protected void doPutFloat(float[] fArray, int n, int n2) {
            short[] sArray = new short[n2];
            for (int i = 0; i < n2; ++i) {
                sArray[i] = (short)fArray[i + n];
            }
            ((ShortBuffer)this.buffer).put(sArray, 0, n2);
        }

        @Override
        protected void doGetDouble(double[] dArray, int n, int n2) {
            short[] sArray = new short[n2];
            ((ShortBuffer)this.buffer).get(sArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                dArray[i + n] = sArray[i];
            }
        }

        @Override
        protected void doPutDouble(double[] dArray, int n, int n2) {
            short[] sArray = new short[n2];
            for (int i = 0; i < n2; ++i) {
                sArray[i] = (short)dArray[i + n];
            }
            ((ShortBuffer)this.buffer).put(sArray, 0, n2);
        }

        @Override
        protected BufferWrapper doGetSubBuffer() {
            return new ShortBufferWrapper(((ShortBuffer)this.buffer).slice());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doPutSubBuffer(int n, BufferWrapper bufferWrapper, int n2, int n3) {
            Buffer buffer = bufferWrapper.getBackingBuffer();
            if (buffer instanceof ShortBuffer) {
                int n4 = ((ShortBuffer)this.buffer).position();
                int n5 = buffer.limit();
                int n6 = buffer.position();
                try {
                    buffer.limit(n2 + n3);
                    buffer.position(n2);
                    ((ShortBuffer)this.buffer).position(n);
                    ((ShortBuffer)this.buffer).put((ShortBuffer)buffer);
                }
                finally {
                    ((ShortBuffer)this.buffer).position(n4);
                    buffer.limit(n5);
                    buffer.position(n6);
                }
                return true;
            }
            return false;
        }
    }

    public static class ByteBufferWrapper
    extends AbstractBufferWrapper<ByteBuffer> {
        public ByteBufferWrapper(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        public ByteBuffer getBackingByteBuffer() {
            return (ByteBuffer)this.buffer;
        }

        @Override
        public int getGLDataType() {
            return 5120;
        }

        @Override
        public long getSizeInBytes() {
            return ((ByteBuffer)this.buffer).capacity();
        }

        @Override
        public byte getByte(int n) {
            return ((ByteBuffer)this.buffer).get(n);
        }

        @Override
        public void putByte(int n, byte by) {
            ((ByteBuffer)this.buffer).put(n, by);
        }

        @Override
        public short getShort(int n) {
            return ((ByteBuffer)this.buffer).get(n);
        }

        @Override
        public void putShort(int n, short s) {
            ((ByteBuffer)this.buffer).put(n, (byte)s);
        }

        @Override
        public int getInt(int n) {
            return ((ByteBuffer)this.buffer).get(n);
        }

        @Override
        public void putInt(int n, int n2) {
            ((ByteBuffer)this.buffer).put(n, (byte)n2);
        }

        @Override
        public float getFloat(int n) {
            return ((ByteBuffer)this.buffer).get(n);
        }

        @Override
        public void putFloat(int n, float f) {
            ((ByteBuffer)this.buffer).put(n, (byte)f);
        }

        @Override
        public double getDouble(int n) {
            return ((ByteBuffer)this.buffer).get(n);
        }

        @Override
        public void putDouble(int n, double d) {
            ((ByteBuffer)this.buffer).put(n, (byte)d);
        }

        @Override
        public BufferWrapper copyOf(int n) {
            if (n < this.length()) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            ByteBuffer byteBuffer = WWBufferUtil.copyOf((ByteBuffer)this.buffer, n);
            return new ByteBufferWrapper(byteBuffer);
        }

        @Override
        protected void doGetByte(byte[] byArray, int n, int n2) {
            ((ByteBuffer)this.buffer).get(byArray, n, n2);
        }

        @Override
        protected void doPutByte(byte[] byArray, int n, int n2) {
            ((ByteBuffer)this.buffer).put(byArray, n, n2);
        }

        @Override
        protected void doGetShort(short[] sArray, int n, int n2) {
            byte[] byArray = new byte[n2];
            ((ByteBuffer)this.buffer).get(byArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                sArray[i + n] = byArray[i];
            }
        }

        @Override
        protected void doPutShort(short[] sArray, int n, int n2) {
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)sArray[i + n];
            }
            ((ByteBuffer)this.buffer).put(byArray, 0, n2);
        }

        @Override
        protected void doGetInt(int[] nArray, int n, int n2) {
            byte[] byArray = new byte[n2];
            ((ByteBuffer)this.buffer).get(byArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                nArray[i + n] = byArray[i];
            }
        }

        @Override
        protected void doPutInt(int[] nArray, int n, int n2) {
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)nArray[i + n];
            }
            ((ByteBuffer)this.buffer).put(byArray, 0, n2);
        }

        @Override
        protected void doGetFloat(float[] fArray, int n, int n2) {
            byte[] byArray = new byte[n2];
            ((ByteBuffer)this.buffer).get(byArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                fArray[i + n] = byArray[i];
            }
        }

        @Override
        protected void doPutFloat(float[] fArray, int n, int n2) {
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)fArray[i + n];
            }
            ((ByteBuffer)this.buffer).put(byArray, 0, n2);
        }

        @Override
        protected void doGetDouble(double[] dArray, int n, int n2) {
            byte[] byArray = new byte[n2];
            ((ByteBuffer)this.buffer).get(byArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                dArray[i + n] = byArray[i];
            }
        }

        @Override
        protected void doPutDouble(double[] dArray, int n, int n2) {
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)dArray[i + n];
            }
            ((ByteBuffer)this.buffer).put(byArray, 0, n2);
        }

        @Override
        protected BufferWrapper doGetSubBuffer() {
            return new ByteBufferWrapper(((ByteBuffer)this.buffer).slice());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doPutSubBuffer(int n, BufferWrapper bufferWrapper, int n2, int n3) {
            Buffer buffer = bufferWrapper.getBackingBuffer();
            if (buffer instanceof ByteBuffer) {
                int n4 = ((ByteBuffer)this.buffer).position();
                int n5 = buffer.limit();
                int n6 = buffer.position();
                try {
                    buffer.limit(n2 + n3);
                    buffer.position(n2);
                    ((ByteBuffer)this.buffer).position(n);
                    ((ByteBuffer)this.buffer).put((ByteBuffer)buffer);
                }
                finally {
                    ((ByteBuffer)this.buffer).position(n4);
                    buffer.limit(n5);
                    buffer.position(n6);
                }
                return true;
            }
            return false;
        }
    }

    public static abstract class AbstractBufferWrapper<T extends Buffer>
    extends BufferWrapper {
        protected T buffer;

        public AbstractBufferWrapper(T t) {
            if (t == null) {
                String string = Logging.getMessage("nullValue.BufferIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.buffer = t;
        }

        @Override
        public int length() {
            return ((Buffer)this.buffer).remaining();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getByte(int n, byte[] byArray, int n2, int n3) {
            if (byArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doGetByte(byArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putByte(int n, byte[] byArray, int n2, int n3) {
            if (byArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doPutByte(byArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getShort(int n, short[] sArray, int n2, int n3) {
            if (sArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doGetShort(sArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putShort(int n, short[] sArray, int n2, int n3) {
            if (sArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doPutShort(sArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doGetInt(nArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doPutInt(nArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getFloat(int n, float[] fArray, int n2, int n3) {
            if (fArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doGetFloat(fArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putFloat(int n, float[] fArray, int n2, int n3) {
            if (fArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doPutFloat(fArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doGetDouble(dArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).position(n);
                this.doPutDouble(dArray, n2, n3);
            }
            finally {
                ((Buffer)this.buffer).position(n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferWrapper getSubBuffer(int n, int n2) {
            if (n2 <= 0) {
                return EMPTY_BUFFER_WRAPPER;
            }
            BufferWrapper bufferWrapper = null;
            int n3 = ((Buffer)this.buffer).limit();
            int n4 = ((Buffer)this.buffer).position();
            try {
                ((Buffer)this.buffer).limit(n + n2);
                ((Buffer)this.buffer).position(n);
                bufferWrapper = this.doGetSubBuffer();
            }
            finally {
                ((Buffer)this.buffer).limit(n3);
                ((Buffer)this.buffer).position(n4);
            }
            return bufferWrapper;
        }

        @Override
        public void putSubBuffer(int n, BufferWrapper bufferWrapper) {
            if (bufferWrapper == null) {
                String string = Logging.getMessage("nullValue.BufferIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.putSubBuffer(n, bufferWrapper, 0, bufferWrapper.length());
        }

        @Override
        public void putSubBuffer(int n, BufferWrapper bufferWrapper, int n2, int n3) {
            if (bufferWrapper == null) {
                String string = Logging.getMessage("nullValue.BufferIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (bufferWrapper.getBackingBuffer() == this.buffer) {
                String string = Logging.getMessage("generic.CannotCopyBufferToSelf");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n3 <= 0) {
                return;
            }
            if (this.doPutSubBuffer(n, bufferWrapper, n2, n3)) {
                return;
            }
            double[] dArray = new double[n3];
            bufferWrapper.getDouble(n2, dArray, 0, n3);
            this.putDouble(n, dArray, 0, n3);
        }

        @Override
        public Buffer getBackingBuffer() {
            return this.buffer;
        }

        protected abstract void doGetByte(byte[] var1, int var2, int var3);

        protected abstract void doPutByte(byte[] var1, int var2, int var3);

        protected abstract void doGetShort(short[] var1, int var2, int var3);

        protected abstract void doPutShort(short[] var1, int var2, int var3);

        protected abstract void doGetInt(int[] var1, int var2, int var3);

        protected abstract void doPutInt(int[] var1, int var2, int var3);

        protected abstract void doGetFloat(float[] var1, int var2, int var3);

        protected abstract void doPutFloat(float[] var1, int var2, int var3);

        protected abstract void doGetDouble(double[] var1, int var2, int var3);

        protected abstract void doPutDouble(double[] var1, int var2, int var3);

        protected abstract BufferWrapper doGetSubBuffer();

        protected abstract boolean doPutSubBuffer(int var1, BufferWrapper var2, int var3, int var4);
    }
}

