/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;

public class BasicDragger
implements SelectListener {
    private final WorldWindow wwd;
    private boolean dragging = false;
    private boolean useTerrain = true;
    private Point dragRefCursorPoint;
    private Vec4 dragRefObjectPoint;
    private double dragRefAltitude;

    public BasicDragger(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
    }

    public BasicDragger(WorldWindow worldWindow, boolean bl) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.setUseTerrain(bl);
    }

    public boolean isUseTerrain() {
        return this.useTerrain;
    }

    public void setUseTerrain(boolean bl) {
        this.useTerrain = bl;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.dragging = false;
            selectEvent.consume();
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            DragSelectEvent dragSelectEvent = (DragSelectEvent)selectEvent;
            Object object = dragSelectEvent.getTopObject();
            if (object == null) {
                return;
            }
            if (!(object instanceof Movable)) {
                return;
            }
            Movable movable = (Movable)object;
            View view = this.wwd.getView();
            Globe globe = this.wwd.getModel().getGlobe();
            Position position = movable.getReferencePosition();
            if (position == null) {
                return;
            }
            Vec4 vec4 = globe.computePointFromPosition(position);
            if (!this.isDragging()) {
                this.dragRefObjectPoint = view.project(vec4);
                this.dragRefCursorPoint = dragSelectEvent.getPreviousPickPoint();
                this.dragRefAltitude = globe.computePositionFromPoint(vec4).getElevation();
            }
            int n = dragSelectEvent.getPickPoint().x - this.dragRefCursorPoint.x;
            int n2 = dragSelectEvent.getPickPoint().y - this.dragRefCursorPoint.y;
            double d = this.dragRefObjectPoint.x + (double)n;
            double d2 = (double)selectEvent.getMouseEvent().getComponent().getSize().height - this.dragRefObjectPoint.y + (double)n2 - 1.0;
            Line line = view.computeRayFromScreenPoint(d, d2);
            Position position2 = null;
            Intersection[] intersectionArray = globe.intersect(line, this.dragRefAltitude);
            if (intersectionArray != null) {
                position2 = globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
            }
            if (position2 != null) {
                Position position3 = new Position(position2, movable.getReferencePosition().getElevation());
                movable.moveTo(position3);
            }
            this.dragging = true;
            selectEvent.consume();
        }
    }
}

