/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.cache.BasicSessionCache;
import gov.nasa.worldwind.util.Logging;

public class AbsentResourceList {
    protected static final int DEFAULT_MAX_ABSENT_RESOURCE_TRIES = 3;
    protected static final int DEFAULT_MIN_ABSENT_RESOURCE_CHECK_INTERVAL = 10000;
    protected static final int DEFAULT_TRY_AGAIN_INTERVAL = 60000;
    protected int maxTries = 3;
    protected int minCheckInterval = 10000;
    protected int tryAgainInterval = 60000;
    protected BasicSessionCache possiblyAbsent = new BasicSessionCache(1000);

    public AbsentResourceList() {
    }

    public AbsentResourceList(int n, int n2) {
        if (n < 1) {
            String string = Logging.getMessage("AbsentResourceList.MaxTriesLessThanOne");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("AbsentResourceList.CheckIntervalLessThanZero");
            throw new IllegalArgumentException(string);
        }
        this.maxTries = n;
        this.minCheckInterval = n2;
    }

    public AbsentResourceList(Integer n, int n2, int n3, int n4) {
        if (n2 < 1) {
            String string = Logging.getMessage("AbsentResourceList.MaxTriesLessThanOne");
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0) {
            String string = Logging.getMessage("AbsentResourceList.CheckIntervalLessThanZero");
            throw new IllegalArgumentException(string);
        }
        if (n4 < 0) {
            String string = Logging.getMessage("AbsentResourceList.RetryIntervalLessThanZero");
            throw new IllegalArgumentException(string);
        }
        if (n != null && n < 1) {
            String string = Logging.getMessage("AbsentResourceList.MaximumListSizeLessThanOne");
            throw new IllegalArgumentException(string);
        }
        if (n != null) {
            this.possiblyAbsent.setCapacity(n);
        }
        this.maxTries = Math.max(n2, 1);
        this.minCheckInterval = n3;
        this.tryAgainInterval = n4;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public void setMaxTries(int n) {
        if (n < 1) {
            String string = Logging.getMessage("AbsentResourceList.MaxTriesLessThanOne");
            throw new IllegalArgumentException(string);
        }
        this.maxTries = n;
    }

    public int getMinCheckInterval() {
        return this.minCheckInterval;
    }

    public void setMinCheckInterval(int n) {
        if (n < 0) {
            String string = Logging.getMessage("AbsentResourceList.CheckIntervalLessThanZero");
            throw new IllegalArgumentException(string);
        }
        this.minCheckInterval = n;
    }

    public int getTryAgainInterval() {
        return this.tryAgainInterval;
    }

    public void setTryAgainInterval(int n) {
        if (n < 0) {
            String string = Logging.getMessage("AbsentResourceList.RetryIntervalLessThanZero");
            throw new IllegalArgumentException(string);
        }
        this.tryAgainInterval = n;
    }

    public final void markResourceAbsent(long l) {
        this.markResourceAbsent(Long.toString(l));
    }

    public final boolean isResourceAbsent(long l) {
        return this.isResourceAbsent(Long.toString(l));
    }

    public final void unmarkResourceAbsent(long l) {
        this.unmarkResourceAbsent(Long.toString(l));
    }

    public final synchronized void markResourceAbsent(String string) {
        AbsentResourceEntry absentResourceEntry = (AbsentResourceEntry)this.possiblyAbsent.get(string);
        if (absentResourceEntry == null) {
            absentResourceEntry = new AbsentResourceEntry();
            this.possiblyAbsent.put(string, absentResourceEntry);
        }
        ++absentResourceEntry.numTries;
        absentResourceEntry.timeOfLastMark = System.currentTimeMillis();
    }

    public final synchronized boolean isResourceAbsent(String string) {
        AbsentResourceEntry absentResourceEntry = (AbsentResourceEntry)this.possiblyAbsent.get(string);
        if (absentResourceEntry == null) {
            return false;
        }
        long l = System.currentTimeMillis() - absentResourceEntry.timeOfLastMark;
        if (l > (long)this.tryAgainInterval) {
            this.possiblyAbsent.remove(string);
            return false;
        }
        return l < (long)this.minCheckInterval || absentResourceEntry.numTries > this.maxTries;
    }

    public final synchronized void unmarkResourceAbsent(String string) {
        this.possiblyAbsent.remove(string);
    }

    protected static class AbsentResourceEntry {
        long timeOfLastMark;
        int numTries;

        protected AbsentResourceEntry() {
        }
    }
}

