/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.terrain.AbstractElevationModel;
import java.util.List;

public class BathymetryFilterElevationModel
extends AbstractElevationModel {
    protected ElevationModel sourceModel;
    protected double threshold = 0.0;

    public BathymetryFilterElevationModel(ElevationModel elevationModel) {
        this.sourceModel = elevationModel;
    }

    @Override
    public void dispose() {
        if (this.sourceModel != null) {
            this.sourceModel.dispose();
        }
    }

    public ElevationModel getSourceModel() {
        return this.sourceModel;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    @Override
    public double getMaxElevation() {
        return this.clampElevation(this.sourceModel.getMaxElevation());
    }

    @Override
    public double getMinElevation() {
        return this.clampElevation(this.sourceModel.getMinElevation());
    }

    @Override
    public double[] getExtremeElevations(Angle angle, Angle angle2) {
        double[] dArray = this.sourceModel.getExtremeElevations(angle, angle2);
        if (dArray == null) {
            return dArray;
        }
        return new double[]{this.clampElevation(dArray[0]), this.clampElevation(dArray[1])};
    }

    @Override
    public double[] getExtremeElevations(Sector sector) {
        double[] dArray = this.sourceModel.getExtremeElevations(sector);
        if (dArray == null) {
            return dArray;
        }
        return new double[]{this.clampElevation(dArray[0]), this.clampElevation(dArray[1])};
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        double d2 = this.sourceModel.getElevations(sector, list, d, dArray);
        for (int i = 0; i < list.size(); ++i) {
            LatLon latLon = list.get(i);
            if (!this.sourceModel.contains(latLon.getLatitude(), latLon.getLongitude()) || !(dArray[i] < this.threshold)) continue;
            dArray[i] = this.threshold;
        }
        return d2;
    }

    @Override
    public double getUnmappedElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        double d2 = this.sourceModel.getElevations(sector, list, d, dArray);
        for (int i = 0; i < list.size(); ++i) {
            LatLon latLon = list.get(i);
            if (!this.sourceModel.contains(latLon.getLatitude(), latLon.getLongitude()) || dArray[i] == this.sourceModel.getMissingDataSignal() || !(dArray[i] < this.threshold)) continue;
            dArray[i] = this.threshold;
        }
        return d2;
    }

    @Override
    public int intersects(Sector sector) {
        return this.sourceModel.intersects(sector);
    }

    @Override
    public boolean contains(Angle angle, Angle angle2) {
        return this.sourceModel.contains(angle, angle2);
    }

    @Override
    public double getBestResolution(Sector sector) {
        return this.sourceModel.getBestResolution(sector);
    }

    @Override
    public double getUnmappedElevation(Angle angle, Angle angle2) {
        double d = this.sourceModel.getUnmappedElevation(angle, angle2);
        return d != this.sourceModel.getMissingDataSignal() && d < this.threshold ? this.threshold : d;
    }

    protected double clampElevation(double d) {
        return d < this.threshold ? this.threshold : d;
    }

    @Override
    public double getLocalDataAvailability(Sector sector, Double d) {
        return this.sourceModel.getLocalDataAvailability(sector, d);
    }

    @Override
    public Object getValue(String string) {
        Object object = super.getValue(string);
        return object != null ? object : (this.sourceModel != null ? this.sourceModel.getValue(string) : null);
    }
}

