/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalPoint;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AbstractCircularGraphic;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.List;

public class RoutePoint
extends AbstractCircularGraphic
implements TacticalPoint,
PreRenderable {
    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-APP--------", "G-G-APC--------");
    }

    public RoutePoint(String string) {
        super(string);
    }

    protected String createLabelText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getGraphicLabel());
        String string = this.getText();
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append("\n");
            stringBuilder.append(this.getText());
        }
        return stringBuilder.toString();
    }

    protected String getGraphicLabel() {
        String string = this.maskedSymbolCode;
        if ("G-G-APP--------".equalsIgnoreCase(string)) {
            return "ACP";
        }
        if ("G-G-APC--------".equalsIgnoreCase(string)) {
            return "CCP";
        }
        return "";
    }

    @Override
    protected void createLabels() {
        String string = this.createLabelText();
        if (!WWUtil.isEmpty(string)) {
            this.addLabel(string);
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        LatLon latLon = this.circle.getCenter();
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(new Position(latLon, 0.0));
    }
}

