/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PrincipleDirectionOfFire
extends AbstractMilStd2525TacticalGraphic
implements PreRenderable {
    public static final double DEFAULT_ARROWHEAD_LENGTH = 0.1;
    public static final Angle DEFAULT_ARROWHEAD_ANGLE = Angle.fromDegrees(60.0);
    public static final double DEFAULT_ARROWHEAD_OUTLINE_WIDTH = 0.3;
    protected Angle arrowAngle = DEFAULT_ARROWHEAD_ANGLE;
    protected double arrowLength = 0.1;
    protected double outlineWidth = 0.3;
    protected Position position1;
    protected Position position2;
    protected Position position3;
    protected Path[] paths;
    protected TacticalSymbol symbol;
    protected TacticalSymbolAttributes symbolAttributes;
    protected SurfacePolygon thickLine;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-DLP--------");
    }

    public PrincipleDirectionOfFire(String string) {
        super(string);
    }

    public Angle getArrowAngle() {
        return this.arrowAngle;
    }

    public void setArrowAngle(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees <= 0.0 || angle.degrees >= 90.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowAngle = angle;
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowLength = d;
    }

    public String getSymbol() {
        return this.symbol != null ? this.symbol.getIdentifier() : null;
    }

    public void setSymbol(String string) {
        if (string != null) {
            if (this.symbolAttributes == null) {
                this.symbolAttributes = new BasicTacticalSymbolAttributes();
            }
            this.symbol = this.createSymbol(string, this.position1, this.symbolAttributes);
        } else {
            this.symbol = null;
            this.symbolAttributes = null;
        }
        this.onModifierChanged();
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            this.position1 = iterator.next();
            this.position2 = iterator.next();
            this.position3 = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.paths = null;
        this.thickLine = null;
        if (this.symbol != null) {
            this.symbol.setPosition(this.position1);
        }
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.position1, this.position2, this.position3);
    }

    @Override
    public Position getReferencePosition() {
        return this.position1;
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("A".equals(string) && object instanceof String) {
            this.setSymbol((String)object);
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public Object getModifier(String string) {
        if ("A".equals(string)) {
            return this.getSymbol();
        }
        return super.getModifier(string);
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        if (this.paths == null) {
            this.createShapes(drawContext);
        }
        this.determinePerFrameAttributes(drawContext);
        if (this.thickLine != null) {
            this.thickLine.preRender(drawContext);
        }
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        for (Path path : this.paths) {
            path.render(drawContext);
        }
        if (this.thickLine != null) {
            this.thickLine.render(drawContext);
        }
    }

    @Override
    protected void doRenderGraphicModifiers(DrawContext drawContext) {
        super.doRenderGraphicModifiers(drawContext);
        if (this.symbol != null) {
            this.symbol.render(drawContext);
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.paths == null) {
            return;
        }
        for (Path path : this.paths) {
            path.setDelegateOwner(object);
        }
        if (this.symbol != null) {
            this.symbol.setDelegateOwner(object);
        }
        if (this.thickLine != null) {
            this.thickLine.setDelegateOwner(object);
        }
    }

    @Override
    protected void createLabels() {
        this.addLabel("(PDF)");
    }

    protected void createShapes(DrawContext drawContext) {
        Angle angle;
        this.paths = new Path[4];
        int n = 0;
        this.paths[n++] = this.createPath(Arrays.asList(this.position1, this.position2));
        this.paths[n++] = this.createPath(Arrays.asList(this.position1, this.position3));
        List<Position> list = this.computeArrowheadPositions(drawContext, this.position1, this.position2);
        this.paths[n++] = this.createPath(list);
        list = this.computeArrowheadPositions(drawContext, this.position1, this.position3);
        this.paths[n] = this.createPath(list);
        LatLon latLon = LatLon.interpolateGreatCircle(0.25, this.position1, this.position2);
        LatLon latLon2 = LatLon.interpolateGreatCircle(0.75, this.position1, this.position2);
        Angle angle2 = LatLon.greatCircleAzimuth(this.position1, this.position2);
        angle2 = angle2.compareTo(angle = LatLon.greatCircleAzimuth(this.position1, this.position3)) > 0 ? angle2.add(Angle.NEG90) : angle2.add(Angle.POS90);
        Angle angle3 = LatLon.greatCircleDistance(this.position1, this.position2);
        LatLon latLon3 = LatLon.greatCircleEndPosition(latLon, angle2, angle3.multiply(0.01));
        LatLon latLon4 = LatLon.greatCircleEndPosition(latLon2, angle2, angle3.multiply(0.01));
        this.thickLine = this.createPolygon(Arrays.asList(latLon, latLon2, latLon4, latLon3));
    }

    protected List<Position> computeArrowheadPositions(DrawContext drawContext, Position position, Position position2) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computePointFromPosition(position2);
        Vec4 vec43 = vec4.subtract3(vec42);
        double d = this.getArrowLength();
        Vec4 vec44 = vec42.add3(vec43.multiply3(d));
        Vec4 vec45 = globe.computeSurfaceNormalAtPoint(vec44);
        double d2 = vec43.getLength3() * d;
        double d3 = d2 * this.getArrowAngle().tanHalfAngle();
        Vec4 vec46 = vec43.cross3(vec45);
        vec46 = vec46.normalize3().multiply3(d3);
        Vec4 vec47 = vec44.add3(vec46);
        Vec4 vec48 = vec44.subtract3(vec46);
        return TacticalGraphicUtil.asPositionList(globe, vec47, vec42, vec48);
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        super.applyDefaultAttributes(shapeAttributes);
        shapeAttributes.setDrawInterior(true);
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (WWUtil.isEmpty(this.labels)) {
            return;
        }
        Angle angle = LatLon.greatCircleAzimuth(this.position1, this.position2);
        Angle angle2 = LatLon.greatCircleDistance(this.position1, this.position2);
        Angle angle3 = Angle.fromDegrees(1.1 * angle2.degrees);
        LatLon latLon = LatLon.greatCircleEndPosition((LatLon)this.position1, angle, angle3);
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(new Position(latLon, 0.0));
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        if (this.symbolAttributes != null) {
            ShapeAttributes shapeAttributes = this.getActiveShapeAttributes();
            this.symbolAttributes.setOpacity(shapeAttributes.getInteriorOpacity());
            this.symbolAttributes.setScale(this.activeOverrides.getScale());
        }
    }

    protected Path createPath(List<Position> list) {
        Path path = new Path(list);
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }

    protected SurfacePolygon createPolygon(List<? extends LatLon> list) {
        SurfacePolygon surfacePolygon = new SurfacePolygon(list);
        surfacePolygon.setAttributes(this.getActiveShapeAttributes());
        return surfacePolygon;
    }
}

