/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AbstractRectangularGraphic;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RectangularTarget
extends AbstractRectangularGraphic {
    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-ATR--------");
    }

    public RectangularTarget(String string) {
        super(string);
    }

    public Angle getHeading() {
        return this.quad.getHeading();
    }

    public void setHeading(Angle angle) {
        this.quad.setHeading(angle);
        this.onModifierChanged();
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.quad.setCenter(iterator.next());
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("AM".equals(string) && object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            this.setWidth((Double)iterator.next());
            this.setLength((Double)iterator.next());
        } else if ("AN".equals(string) && object instanceof Angle) {
            this.setHeading((Angle)object);
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public Object getModifier(String string) {
        if ("AM".equals(string)) {
            return Arrays.asList(this.getWidth(), this.getLength());
        }
        if ("AN".equals(string)) {
            return this.quad.getHeading();
        }
        return super.getModifier(string);
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(new Position(this.quad.getCenter(), 0.0));
    }

    @Override
    protected void createLabels() {
        String string = this.getText();
        if (!WWUtil.isEmpty(string)) {
            this.addLabel(this.getText());
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (!WWUtil.isEmpty(this.labels)) {
            ((TacticalGraphicLabel)this.labels.get(0)).setPosition(new Position(this.quad.getCenter(), 0.0));
        }
    }
}

