/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.AbstractTacticalSymbol;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525IconRetriever;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525ModifierRetriever;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525Util;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.util.Logging;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class LimitedAccessSymbol
extends AbstractTacticalSymbol {
    protected String symbolId;

    public LimitedAccessSymbol(String string, Position position) {
        super(position);
        this.init(string);
    }

    protected void init(String string) {
        this.symbolId = string;
        String string2 = Configuration.getStringValue("gov.nasa.worldwind.avkey.MilStd2525IconRetrieverPath", "http://worldwind.arc.nasa.gov/milstd2525c/rev1/");
        this.setIconRetriever(new IconRetriever(string2));
        this.setModifierRetriever(new MilStd2525ModifierRetriever(string2));
        this.setOffset(Offset.fromFraction(0.5, 0.0));
    }

    @Override
    public String getIdentifier() {
        return this.symbolId;
    }

    static class IconRetriever
    extends MilStd2525IconRetriever {
        public IconRetriever(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedImage createIcon(String string, AVList aVList) {
            if (string == null) {
                String string2 = Logging.getMessage("nullValue.SymbolCodeIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            SymbolCode symbolCode = new SymbolCode(string);
            BufferedImage bufferedImage = this.drawIcon(symbolCode, aVList, null);
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = (int)((double)n * 1.1);
            int n4 = (int)((double)n2 * 1.5);
            BufferedImage bufferedImage2 = new BufferedImage(n3, n4, bufferedImage.getType());
            int n5 = (int)Math.max((double)n * 0.03, 1.0);
            Color color = this.getColorFromParams(aVList);
            if (color == null) {
                color = this.getColorForStandardIdentity(symbolCode);
            }
            Graphics2D graphics2D = null;
            try {
                graphics2D = bufferedImage2.createGraphics();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(n5));
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawImage((Image)bufferedImage, (n3 - n - n5 * 2) / 2, 0, null);
                graphics2D.drawLine(0, 0, 0, n2);
                graphics2D.drawLine(0, 0, n3, 0);
                graphics2D.drawLine(n3 - 1, 0, n3 - 1, n2);
                graphics2D.drawLine(0, n2, n3 / 2, n4);
                graphics2D.drawLine(n3, n2, n3 / 2, n4);
            }
            finally {
                if (graphics2D != null) {
                    graphics2D.dispose();
                }
            }
            return bufferedImage2;
        }

        @Override
        protected Color getColorFromParams(AVList aVList) {
            if (aVList == null) {
                return null;
            }
            Object object = aVList.getValue("gov.nasa.worldwind.avkey.Color");
            return object instanceof Color ? (Color)object : null;
        }

        protected Color getColorForStandardIdentity(SymbolCode symbolCode) {
            return MilStd2525Util.getDefaultGraphicMaterial(symbolCode).getDiffuse();
        }
    }
}

