/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CircularRangeFan
extends AbstractMilStd2525TacticalGraphic
implements PreRenderable {
    protected static final Offset LABEL_OFFSET = Offset.fromFraction(0.0, 0.0);
    protected Position position;
    protected List<SurfaceCircle> rings = new ArrayList<SurfaceCircle>();
    protected TacticalSymbol symbol;
    protected TacticalSymbolAttributes symbolAttributes;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-AXC--------");
    }

    public CircularRangeFan(String string) {
        super(string);
    }

    public Position getPosition() {
        return this.getReferencePosition();
    }

    public void setPosition(Position position) {
        this.moveTo(position);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = iterator.next();
        for (SurfaceCircle surfaceCircle : this.rings) {
            surfaceCircle.setCenter(this.position);
        }
        if (this.symbol != null) {
            this.symbol.setPosition(this.position);
        }
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("AM".equals(string)) {
            if (object instanceof Iterable) {
                this.setRadii((Iterable)object);
            } else if (object instanceof Double) {
                this.setRadii(Arrays.asList((Double)object));
            }
        } else if ("A".equals(string) && object instanceof String) {
            this.setSymbol((String)object);
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public Object getModifier(String string) {
        if ("AM".equals(string)) {
            return this.getRadii();
        }
        if ("A".equals(string)) {
            return this.getSymbol();
        }
        return super.getModifier(string);
    }

    public List<Double> getRadii() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (SurfaceCircle surfaceCircle : this.rings) {
            arrayList.add(surfaceCircle.getRadius());
        }
        return arrayList;
    }

    public void setRadii(Iterable<Double> iterable) {
        this.rings.clear();
        for (Double d : iterable) {
            if (d == null) continue;
            SurfaceCircle surfaceCircle = this.createCircle();
            surfaceCircle.setRadius(d);
            if (this.position != null) {
                surfaceCircle.setCenter(this.position);
            }
            this.rings.add(surfaceCircle);
        }
        this.onModifierChanged();
    }

    public String getSymbol() {
        return this.symbol != null ? this.symbol.getIdentifier() : null;
    }

    public void setSymbol(String string) {
        if (string != null) {
            if (this.symbolAttributes == null) {
                this.symbolAttributes = new BasicTacticalSymbolAttributes();
            }
            this.symbol = this.createSymbol(string, this.getPosition(), this.symbolAttributes);
        } else {
            this.symbol = null;
            this.symbolAttributes = null;
        }
        this.onModifierChanged();
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.position);
    }

    @Override
    public Position getReferencePosition() {
        return this.position;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        this.determineActiveAttributes();
        for (SurfaceCircle surfaceCircle : this.rings) {
            surfaceCircle.preRender(drawContext);
        }
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        for (SurfaceCircle surfaceCircle : this.rings) {
            surfaceCircle.render(drawContext);
        }
    }

    @Override
    protected void doRenderGraphicModifiers(DrawContext drawContext) {
        super.doRenderGraphicModifiers(drawContext);
        if (this.symbol != null) {
            this.symbol.render(drawContext);
        }
    }

    @Override
    protected void createLabels() {
        Iterator<Object> iterator = null;
        Object object = this.getModifier("X");
        if (object instanceof Iterable) {
            iterator = ((Iterable)object).iterator();
        } else if (object != null) {
            iterator = Arrays.asList(object).iterator();
        }
        for (int i = 0; i < this.rings.size(); ++i) {
            Object object2;
            SurfaceCircle surfaceCircle = this.rings.get(i);
            StringBuilder stringBuilder = new StringBuilder();
            if (i == 0) {
                stringBuilder.append("MIN RG ");
            } else {
                stringBuilder.append("MAX RG(");
                stringBuilder.append(i);
                stringBuilder.append(") ");
            }
            stringBuilder.append(surfaceCircle.getRadius());
            if (iterator != null && iterator.hasNext()) {
                object2 = iterator.next();
                stringBuilder.append("\n");
                stringBuilder.append("ALT ");
                stringBuilder.append(object2);
            }
            object2 = this.addLabel(stringBuilder.toString());
            ((TacticalGraphicLabel)object2).setOffset(LABEL_OFFSET);
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        double d = Angle.POS180.radians;
        double d2 = drawContext.getGlobe().getRadius();
        int n = 0;
        for (SurfaceCircle surfaceCircle : this.rings) {
            double d3 = surfaceCircle.getRadius();
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)this.position, d, d3 / d2);
            ((TacticalGraphicLabel)this.labels.get(n)).setPosition(new Position(latLon, 0.0));
            ++n;
        }
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        if (this.symbolAttributes != null) {
            ShapeAttributes shapeAttributes = this.getActiveShapeAttributes();
            this.symbolAttributes.setOpacity(shapeAttributes.getInteriorOpacity());
            this.symbolAttributes.setScale(this.activeOverrides.getScale());
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.rings == null) {
            return;
        }
        for (SurfaceCircle surfaceCircle : this.rings) {
            surfaceCircle.setDelegateOwner(object);
        }
    }

    protected SurfaceCircle createCircle() {
        SurfaceCircle surfaceCircle = new SurfaceCircle();
        surfaceCircle.setDelegateOwner(this.getActiveDelegateOwner());
        surfaceCircle.setAttributes(this.activeShapeAttributes);
        return surfaceCircle;
    }
}

