/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AbstractCircularGraphic;
import java.util.Arrays;
import java.util.List;

public class CircularPositionArea
extends AbstractCircularGraphic {
    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-ACPC-------");
    }

    public CircularPositionArea(String string) {
        super(string);
    }

    @Override
    protected void createLabels() {
        this.addLabel("PAA");
        this.addLabel("PAA");
        this.addLabel("PAA");
        this.addLabel("PAA");
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        Position position = new Position(this.circle.getCenter(), 0.0);
        Angle angle = Angle.fromRadians(this.circle.getRadius() / drawContext.getGlobe().getRadius());
        Angle[] angleArray = new Angle[]{Angle.NEG90, Angle.POS90, Angle.ZERO, Angle.POS180};
        int n = 0;
        for (Angle angle2 : angleArray) {
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, angle2, angle);
            ((TacticalGraphicLabel)this.labels.get(n)).setPosition(new Position(latLon, 0.0));
            ++n;
        }
    }
}

