/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.symbology.milstd2525.graphics.EchelonSymbol;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BasicArea;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class BattlePosition
extends BasicArea {
    protected static final int PBNO_OUTLINE_STIPPLE_FACTOR = 12;
    protected TacticalSymbol echelonSymbol;
    protected TacticalSymbolAttributes symbolAttributes;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-DAB--------", "G-G-DABP-------");
    }

    public BattlePosition(String string) {
        super(string);
        String string2 = this.symbolCode.getEchelon();
        if (!SymbolCode.isFieldEmpty(string2)) {
            this.echelonSymbol = this.createEchelonSymbol(string);
        }
    }

    @Override
    protected void doRenderGraphicModifiers(DrawContext drawContext) {
        super.doRenderGraphicModifiers(drawContext);
        if (this.echelonSymbol != null) {
            this.echelonSymbol.render(drawContext);
        }
    }

    @Override
    protected String createLabelText() {
        String string = this.getGraphicLabel();
        String string2 = this.getText();
        if (string == null && string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append(string).append(" ");
        }
        if (!WWUtil.isEmpty(string2)) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getGraphicLabel() {
        if ("G-G-DABP-------".equalsIgnoreCase(this.maskedSymbolCode)) {
            return "(P)";
        }
        return null;
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (this.labels == null || this.labels.isEmpty()) {
            return;
        }
        Position position = this.determineMainLabelPosition(drawContext);
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(position);
        this.determineIdentityLabelPositions();
    }

    @Override
    protected void determineIdentityLabelPositions() {
        int n;
        Iterator<? extends Position> iterator = this.getPositions().iterator();
        Position position = iterator.next();
        Position position2 = iterator.next();
        Position position3 = position;
        LatLon latLon = LatLon.interpolate(0.5, position, position2);
        if (this.echelonSymbol != null) {
            this.echelonSymbol.setPosition(new Position(latLon, 0.0));
        }
        int n2 = this.getPositionCount();
        if (this.identityLabel1 != null) {
            for (n = 0; n < (n2 + 1) / 4; ++n) {
                position = position2;
                position2 = iterator.next();
            }
            latLon = LatLon.interpolate(0.5, position, position2);
            this.identityLabel1.setPosition(new Position(latLon, 0.0));
        }
        if (this.identityLabel2 != null) {
            for (n = 0; n <= n2 / 4; ++n) {
                position = position2;
                position2 = iterator.hasNext() ? iterator.next() : position3;
            }
            latLon = LatLon.interpolate(0.5, position, position2);
            if (this.identityLabel2 != null) {
                this.identityLabel2.setPosition(new Position(latLon, 0.0));
            }
        }
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        super.applyDefaultAttributes(shapeAttributes);
        if ("G-G-DABP-------".equalsIgnoreCase(this.maskedSymbolCode)) {
            shapeAttributes.setOutlineStippleFactor(12);
            shapeAttributes.setOutlineStipplePattern(this.getOutlineStipplePattern());
        }
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        if (this.symbolAttributes != null) {
            ShapeAttributes shapeAttributes = this.getActiveShapeAttributes();
            this.symbolAttributes.setOpacity(shapeAttributes.getInteriorOpacity());
            this.symbolAttributes.setTextModifierMaterial(this.getLabelMaterial());
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        super.applyDelegateOwner(object);
        if (this.echelonSymbol != null) {
            this.echelonSymbol.setDelegateOwner(object);
        }
    }

    protected TacticalSymbol createEchelonSymbol(String string) {
        EchelonSymbol echelonSymbol = new EchelonSymbol(string);
        if (this.symbolAttributes == null) {
            this.symbolAttributes = new BasicTacticalSymbolAttributes();
        }
        echelonSymbol.setAttributes(this.symbolAttributes);
        return echelonSymbol;
    }
}

