/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BasicArea;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.List;

public class Airhead
extends BasicArea {
    public static final Offset DEFAULT_OFFSET = new Offset(0.0, 0.0, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-SAA--------");
    }

    public Airhead(String string) {
        super(string);
        this.setShowHostileIndicator(false);
    }

    @Override
    protected String createLabelText() {
        String string = this.getText();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AIRHEAD LINE\n");
        stringBuilder.append("(PL ");
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append(string);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    protected Position determineMainLabelPosition(DrawContext drawContext) {
        Iterable<? extends LatLon> iterable = this.polygon.getLocations();
        if (iterable == null) {
            return null;
        }
        Sector sector = Sector.boundingSector(iterable);
        Angle angle = sector.getMinLatitude();
        Angle angle2 = sector.getCentroid().longitude;
        return new Position(angle, angle2, 0.0);
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        return DEFAULT_OFFSET;
    }
}

