/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.AbstractTacticalSymbol;
import gov.nasa.worldwind.symbology.SymbologyConstants;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525PointGraphicRetriever;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525TacticalSymbol;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525Util;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.symbology.milstd2525.graphics.DefaultLabelLayouts;
import gov.nasa.worldwind.symbology.milstd2525.graphics.DefaultOffsets;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TacticalGraphicSymbol
extends AbstractTacticalSymbol {
    protected static DefaultOffsets defaultOffsets = new DefaultOffsets();
    protected static DefaultLabelLayouts defaultLayouts = new DefaultLabelLayouts();
    protected static final Offset BELOW_BOTTOM_CENTER_OFFSET = Offset.fromFraction(0.5, -0.1);
    protected static final int DEFAULT_LABEL_LINES = 2;
    protected SymbolCode symbolCode;
    protected String maskedSymbolCode;

    public TacticalGraphicSymbol(String string) {
        this.init(string);
    }

    public TacticalGraphicSymbol(String string, Position position) {
        super(position);
        this.init(string);
    }

    public String getStatus() {
        return this.symbolCode.getStatus();
    }

    public void setStatus(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!SymbologyConstants.STATUS_ALL.contains(string.toUpperCase())) {
            String string3 = Logging.getMessage("Symbology.InvalidStatus", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.symbolCode.setStatus(string);
    }

    protected void init(String string) {
        this.symbolCode = new SymbolCode(string);
        this.maskedSymbolCode = this.symbolCode.toMaskedString();
        this.setAltitudeMode(1);
        String string2 = Configuration.getStringValue("gov.nasa.worldwind.avkey.MilStd2525IconRetrieverPath", "http://worldwind.arc.nasa.gov/milstd2525c/rev1/");
        this.setIconRetriever(new MilStd2525PointGraphicRetriever(string2));
        Offset offset = defaultOffsets.get(this.symbolCode.toMaskedString());
        this.setOffset(offset);
        this.setShowHostileIndicator(true);
        this.setUnitsFormat(MilStd2525TacticalSymbol.DEFAULT_UNITS_FORMAT);
    }

    @Override
    public String getIdentifier() {
        return this.symbolCode.toString();
    }

    @Override
    protected int getMaxLabelLines(AVList aVList) {
        return 2;
    }

    @Override
    protected void applyImplicitModifiers(AVList aVList) {
        boolean bl;
        String string = this.symbolCode.getStandardIdentity();
        boolean bl2 = bl = "H".equalsIgnoreCase(string) || "S".equalsIgnoreCase(string) || "J".equalsIgnoreCase(string) || "K".equalsIgnoreCase(string);
        if (!aVList.hasKey("ENY") && this.isShowHostileIndicator() && bl) {
            aVList.setValue("ENY", "ENY");
        }
        if (!aVList.hasKey("Y") && this.isShowLocation()) {
            aVList.setValue("Y", this.getFormattedPosition());
        }
        if (!aVList.hasKey("X") && this.isShowLocation()) {
            Position position = this.getPosition();
            UnitsFormat unitsFormat = this.getUnitsFormat();
            int n = this.getAltitudeMode();
            String string2 = n == 1 ? "GL" : (n == 2 ? unitsFormat.eyeAltitude(position.getElevation()) + " AGL" : unitsFormat.eyeAltitude(position.getElevation()) + " AMSL");
            aVList.setValue("X", string2);
        }
        if (!aVList.hasKey("V")) {
            if ("G-M-NEB--------".equalsIgnoreCase(this.maskedSymbolCode)) {
                aVList.setValue("V", "BIO");
            } else if ("G-M-NEC--------".equalsIgnoreCase(this.maskedSymbolCode)) {
                aVList.setValue("V", "CML");
            }
        }
    }

    @Override
    protected void layoutTextModifiers(DrawContext drawContext, AVList aVList) {
        this.currentLabels.clear();
        Font font = this.getActiveAttributes().getTextModifierFont();
        List<LabelLayout> list = this.getLayouts(this.symbolCode.toMaskedString());
        for (LabelLayout labelLayout : list) {
            String string;
            Object object;
            List<OffsetPair> list2 = labelLayout.offsets;
            if (WWUtil.isEmpty(list2) || WWUtil.isEmpty(object = aVList.getValue(labelLayout.modifier))) continue;
            if ("W".equals(labelLayout.modifier) && object instanceof Iterable) {
                object = this.addHyphenToDateRange((Iterable)object, list2);
            }
            String string2 = string = "Y".equals(labelLayout.modifier) ? "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative" : "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutNone";
            if (object instanceof Iterable) {
                this.layoutMultiLabel(drawContext, font, list2, (Iterable)object, string);
                continue;
            }
            if (object == null) continue;
            this.layoutLabel(drawContext, font, labelLayout.offsets.get(0), object.toString(), string);
        }
    }

    protected List<LabelLayout> getLayouts(String string) {
        return defaultLayouts.get(string);
    }

    @Override
    protected void layoutDynamicModifiers(DrawContext drawContext, AVList aVList) {
        this.currentLines.clear();
        if (!this.isShowGraphicModifiers()) {
            return;
        }
        Object object = aVList.getValue("Q");
        if (this.isShowDirectionOfMovement() && object instanceof Angle) {
            double d = this.iconRect.getHeight();
            List<? extends Point2D> list = MilStd2525Util.computeGroundHeadingIndicatorPoints(drawContext, this.placePoint, (Angle)object, d, this.iconRect.getHeight());
            this.addLine(drawContext, BELOW_BOTTOM_CENTER_OFFSET, list, "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative", list.size() - 1);
        }
    }

    protected Iterable addHyphenToDateRange(Iterable iterable, List<OffsetPair> list) {
        Object var5_5;
        if (list.size() != 2) {
            return iterable;
        }
        Iterator iterator = iterable.iterator();
        Object var4_4 = iterator.hasNext() ? iterator.next() : null;
        Object v0 = var5_5 = iterator.hasNext() ? iterator.next() : null;
        if (var4_4 != null && var5_5 != null) {
            return Arrays.asList(var4_4 + "-", var5_5);
        }
        return iterable;
    }

    protected void layoutLabel(DrawContext drawContext, Font font, OffsetPair offsetPair, String string, String string2) {
        if (!WWUtil.isEmpty(string)) {
            this.addLabel(drawContext, offsetPair.offset, offsetPair.hotSpot, string, font, null, string2);
        }
    }

    protected void layoutMultiLabel(DrawContext drawContext, Font font, List<OffsetPair> list, Iterable iterable, String string) {
        Iterator iterator = iterable.iterator();
        Iterator<OffsetPair> iterator2 = list.iterator();
        while (iterator2.hasNext() && iterator.hasNext()) {
            OffsetPair offsetPair = iterator2.next();
            Object t = iterator.next();
            if (t == null) continue;
            this.layoutLabel(drawContext, font, offsetPair, t.toString(), string);
        }
    }

    protected boolean isShowDirectionOfMovement() {
        String string = this.maskedSymbolCode;
        return "G-M-NZ---------".equalsIgnoreCase(string) || "G-M-NF---------".equalsIgnoreCase(string) || "G-M-NEB--------".equalsIgnoreCase(string) || "G-M-NEC--------".equalsIgnoreCase(string);
    }

    @Override
    protected void computeTransform(DrawContext drawContext) {
        super.computeTransform(drawContext);
        if (this.iconRect != null && this.layoutRect != null && this.isShowDirectionOfMovement()) {
            this.dx = -this.iconRect.getCenterX();
            this.dy = -this.layoutRect.getMinY();
        }
    }

    public static class OffsetPair {
        public Offset offset;
        public Offset hotSpot;

        public OffsetPair(Offset offset, Offset offset2) {
            this.offset = offset;
            this.hotSpot = offset2;
        }
    }

    public static class LabelLayout {
        protected String modifier;
        protected List<OffsetPair> offsets = new ArrayList<OffsetPair>();

        public LabelLayout(String string) {
            this.modifier = string;
        }

        public void add(Offset offset, Offset offset2) {
            this.offsets.add(new OffsetPair(offset, offset2));
        }

        public String getModifier() {
            return this.modifier;
        }

        public List<OffsetPair> getOffsets() {
            return this.offsets;
        }
    }
}

