/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.event.BulkRetrievalEvent;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.Progress;
import gov.nasa.worldwind.util.Logging;
import javax.swing.event.EventListenerList;

public abstract class BulkRetrievalThread
extends Thread {
    protected int RETRIEVAL_SERVICE_POLL_DELAY = 1000;
    protected final BulkRetrievable retrievable;
    protected final Sector sector;
    protected final double resolution;
    protected final Progress progress;
    protected final FileStore fileStore;
    protected EventListenerList retrievalListeners = new EventListenerList();

    public BulkRetrievalThread(BulkRetrievable bulkRetrievable, Sector sector, double d, FileStore fileStore, BulkRetrievalListener bulkRetrievalListener) {
        if (bulkRetrievable == null) {
            String string = Logging.getMessage("nullValue.RetrievableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fileStore == null) {
            String string = Logging.getMessage("nullValue.FileStoreIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.retrievable = bulkRetrievable;
        this.sector = sector;
        this.resolution = d;
        this.fileStore = fileStore;
        this.progress = new Progress();
        if (bulkRetrievalListener != null) {
            this.addRetrievalListener(bulkRetrievalListener);
        }
    }

    @Override
    public abstract void run();

    public BulkRetrievable getRetrievable() {
        return this.retrievable;
    }

    public Sector getSector() {
        return this.sector;
    }

    public double getResolution() {
        return this.resolution;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void addRetrievalListener(BulkRetrievalListener bulkRetrievalListener) {
        if (bulkRetrievalListener != null) {
            this.retrievalListeners.add(BulkRetrievalListener.class, bulkRetrievalListener);
        }
    }

    public void removeRetrievalListener(BulkRetrievalListener bulkRetrievalListener) {
        if (bulkRetrievalListener != null) {
            this.retrievalListeners.remove(BulkRetrievalListener.class, bulkRetrievalListener);
        }
    }

    protected boolean hasRetrievalListeners() {
        return this.retrievalListeners.getListenerCount() > 0;
    }

    protected void callRetrievalListeners(BulkRetrievalEvent bulkRetrievalEvent) {
        for (BulkRetrievalListener bulkRetrievalListener : (BulkRetrievalListener[])this.retrievalListeners.getListeners(BulkRetrievalListener.class)) {
            bulkRetrievalListener.eventOccurred(bulkRetrievalEvent);
        }
    }
}

