/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.markers;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sphere;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.media.opengl.GL2;

public class MarkerRenderer {
    private double elevation = 10.0;
    private boolean overrideMarkerElevation = false;
    private boolean keepSeparated = true;
    private boolean enablePickSizeReturn = false;
    private long frameTimeStamp = 0L;
    private ArrayList<Vec4> surfacePoints = new ArrayList();
    private MarkerAttributes previousAttributes;
    protected PickSupport pickSupport = new PickSupport();

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public boolean isOverrideMarkerElevation() {
        return this.overrideMarkerElevation;
    }

    public void setOverrideMarkerElevation(boolean bl) {
        this.overrideMarkerElevation = bl;
    }

    public boolean isKeepSeparated() {
        return this.keepSeparated;
    }

    public void setKeepSeparated(boolean bl) {
        this.keepSeparated = bl;
    }

    public boolean isEnablePickSizeReturn() {
        return this.enablePickSizeReturn;
    }

    public void setEnablePickSizeReturn(boolean bl) {
        this.enablePickSizeReturn = bl;
    }

    public void render(DrawContext drawContext, Iterable<Marker> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.MarkerListIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.draw(drawContext, iterable);
    }

    protected void draw(DrawContext drawContext, Iterable<Marker> iterable) {
        if (this.isKeepSeparated()) {
            this.drawSeparated(drawContext, iterable);
        } else {
            this.drawAll(drawContext, iterable);
        }
    }

    protected void drawSeparated(DrawContext drawContext, Iterable<Marker> iterable) {
        double d;
        double d2;
        ArrayList<Marker> arrayList;
        if (iterable instanceof List) {
            arrayList = (ArrayList<Marker>)iterable;
        } else {
            arrayList = new ArrayList<Marker>();
            for (Marker object2 : iterable) {
                arrayList.add(object2);
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        Layer layer = drawContext.getCurrentLayer();
        Vec4 vec4 = drawContext.getView().getEyePoint();
        Marker marker = (Marker)arrayList.get(0);
        Vec4 vec42 = this.computeSurfacePoint(drawContext, marker.getPosition());
        if (this.intersectsFrustum(drawContext, vec42, d2 = this.computeMarkerRadius(drawContext, vec42, marker))) {
            drawContext.addOrderedRenderable(new OrderedMarker(0, marker, vec42, d2, layer, vec4.distanceTo3(vec42)));
        }
        if (arrayList.size() < 2) {
            return;
        }
        int n = arrayList.size() - 1;
        Marker marker2 = (Marker)arrayList.get(n);
        Vec4 vec43 = this.computeSurfacePoint(drawContext, marker2.getPosition());
        if (this.intersectsFrustum(drawContext, vec43, d = this.computeMarkerRadius(drawContext, vec43, marker2))) {
            drawContext.addOrderedRenderable(new OrderedMarker(n, marker2, vec43, d, layer, vec4.distanceTo3(vec43)));
        }
        if (arrayList.size() < 3) {
            return;
        }
        this.drawInBetweenMarkers(drawContext, 0, vec42, d2, n, vec43, d, arrayList, layer, vec4);
    }

    private void drawInBetweenMarkers(DrawContext drawContext, int n, Vec4 vec4, double d, int n2, Vec4 vec42, double d2, List<Marker> list, Layer layer, Vec4 vec43) {
        if (n2 == n + 1) {
            return;
        }
        if (vec4.distanceTo3(vec42) <= d + d2) {
            return;
        }
        int n3 = (n + n2) / 2;
        Marker marker = list.get(n3);
        Vec4 vec44 = this.computeSurfacePoint(drawContext, marker.getPosition());
        double d3 = this.computeMarkerRadius(drawContext, vec44, marker);
        boolean bl = false;
        boolean bl2 = false;
        if (vec44.distanceTo3(vec4) > d3 + d) {
            this.drawInBetweenMarkers(drawContext, n, vec4, d, n3, vec44, d3, list, layer, vec43);
            bl = true;
        }
        if (vec44.distanceTo3(vec42) > d3 + d2) {
            this.drawInBetweenMarkers(drawContext, n3, vec44, d3, n2, vec42, d2, list, layer, vec43);
            bl2 = true;
        }
        if (bl && bl2 && this.intersectsFrustum(drawContext, vec44, d3)) {
            drawContext.addOrderedRenderable(new OrderedMarker(n3, marker, vec44, d3, layer, vec43.distanceTo3(vec44)));
        }
    }

    private void drawMarker(DrawContext drawContext, int n, Marker marker, Vec4 vec4, double d) {
        Object object;
        if (drawContext.isPickingMode()) {
            object = drawContext.getUniquePickColor();
            int n2 = ((Color)object).getRGB();
            PickedObject pickedObject = new PickedObject(n2, marker, marker.getPosition(), false);
            pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.ID", n);
            if (this.enablePickSizeReturn) {
                pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.Size", 2.0 * d);
            }
            this.pickSupport.addPickableObject(pickedObject);
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glColor3ub((byte)((Color)object).getRed(), (byte)((Color)object).getGreen(), (byte)((Color)object).getBlue());
        }
        if ((object = marker.getAttributes()) != this.previousAttributes) {
            object.apply(drawContext);
            this.previousAttributes = object;
        }
        marker.render(drawContext, vec4, d);
    }

    protected void computeSurfacePoints(DrawContext drawContext, Iterable<? extends Marker> iterable) {
        this.surfacePoints.clear();
        for (Marker marker : iterable) {
            if (marker == null) {
                this.surfacePoints.add(null);
                continue;
            }
            Position position = marker.getPosition();
            Vec4 vec4 = this.computeSurfacePoint(drawContext, position);
            if (!drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
                this.surfacePoints.add(null);
                continue;
            }
            this.surfacePoints.add(vec4);
        }
    }

    protected void drawAll(DrawContext drawContext, Iterable<Marker> iterable) {
        Layer layer = drawContext.getCurrentLayer();
        Vec4 vec4 = drawContext.getView().getEyePoint();
        if (drawContext.getFrameTimeStamp() != this.frameTimeStamp) {
            this.frameTimeStamp = drawContext.getFrameTimeStamp();
            this.computeSurfacePoints(drawContext, iterable);
        }
        Iterator<Marker> iterator = iterable.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Marker marker = iterator.next();
            Vec4 vec42 = this.surfacePoints.get(n);
            if (vec42 != null) {
                double d = this.computeMarkerRadius(drawContext, vec42, marker);
                if (!drawContext.isPickingMode() || this.intersectsFrustum(drawContext, vec42, d)) {
                    drawContext.addOrderedRenderable(new OrderedMarker(n, marker, vec42, d, layer, vec4.distanceTo3(vec42)));
                }
            }
            ++n;
        }
    }

    protected void begin(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        Vec4 vec4 = drawContext.getView().getEyePoint();
        if (drawContext.isPickingMode()) {
            this.pickSupport.beginPicking(drawContext);
            gL2.glPushAttrib(12289);
            gL2.glDisable(2903);
        } else {
            gL2.glPushAttrib(28737);
            float[] fArray = new float[]{(float)(vec4.x * 2.0), (float)(vec4.y / 2.0), (float)vec4.z, 0.0f};
            float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            float[] fArray4 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            gL2.glDisable(2903);
            gL2.glLightfv(16385, 4611, fArray, 0);
            gL2.glLightfv(16385, 4609, fArray2, 0);
            gL2.glLightfv(16385, 4608, fArray3, 0);
            gL2.glLightfv(16385, 4610, fArray4, 0);
            gL2.glDisable(16384);
            gL2.glEnable(16385);
            gL2.glEnable(2896);
            gL2.glEnable(2977);
            drawContext.getGL().glEnable(3042);
            drawContext.getGL().glBlendFunc(770, 771);
        }
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        this.previousAttributes = null;
    }

    protected void end(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        } else {
            gL2.glDisable(16385);
            gL2.glEnable(16384);
            gL2.glDisable(2896);
            gL2.glDisable(2977);
        }
        gL2.glPopAttrib();
    }

    protected boolean intersectsFrustum(DrawContext drawContext, Vec4 vec4, double d) {
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(new Sphere(vec4, d));
        }
        return drawContext.getView().getFrustumInModelCoordinates().contains(vec4);
    }

    protected Vec4 computeSurfacePoint(DrawContext drawContext, Position position) {
        double d = drawContext.getVerticalExaggeration();
        if (!this.overrideMarkerElevation) {
            return drawContext.getGlobe().computePointFromPosition(position, position.getElevation() * d);
        }
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(position.getLatitude(), position.getLongitude(), this.elevation * d);
        if (vec4 != null) {
            return vec4;
        }
        return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), this.elevation * d);
    }

    protected double computeMarkerRadius(DrawContext drawContext, Vec4 vec4, Marker marker) {
        double d = vec4.distanceTo3(drawContext.getView().getEyePoint());
        double d2 = marker.getAttributes().getMarkerPixels() * drawContext.getView().computePixelSizeAtDistance(d);
        if (d2 < marker.getAttributes().getMinMarkerSize()) {
            d2 = marker.getAttributes().getMinMarkerSize();
        } else if (d2 > marker.getAttributes().getMaxMarkerSize()) {
            d2 = marker.getAttributes().getMaxMarkerSize();
        }
        return d2;
    }

    protected void drawOrderedMarkers(DrawContext drawContext, OrderedMarker orderedMarker) {
        this.drawMarker(drawContext, orderedMarker.index, orderedMarker.marker, orderedMarker.point, orderedMarker.radius);
        OrderedRenderable orderedRenderable = drawContext.peekOrderedRenderables();
        while (orderedRenderable != null && orderedRenderable instanceof OrderedMarker && ((OrderedMarker)orderedRenderable).getRenderer() == this) {
            drawContext.pollOrderedRenderables();
            OrderedMarker orderedMarker2 = (OrderedMarker)orderedRenderable;
            this.drawMarker(drawContext, orderedMarker2.index, orderedMarker2.marker, orderedMarker2.point, orderedMarker2.radius);
            orderedRenderable = drawContext.peekOrderedRenderables();
        }
    }

    protected void pickOrderedMarkers(DrawContext drawContext, OrderedMarker orderedMarker) {
        this.drawMarker(drawContext, orderedMarker.index, orderedMarker.marker, orderedMarker.point, orderedMarker.radius);
        OrderedRenderable orderedRenderable = drawContext.peekOrderedRenderables();
        while (orderedRenderable != null && orderedRenderable instanceof OrderedMarker && ((OrderedMarker)orderedRenderable).getRenderer() == this && ((OrderedMarker)orderedRenderable).layer == orderedMarker.layer) {
            drawContext.pollOrderedRenderables();
            OrderedMarker orderedMarker2 = (OrderedMarker)orderedRenderable;
            this.drawMarker(drawContext, orderedMarker2.index, orderedMarker2.marker, orderedMarker2.point, orderedMarker2.radius);
            orderedRenderable = drawContext.peekOrderedRenderables();
        }
    }

    protected class OrderedMarker
    implements OrderedRenderable {
        protected int index;
        protected Marker marker;
        protected Vec4 point;
        protected double radius;
        protected Layer layer;
        protected double eyeDistance;

        public OrderedMarker(int n, Marker marker, Vec4 vec4, double d, Layer layer, double d2) {
            this.index = n;
            this.marker = marker;
            this.point = vec4;
            this.radius = d;
            this.layer = layer;
            this.eyeDistance = d2;
        }

        public MarkerRenderer getRenderer() {
            return MarkerRenderer.this;
        }

        @Override
        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pick(DrawContext drawContext, Point point) {
            MarkerRenderer.this.begin(drawContext);
            try {
                MarkerRenderer.this.pickOrderedMarkers(drawContext, this);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionWhilePickingMarker", this), exception);
            }
            finally {
                MarkerRenderer.this.end(drawContext);
                MarkerRenderer.this.pickSupport.resolvePick(drawContext, point, this.layer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void render(DrawContext drawContext) {
            MarkerRenderer.this.begin(drawContext);
            try {
                MarkerRenderer.this.drawOrderedMarkers(drawContext, this);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionWhileRenderingMarker", this), exception);
            }
            finally {
                MarkerRenderer.this.end(drawContext);
            }
        }
    }
}

