/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces.editor;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPoint;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditor;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;

public class AirspaceEditorController
implements KeyListener,
MouseListener,
MouseMotionListener {
    private boolean active = false;
    private String activeAction;
    private AirspaceEditor editor;
    private WorldWindow wwd;
    private Point mousePoint;
    private Airspace activeAirspace;
    private AirspaceControlPoint activeControlPoint;
    private Map<String, Cursor> actionCursorMap = new HashMap<String, Cursor>();
    protected static final String MOVE_AIRSPACE_LATERALLY = "AirspaceEdiorController.MoveAirspaceLaterally";
    protected static final String MOVE_AIRSPACE_VERTICALLY = "AirspaceEdiorController.MoveAirspaceVertically";
    protected static final String RESIZE_AIRSPACE = "AirspaceEdiorController.ResizeAirspace";
    protected static final String ADD_CONTROL_POINT = "AirspaceEdiorController.AddControlPoint";
    protected static final String REMOVE_CONTROL_POINT = "AirspaceEdiorController.RemoveControlPoint";
    protected static final String MOVE_CONTROL_POINT = "AirspaceEdiorController.MoveControlPoint";

    public AirspaceEditorController(WorldWindow worldWindow) {
        this.setWorldWindow(worldWindow);
        this.setupActionCursorMap();
    }

    public AirspaceEditorController() {
        this(null);
    }

    public boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean bl) {
        this.active = bl;
    }

    public String getActiveAction() {
        return this.activeAction;
    }

    protected void setActiveAction(String string) {
        this.activeAction = string;
    }

    public AirspaceEditor getEditor() {
        return this.editor;
    }

    public void setEditor(AirspaceEditor airspaceEditor) {
        this.editor = airspaceEditor;
    }

    public WorldWindow getWorldWindow() {
        return this.wwd;
    }

    public void setWorldWindow(WorldWindow worldWindow) {
        if (this.wwd == worldWindow) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.getInputHandler().removeKeyListener(this);
            this.wwd.getInputHandler().removeMouseListener(this);
            this.wwd.getInputHandler().removeMouseMotionListener(this);
        }
        this.wwd = worldWindow;
        if (this.wwd != null) {
            this.wwd.getInputHandler().addKeyListener(this);
            this.wwd.getInputHandler().addMouseListener(this);
            this.wwd.getInputHandler().addMouseMotionListener(this);
        }
    }

    protected Point getMousePoint() {
        return this.mousePoint;
    }

    protected void setMousePoint(Point point) {
        this.mousePoint = point;
    }

    protected AirspaceControlPoint getActiveControlPoint() {
        return this.activeControlPoint;
    }

    protected void setActiveControlPoint(AirspaceControlPoint airspaceControlPoint) {
        this.activeControlPoint = airspaceControlPoint;
    }

    protected Airspace getActiveAirspace() {
        return this.activeAirspace;
    }

    protected void setActiveAirspace(Airspace airspace) {
        this.activeAirspace = airspace;
    }

    protected Airspace getTopOwnedAirspaceAtCurrentPosition() {
        if (this.getEditor() == null) {
            return null;
        }
        Object object = this.getTopPickedObject();
        if (this.getEditor().getAirspace() != object) {
            return null;
        }
        return (Airspace)object;
    }

    protected AirspaceControlPoint getTopOwnedControlPointAtCurrentPosition() {
        if (this.getEditor() == null) {
            return null;
        }
        Object object = this.getTopPickedObject();
        if (!(object instanceof AirspaceControlPoint)) {
            return null;
        }
        if (this.getEditor() != ((AirspaceControlPoint)object).getEditor()) {
            return null;
        }
        return (AirspaceControlPoint)object;
    }

    protected Object getTopPickedObject() {
        if (this.getWorldWindow() == null) {
            return null;
        }
        PickedObjectList pickedObjectList = this.getWorldWindow().getObjectsAtCurrentPosition();
        if (pickedObjectList == null || pickedObjectList.getTopPickedObject() == null || pickedObjectList.getTopPickedObject().isTerrain()) {
            return null;
        }
        return pickedObjectList.getTopPickedObject().getObject();
    }

    protected Map<String, Cursor> getActionCursorMap() {
        return this.actionCursorMap;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return;
        }
        this.updateCursor(keyEvent);
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return;
        }
        this.updateCursor(keyEvent);
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.updateCursor(mouseEvent);
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
        AirspaceControlPoint airspaceControlPoint = this.getTopOwnedControlPointAtCurrentPosition();
        if (mouseEvent.getButton() == 1 && mouseEvent.isControlDown()) {
            if (airspaceControlPoint != null) {
                this.handleControlPointRemoved(airspaceControlPoint, mouseEvent);
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.setMousePoint(new Point(mouseEvent.getPoint()));
        this.updateCursor(mouseEvent);
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
        Airspace airspace = this.getTopOwnedAirspaceAtCurrentPosition();
        AirspaceControlPoint airspaceControlPoint = this.getTopOwnedControlPointAtCurrentPosition();
        if (mouseEvent.getButton() == 1) {
            if (mouseEvent.isControlDown()) {
                this.setActive(true);
                this.setActiveAction(REMOVE_CONTROL_POINT);
                mouseEvent.consume();
            } else if (mouseEvent.isAltDown()) {
                AirspaceControlPoint airspaceControlPoint2;
                this.setActive(true);
                this.setActiveAction(ADD_CONTROL_POINT);
                if (airspaceControlPoint == null && (airspaceControlPoint2 = this.handleControlPointAdded(this.getEditor().getAirspace(), mouseEvent)) != null) {
                    this.setActiveControlPoint(airspaceControlPoint2);
                }
                mouseEvent.consume();
            } else if (airspaceControlPoint != null) {
                this.setActive(true);
                this.setActiveAction(null);
                this.setActiveControlPoint(airspaceControlPoint);
                mouseEvent.consume();
            } else if (airspace != null) {
                this.setActive(true);
                this.setActiveAction(null);
                this.setActiveAirspace(airspace);
                mouseEvent.consume();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.setMousePoint(new Point(mouseEvent.getPoint()));
        this.updateCursor(mouseEvent);
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
        if (mouseEvent.getButton() == 1 && this.isActive()) {
            this.setActive(false);
            this.setActiveAction(null);
            this.setActiveAirspace(null);
            this.setActiveControlPoint(null);
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
    }

    protected AirspaceControlPoint handleControlPointAdded(Airspace airspace, MouseEvent mouseEvent) {
        AirspaceControlPoint airspaceControlPoint = this.getEditor().addControlPoint(this.getWorldWindow(), airspace, mouseEvent.getPoint());
        this.getWorldWindow().redraw();
        return airspaceControlPoint;
    }

    protected void handleControlPointRemoved(AirspaceControlPoint airspaceControlPoint, MouseEvent mouseEvent) {
        this.getEditor().removeControlPoint(this.getWorldWindow(), airspaceControlPoint);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        Point point = this.getMousePoint();
        this.setMousePoint(new Point(mouseEvent.getPoint()));
        this.updateCursor(mouseEvent);
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
        if ((mouseEvent.getModifiersEx() & 0x400) != 0 && this.isActive()) {
            if (this.getActiveControlPoint() != null) {
                this.handleControlPointDragged(this.getActiveControlPoint(), mouseEvent, point);
            } else if (this.getActiveAirspace() != null) {
                this.handleAirspaceDragged(this.getActiveAirspace(), mouseEvent, point);
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.setMousePoint(new Point(mouseEvent.getPoint()));
        this.updateCursor(mouseEvent);
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
    }

    protected void handleControlPointDragged(AirspaceControlPoint airspaceControlPoint, MouseEvent mouseEvent, Point point) {
        if (mouseEvent.isShiftDown()) {
            this.setActiveAction(RESIZE_AIRSPACE);
            this.getEditor().resizeAtControlPoint(this.getWorldWindow(), airspaceControlPoint, mouseEvent.getPoint(), point);
        } else {
            this.setActiveAction(MOVE_CONTROL_POINT);
            this.getEditor().moveControlPoint(this.getWorldWindow(), airspaceControlPoint, mouseEvent.getPoint(), point);
        }
    }

    protected void handleAirspaceDragged(Airspace airspace, MouseEvent mouseEvent, Point point) {
        if (mouseEvent.isShiftDown()) {
            this.setActiveAction(MOVE_AIRSPACE_VERTICALLY);
            this.getEditor().moveAirspaceVertically(this.getWorldWindow(), airspace, mouseEvent.getPoint(), point);
        } else {
            this.setActiveAction(MOVE_AIRSPACE_LATERALLY);
            this.getEditor().moveAirspaceLaterally(this.getWorldWindow(), airspace, mouseEvent.getPoint(), point);
        }
    }

    protected void setupActionCursorMap() {
        this.getActionCursorMap().put(MOVE_AIRSPACE_LATERALLY, Cursor.getPredefinedCursor(13));
        this.getActionCursorMap().put(MOVE_AIRSPACE_VERTICALLY, Cursor.getPredefinedCursor(8));
        this.getActionCursorMap().put(RESIZE_AIRSPACE, Cursor.getPredefinedCursor(8));
        this.getActionCursorMap().put(ADD_CONTROL_POINT, Cursor.getPredefinedCursor(1));
        this.getActionCursorMap().put(REMOVE_CONTROL_POINT, Cursor.getPredefinedCursor(1));
        this.getActionCursorMap().put(MOVE_CONTROL_POINT, Cursor.getPredefinedCursor(12));
    }

    protected void updateCursor(InputEvent inputEvent) {
        if (inputEvent == null || inputEvent.getComponent() == null) {
            return;
        }
        Cursor cursor = this.getCursorFor(inputEvent);
        inputEvent.getComponent().setCursor(cursor);
        inputEvent.getComponent().repaint();
    }

    protected Cursor getCursorFor(InputEvent inputEvent) {
        if (inputEvent == null) {
            return null;
        }
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return null;
        }
        String string = this.isActive() ? this.getActiveAction() : this.getPotentialActionFor(inputEvent);
        return this.getActionCursorMap().get(string);
    }

    protected String getPotentialActionFor(InputEvent inputEvent) {
        Airspace airspace = this.getTopOwnedAirspaceAtCurrentPosition();
        AirspaceControlPoint airspaceControlPoint = this.getTopOwnedControlPointAtCurrentPosition();
        if (inputEvent.isAltDown()) {
            if (airspaceControlPoint == null) {
                return ADD_CONTROL_POINT;
            }
        } else if (inputEvent.isControlDown()) {
            if (airspaceControlPoint != null) {
                return REMOVE_CONTROL_POINT;
            }
        } else if (inputEvent.isShiftDown()) {
            if (airspaceControlPoint != null) {
                return RESIZE_AIRSPACE;
            }
            if (airspace != null) {
                return MOVE_AIRSPACE_VERTICALLY;
            }
        } else {
            if (airspaceControlPoint != null) {
                return MOVE_CONTROL_POINT;
            }
            if (airspace != null) {
                return MOVE_AIRSPACE_LATERALLY;
            }
        }
        return null;
    }
}

