/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SurfaceSector
extends AbstractSurfaceShape
implements Exportable {
    protected Sector sector = Sector.EMPTY_SECTOR;

    public SurfaceSector() {
    }

    public SurfaceSector(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfaceSector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
    }

    public SurfaceSector(ShapeAttributes shapeAttributes, Sector sector) {
        super(shapeAttributes);
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
    }

    public Sector getSector() {
        return this.sector;
    }

    public void setSector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.onShapeChanged();
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.sector.getCentroid(), 0.0);
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        if (this.sector.equals(Sector.EMPTY_SECTOR)) {
            return null;
        }
        LatLon[] latLonArray = new LatLon[5];
        System.arraycopy(this.sector.getCorners(), 0, latLonArray, 0, 4);
        latLonArray[4] = latLonArray[0];
        return Arrays.asList(latLonArray);
    }

    @Override
    protected List<List<LatLon>> createGeometry(Globe globe, SurfaceTileDrawContext surfaceTileDrawContext) {
        Iterable<? extends LatLon> iterable = this.getLocations(globe);
        if (iterable == null) {
            return null;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        double d = this.computeEdgeIntervalsPerDegree(surfaceTileDrawContext);
        this.generateIntermediateLocations(iterable, d, false, arrayList);
        ArrayList<List<LatLon>> arrayList2 = new ArrayList<List<LatLon>>();
        arrayList2.add(arrayList);
        return arrayList2;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        LatLon[] latLonArray = new LatLon[]{new LatLon(this.sector.getMinLatitude(), this.sector.getMinLongitude()), new LatLon(this.sector.getMaxLatitude(), this.sector.getMaxLongitude())};
        LatLon[] latLonArray2 = new LatLon[2];
        for (int i = 0; i < 2; ++i) {
            Angle angle = LatLon.greatCircleAzimuth(position, latLonArray[i]);
            Angle angle2 = LatLon.greatCircleDistance(position, latLonArray[i]);
            latLonArray2[i] = LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2);
        }
        this.setSector(new Sector(latLonArray2[0].getLatitude(), latLonArray2[1].getLatitude(), latLonArray2[0].getLongitude(), latLonArray2[1].getLongitude()));
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsSector(stateObject, "sector", this.getSector());
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doRestoreState(restorableSupport, stateObject);
        Sector sector = restorableSupport.getStateValueAsSector(stateObject, "sector");
        if (sector != null) {
            this.setSector(sector);
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.legacyRestoreState(restorableSupport, stateObject);
        List<LatLon> list = restorableSupport.getStateValueAsLatLonList(stateObject, "locations");
        if (list != null) {
            this.setSector(Sector.boundingSector(list));
        }
    }

    @Override
    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        String string;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string2 = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string2);
            throw new IllegalArgumentException(string2);
        }
        xMLStreamWriter.writeStartElement("Placemark");
        String string3 = (String)this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        if (string3 != null) {
            xMLStreamWriter.writeStartElement("name");
            xMLStreamWriter.writeCharacters(string3);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("visibility");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isVisible()));
        xMLStreamWriter.writeEndElement();
        String string4 = (String)this.getValue("gov.nasa.worldwind.avkey.Server.ShortDescription");
        if (string4 != null) {
            xMLStreamWriter.writeStartElement("Snippet");
            xMLStreamWriter.writeCharacters(string4);
            xMLStreamWriter.writeEndElement();
        }
        if ((string = (String)this.getValue("gov.nasa.worldwind.avkey.BalloonText")) != null) {
            xMLStreamWriter.writeStartElement("description");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
        }
        ShapeAttributes shapeAttributes = this.getAttributes();
        ShapeAttributes shapeAttributes2 = this.getHighlightAttributes();
        if (shapeAttributes != null || shapeAttributes2 != null) {
            xMLStreamWriter.writeStartElement("StyleMap");
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "normal", shapeAttributes);
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "highlight", shapeAttributes2);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("Polygon");
        xMLStreamWriter.writeStartElement("extrude");
        xMLStreamWriter.writeCharacters("0");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters("clampToGround");
        xMLStreamWriter.writeEndElement();
        Sector sector = this.getSector();
        LatLon[] latLonArray = sector.getCorners();
        xMLStreamWriter.writeStartElement("outerBoundaryIs");
        KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, Arrays.asList(latLonArray), null);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }
}

