/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.render.AbstractBrowserBalloon;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenBalloon;
import gov.nasa.worldwind.util.Logging;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class ScreenBrowserBalloon
extends AbstractBrowserBalloon
implements ScreenBalloon {
    protected Point screenLocation;

    public ScreenBrowserBalloon(String string, Point point) {
        super(string);
        if (point == null) {
            String string2 = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.screenLocation = point;
    }

    @Override
    public Point getScreenLocation() {
        return this.screenLocation;
    }

    @Override
    public void setScreenLocation(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.screenLocation = point;
    }

    @Override
    protected void computeBalloonPoints(DrawContext drawContext) {
        this.screenOffset = null;
        this.screenRect = null;
        this.screenExtent = null;
        this.screenPickExtent = null;
        this.webViewRect = null;
        this.eyeDistance = 0.0;
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        Dimension dimension = this.computeSize(drawContext, balloonAttributes);
        this.screenOffset = this.computeOffset(drawContext, balloonAttributes, dimension.width, dimension.height);
        int n = drawContext.getView().getViewport().height - this.screenLocation.y;
        this.screenRect = new Rectangle(this.screenLocation.x - this.screenOffset.x, n - this.screenOffset.y, dimension.width, dimension.height);
        this.screenExtent = new Rectangle(this.screenRect);
        this.screenExtent.add(this.screenLocation.x, n);
        this.screenPickExtent = this.computeFramePickRect(this.screenExtent);
        this.webViewRect = this.computeWebViewRectForFrameRect(balloonAttributes, this.screenRect);
        this.eyeDistance = 0.0;
    }

    @Override
    protected void setupDepthTest(DrawContext drawContext) {
        drawContext.getGL().glDisable(2929);
    }
}

