/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.render.AbstractAnnotationBalloon;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.ScreenBalloon;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.Rectangle;

public class ScreenAnnotationBalloon
extends AbstractAnnotationBalloon
implements ScreenBalloon {
    protected Point screenPoint;
    protected ScreenAnnotation annotation;

    public ScreenAnnotationBalloon(String string, Point point) {
        super(string);
        if (point == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.screenPoint = point;
        this.annotation = this.createAnnotation();
    }

    @Override
    protected ScreenAnnotation createAnnotation() {
        ScreenAnnotation screenAnnotation = new ScreenAnnotation(this.getDecodedText(), this.screenPoint);
        screenAnnotation.getAttributes().setHighlightScale(1.0);
        return screenAnnotation;
    }

    @Override
    protected ScreenAnnotation getAnnotation() {
        return this.annotation;
    }

    @Override
    protected void computePosition(DrawContext drawContext) {
        Rectangle rectangle = drawContext.getView().getViewport();
        int n = (int)rectangle.getHeight() - this.screenPoint.y - 1;
        this.getAnnotation().setScreenPoint(new Point(this.screenPoint.x, n));
    }

    @Override
    public void setScreenLocation(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.screenPoint = point;
    }

    @Override
    public Point getScreenLocation() {
        return this.screenPoint;
    }
}

