/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLTextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.opengl.GL2;

public class MultiLineTextRenderer {
    protected TextRenderer textRenderer;
    protected int lineSpacing = 0;
    protected int lineHeight = 14;
    protected String textAlign = "gov.nasa.worldwind.avkey.Left";
    protected String continuationString = "...";
    protected Color textColor = Color.DARK_GRAY;
    protected Color backColor = Color.LIGHT_GRAY;
    protected Color linkColor = Color.BLUE;
    protected boolean isPicking = false;
    protected DrawContext drawContext;
    protected PickSupport pickSupport;
    protected Object pickObject;
    protected Position pickPosition;
    protected static Pattern SGMLPattern = Pattern.compile("<[^\\s].*?>");
    protected static Pattern SGMLOrSpacePattern = Pattern.compile("(<[^\\s].*?>)|(\\s)");

    public MultiLineTextRenderer(TextRenderer textRenderer) {
        if (textRenderer == null) {
            String string = Logging.getMessage("nullValue.TextRendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textRenderer = textRenderer;
    }

    public MultiLineTextRenderer(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textRenderer = new TextRenderer(font, true, false);
        this.textRenderer.setUseVertexArrays(false);
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int n) {
        this.lineSpacing = n;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int n) {
        this.lineHeight = n;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String string) {
        if (!(string.equals("gov.nasa.worldwind.avkey.Left") || string.equals("gov.nasa.worldwind.avkey.Center") || string.equals("gov.nasa.worldwind.avkey.Right"))) {
            String string2 = Logging.getMessage("generic.ArgumentOutOfRange", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.textAlign = string;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textColor = color;
        this.textRenderer.setColor(color);
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.backColor = color;
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.linkColor = color;
    }

    public void setContinuationString(String string) {
        this.continuationString = string;
    }

    public double getMaxLineHeight(TextRenderer textRenderer) {
        return textRenderer.getBounds("_\u00c9").getHeight();
    }

    public Rectangle getBounds(String string) {
        String[] stringArray;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        int n = 0;
        int n2 = 0;
        for (String string3 : stringArray = string.split("\n")) {
            Rectangle2D rectangle2D = this.textRenderer.getBounds(string3);
            n = (int)Math.max(rectangle2D.getWidth(), (double)n);
            n2 = (int)Math.max(rectangle2D.getHeight(), (double)this.lineHeight);
        }
        this.lineHeight = n2 = (int)Math.max(this.getMaxLineHeight(this.textRenderer), (double)n2);
        return new Rectangle(stringArray.length, this.lineHeight, n, stringArray.length * n2 + (stringArray.length - 1) * this.lineSpacing);
    }

    public void draw(String string, int n, int n2) {
        this.draw(string, n, n2, this.lineHeight);
    }

    public void draw(String string, int n, int n2, String string2) {
        this.draw(string, n, n2, this.lineHeight, string2);
    }

    public void draw(String string, int n, int n2, int n3, String string2) {
        if (string2 == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2.equals("gov.nasa.worldwind.avkey.TextEffectShadow")) {
            this.textRenderer.setColor(this.backColor);
            this.draw(string, n + 1, n2 - 1, n3);
            this.textRenderer.setColor(this.textColor);
        } else if (string2.equals("gov.nasa.worldwind.avkey.TextEffectOutline")) {
            this.textRenderer.setColor(this.backColor);
            this.draw(string, n, n2 + 1, n3);
            this.draw(string, n + 1, n2, n3);
            this.draw(string, n, n2 - 1, n3);
            this.draw(string, n - 1, n2, n3);
            this.textRenderer.setColor(this.textColor);
        }
        this.draw(string, n, n2, n3);
    }

    public void draw(String string, int n, int n2, int n3) {
        String[] stringArray;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        for (String string3 : stringArray = string.split("\n")) {
            int n4 = n;
            if (this.textAlign.equals("gov.nasa.worldwind.avkey.Center")) {
                n4 = n - (int)(this.textRenderer.getBounds(string3).getWidth() / 2.0);
            } else if (this.textAlign.equals("gov.nasa.worldwind.avkey.Right")) {
                n4 = n - (int)this.textRenderer.getBounds(string3).getWidth();
            }
            this.textRenderer.draw3D(string3, (float)n4, (float)(n2 -= n3), 0.0f, 1.0f);
            n2 -= this.lineSpacing;
        }
    }

    public void pick(String string, int n, int n2, int n3, DrawContext drawContext, PickSupport pickSupport, Object object, Position position) {
        String[] stringArray;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext == null) {
            String string3 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (pickSupport == null) {
            String string4 = Logging.getMessage("nullValue.PickSupportIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        for (String string5 : stringArray = string.split("\n")) {
            int n4 = n;
            if (this.textAlign.equals("gov.nasa.worldwind.avkey.Center")) {
                n4 = n - (int)(this.textRenderer.getBounds(string5).getWidth() / 2.0);
            } else if (this.textAlign.equals("gov.nasa.worldwind.avkey.Right")) {
                n4 = n - (int)this.textRenderer.getBounds(string5).getWidth();
            }
            this.drawLineWithUniqueColors(string5, n4, n2 -= n3, drawContext, pickSupport, object, position);
            n2 -= this.lineSpacing;
        }
    }

    protected void drawLineWithUniqueColors(String string, int n, int n2, DrawContext drawContext, PickSupport pickSupport, Object object, Position position) {
        GL2 gL2 = drawContext.getGL().getGL2();
        String string2 = string.trim();
        int n3 = 0;
        int n4 = string2.indexOf(32, n3 + 1);
        while (n3 < string2.length()) {
            if (n4 == -1) {
                n4 = string2.length();
            }
            String string3 = string2.substring(n3, n4);
            Rectangle2D rectangle2D = this.textRenderer.getBounds(string3);
            Rectangle2D rectangle2D2 = this.textRenderer.getBounds(string2.substring(0, n3));
            float f = (float)n + (n3 > 0 ? (float)rectangle2D2.getWidth() + (float)rectangle2D2.getX() : 0.0f);
            Color color = drawContext.getUniquePickColor();
            int n5 = color.getRGB();
            PickedObject pickedObject = new PickedObject(n5, object, position, false);
            pickedObject.setValue("gov.nasa.worldwind.avkey.Text", string3.trim());
            pickSupport.addPickableObject(pickedObject);
            gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            this.drawFilledRectangle(drawContext, (double)f + rectangle2D.getX(), (double)n2 - rectangle2D.getHeight() - rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            n3 = n4;
            if (n3 >= string2.length() - 1) continue;
            n4 = string2.indexOf(32, n3 + 1);
        }
    }

    public String wrap(String string, int n, int n2) {
        int n3;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = this.wrapLine(stringArray[n3], n);
        }
        n3 = 0;
        boolean bl = false;
        double d = this.getMaxLineHeight(this.textRenderer);
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            String[] stringArray2 = stringArray[i].split("\n");
            for (int j = 0; j < stringArray2.length && !bl; ++j) {
                if (n2 <= 0 || (double)n3 + d <= (double)n2) {
                    stringBuffer.append(stringArray2[j]);
                    n3 = (int)((double)n3 + (d + (double)this.lineSpacing));
                    if (j >= stringArray2.length - 1) continue;
                    stringBuffer.append('\n');
                    continue;
                }
                bl = true;
            }
            if (i >= stringArray.length - 1 || bl) continue;
            stringBuffer.append('\n');
        }
        if (bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            stringBuffer.append(this.continuationString);
        }
        return stringBuffer.toString();
    }

    protected String wrapLine(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.trim();
        Rectangle2D rectangle2D = this.textRenderer.getBounds(string2);
        if (rectangle2D.getWidth() > (double)n) {
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = 0;
            int n3 = string2.indexOf(32, n2 + 1);
            while (n2 < string2.length()) {
                if (n3 == -1) {
                    n3 = string2.length();
                }
                String string3 = string2.substring(n2, n3);
                String string4 = stringBuffer2 + string3;
                if (this.textRenderer.getBounds(string4).getWidth() <= (double)n) {
                    stringBuffer2.append(string3);
                } else if (stringBuffer2.length() != 0) {
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append('\n');
                    stringBuffer2.delete(0, stringBuffer2.length());
                    stringBuffer2.append(string3.trim());
                } else {
                    stringBuffer2.append(string3.trim());
                }
                if ((n2 = n3) >= string2.length() - 1) continue;
                n3 = string2.indexOf(32, n2 + 1);
            }
            stringBuffer.append(stringBuffer2);
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static boolean containsHTML(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Matcher matcher = SGMLPattern.matcher(string);
        return matcher.find();
    }

    public static String processLineBreaksHTML(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        string = string.replaceAll("\n", "");
        string = string.replaceAll("(?i)<br\\s?.*?>", "\n");
        string = string.replaceAll("(?i)<p\\s?.*?>", "");
        string = string.replaceAll("(?i)</p>", "\n\n");
        return string;
    }

    public static String removeTagsHTML(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.replaceAll("<[^\\s].*?>", "");
    }

    public static String getAttributeFromTagHTML(String string, String string2) {
        if (string == null || string2 == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Pattern pattern = Pattern.compile("(?i)" + string2.toLowerCase() + "=\"([^\"].*?)\"");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public Rectangle getBoundsHTML(String string, TextRendererCache textRendererCache) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (textRendererCache == null) {
            String string3 = Logging.getMessage("nullValue.TextRendererCacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        DrawState drawState = new DrawState(textRendererCache, this.textRenderer.getFont(), null, this.textColor);
        return this.getTextBoundsHTML(string, drawState).getBounds();
    }

    protected Rectangle2D getTextBoundsHTML(String string, DrawState drawState) {
        String[] stringArray;
        double d = 0.0;
        double d2 = 0.0;
        for (String string2 : stringArray = string.split("\n")) {
            Rectangle2D rectangle2D = this.getLineBoundsHTML(string2, drawState);
            d = Math.max(rectangle2D.getWidth(), d);
            d2 += rectangle2D.getHeight() + (double)this.lineSpacing;
        }
        return new Rectangle2D.Double(0.0, 0.0, d, d2 -= (double)this.lineSpacing);
    }

    protected Rectangle2D getLineBoundsHTML(String string, DrawState drawState) {
        double d = 0.0;
        double d2 = this.getMaxLineHeight(drawState.textRenderer);
        WordIteratorHTML wordIteratorHTML = new WordIteratorHTML(string);
        while (wordIteratorHTML.hasNext()) {
            Rectangle2D rectangle2D = this.getWordBoundsHTML((String)wordIteratorHTML.next(), drawState);
            d += rectangle2D.getWidth();
            d2 = Math.max(rectangle2D.getHeight(), d2);
            if (!wordIteratorHTML.hasNext()) continue;
            d += (double)drawState.textRenderer.getCharWidth(' ');
        }
        return new Rectangle2D.Double(0.0, 0.0, d, d2);
    }

    protected Rectangle2D getWordBoundsHTML(String string, DrawState drawState) {
        Rectangle2D rectangle2D;
        String string2;
        double d = 0.0;
        double d2 = this.getMaxLineHeight(drawState.textRenderer);
        int n = 0;
        Matcher matcher = SGMLOrSpacePattern.matcher(string);
        while (matcher.find()) {
            if (matcher.group().equals(" ")) continue;
            if (matcher.start() > n) {
                string2 = string.substring(n, matcher.start());
                rectangle2D = drawState.textRenderer.getBounds(string2);
                d += rectangle2D.getWidth() + rectangle2D.getX();
            }
            drawState.updateFromHTMLTag(matcher.group(), false);
            d2 = Math.max(this.getMaxLineHeight(drawState.textRenderer), d2);
            n = matcher.end();
        }
        if (n < string.length()) {
            string2 = string.substring(n, string.length());
            rectangle2D = drawState.textRenderer.getBounds(string2);
            d += rectangle2D.getWidth() + rectangle2D.getX();
        }
        return new Rectangle2D.Double(0.0, 0.0, d, d2);
    }

    public String wrapHTML(String string, double d, double d2, TextRendererCache textRendererCache) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (textRendererCache == null) {
            String string3 = Logging.getMessage("nullValue.TextRendererCacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        DrawState drawState = new DrawState(textRendererCache, this.textRenderer.getFont(), null, this.textColor);
        return this.wrapTextHTML(string, d, d2, drawState);
    }

    protected String wrapTextHTML(String string, double d, double d2, DrawState drawState) {
        String[] stringArray;
        DrawState drawState2 = new DrawState(drawState);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : stringArray = string.split("\n")) {
            stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "");
            stringBuffer.append(this.wrapLineHTML(string2, d, drawState));
        }
        if (d2 > 0.0) {
            return this.trimTextHTML(stringBuffer.toString(), d2, drawState2);
        }
        return stringBuffer.toString();
    }

    protected String trimTextHTML(String string, double d, DrawState drawState) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        double d2 = 0.0;
        for (String string2 : stringArray = string.split("\n")) {
            Rectangle2D rectangle2D = this.getLineBoundsHTML(string2, drawState);
            if (d2 + rectangle2D.getHeight() <= d) {
                stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "");
                stringBuffer.append(string2);
                d2 += rectangle2D.getHeight() + (double)this.lineSpacing;
                continue;
            }
            stringBuffer.append(this.continuationString);
            break;
        }
        return stringBuffer.toString();
    }

    protected String wrapLineHTML(String string, double d, DrawState drawState) {
        DrawState drawState2 = new DrawState(drawState);
        Rectangle2D rectangle2D = this.getLineBoundsHTML(string, drawState);
        if (rectangle2D.getWidth() <= d) {
            return string;
        }
        double d2 = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        WordIteratorHTML wordIteratorHTML = new WordIteratorHTML(string);
        while (wordIteratorHTML.hasNext()) {
            double d3;
            String string2;
            block6: {
                double d4;
                block5: {
                    string2 = wordIteratorHTML.next();
                    d4 = drawState2.textRenderer.getCharWidth(' ');
                    d3 = this.getWordBoundsHTML(string2, drawState2).getWidth();
                    if (d2 == 0.0) break block5;
                    double d5 = d2 > 0.0 ? d4 : 0.0;
                    if (!(d2 + d3 + d5 <= d)) break block6;
                }
                stringBuffer.append(d2 > 0.0 ? " " : "");
                stringBuffer.append(string2);
                d2 += d3 + (d2 > 0.0 ? d4 : 0.0);
                continue;
            }
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            d2 = d3;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pickHTML(String string, int n, int n2, TextRendererCache textRendererCache, DrawContext drawContext, PickSupport pickSupport, Object object, Position position) {
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (pickSupport == null) {
            String string3 = Logging.getMessage("nullValue.PickSupportIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.drawContext = drawContext;
        this.pickSupport = pickSupport;
        this.pickObject = object;
        this.pickPosition = position;
        this.isPicking = true;
        try {
            this.drawHTML(string, n, n2, textRendererCache);
        }
        finally {
            this.isPicking = false;
        }
    }

    public void drawHTML(String string, double d, double d2, TextRendererCache textRendererCache) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (textRendererCache == null) {
            String string3 = Logging.getMessage("nullValue.TextRendererCacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        DrawState drawState = new DrawState(textRendererCache, this.textRenderer.getFont(), null, this.textColor);
        this.drawTextHTML(string, d, d2, drawState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTextHTML(String string, double d, double d2, DrawState drawState) {
        if (!this.isPicking) {
            drawState.textRenderer.begin3DRendering();
        }
        try {
            String[] stringArray;
            drawState.textRenderer.setColor(this.textColor);
            double d3 = d2;
            for (String string2 : stringArray = string.split("\n")) {
                double d4 = d;
                Rectangle2D rectangle2D = this.getTextBoundsHTML(string2, new DrawState(drawState));
                if (this.textAlign.equals("gov.nasa.worldwind.avkey.Center")) {
                    d4 = d - rectangle2D.getWidth() / 2.0;
                } else if (this.textAlign.equals("gov.nasa.worldwind.avkey.Right")) {
                    d4 = d - rectangle2D.getWidth();
                }
                this.drawLineHTML(string2, d4, d3 -= rectangle2D.getHeight(), drawState);
                d3 -= (double)this.lineSpacing;
            }
        }
        finally {
            if (!this.isPicking) {
                drawState.textRenderer.end3DRendering();
            }
        }
    }

    protected void drawLineHTML(String string, double d, double d2, DrawState drawState) {
        WordIteratorHTML wordIteratorHTML = new WordIteratorHTML(string);
        double d3 = d;
        while (wordIteratorHTML.hasNext()) {
            String string2 = wordIteratorHTML.next();
            Rectangle2D rectangle2D = this.getWordBoundsHTML(string2, new DrawState(drawState));
            if (this.isPicking) {
                this.pickWordHTML(string2, d3, d2, drawState);
            } else {
                this.drawWordHTML(string2, d3, d2, drawState);
            }
            d3 += rectangle2D.getWidth() + (double)drawState.textRenderer.getCharWidth(' ');
        }
    }

    protected void drawWordHTML(String string, double d, double d2, DrawState drawState) {
        String string2;
        double d3 = d;
        int n = 0;
        Matcher matcher = SGMLOrSpacePattern.matcher(string);
        while (matcher.find()) {
            if (matcher.group().equals(" ")) continue;
            if (matcher.start() > n) {
                string2 = string.substring(n, matcher.start());
                Rectangle2D rectangle2D = drawState.textRenderer.getBounds(string2);
                drawState.textRenderer.draw(string2, (int)d3, (int)d2);
                d3 += rectangle2D.getWidth() + rectangle2D.getX();
            }
            drawState.updateFromHTMLTag(matcher.group(), true);
            n = matcher.end();
        }
        if (n < string.length()) {
            string2 = string.substring(n, string.length());
            drawState.textRenderer.draw(string2, (int)d3, (int)d2);
        }
    }

    protected void pickWordHTML(String string, double d, double d2, DrawState drawState) {
        Rectangle2D rectangle2D;
        String string2;
        double d3 = d;
        int n = 0;
        boolean bl = true;
        Matcher matcher = SGMLOrSpacePattern.matcher(string);
        while (matcher.find()) {
            if (matcher.group().equals(" ")) continue;
            if (matcher.start() > n) {
                string2 = string.substring(n, matcher.start());
                rectangle2D = drawState.textRenderer.getBounds(string2);
                this.pickWordPartHTML(string2, d3, d2, rectangle2D, drawState, bl);
                bl = false;
                d3 += rectangle2D.getWidth() + rectangle2D.getX();
            }
            drawState.updateFromHTMLTag(matcher.group(), false);
            n = matcher.end();
        }
        if (n < string.length()) {
            string2 = string.substring(n, string.length());
            rectangle2D = drawState.textRenderer.getBounds(string2);
            this.pickWordPartHTML(string2, d3, d2, rectangle2D, drawState, bl);
        }
    }

    protected void pickWordPartHTML(String string, double d, double d2, Rectangle2D rectangle2D, DrawState drawState, boolean bl) {
        Rectangle2D.Double double_;
        String string2 = drawState.getDrawAttributes().hyperlink;
        double d3 = (double)drawState.textRenderer.getCharWidth(' ') * 1.5;
        double d4 = this.getMaxLineHeight(drawState.textRenderer);
        if (bl) {
            double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth() + rectangle2D.getX() + d3, d4 * 1.1);
            d -= d3 / 2.0;
        } else {
            double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth() + rectangle2D.getX() + d3 / 2.0, d4 * 1.1);
        }
        this.pickWord(string, string2, d, d2, double_, this.drawContext, this.pickSupport, this.pickObject, this.pickPosition);
    }

    protected void pickWord(String string, String string2, double d, double d2, Rectangle2D rectangle2D, DrawContext drawContext, PickSupport pickSupport, Object object, Position position) {
        GL2 gL2 = drawContext.getGL().getGL2();
        Color color = drawContext.getUniquePickColor();
        int n = color.getRGB();
        PickedObject pickedObject = new PickedObject(n, object, position, false);
        pickedObject.setValue("gov.nasa.worldwind.avkey.Text", MultiLineTextRenderer.removeTagsHTML(string.trim()));
        if (string2 != null) {
            pickedObject.setValue("gov.nasa.worldwind.avkey.URL", string2);
        }
        pickSupport.addPickableObject(pickedObject);
        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        this.drawFilledRectangle(drawContext, d, d2 - rectangle2D.getHeight() / 4.0, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected void drawFilledRectangle(DrawContext drawContext, double d, double d2, double d3, double d4) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBegin(9);
        gL2.glVertex3d(d, d2, 0.0);
        gL2.glVertex3d(d + d3 - 1.0, d2, 0.0);
        gL2.glVertex3d(d + d3 - 1.0, d2 + d4 - 1.0, 0.0);
        gL2.glVertex3d(d, d2 + d4 - 1.0, 0.0);
        gL2.glVertex3d(d, d2, 0.0);
        gL2.glEnd();
    }

    protected class DrawState {
        protected ArrayList<DrawAttributes> stack = new ArrayList();
        protected TextRendererCache renderers;
        public TextRenderer textRenderer;
        protected Pattern SGMLPattern = Pattern.compile("(<[^\\s].*?>)");

        public DrawState(TextRendererCache textRendererCache, Font font, String string, Color color) {
            this.push(new DrawAttributes(font, string, color));
            this.renderers = textRendererCache;
            this.textRenderer = this.getTextRenderer(font);
        }

        public DrawState(DrawState drawState) {
            for (DrawAttributes drawAttributes : drawState.stack) {
                this.push(new DrawAttributes(drawAttributes.font, drawAttributes.hyperlink, drawAttributes.color));
            }
            this.renderers = drawState.renderers;
            this.textRenderer = drawState.textRenderer;
        }

        public DrawAttributes getDrawAttributes() {
            if (this.stack.size() < 1) {
                return null;
            }
            return this.stack.get(this.stack.size() - 1);
        }

        protected TextRenderer getTextRenderer(Font font) {
            return OGLTextRenderer.getOrCreateTextRenderer(this.renderers, font);
        }

        protected Font getFont(Font font, boolean bl, boolean bl2) {
            int n = bl ? (bl2 ? 3 : 1) : (bl2 ? 2 : 0);
            return font.deriveFont(n);
        }

        public void updateFromHTMLText(String string, boolean bl) {
            Matcher matcher = this.SGMLPattern.matcher(string);
            while (matcher.find()) {
                this.updateFromHTMLTag(matcher.group(), bl);
            }
        }

        public void updateFromHTMLTag(String string, boolean bl) {
            DrawAttributes drawAttributes = this.getDrawAttributes();
            boolean bl2 = false;
            if (string.equalsIgnoreCase("<b>")) {
                this.push(new DrawAttributes(this.getFont(drawAttributes.font, true, drawAttributes.font.isItalic()), drawAttributes.hyperlink, drawAttributes.color));
                bl2 = true;
            } else if (string.equalsIgnoreCase("</b>")) {
                this.pop();
                bl2 = true;
            } else if (string.equalsIgnoreCase("<i>")) {
                this.push(new DrawAttributes(this.getFont(drawAttributes.font, drawAttributes.font.isBold(), true), drawAttributes.hyperlink, drawAttributes.color));
                bl2 = true;
            } else if (string.equalsIgnoreCase("</i>")) {
                this.pop();
                bl2 = true;
            } else if (string.toLowerCase().startsWith("<a ")) {
                this.push(new DrawAttributes(drawAttributes.font, MultiLineTextRenderer.getAttributeFromTagHTML(string, "href"), this.applyTextAlpha(MultiLineTextRenderer.this.linkColor)));
                if (bl) {
                    this.textRenderer.setColor(this.applyTextAlpha(MultiLineTextRenderer.this.linkColor));
                }
            } else if (string.equalsIgnoreCase("</a>")) {
                this.pop();
                if (bl) {
                    this.textRenderer.setColor(this.getDrawAttributes().color);
                }
            } else if (string.toLowerCase().startsWith("<font ")) {
                String string2 = MultiLineTextRenderer.getAttributeFromTagHTML(string, "color");
                if (string2 != null) {
                    Color color = drawAttributes.color;
                    try {
                        color = this.applyTextAlpha(Color.decode(string2));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.push(new DrawAttributes(drawAttributes.font, drawAttributes.hyperlink, color));
                    if (bl) {
                        this.textRenderer.setColor(color);
                    }
                }
            } else if (string.equalsIgnoreCase("</font>")) {
                this.pop();
                if (bl) {
                    this.textRenderer.setColor(this.getDrawAttributes().color);
                }
            }
            if (bl2) {
                if (bl) {
                    this.textRenderer.end3DRendering();
                }
                drawAttributes = this.getDrawAttributes();
                this.textRenderer = this.getTextRenderer(drawAttributes.font);
                if (bl) {
                    this.textRenderer.begin3DRendering();
                    this.textRenderer.setColor(drawAttributes.color);
                }
            }
        }

        protected void push(DrawAttributes drawAttributes) {
            this.stack.add(drawAttributes);
        }

        protected void pop() {
            if (this.stack.size() > 1) {
                this.stack.remove(this.stack.size() - 1);
            }
        }

        protected Color applyTextAlpha(Color color) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() * MultiLineTextRenderer.this.textColor.getAlpha() / 255);
        }

        protected class DrawAttributes {
            protected final Font font;
            protected String hyperlink;
            protected final Color color;

            public DrawAttributes(Font font, String string, Color color) {
                this.font = font;
                this.hyperlink = string;
                this.color = color;
            }
        }
    }

    public static class WordIteratorHTML
    implements Iterator<String> {
        protected ArrayList<String> words;
        protected int nextWord = -1;
        protected static Pattern SGMLOrSpacePattern = Pattern.compile("(<[^\\s].*?>)|(\\s)");

        public WordIteratorHTML(String string) {
            Matcher matcher = SGMLOrSpacePattern.matcher(string);
            this.words = new ArrayList();
            int n = 0;
            while (matcher.find()) {
                if (!matcher.group().equals(" ")) continue;
                this.addWord(string.substring(n, matcher.end()));
                n = matcher.end();
            }
            if (n < string.length()) {
                this.addWord(string.substring(n));
            }
            if (this.words.size() > 0) {
                this.nextWord = 0;
            }
        }

        protected void addWord(String string) {
            if ((string = string.trim()).length() > 0) {
                this.words.add(string);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextWord != -1 && this.nextWord < this.words.size();
        }

        @Override
        public String next() {
            return this.words.get(this.nextWord++);
        }

        @Override
        public void remove() {
        }
    }
}

