/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.cache.ShapeDataCache;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Triangle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.GLUTessellatorSupport;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.WWBufferUtil;
import gov.nasa.worldwind.util.WWMath;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ExtrudedPolygon
extends AbstractShape {
    protected static final Material DEFAULT_SIDES_INTERIOR_MATERIAL = Material.LIGHT_GRAY;
    protected static final int DEFAULT_ALTITUDE_MODE = 3;
    protected static final ShapeAttributes defaultSideAttributes = new BasicShapeAttributes();
    protected double baseDepth;
    protected static HashMap<Integer, IntBuffer> capEdgeIndexBuffers;
    protected static HashMap<Integer, IntBuffer> sideFillIndexBuffers;
    protected static HashMap<Integer, IntBuffer> sideEdgeIndexBuffers;
    protected static final int VBO_THRESHOLD;
    protected List<List<? extends LatLon>> boundaries;
    protected int totalNumLocations;
    protected int totalFaceCount;
    protected double height = 1.0;
    protected ShapeAttributes sideAttributes;
    protected ShapeAttributes sideHighlightAttributes;
    protected ShapeAttributes activeSideAttributes = new BasicShapeAttributes();
    protected List<List<WWTexture>> sideTextures;
    protected WWTexture capTexture;
    protected FloatBuffer capTextureCoords;
    protected boolean enableCap = true;
    protected boolean enableSides = true;
    protected Terrain previousIntersectionTerrain;
    protected Object previousIntersectionGlobeStateKey;
    protected ShapeData previousIntersectionShapeData;

    @Override
    protected AbstractShape.AbstractShapeData createCacheEntry(DrawContext drawContext) {
        return new ShapeData(drawContext, this);
    }

    protected ShapeData getCurrent() {
        return (ShapeData)this.getCurrentData();
    }

    public ExtrudedPolygon() {
        this.boundaries = new ArrayList<List<? extends LatLon>>();
        this.boundaries.add(new ArrayList());
    }

    public ExtrudedPolygon(Double d) {
        this();
        this.setHeight(d);
    }

    public ExtrudedPolygon(Iterable<? extends LatLon> iterable, Double d) {
        this();
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d != null && d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOuterBoundary(iterable, d);
    }

    public ExtrudedPolygon(Iterable<? extends LatLon> iterable, double d, Iterable<?> iterable2) {
        this(iterable, d);
        if (iterable2 != null) {
            this.sideTextures = new ArrayList<List<WWTexture>>();
            this.sideTextures.add(this.fillImageList(iterable2));
        }
    }

    public ExtrudedPolygon(Iterable<? extends Position> iterable) {
        this(iterable, 1.0);
    }

    public ExtrudedPolygon(Position.PositionList positionList) {
        this(positionList.list, 1.0);
    }

    public ExtrudedPolygon(Iterable<? extends Position> iterable, Iterable<?> iterable2) {
        this(iterable);
        if (iterable2 != null) {
            this.sideTextures = new ArrayList<List<WWTexture>>();
            this.sideTextures.add(this.fillImageList(iterable2));
        }
    }

    @Override
    protected void initialize() {
        this.altitudeMode = 3;
    }

    @Override
    protected void reset() {
        for (List<? extends LatLon> list : this.boundaries) {
            if (list == null || list.size() < 3 || WWMath.computeWindingOrderOfLocations(list).equals("gov.nasa.worldwind.avkey.CounterClockWise")) continue;
            Collections.reverse(list);
        }
        this.totalNumLocations = this.countLocations();
        this.previousIntersectionShapeData = null;
        this.previousIntersectionTerrain = null;
        this.previousIntersectionGlobeStateKey = null;
        super.reset();
    }

    protected int countLocations() {
        int n = 0;
        for (List<? extends LatLon> list : this.boundaries) {
            n += list.size();
        }
        this.totalFaceCount = n - this.boundaries.size();
        return n;
    }

    public Iterable<? extends LatLon> getOuterBoundary() {
        return this.outerBoundary();
    }

    protected List<? extends LatLon> outerBoundary() {
        return this.boundaries.get(0);
    }

    protected boolean isOuterBoundaryValid() {
        return this.boundaries.size() > 0 && this.boundaries.get(0).size() > 2;
    }

    public void setOuterBoundary(Iterable<? extends LatLon> iterable) {
        this.setOuterBoundary(iterable, this.getHeight());
    }

    public void setOuterBoundary(Iterable<? extends LatLon> iterable, Iterable<?> iterable2) {
        this.setOuterBoundary(iterable);
        if (iterable2 == null && this.sideTextures == null) {
            return;
        }
        if (this.sideTextures == null) {
            this.sideTextures = new ArrayList<List<WWTexture>>();
        }
        List<WWTexture> list = this.fillImageList(iterable2);
        this.sideTextures.set(0, list);
        for (ShapeDataCache.ShapeDataCacheEntry shapeDataCacheEntry : this.shapeDataCache) {
            ShapeData shapeData = (ShapeData)shapeDataCacheEntry;
            if (shapeData.boundaries == null) continue;
            shapeData.copySideTextureReferences(this);
        }
    }

    public void setOuterBoundary(Iterable<? extends LatLon> iterable, Double d) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getBoundaries().set(0, this.fillBoundary(iterable));
        if (d != null) {
            this.height = d;
        }
        this.reset();
    }

    protected List<? extends LatLon> fillBoundary(Iterable<? extends LatLon> iterable) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon : iterable) {
            if (latLon == null) continue;
            arrayList.add(latLon);
        }
        if (arrayList.size() < 3) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (arrayList.size() > 0 && !((LatLon)arrayList.get(0)).equals(arrayList.get(arrayList.size() - 1))) {
            arrayList.add((LatLon)arrayList.get(0));
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public void addInnerBoundary(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationInListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getBoundaries().add(this.fillBoundary(iterable));
        this.reset();
    }

    public void addInnerBoundary(Iterable<? extends LatLon> iterable, Iterable<?> iterable2) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationInListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getBoundaries().add(this.fillBoundary(iterable));
        if (iterable2 != null) {
            if (this.sideTextures == null) {
                this.sideTextures = new ArrayList<List<WWTexture>>();
                this.sideTextures.add(new ArrayList());
            }
            this.sideTextures.add(this.fillImageList(iterable2));
        }
        this.reset();
    }

    protected List<List<? extends LatLon>> getBoundaries() {
        return this.boundaries;
    }

    protected List<WWTexture> fillImageList(Iterable<?> iterable) {
        if (iterable == null) {
            return null;
        }
        ArrayList<WWTexture> arrayList = new ArrayList<WWTexture>();
        for (Object obj : iterable) {
            if (obj != null) {
                arrayList.add(this.makeTexture(obj));
                continue;
            }
            arrayList.add(null);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public Object getCapImageSource() {
        return this.capTexture != null ? this.capTexture.getImageSource() : null;
    }

    public void setCapImageSource(Object object, float[] fArray, int n) {
        if (object == null) {
            this.capTexture = null;
            this.capTextureCoords = null;
            return;
        }
        if (fArray == null) {
            String string = Logging.getMessage("generic.ListIsEmpty");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 3 || fArray.length < 2 * n) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.capTexture = this.makeTexture(object);
        boolean bl = fArray[0] != fArray[n - 2] || fArray[1] != fArray[n - 1];
        this.capTextureCoords = Buffers.newDirectFloatBuffer(2 * (n + (bl ? 1 : 0)));
        for (int i = 0; i < 2 * n; ++i) {
            this.capTextureCoords.put(fArray[i]);
        }
        if (bl) {
            this.capTextureCoords.put(this.capTextureCoords.get(0));
            this.capTextureCoords.put(this.capTextureCoords.get(1));
        }
    }

    public float[] getTextureCoords() {
        if (this.capTextureCoords == null) {
            return null;
        }
        float[] fArray = new float[this.capTextureCoords.limit()];
        this.capTextureCoords.get(fArray, 0, fArray.length);
        return fArray;
    }

    protected WWTexture getCapTexture() {
        return this.capTexture;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        if (this.height == d) {
            return;
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.height = d;
        this.reset();
    }

    public boolean isEnableCap() {
        return this.enableCap;
    }

    public void setEnableCap(boolean bl) {
        this.enableCap = bl;
    }

    public boolean isEnableSides() {
        return this.enableSides;
    }

    public void setEnableSides(boolean bl) {
        this.enableSides = bl;
    }

    public ShapeAttributes getSideAttributes() {
        return this.sideAttributes;
    }

    public void setSideAttributes(ShapeAttributes shapeAttributes) {
        if (shapeAttributes == null) {
            String string = "nullValue.AttributesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sideAttributes = shapeAttributes;
    }

    public ShapeAttributes getCapAttributes() {
        return this.getAttributes();
    }

    public void setCapAttributes(ShapeAttributes shapeAttributes) {
        this.setAttributes(shapeAttributes);
    }

    public ShapeAttributes getSideHighlightAttributes() {
        return this.sideHighlightAttributes;
    }

    public void setSideHighlightAttributes(ShapeAttributes shapeAttributes) {
        if (shapeAttributes == null) {
            String string = "nullValue.AttributesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sideHighlightAttributes = shapeAttributes;
    }

    public ShapeAttributes getCapHighlightAttributes() {
        return this.getHighlightAttributes();
    }

    public void setCapHighlightAttributes(ShapeAttributes shapeAttributes) {
        this.setHighlightAttributes(shapeAttributes);
    }

    protected ShapeAttributes getActiveSideAttributes() {
        return this.activeSideAttributes;
    }

    protected ShapeAttributes getActiveCapAttributes() {
        return this.getActiveAttributes();
    }

    @Override
    public Sector getSector() {
        if (this.sector == null && this.outerBoundary().size() > 2) {
            this.sector = Sector.boundingSector(this.getOuterBoundary());
        }
        return this.sector;
    }

    public LatLon getReferenceLocation() {
        return this.getReferencePosition();
    }

    public void setReferenceLocation(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LocationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.referencePosition = new Position(latLon, 0.0);
    }

    @Override
    public Position getReferencePosition() {
        if (this.referencePosition != null) {
            return this.referencePosition;
        }
        if (this.boundaries.size() > 0 && this.outerBoundary().size() > 0) {
            this.referencePosition = this.outerBoundary().get(0) instanceof Position ? (Position)this.outerBoundary().get(0) : new Position(this.outerBoundary().get(0), 0.0);
        }
        return this.referencePosition;
    }

    public double getBaseDepth() {
        return this.baseDepth;
    }

    public void setBaseDepth(double d) {
        this.baseDepth = d;
    }

    public List<List<Object>> getImageSources() {
        if (this.sideTextures == null) {
            return null;
        }
        boolean bl = false;
        for (List<WWTexture> list : this.sideTextures) {
            if (list == null || list.size() <= 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.getBoundaries().size());
        for (List list : this.sideTextures) {
            if (list == null) {
                arrayList.add(null);
                continue;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>(list.size());
            arrayList.add(arrayList2);
            for (WWTexture wWTexture : list) {
                arrayList2.add(wWTexture.getImageSource());
            }
        }
        return arrayList;
    }

    public boolean hasSideTextures() {
        if (this.sideTextures == null) {
            return false;
        }
        for (List<WWTexture> list : this.sideTextures) {
            if (list == null || list.size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean mustApplyTexture(DrawContext drawContext) {
        if (this.getCapTexture() != null && this.capTextureCoords != null) {
            return true;
        }
        return this.mustApplySideTextures();
    }

    @Override
    protected boolean isTerrainDependent() {
        return true;
    }

    protected boolean mustApplySideTextures() {
        return this.hasSideTextures();
    }

    @Override
    protected boolean mustDrawInterior() {
        return super.mustDrawInterior() || this.getActiveSideAttributes().isDrawInterior();
    }

    @Override
    protected boolean mustDrawOutline() {
        return super.mustDrawOutline() || this.getActiveSideAttributes().isDrawOutline();
    }

    @Override
    protected boolean mustRegenerateGeometry(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrent();
        if (shapeData.capVertexBuffer == null || shapeData.sideVertexBuffer == null) {
            return true;
        }
        if (drawContext.getVerticalExaggeration() != shapeData.getVerticalExaggeration()) {
            return true;
        }
        if (this.mustApplyLighting(drawContext, this.getActiveCapAttributes()) && shapeData.capNormalBuffer == null || this.mustApplyLighting(drawContext, this.getActiveSideAttributes()) && shapeData.sideNormalBuffer == null) {
            return true;
        }
        return super.mustRegenerateGeometry(drawContext);
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        Extent extent = super.getExtent(globe, d);
        if (extent != null) {
            return extent;
        }
        return super.computeExtentFromPositions(globe, d, this.getOuterBoundary());
    }

    protected Extent computeExtent(ExtrudedBoundaryInfo extrudedBoundaryInfo, Vec4 vec4) {
        if (extrudedBoundaryInfo == null || extrudedBoundaryInfo.capVertices == null || extrudedBoundaryInfo.baseVertices == null) {
            return null;
        }
        Vec4[] vec4Array = extrudedBoundaryInfo.capVertices;
        Vec4[] vec4Array2 = extrudedBoundaryInfo.baseVertices;
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>(2 * vec4Array.length);
        arrayList.addAll(Arrays.asList(vec4Array));
        arrayList.addAll(Arrays.asList(vec4Array2));
        Box box = Box.computeBoundingBox(arrayList);
        return box != null ? box.translate(vec4) : null;
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        if (this.isHighlighted()) {
            if (this.getSideHighlightAttributes() != null) {
                this.activeSideAttributes.copy(this.getSideHighlightAttributes());
            } else {
                if (this.getSideAttributes() != null) {
                    this.activeSideAttributes.copy(this.getSideAttributes());
                } else {
                    this.activeSideAttributes.copy(defaultSideAttributes);
                }
                this.activeSideAttributes.setOutlineMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
                this.activeSideAttributes.setInteriorMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
            }
        } else if (this.getSideAttributes() != null) {
            this.activeSideAttributes.copy(this.getSideAttributes());
        } else {
            this.activeSideAttributes.copy(defaultSideAttributes);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (!this.isOuterBoundaryValid()) {
            return;
        }
        super.render(drawContext);
    }

    @Override
    protected boolean isOrderedRenderableValid(DrawContext drawContext) {
        return this.getCurrent().capVertexBuffer != null || this.getCurrent().sideVertexBuffer != null;
    }

    @Override
    protected boolean doMakeOrderedRenderable(DrawContext drawContext) {
        if (drawContext.getSurfaceGeometry() == null || !this.isOuterBoundaryValid()) {
            return false;
        }
        this.createMinimalGeometry(drawContext, this.getCurrent());
        if (this.getExtent() == null || drawContext.isSmall(this.getExtent(), 1)) {
            return false;
        }
        if (!this.intersectsFrustum(drawContext)) {
            return false;
        }
        this.createFullGeometry(drawContext, drawContext.getTerrain(), this.getCurrent(), true);
        return true;
    }

    @Override
    protected OGLStackHandler beginDrawing(DrawContext drawContext, int n) {
        OGLStackHandler oGLStackHandler = super.beginDrawing(drawContext, n);
        if (!drawContext.isPickingMode()) {
            GL2 gL2 = drawContext.getGL().getGL2();
            oGLStackHandler.pushTextureIdentity(gL2);
        }
        return oGLStackHandler;
    }

    @Override
    public void drawOutline(DrawContext drawContext) {
        if (this.isEnableSides() && this.getActiveSideAttributes().isDrawOutline()) {
            this.drawSideOutline(drawContext, this.getCurrent());
        }
        if (this.isEnableCap() && this.getActiveCapAttributes().isDrawOutline()) {
            this.drawCapOutline(drawContext, this.getCurrent());
        }
    }

    @Override
    public void drawInterior(DrawContext drawContext) {
        if (this.isEnableSides() && this.getActiveSideAttributes().isDrawInterior()) {
            this.drawSideInteriors(drawContext, this.getCurrent());
        }
        if (this.isEnableCap() && this.getActiveCapAttributes().isDrawInterior()) {
            this.drawCapInterior(drawContext, this.getCurrent());
        }
    }

    @Override
    protected void doDrawOutline(DrawContext drawContext) {
    }

    public void drawCapOutline(DrawContext drawContext, ShapeData shapeData) {
        this.prepareToDrawOutline(drawContext, this.getActiveCapAttributes(), defaultAttributes);
        GL2 gL2 = drawContext.getGL().getGL2();
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, this.getActiveCapAttributes())) {
                gL2.glNormalPointer(5126, 0, extrudedBoundaryInfo.capNormalBuffer.rewind());
            }
            IntBuffer intBuffer = extrudedBoundaryInfo.capEdgeIndices;
            gL2.glVertexPointer(3, 5126, 0, extrudedBoundaryInfo.capVertexBuffer.rewind());
            gL2.glDrawElements(1, intBuffer.limit(), 5125, intBuffer.rewind());
        }
    }

    protected void drawSideOutline(DrawContext drawContext, ShapeData shapeData) {
        this.prepareToDrawOutline(drawContext, this.getActiveSideAttributes(), defaultSideAttributes);
        GL2 gL2 = drawContext.getGL().getGL2();
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, this.getActiveSideAttributes())) {
                gL2.glNormalPointer(5126, 0, extrudedBoundaryInfo.sideNormalBuffer.rewind());
            }
            IntBuffer intBuffer = extrudedBoundaryInfo.sideEdgeIndices;
            intBuffer.rewind();
            if (this.isEnableCap() && this.getActiveCapAttributes().isDrawOutline()) {
                intBuffer = intBuffer.slice();
                intBuffer.position(2 * extrudedBoundaryInfo.faceCount);
            }
            gL2.glVertexPointer(3, 5126, 0, extrudedBoundaryInfo.sideVertexBuffer.rewind());
            gL2.glDrawElements(1, intBuffer.remaining(), 5125, intBuffer);
        }
    }

    @Override
    protected void doDrawInterior(DrawContext drawContext) {
    }

    public void drawCapInterior(DrawContext drawContext, ShapeData shapeData) {
        super.prepareToDrawInterior(drawContext, this.getActiveCapAttributes(), defaultAttributes);
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, this.getActiveCapAttributes())) {
            gL2.glNormalPointer(5126, 0, shapeData.capNormalBuffer.rewind());
        }
        WWTexture wWTexture = this.getCapTexture();
        if (!drawContext.isPickingMode() && wWTexture != null && this.capTextureCoords != null) {
            wWTexture.bind(drawContext);
            wWTexture.applyInternalTransform(drawContext);
            gL2.glTexCoordPointer(2, 5126, 0, this.capTextureCoords.rewind());
            drawContext.getGL().glEnable(3553);
            gL2.glEnableClientState(32888);
        } else {
            drawContext.getGL().glDisable(3553);
            gL2.glDisableClientState(32888);
        }
        gL2.glVertexPointer(3, 5126, 0, shapeData.capVertexBuffer.rewind());
        for (int i = 0; i < shapeData.cb.getPrimTypes().size(); ++i) {
            IntBuffer intBuffer = shapeData.capFillIndexBuffers.get(i);
            gL2.glDrawElements((int)shapeData.cb.getPrimTypes().get(i), intBuffer.limit(), 5125, intBuffer.rewind());
        }
    }

    protected void drawSideInteriors(DrawContext drawContext, ShapeData shapeData) {
        super.prepareToDrawInterior(drawContext, this.getActiveSideAttributes(), defaultSideAttributes);
        GL2 gL2 = drawContext.getGL().getGL2();
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, this.getActiveSideAttributes())) {
                gL2.glNormalPointer(5126, 0, extrudedBoundaryInfo.sideNormalBuffer.rewind());
            }
            if (!drawContext.isPickingMode() && extrudedBoundaryInfo.sideTextureCoords != null) {
                gL2.glEnable(3553);
                gL2.glEnableClientState(32888);
                gL2.glTexCoordPointer(2, 5126, 0, extrudedBoundaryInfo.sideTextureCoords.rewind());
            } else {
                gL2.glDisable(3553);
                gL2.glDisableClientState(32888);
            }
            gL2.glVertexPointer(3, 5126, 0, extrudedBoundaryInfo.sideVertexBuffer.rewind());
            extrudedBoundaryInfo.sideIndices.rewind();
            for (int i = 0; i < extrudedBoundaryInfo.faceCount; ++i) {
                if (!drawContext.isPickingMode() && extrudedBoundaryInfo.sideTextureCoords != null) {
                    if (!extrudedBoundaryInfo.sideTextures.get(i).bind(drawContext)) continue;
                    extrudedBoundaryInfo.sideTextures.get(i).applyInternalTransform(drawContext);
                }
                extrudedBoundaryInfo.sideIndices.position(4 * i);
                extrudedBoundaryInfo.sideIndices.limit(4 * (i + 1));
                gL2.glDrawElements(5, 4, 5125, extrudedBoundaryInfo.sideIndices);
            }
        }
    }

    protected void createMinimalGeometry(DrawContext drawContext, ShapeData shapeData) {
        this.computeReferencePoint(drawContext.getTerrain(), shapeData);
        if (shapeData.getReferencePoint() == null) {
            return;
        }
        this.computeBoundaryVertices(drawContext.getTerrain(), shapeData.getOuterBoundaryInfo(), shapeData.getReferencePoint());
        if (this.getExtent() == null || this.getAltitudeMode() != 0) {
            shapeData.setExtent(this.computeExtent(shapeData.getOuterBoundaryInfo(), shapeData.getReferencePoint()));
        }
        shapeData.setEyeDistance(this.computeEyeDistance(drawContext, shapeData));
        shapeData.setGlobeStateKey(drawContext.getGlobe().getGlobeStateKey(drawContext));
        shapeData.setVerticalExaggeration(drawContext.getVerticalExaggeration());
    }

    protected double computeEyeDistance(DrawContext drawContext, ShapeData shapeData) {
        double d = Double.MAX_VALUE;
        Vec4 vec4 = drawContext.getView().getEyePoint();
        for (Vec4 vec42 : shapeData.getOuterBoundaryInfo().capVertices) {
            double d2 = vec42.add3(shapeData.getReferencePoint()).distanceTo3(vec4);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    protected void computeReferencePoint(Terrain terrain, ShapeData shapeData) {
        Position position = this.getReferencePosition();
        if (position == null) {
            return;
        }
        shapeData.setReferencePoint(terrain.getSurfacePoint(position.getLatitude(), position.getLongitude(), 0.0));
    }

    protected void createFullGeometry(DrawContext drawContext, Terrain terrain, ShapeData shapeData, boolean bl) {
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            extrudedBoundaryInfo.capEdgeIndices = this.getCapEdgeIndices(extrudedBoundaryInfo.locations.size());
            extrudedBoundaryInfo.sideIndices = this.getSideIndices(extrudedBoundaryInfo.locations.size());
            extrudedBoundaryInfo.sideEdgeIndices = this.getSideEdgeIndices(extrudedBoundaryInfo.locations.size());
        }
        if (this.isEnableSides() || this.isEnableCap()) {
            this.createVertices(terrain, shapeData, bl);
        }
        if (this.isEnableSides()) {
            this.createSideGeometry(shapeData);
            if (this.mustApplyLighting(drawContext, this.getActiveSideAttributes())) {
                this.createSideNormals(shapeData);
            }
            if (!drawContext.isPickingMode() && this.mustApplySideTextures()) {
                this.createSideTextureCoords(shapeData);
            }
        }
        if (this.isEnableCap()) {
            this.createCapGeometry(drawContext, shapeData);
            if (this.mustApplyLighting(drawContext, this.getActiveCapAttributes())) {
                this.createCapNormals(shapeData);
            }
        }
    }

    protected void createVertices(Terrain terrain, ShapeData shapeData, boolean bl) {
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            if (extrudedBoundaryInfo == shapeData.getOuterBoundaryInfo() && bl) continue;
            this.computeBoundaryVertices(terrain, extrudedBoundaryInfo, shapeData.getReferencePoint());
        }
    }

    protected void computeBoundaryVertices(Terrain terrain, ExtrudedBoundaryInfo extrudedBoundaryInfo, Vec4 vec4) {
        Vec4[] vec4Array;
        Vec4[] vec4Array2 = extrudedBoundaryInfo.capVertices;
        if (vec4Array2 == null || vec4Array2.length < extrudedBoundaryInfo.locations.size()) {
            vec4Array2 = new Vec4[extrudedBoundaryInfo.locations.size()];
        }
        if ((vec4Array = extrudedBoundaryInfo.baseVertices) == null || vec4Array.length < extrudedBoundaryInfo.locations.size()) {
            vec4Array = new Vec4[extrudedBoundaryInfo.locations.size()];
        }
        Vec4 vec42 = null;
        Vec4 vec43 = null;
        double d = 0.0;
        double d2 = 0.0;
        extrudedBoundaryInfo.faceCount = extrudedBoundaryInfo.locations.size() - 1;
        for (int i = 0; i < extrudedBoundaryInfo.faceCount; ++i) {
            double d3;
            LatLon latLon = extrudedBoundaryInfo.locations.get(i);
            Vec4 vec44 = terrain.getSurfacePoint(latLon.getLatitude(), latLon.getLongitude(), 0.0);
            if (this.getBaseDepth() == 0.0) {
                vec4Array[i] = vec44.subtract3(vec4);
            } else {
                d3 = vec44.getLength3();
                vec4Array[i] = vec44.multiply3((d3 - this.getBaseDepth()) / d3).subtract3(vec4);
            }
            if (this.getAltitudeMode() == 3 || !(latLon instanceof Position)) {
                if (vec43 == null) {
                    Position position = this.getReferencePosition();
                    vec42 = terrain.getGlobe().computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude());
                    vec43 = vec42.multiply3(this.getHeight());
                    d = vec43.getLength3();
                    d2 = vec4.dot3(vec42);
                }
                d3 = vec44.dot3(vec42) - d2;
                vec44 = vec44.add3(vec43.multiply3(1.0 - d3 / d));
            } else {
                vec44 = this.getAltitudeMode() == 2 ? terrain.getSurfacePoint(latLon.getLatitude(), latLon.getLongitude(), ((Position)latLon).getAltitude()) : terrain.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), ((Position)latLon).getAltitude() * terrain.getVerticalExaggeration());
            }
            vec4Array2[i] = vec44.subtract3(vec4);
        }
        vec4Array2[extrudedBoundaryInfo.locations.size() - 1] = vec4Array2[0];
        vec4Array[extrudedBoundaryInfo.locations.size() - 1] = vec4Array[0];
        extrudedBoundaryInfo.capVertices = vec4Array2;
        extrudedBoundaryInfo.baseVertices = vec4Array;
    }

    protected void createSideGeometry(ShapeData shapeData) {
        int n = this.totalFaceCount * 4 * 3;
        if (shapeData.sideVertexBuffer != null && shapeData.sideVertexBuffer.capacity() >= n) {
            shapeData.sideVertexBuffer.clear();
        } else {
            shapeData.sideVertexBuffer = Buffers.newDirectFloatBuffer(n);
        }
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            extrudedBoundaryInfo.sideVertexBuffer = this.fillSideVertexBuffer(extrudedBoundaryInfo.capVertices, extrudedBoundaryInfo.baseVertices, shapeData.sideVertexBuffer.slice());
            shapeData.sideVertexBuffer.position(shapeData.sideVertexBuffer.position() + extrudedBoundaryInfo.sideVertexBuffer.limit());
        }
    }

    protected void createSideNormals(ShapeData shapeData) {
        int n = this.totalFaceCount * 4 * 3;
        if (shapeData.sideNormalBuffer != null && shapeData.sideNormalBuffer.capacity() >= n) {
            shapeData.sideNormalBuffer.clear();
        } else {
            shapeData.sideNormalBuffer = Buffers.newDirectFloatBuffer(n);
        }
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            extrudedBoundaryInfo.sideNormalBuffer = this.fillSideNormalBuffer(extrudedBoundaryInfo.capVertices, extrudedBoundaryInfo.baseVertices, shapeData.sideNormalBuffer.slice());
            shapeData.sideNormalBuffer.position(shapeData.sideNormalBuffer.position() + extrudedBoundaryInfo.sideNormalBuffer.limit());
        }
    }

    protected void createSideTextureCoords(ShapeData shapeData) {
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            boolean bl = this.hasSideTextures() && extrudedBoundaryInfo.sideTextures != null && extrudedBoundaryInfo.sideTextures.size() == extrudedBoundaryInfo.faceCount;
            if (!bl) continue;
            int n = extrudedBoundaryInfo.faceCount * 4 * 2;
            if (extrudedBoundaryInfo.sideTextureCoords != null && extrudedBoundaryInfo.sideTextureCoords.capacity() >= n) {
                extrudedBoundaryInfo.sideTextureCoords.clear();
            } else {
                extrudedBoundaryInfo.sideTextureCoords = Buffers.newDirectFloatBuffer(n);
            }
            this.fillSideTexCoordBuffer(extrudedBoundaryInfo.capVertices, extrudedBoundaryInfo.baseVertices, extrudedBoundaryInfo.sideTextureCoords);
        }
    }

    protected void createCapGeometry(DrawContext drawContext, ShapeData shapeData) {
        if (shapeData.capVertexBuffer != null && shapeData.capVertexBuffer.capacity() >= this.totalNumLocations * 3) {
            shapeData.capVertexBuffer.clear();
        } else {
            shapeData.capVertexBuffer = Buffers.newDirectFloatBuffer(this.totalNumLocations * 3);
        }
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            extrudedBoundaryInfo.capVertexBuffer = WWBufferUtil.copyArrayToBuffer(extrudedBoundaryInfo.capVertices, shapeData.capVertexBuffer.slice());
            shapeData.capVertexBuffer.position(shapeData.capVertexBuffer.position() + extrudedBoundaryInfo.capVertexBuffer.limit());
        }
        if (shapeData.cb == null) {
            this.createTessllationGeometry(drawContext, shapeData);
        }
        this.generateCapInteriorIndices(shapeData);
    }

    protected void createCapNormals(ShapeData shapeData) {
        if (shapeData.capNormalBuffer != null && shapeData.capNormalBuffer.capacity() >= this.totalNumLocations * 3) {
            shapeData.capNormalBuffer.clear();
        } else {
            shapeData.capNormalBuffer = Buffers.newDirectFloatBuffer(shapeData.capVertexBuffer.capacity());
        }
        for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
            extrudedBoundaryInfo.capNormalBuffer = this.computeCapNormals(extrudedBoundaryInfo, shapeData.capNormalBuffer.slice());
            shapeData.capNormalBuffer.position(shapeData.capNormalBuffer.position() + extrudedBoundaryInfo.capNormalBuffer.limit());
        }
    }

    protected FloatBuffer computeCapNormals(ExtrudedBoundaryInfo extrudedBoundaryInfo, FloatBuffer floatBuffer) {
        int n = extrudedBoundaryInfo.locations.size();
        Vec4[] vec4Array = extrudedBoundaryInfo.capVertices;
        Vec4 vec4 = vec4Array[1].subtract3(vec4Array[0]);
        Vec4 vec42 = vec4Array[n - 2].subtract3(vec4Array[0]);
        double d = vec4.y * vec42.z - vec4.z * vec42.y;
        double d2 = vec4.z * vec42.x - vec4.x * vec42.z;
        double d3 = vec4.x * vec42.y - vec4.y * vec42.x;
        for (int i = 1; i < n - 1; ++i) {
            vec4 = vec4Array[i + 1].subtract3(vec4Array[i]);
            vec42 = vec4Array[i - 1].subtract3(vec4Array[i]);
            d += vec4.y * vec42.z - vec4.z * vec42.y;
            d2 += vec4.z * vec42.x - vec4.x * vec42.z;
            d3 += vec4.x * vec42.y - vec4.y * vec42.x;
        }
        double d4 = Math.sqrt((d /= (double)(n - 1)) * d + (d2 /= (double)(n - 1)) * d2 + (d3 /= (double)(n - 1)) * d3);
        for (int i = 0; i < n; ++i) {
            floatBuffer.put((float)(d / d4)).put((float)(d2 / d4)).put((float)(d3 / d4));
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    protected FloatBuffer fillSideVertexBuffer(Vec4[] vec4Array, Vec4[] vec4Array2, FloatBuffer floatBuffer) {
        int n = vec4Array.length - 1;
        int n2 = n * 4 * 3;
        floatBuffer.limit(n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3;
            floatBuffer.put((float)vec4Array2[n4].x).put((float)vec4Array2[n4].y).put((float)vec4Array2[n4].z);
            n4 = n3 + 1;
            floatBuffer.put((float)vec4Array2[n4].x).put((float)vec4Array2[n4].y).put((float)vec4Array2[n4].z);
            n4 = n3 + 1;
            floatBuffer.put((float)vec4Array[n4].x).put((float)vec4Array[n4].y).put((float)vec4Array[n4].z);
            n4 = n3++;
            floatBuffer.put((float)vec4Array[n4].x).put((float)vec4Array[n4].y).put((float)vec4Array[n4].z);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    protected FloatBuffer fillSideNormalBuffer(Vec4[] vec4Array, Vec4[] vec4Array2, FloatBuffer floatBuffer) {
        int n = vec4Array.length - 1;
        int n2 = n * 4 * 3;
        floatBuffer.limit(n2);
        for (int i = 0; i < n; ++i) {
            Vec4 vec4 = vec4Array[i + 1].subtract3(vec4Array2[i]);
            Vec4 vec42 = vec4Array[i].subtract3(vec4Array2[i + 1]);
            Vec4 vec43 = vec4.cross3(vec42).normalize3();
            floatBuffer.put((float)vec43.x).put((float)vec43.y).put((float)vec43.z);
            floatBuffer.put((float)vec43.x).put((float)vec43.y).put((float)vec43.z);
            floatBuffer.put((float)vec43.x).put((float)vec43.y).put((float)vec43.z);
            floatBuffer.put((float)vec43.x).put((float)vec43.y).put((float)vec43.z);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    protected void fillSideTexCoordBuffer(Vec4[] vec4Array, Vec4[] vec4Array2, FloatBuffer floatBuffer) {
        int n;
        int n2 = vec4Array.length - 1;
        double[] dArray = new double[n2 + 1];
        for (n = 0; n < n2; ++n) {
            dArray[n] = vec4Array2[n].distanceTo3(vec4Array[n]);
        }
        dArray[n2] = dArray[0];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            if (dArray[i] > dArray[i + 1]) {
                floatBuffer.put(n++, 0.0f).put(n++, 0.0f);
                floatBuffer.put(n++, 1.0f).put(n++, (float)(1.0 - dArray[i + 1] / dArray[i]));
            } else {
                floatBuffer.put(n++, 0.0f).put(n++, (float)(1.0 - dArray[i] / dArray[i + 1]));
                floatBuffer.put(n++, 1.0f).put(n++, 0.0f);
            }
            floatBuffer.put(n++, 1.0f).put(n++, 1.0f);
            floatBuffer.put(n++, 0.0f).put(n++, 1.0f);
        }
    }

    protected IntBuffer getCapEdgeIndices(int n) {
        IntBuffer intBuffer = capEdgeIndexBuffers.get(n);
        if (intBuffer != null) {
            return intBuffer;
        }
        intBuffer = Buffers.newDirectIntBuffer(2 * (n - 1) * 3);
        for (int i = 0; i < n - 1; ++i) {
            intBuffer.put(i).put(i + 1);
        }
        capEdgeIndexBuffers.put(n, intBuffer);
        return intBuffer;
    }

    protected IntBuffer getSideIndices(int n) {
        IntBuffer intBuffer = sideFillIndexBuffers.get(n);
        if (intBuffer != null) {
            return intBuffer;
        }
        intBuffer = Buffers.newDirectIntBuffer(n * 4);
        for (int i = 0; i < n; ++i) {
            intBuffer.put(4 * i + 3).put(4 * i).put(4 * i + 2).put(4 * i + 1);
        }
        sideFillIndexBuffers.put(n, intBuffer);
        return intBuffer;
    }

    protected IntBuffer getSideEdgeIndices(int n) {
        int n2;
        IntBuffer intBuffer = sideEdgeIndexBuffers.get(n);
        if (intBuffer != null) {
            return intBuffer;
        }
        int n3 = n - 1;
        intBuffer = Buffers.newDirectIntBuffer(2 * n3 * 3);
        for (n2 = 0; n2 < n3; ++n2) {
            intBuffer.put(4 * n2 + 2).put(4 * n2 + 3);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            intBuffer.put(4 * n2).put(4 * n2 + 1);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            intBuffer.put(4 * n2).put(4 * n2 + 3);
        }
        sideEdgeIndexBuffers.put(n, intBuffer);
        return intBuffer;
    }

    @Override
    protected void fillVBO(DrawContext drawContext) {
    }

    protected void createTessllationGeometry(DrawContext drawContext, ShapeData shapeData) {
        block3: {
            try {
                Vec4 vec4 = this.computePolygonNormal(shapeData);
                if (vec4 == null) {
                    String string = Logging.getMessage("Geom.ShapeNormalVectorNotComputable", this);
                    Logging.logger().log(Level.SEVERE, string);
                    shapeData.tessellationError = true;
                    return;
                }
                this.tessellatePolygon(shapeData, vec4.normalize3());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                String string = Logging.getMessage("generic.ExceptionWhileTessellating", this);
                Logging.logger().log(Level.SEVERE, string, outOfMemoryError);
                shapeData.tessellationError = true;
                if (drawContext == null) break block3;
                drawContext.addRenderingException(new WWRuntimeException(string, outOfMemoryError));
            }
        }
    }

    protected Vec4 computePolygonNormal(ShapeData shapeData) {
        Globe globe;
        Vec4 vec4 = WWMath.computeBufferNormal(shapeData.capVertexBuffer, 0);
        if (vec4 == null && (globe = shapeData.getGlobeStateKey().getGlobe()) != null) {
            vec4 = globe.computeSurfaceNormalAtLocation(this.getReferencePosition().getLatitude(), this.getReferencePosition().getLongitude());
        }
        return vec4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tessellatePolygon(ShapeData shapeData, Vec4 vec4) {
        GLUTessellatorSupport gLUTessellatorSupport = new GLUTessellatorSupport();
        shapeData.cb = new GLUTessellatorSupport.CollectIndexListsCallback();
        gLUTessellatorSupport.beginTessellation(shapeData.cb, vec4);
        try {
            double[] dArray = new double[3];
            GLU.gluTessBeginPolygon(gLUTessellatorSupport.getGLUtessellator(), null);
            int n = 0;
            for (ExtrudedBoundaryInfo extrudedBoundaryInfo : shapeData) {
                GLU.gluTessBeginContour(gLUTessellatorSupport.getGLUtessellator());
                FloatBuffer floatBuffer = extrudedBoundaryInfo.capVertexBuffer;
                for (int i = 0; i < extrudedBoundaryInfo.locations.size(); ++i) {
                    dArray[0] = floatBuffer.get(i * 3);
                    dArray[1] = floatBuffer.get(i * 3 + 1);
                    dArray[2] = floatBuffer.get(i * 3 + 2);
                    GLU.gluTessVertex(gLUTessellatorSupport.getGLUtessellator(), dArray, 0, n++);
                }
                GLU.gluTessEndContour(gLUTessellatorSupport.getGLUtessellator());
            }
            GLU.gluTessEndPolygon(gLUTessellatorSupport.getGLUtessellator());
        }
        finally {
            gLUTessellatorSupport.endTessellation();
        }
    }

    protected void generateCapInteriorIndices(ShapeData shapeData) {
        GLUTessellatorSupport.CollectIndexListsCallback collectIndexListsCallback = shapeData.cb;
        if (shapeData.capFillIndices == null || shapeData.capFillIndices.capacity() < collectIndexListsCallback.getNumIndices()) {
            shapeData.capFillIndices = Buffers.newDirectIntBuffer(collectIndexListsCallback.getNumIndices());
        } else {
            shapeData.capFillIndices.clear();
        }
        if (shapeData.capFillIndexBuffers == null || shapeData.capFillIndexBuffers.size() < collectIndexListsCallback.getPrimTypes().size()) {
            shapeData.capFillIndexBuffers = new ArrayList<IntBuffer>(collectIndexListsCallback.getPrimTypes().size());
        } else {
            shapeData.capFillIndexBuffers.clear();
        }
        for (List<Integer> list : collectIndexListsCallback.getPrims()) {
            IntBuffer intBuffer = shapeData.capFillIndices.slice();
            for (Integer n : list) {
                intBuffer.put(n);
            }
            intBuffer.flip();
            shapeData.capFillIndexBuffers.add(intBuffer);
            shapeData.capFillIndices.position(shapeData.capFillIndices.position() + intBuffer.limit());
        }
    }

    protected boolean isSameAsPreviousTerrain(Terrain terrain) {
        if (terrain == null || terrain != this.previousIntersectionTerrain) {
            return false;
        }
        if (terrain.getVerticalExaggeration() != this.previousIntersectionTerrain.getVerticalExaggeration()) {
            return false;
        }
        return this.previousIntersectionGlobeStateKey != null && terrain.getGlobe().getGlobeStateKey().equals(this.previousIntersectionGlobeStateKey);
    }

    @Override
    public List<Intersection> intersect(Line line, Terrain terrain) throws InterruptedException {
        List<Intersection> list;
        ShapeData shapeData;
        if (!this.isEnableSides() && !this.isEnableCap()) {
            return null;
        }
        Position position = this.getReferencePosition();
        if (position == null) {
            return null;
        }
        if (!this.isOuterBoundaryValid()) {
            return null;
        }
        ShapeData shapeData2 = shapeData = this.isSameAsPreviousTerrain(terrain) ? this.previousIntersectionShapeData : null;
        if (shapeData == null) {
            shapeData = this.createIntersectionGeometry(terrain);
            if (shapeData == null) {
                return null;
            }
            this.previousIntersectionShapeData = shapeData;
            this.previousIntersectionTerrain = terrain;
            this.previousIntersectionGlobeStateKey = terrain.getGlobe().getGlobeStateKey();
        }
        if (shapeData.getExtent() != null && shapeData.getExtent().intersect(line) == null) {
            return null;
        }
        Line line2 = new Line(line.getOrigin().subtract3(shapeData.getReferencePoint()), line.getDirection());
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (ExtrudedBoundaryInfo object : shapeData) {
            list = this.intersectBoundarySides(line2, object);
            if (list == null || list.size() <= 0) continue;
            arrayList.addAll(list);
        }
        if (this.isEnableCap()) {
            this.intersectCap(line2, shapeData, arrayList);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        for (Intersection intersection : arrayList) {
            list = intersection.getIntersectionPoint().add3(shapeData.getReferencePoint());
            intersection.setIntersectionPoint((Vec4)((Object)list));
            Position position2 = terrain.getGlobe().computePositionFromPoint((Vec4)((Object)list));
            Vec4 vec4 = terrain.getSurfacePoint(position2.getLatitude(), position2.getLongitude(), 0.0);
            double d = Math.sqrt(((Vec4)((Object)list)).dotSelf3()) - Math.sqrt(vec4.dotSelf3());
            intersection.setIntersectionPosition(new Position(position2, d));
            intersection.setObject(this);
        }
        return arrayList;
    }

    protected ShapeData createIntersectionGeometry(Terrain terrain) {
        ShapeData shapeData = new ShapeData(null, this);
        shapeData.setGlobeStateKey(terrain.getGlobe().getGlobeStateKey());
        this.computeReferencePoint(terrain, shapeData);
        if (shapeData.getReferencePoint() == null) {
            return null;
        }
        this.createVertices(terrain, shapeData, false);
        if (this.isEnableSides()) {
            this.createSideGeometry(shapeData);
        }
        if (this.isEnableCap()) {
            this.createCapGeometry(null, shapeData);
        }
        shapeData.setExtent(this.computeExtent(shapeData.getOuterBoundaryInfo(), shapeData.getReferencePoint()));
        return shapeData;
    }

    protected List<Intersection> intersectBoundarySides(Line line, ExtrudedBoundaryInfo extrudedBoundaryInfo) throws InterruptedException {
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        Vec4[] vec4Array = extrudedBoundaryInfo.capVertices;
        Vec4[] vec4Array2 = extrudedBoundaryInfo.baseVertices;
        for (int i = 0; i < extrudedBoundaryInfo.baseVertices.length - 1; ++i) {
            Vec4 vec4 = vec4Array2[i];
            Vec4 vec42 = vec4Array[i + 1];
            Vec4 vec43 = vec4Array[i];
            Intersection intersection = Triangle.intersect(line, vec4, vec42, vec43);
            if (intersection != null) {
                arrayList.add(intersection);
            }
            if ((intersection = Triangle.intersect(line, vec4, vec42, vec43 = vec4Array2[i + 1])) == null) continue;
            arrayList.add(intersection);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    protected void intersectCap(Line line, ShapeData shapeData, List<Intersection> list) throws InterruptedException {
        if (shapeData.cb.getPrimTypes() == null) {
            return;
        }
        for (int i = 0; i < shapeData.cb.getPrimTypes().size(); ++i) {
            IntBuffer intBuffer = shapeData.capFillIndexBuffers.get(i);
            intBuffer.rewind();
            List<Intersection> list2 = Triangle.intersectTriangleTypes(line, shapeData.capVertexBuffer, intBuffer, shapeData.cb.getPrimTypes().get(i));
            if (list2 == null || list2.size() <= 0) continue;
            list.addAll(list2);
        }
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isOuterBoundaryValid()) {
            return;
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        ArrayList<List<? extends LatLon>> arrayList = new ArrayList<List<? extends LatLon>>(this.boundaries.size());
        for (List<? extends LatLon> list : this.boundaries) {
            List<LatLon> list2;
            if (list == null || list.size() == 0 || (list2 = LatLon.computeShiftedLocations(position2, position, list)) == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof Position)) continue;
                list2.set(i, new Position(list2.get(i), ((Position)list.get(i)).getAltitude()));
            }
            arrayList.add(list2);
        }
        this.boundaries = arrayList;
        this.setReferencePosition(position);
        this.reset();
    }

    @Override
    protected void doExportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        xMLStreamWriter.writeStartElement("Polygon");
        xMLStreamWriter.writeStartElement("extrude");
        xMLStreamWriter.writeCharacters("1");
        xMLStreamWriter.writeEndElement();
        String string = KMLExportUtil.kmlAltitudeMode(this.getAltitudeMode());
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        this.writeKMLBoundaries(xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    protected void writeKMLBoundaries(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        Iterator<List<? extends LatLon>> iterator;
        Iterable<? extends LatLon> iterable = this.getOuterBoundary();
        if (iterable != null) {
            xMLStreamWriter.writeStartElement("outerBoundaryIs");
            if (iterable.iterator().hasNext() && iterable.iterator().next() instanceof Position) {
                this.exportBoundaryAsLinearRing(xMLStreamWriter, iterable);
            } else {
                KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, iterable, this.getHeight());
            }
            xMLStreamWriter.writeEndElement();
        }
        if ((iterator = this.boundaries.iterator()).hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            List<? extends LatLon> list = iterator.next();
            xMLStreamWriter.writeStartElement("innerBoundaryIs");
            if (list.iterator().hasNext() && list.iterator().next() instanceof Position) {
                this.exportBoundaryAsLinearRing(xMLStreamWriter, iterable);
            } else {
                KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, list, this.getHeight());
            }
            xMLStreamWriter.writeEndElement();
        }
    }

    protected void exportBoundaryAsLinearRing(XMLStreamWriter xMLStreamWriter, Iterable<? extends LatLon> iterable) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("LinearRing");
        xMLStreamWriter.writeStartElement("coordinates");
        for (LatLon latLon : iterable) {
            if (latLon instanceof Position) {
                xMLStreamWriter.writeCharacters(String.format(Locale.US, "%f,%f,%f ", latLon.getLongitude().getDegrees(), latLon.getLatitude().getDegrees(), ((Position)latLon).getAltitude()));
                continue;
            }
            xMLStreamWriter.writeCharacters(String.format(Locale.US, "%f,%f ", latLon.getLongitude().getDegrees(), latLon.getLatitude().getDegrees()));
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    static {
        defaultSideAttributes.setInteriorMaterial(DEFAULT_SIDES_INTERIOR_MATERIAL);
        capEdgeIndexBuffers = new HashMap();
        sideFillIndexBuffers = new HashMap();
        sideEdgeIndexBuffers = new HashMap();
        VBO_THRESHOLD = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.VBOThreshold", 30);
    }

    protected static class ExtrudedBoundaryInfo {
        protected List<? extends LatLon> locations;
        protected int faceCount;
        protected Vec4[] capVertices;
        protected Vec4[] baseVertices;
        protected IntBuffer capFillIndices;
        protected IntBuffer capEdgeIndices;
        protected FloatBuffer capVertexBuffer;
        protected FloatBuffer capNormalBuffer;
        protected IntBuffer sideIndices;
        protected IntBuffer sideEdgeIndices;
        protected FloatBuffer sideVertexBuffer;
        protected FloatBuffer sideNormalBuffer;
        protected List<WWTexture> sideTextures;
        protected FloatBuffer sideTextureCoords;

        public ExtrudedBoundaryInfo(List<? extends LatLon> list) {
            this.locations = list;
            this.faceCount = list.size() - 1;
        }
    }

    protected static class ShapeData
    extends AbstractShape.AbstractShapeData
    implements Iterable<ExtrudedBoundaryInfo> {
        protected List<ExtrudedBoundaryInfo> boundaries = new ArrayList<ExtrudedBoundaryInfo>();
        protected FloatBuffer capVertexBuffer;
        protected FloatBuffer capNormalBuffer;
        protected FloatBuffer sideVertexBuffer;
        protected FloatBuffer sideNormalBuffer;
        protected FloatBuffer sideTextureCoordsBuffer;
        protected GLUTessellatorSupport.CollectIndexListsCallback cb;
        protected IntBuffer capFillIndices;
        protected List<IntBuffer> capFillIndexBuffers;
        protected boolean tessellationError = false;

        public ShapeData(DrawContext drawContext, ExtrudedPolygon extrudedPolygon) {
            super(drawContext, extrudedPolygon.minExpiryTime, extrudedPolygon.maxExpiryTime);
            if (extrudedPolygon.boundaries.size() < 1) {
                this.boundaries.add(new ExtrudedBoundaryInfo(new ArrayList()));
                return;
            }
            for (List<? extends LatLon> list : extrudedPolygon.boundaries) {
                this.boundaries.add(new ExtrudedBoundaryInfo(list));
            }
            this.copySideTextureReferences(extrudedPolygon);
        }

        protected void copySideTextureReferences(ExtrudedPolygon extrudedPolygon) {
            if (extrudedPolygon.sideTextures != null) {
                for (int i = 0; i < this.boundaries.size() && i < extrudedPolygon.sideTextures.size(); ++i) {
                    ExtrudedBoundaryInfo extrudedBoundaryInfo = this.boundaries.get(i);
                    if (extrudedBoundaryInfo == null) continue;
                    this.boundaries.get((int)i).sideTextures = extrudedPolygon.sideTextures.get(i);
                }
            }
        }

        protected ExtrudedBoundaryInfo getOuterBoundaryInfo() {
            return this.boundaries.get(0);
        }

        @Override
        public Iterator<ExtrudedBoundaryInfo> iterator() {
            return this.boundaries.iterator();
        }
    }
}

