/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.render.Balloon;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.BasicBalloonAttributes;
import gov.nasa.worldwind.util.BasicTextDecoder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.TextDecoder;

public abstract class AbstractBalloon
extends WWObjectImpl
implements Balloon {
    protected boolean alwaysOnTop = false;
    protected boolean pickEnabled = true;
    protected Object delegateOwner;
    protected BalloonAttributes attributes;
    protected BalloonAttributes highlightAttributes;
    protected BalloonAttributes activeAttributes = new BasicBalloonAttributes();
    protected String text;
    protected TextDecoder textDecoder = new BasicTextDecoder();
    protected boolean visible = true;
    protected boolean highlighted;
    protected double minActiveAltitude = -1.7976931348623157E308;
    protected double maxActiveAltitude = Double.MAX_VALUE;
    protected static final BalloonAttributes defaultAttributes = new BasicBalloonAttributes();

    protected AbstractBalloon() {
    }

    protected AbstractBalloon(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.setText(string);
    }

    @Override
    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
    }

    @Override
    public boolean isPickEnabled() {
        return this.pickEnabled;
    }

    @Override
    public void setPickEnabled(boolean bl) {
        this.pickEnabled = bl;
    }

    @Override
    public String getText() {
        return this.text;
    }

    protected String getDecodedText() {
        return this.getTextDecoder().getDecodedText();
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.text = string;
        this.getTextDecoder().setText(string);
    }

    @Override
    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    @Override
    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    @Override
    public BalloonAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(BalloonAttributes balloonAttributes) {
        if (balloonAttributes == null) {
            String string = Logging.getMessage("nullValue.BalloonAttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = balloonAttributes;
    }

    @Override
    public BalloonAttributes getHighlightAttributes() {
        return this.highlightAttributes;
    }

    @Override
    public void setHighlightAttributes(BalloonAttributes balloonAttributes) {
        if (balloonAttributes == null) {
            String string = Logging.getMessage("nullValue.BalloonAttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.highlightAttributes = balloonAttributes;
    }

    protected void determineActiveAttributes() {
        if (this.isHighlighted()) {
            if (this.getHighlightAttributes() != null) {
                this.activeAttributes.copy(this.getHighlightAttributes());
            } else if (this.getAttributes() != null) {
                this.activeAttributes.copy(this.getAttributes());
            } else {
                this.activeAttributes.copy(defaultAttributes);
            }
        } else if (this.getAttributes() != null) {
            this.activeAttributes.copy(this.getAttributes());
        } else {
            this.activeAttributes.copy(defaultAttributes);
        }
    }

    protected BalloonAttributes getActiveAttributes() {
        return this.activeAttributes;
    }

    @Override
    public TextDecoder getTextDecoder() {
        return this.textDecoder;
    }

    @Override
    public void setTextDecoder(TextDecoder textDecoder) {
        if (textDecoder == null) {
            String string = Logging.getMessage("nullValue.TextDecoderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textDecoder = textDecoder;
        this.textDecoder.setText(this.getText());
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public double getMinActiveAltitude() {
        return this.minActiveAltitude;
    }

    @Override
    public void setMinActiveAltitude(double d) {
        this.minActiveAltitude = d;
    }

    @Override
    public double getMaxActiveAltitude() {
        return this.maxActiveAltitude;
    }

    @Override
    public void setMaxActiveAltitude(double d) {
        this.maxActiveAltitude = d;
    }
}

