/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wms;

import gov.nasa.worldwind.ogc.wms.WMSLayerInfoURL;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class WMSLogoURL
extends WMSLayerInfoURL {
    protected Integer width;
    protected Integer height;

    public WMSLogoURL(String string) {
        super(string);
    }

    @Override
    protected void doParseEventAttributes(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) {
        super.doParseEventAttributes(xMLEventParserContext, xMLEvent, objectArray);
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Integer n;
            Attribute attribute = iterator.next();
            if (attribute.getName().getLocalPart().equals("width") && attribute.getValue() != null && (n = WWUtil.convertStringToInteger(attribute.getValue())) != null) {
                this.setWidth(n);
            }
            if (!attribute.getName().getLocalPart().equals("height") || attribute.getValue() == null || (n = WWUtil.convertStringToInteger(attribute.getValue())) == null) continue;
            this.setHeight(n);
        }
    }

    public Integer getWidth() {
        return this.width;
    }

    protected void setWidth(Integer n) {
        this.width = n;
    }

    public Integer getHeight() {
        return this.height;
    }

    protected void setHeight(Integer n) {
        this.height = n;
    }
}

