/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.io;

import gov.nasa.worldwind.ogc.kml.io.KMLDoc;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KMLFile
implements KMLDoc {
    protected File kmlFile;

    public KMLFile(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.kmlFile = file;
    }

    public File getZipFile() {
        return this.kmlFile;
    }

    @Override
    public InputStream getKMLStream() throws IOException {
        return new FileInputStream(this.kmlFile);
    }

    @Override
    public InputStream getSupportFileStream(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return null;
        }
        file = new File(this.kmlFile.getParentFile(), string);
        return file.exists() ? new FileInputStream(file) : null;
    }

    @Override
    public String getSupportFilePath(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return null;
        }
        file = new File(this.kmlFile.getParentFile(), string);
        return file.exists() ? file.getPath() : null;
    }
}

