/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.ogc.kml.KMLGroundOverlay;
import gov.nasa.worldwind.ogc.kml.KMLLatLonBox;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.io.IOException;

public class KMLGroundOverlayPolygonImpl
extends Polygon
implements KMLRenderable {
    protected final KMLGroundOverlay parent;
    protected boolean attributesResolved;

    public KMLGroundOverlayPolygonImpl(KMLTraversalContext kMLTraversalContext, KMLGroundOverlay kMLGroundOverlay) {
        String string;
        if (kMLTraversalContext == null) {
            String string2 = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (kMLGroundOverlay == null) {
            String string3 = Logging.getMessage("nullValue.ParentIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.parent = kMLGroundOverlay;
        String string4 = kMLGroundOverlay.getAltitudeMode();
        if (!WWUtil.isEmpty(string4)) {
            if ("relativeToGround".equals(string4)) {
                this.setAltitudeMode(2);
            } else if ("absolute".equals(string4)) {
                this.setAltitudeMode(0);
            }
        }
        Position.PositionList positionList = kMLGroundOverlay.getPositions();
        this.setOuterBoundary(positionList.list);
        KMLLatLonBox kMLLatLonBox = kMLGroundOverlay.getLatLonBox();
        if (kMLLatLonBox != null) {
            this.setRotation(kMLLatLonBox.getRotation());
        }
        if (kMLGroundOverlay.getName() != null) {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", kMLGroundOverlay.getName());
        }
        if (kMLGroundOverlay.getDescription() != null) {
            this.setValue("gov.nasa.worldwind.avkey.BalloonText", kMLGroundOverlay.getDescription());
        }
        if (kMLGroundOverlay.getSnippetText() != null) {
            this.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", kMLGroundOverlay.getSnippetText());
        }
        if (!(this.parent.getIcon() != null && this.parent.getIcon().getHref() != null || WWUtil.isEmpty(string = kMLGroundOverlay.getColor()))) {
            Color color = WWUtil.decodeColorABGR(string);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setInteriorMaterial(new Material(color));
            this.setAttributes(basicShapeAttributes);
        }
    }

    @Override
    public void preRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
    }

    protected boolean mustResolveHref() {
        return this.getTextureImageSource() == null && this.parent.getIcon() != null && this.parent.getIcon().getHref() != null;
    }

    @Override
    public void render(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (this.mustResolveHref()) {
            String string = this.parent.getIcon().getHref();
            String string2 = null;
            try {
                string2 = this.parent.getRoot().getSupportFilePath(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
            this.setTextureImageSource(string2 != null ? string2 : string, fArray, 4);
        }
        this.render(drawContext);
    }

    @Override
    public boolean isHighlighted() {
        return false;
    }
}

