/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLData;
import gov.nasa.worldwind.ogc.kml.KMLExtendedData;
import gov.nasa.worldwind.ogc.kml.KMLSchema;
import gov.nasa.worldwind.ogc.kml.KMLSchemaData;
import gov.nasa.worldwind.ogc.kml.KMLSimpleData;
import gov.nasa.worldwind.ogc.kml.KMLSimpleField;
import gov.nasa.worldwind.util.BasicTextDecoder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KMLBalloonTextDecoder
extends BasicTextDecoder {
    protected boolean isUnresolved;
    protected Map<String, String> entityCache = new HashMap<String, String>();
    protected KMLAbstractFeature feature;

    public KMLBalloonTextDecoder(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature == null) {
            String string = Logging.getMessage("nullValue.FeatureIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.feature = kMLAbstractFeature;
    }

    @Override
    public synchronized String getDecodedText() {
        if (this.decodedText == null) {
            this.lastUpdateTime = System.currentTimeMillis();
        }
        if (this.decodedText == null || this.isUnresolved) {
            this.decodedText = this.decode(this.text);
        }
        if (!this.isUnresolved) {
            this.text = null;
        }
        return this.decodedText;
    }

    @Override
    protected String decode(String string) {
        if (string == null) {
            return null;
        }
        this.isUnresolved = false;
        Pattern pattern = Pattern.compile("\\$\\[(.*?)\\]");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = this.entityCache.get(string2);
            if (string3 == null && (string3 = this.resolveEntityReference(string2)) != null) {
                this.entityCache.put(string2, string3);
                this.lastUpdateTime = System.currentTimeMillis();
            }
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3 != null ? string3 : ""));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public synchronized void setText(String string) {
        super.setText(string);
        this.entityCache.clear();
    }

    protected String resolveEntityReference(String string) {
        KMLExtendedData kMLExtendedData;
        KMLAbstractFeature kMLAbstractFeature = this.getFeature();
        if ("geDirections".equals(string)) {
            return this.getGeDirectionsText();
        }
        Object object = kMLAbstractFeature.getField(string);
        if (object instanceof KMLAbstractObject) {
            return ((KMLAbstractObject)object).getCharacters();
        }
        if (object != null) {
            return object.toString();
        }
        String string2 = "";
        boolean bl = string.endsWith("/displayName");
        String[] stringArray = string.split("/");
        String string3 = stringArray[0];
        if (stringArray.length == 2 && !bl || stringArray.length > 2) {
            string2 = stringArray[1];
        }
        if ((kMLExtendedData = kMLAbstractFeature.getExtendedData()) != null) {
            for (KMLData object22 : kMLExtendedData.getData()) {
                if (!string3.equals(object22.getName())) continue;
                if (bl) {
                    if (!WWUtil.isEmpty(object22.getDisplayName())) {
                        return object22.getDisplayName();
                    }
                    return object22.getName();
                }
                return object22.getValue();
            }
            boolean bl2 = false;
            List<KMLSchemaData> list = kMLExtendedData.getSchemaData();
            for (KMLSchemaData kMLSchemaData : list) {
                String string4 = kMLSchemaData.getSchemaUrl();
                KMLSchema kMLSchema = (KMLSchema)kMLAbstractFeature.getRoot().resolveReference(string4);
                if (kMLSchema != null && string3.equals(kMLSchema.getName())) {
                    if (bl) {
                        for (KMLSimpleField kMLSimpleField : kMLSchema.getSimpleFields()) {
                            if (!string2.equals(kMLSimpleField.getName())) continue;
                            return kMLSimpleField.getDisplayName();
                        }
                        continue;
                    }
                    for (KMLSimpleData kMLSimpleData : kMLSchemaData.getSimpleData()) {
                        if (!string2.equals(kMLSimpleData.getName())) continue;
                        return kMLSimpleData.getCharacters();
                    }
                    continue;
                }
                if (kMLSchema != null) continue;
                bl2 = true;
            }
            if (bl2 && !WWUtil.isEmpty(string3) && !WWUtil.isEmpty(string2)) {
                this.isUnresolved = true;
            }
        }
        return null;
    }

    public KMLAbstractFeature getFeature() {
        return this.feature;
    }

    protected String getGeDirectionsText() {
        return "";
    }
}

