/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLBoundary;
import gov.nasa.worldwind.ogc.kml.KMLLinearRing;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLPolygon
extends KMLAbstractGeometry {
    protected List<KMLLinearRing> innerBoundaries;

    public KMLPolygon(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof KMLBoundary && xMLEvent.asStartElement().getName().getLocalPart().equals("innerBoundaryIs")) {
            this.addInnerBoundary(((KMLBoundary)object).getLinearRing());
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addInnerBoundary(KMLLinearRing kMLLinearRing) {
        if (this.innerBoundaries == null) {
            this.innerBoundaries = new ArrayList<KMLLinearRing>();
        }
        this.innerBoundaries.add(kMLLinearRing);
    }

    public boolean isExtrude() {
        return this.getExtrude() == Boolean.TRUE;
    }

    public Boolean getExtrude() {
        return (Boolean)this.getField("extrude");
    }

    public Boolean getTessellate() {
        return (Boolean)this.getField("tessellate");
    }

    public String getAltitudeMode() {
        return (String)this.getField("altitudeMode");
    }

    public Iterable<? extends KMLLinearRing> getInnerBoundaries() {
        return this.innerBoundaries;
    }

    public KMLLinearRing getOuterBoundary() {
        Object object = this.getField("outerBoundaryIs");
        return object != null ? ((KMLBoundary)object).getLinearRing() : null;
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLPolygon)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        KMLPolygon kMLPolygon = (KMLPolygon)kMLAbstractObject;
        if (kMLPolygon.getInnerBoundaries() != null) {
            this.innerBoundaries = kMLPolygon.innerBoundaries;
        }
        super.applyChange(kMLAbstractObject);
    }
}

