/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLAbstractStyleSelector;
import gov.nasa.worldwind.ogc.kml.KMLAbstractSubStyle;
import gov.nasa.worldwind.ogc.kml.KMLAbstractTimePrimitive;
import gov.nasa.worldwind.ogc.kml.KMLAbstractView;
import gov.nasa.worldwind.ogc.kml.KMLExtendedData;
import gov.nasa.worldwind.ogc.kml.KMLRegion;
import gov.nasa.worldwind.ogc.kml.KMLSnippet;
import gov.nasa.worldwind.ogc.kml.KMLStyleUrl;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.render.Balloon;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import gov.nasa.worldwind.util.xml.atom.AtomLink;
import gov.nasa.worldwind.util.xml.atom.AtomPerson;
import gov.nasa.worldwind.util.xml.xal.XALAddressDetails;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public abstract class KMLAbstractFeature
extends KMLAbstractObject
implements KMLRenderable {
    protected List<KMLAbstractStyleSelector> styleSelectors = new ArrayList<KMLAbstractStyleSelector>();
    protected Boolean visibility;
    protected KMLRegion region;
    protected Balloon balloon;

    protected KMLAbstractFeature(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof KMLAbstractView) {
            this.setView((KMLAbstractView)object);
        } else if (object instanceof KMLAbstractTimePrimitive) {
            this.setTimePrimitive((KMLAbstractTimePrimitive)object);
        } else if (object instanceof KMLAbstractStyleSelector) {
            this.addStyleSelector((KMLAbstractStyleSelector)object);
        } else if (object instanceof KMLRegion) {
            this.setRegion((KMLRegion)object);
        } else if (object instanceof Boolean && xMLEvent.asStartElement().getName().getLocalPart().equalsIgnoreCase("visibility")) {
            this.setVisibility((Boolean)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public String getName() {
        return (String)this.getField("name");
    }

    public Boolean getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Boolean bl) {
        this.visibility = bl;
    }

    public Boolean getOpen() {
        return (Boolean)this.getField("open");
    }

    public AtomPerson getAuthor() {
        return (AtomPerson)this.getField("author");
    }

    public AtomLink getLink() {
        return (AtomLink)this.getField("link");
    }

    public String getAddress() {
        return (String)this.getField("address");
    }

    public XALAddressDetails getAddressDetails() {
        return (XALAddressDetails)this.getField("AddressDetails");
    }

    public String getPhoneNumber() {
        return (String)this.getField("phoneNumber");
    }

    public Object getSnippet() {
        Object object = this.getField("snippet");
        if (object != null) {
            return object;
        }
        return this.getField("Snippet");
    }

    public String getSnippetText() {
        Object object = this.getField("snippet");
        if (object != null) {
            return ((String)object).trim();
        }
        KMLSnippet kMLSnippet = (KMLSnippet)this.getSnippet();
        if (kMLSnippet != null && kMLSnippet.getCharacters() != null) {
            return kMLSnippet.getCharacters().trim();
        }
        return null;
    }

    public String getDescription() {
        return (String)this.getField("description");
    }

    protected void setView(KMLAbstractView kMLAbstractView) {
        this.setField("AbstractView", (Object)kMLAbstractView);
    }

    public KMLAbstractView getView() {
        return (KMLAbstractView)this.getField("AbstractView");
    }

    protected void setTimePrimitive(KMLAbstractTimePrimitive kMLAbstractTimePrimitive) {
        this.setField("AbstractTimePrimitive", (Object)kMLAbstractTimePrimitive);
    }

    public KMLAbstractTimePrimitive getTimePrimitive() {
        return (KMLAbstractTimePrimitive)this.getField("AbstractTimePrimitive");
    }

    public KMLStyleUrl getStyleUrl() {
        return (KMLStyleUrl)this.getField("styleUrl");
    }

    protected void addStyleSelector(KMLAbstractStyleSelector kMLAbstractStyleSelector) {
        this.styleSelectors.add(kMLAbstractStyleSelector);
    }

    public List<KMLAbstractStyleSelector> getStyleSelectors() {
        return this.styleSelectors;
    }

    public boolean hasStyleSelectors() {
        return this.getStyleSelectors() != null && this.getStyleSelectors().size() > 0;
    }

    public boolean hasStyle() {
        return this.hasStyleSelectors() || this.getStyleUrl() != null;
    }

    public KMLRegion getRegion() {
        return this.region;
    }

    protected void setRegion(KMLRegion kMLRegion) {
        this.region = kMLRegion;
    }

    public KMLExtendedData getExtendedData() {
        return (KMLExtendedData)this.getField("ExtendedData");
    }

    public void setBalloon(Balloon balloon) {
        this.balloon = balloon;
    }

    public Balloon getBalloon() {
        return this.balloon;
    }

    @Override
    public void preRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (kMLTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isFeatureActive(kMLTraversalContext, drawContext)) {
            return;
        }
        this.doPreRender(kMLTraversalContext, drawContext);
    }

    @Override
    public void render(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (kMLTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isFeatureActive(kMLTraversalContext, drawContext)) {
            return;
        }
        this.doRender(kMLTraversalContext, drawContext);
    }

    protected boolean isFeatureActive(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (this.getVisibility() != null && !this.getVisibility().booleanValue()) {
            return false;
        }
        KMLRegion kMLRegion = this.getRegion();
        if (kMLRegion == null) {
            kMLRegion = kMLTraversalContext.peekRegion();
        }
        return kMLRegion == null || kMLRegion.isActive(kMLTraversalContext, drawContext);
    }

    protected void doPreRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
    }

    protected void doRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
    }

    protected void renderBalloon(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (this.getBalloon() != null) {
            this.getBalloon().render(drawContext);
        }
    }

    public KMLAbstractSubStyle getSubStyle(KMLAbstractSubStyle kMLAbstractSubStyle, String string) {
        return KMLAbstractStyleSelector.mergeSubStyles(this.getStyleUrl(), this.getStyleSelectors(), string, kMLAbstractSubStyle);
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLAbstractFeature)) {
            String string = Logging.getMessage("KML.InvalidElementType", kMLAbstractObject.getClass().getName());
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        super.applyChange(kMLAbstractObject);
        KMLAbstractFeature kMLAbstractFeature = (KMLAbstractFeature)kMLAbstractObject;
        if (kMLAbstractObject.hasField("visibility")) {
            this.setVisibility((Boolean)kMLAbstractFeature.getField("visibility"));
        }
        if (kMLAbstractFeature.getRegion() != null) {
            this.setRegion(kMLAbstractFeature.getRegion());
        }
        if (kMLAbstractFeature.getStyleSelectors() != null && kMLAbstractFeature.getStyleSelectors().size() > 0) {
            this.mergeStyleSelectors(kMLAbstractFeature);
            this.onChange(new Message("KMLAbstractObject.StyleChanged", this));
        }
    }

    protected void mergeStyleSelectors(KMLAbstractFeature kMLAbstractFeature) {
        ArrayList<KMLAbstractStyleSelector> arrayList = new ArrayList<KMLAbstractStyleSelector>(this.getStyleSelectors().size());
        arrayList.addAll(this.getStyleSelectors());
        for (KMLAbstractStyleSelector kMLAbstractStyleSelector : kMLAbstractFeature.getStyleSelectors()) {
            String string = kMLAbstractStyleSelector.getId();
            if (!WWUtil.isEmpty(string)) {
                for (KMLAbstractStyleSelector kMLAbstractStyleSelector2 : arrayList) {
                    String string2 = kMLAbstractStyleSelector2.getId();
                    if (WWUtil.isEmpty(string2) || !string2.equals(string)) continue;
                    this.getStyleSelectors().remove(kMLAbstractStyleSelector2);
                }
            }
            this.getStyleSelectors().add(kMLAbstractStyleSelector);
        }
    }
}

