/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada.impl;

import gov.nasa.worldwind.ogc.collada.ColladaRoot;
import gov.nasa.worldwind.ogc.collada.impl.ColladaTraversalContext;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;

public class ColladaController
implements Renderable,
PreRenderable {
    protected ColladaRoot colladaRoot;
    protected ColladaTraversalContext tc;

    public ColladaController(ColladaRoot colladaRoot) {
        this.setColladaRoot(colladaRoot);
        this.setTraversalContext(new ColladaTraversalContext());
    }

    public ColladaRoot getColladaRoot() {
        return this.colladaRoot;
    }

    public void setColladaRoot(ColladaRoot colladaRoot) {
        if (colladaRoot == null) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.colladaRoot = colladaRoot;
    }

    public ColladaTraversalContext getTraversalContext() {
        return this.tc;
    }

    public void setTraversalContext(ColladaTraversalContext colladaTraversalContext) {
        if (colladaTraversalContext == null) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tc = colladaTraversalContext;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        this.initializeTraversalContext(this.getTraversalContext());
        this.colladaRoot.preRender(this.getTraversalContext(), drawContext);
    }

    @Override
    public void render(DrawContext drawContext) {
        this.initializeTraversalContext(this.getTraversalContext());
        this.colladaRoot.render(this.getTraversalContext(), drawContext);
    }

    protected void initializeTraversalContext(ColladaTraversalContext colladaTraversalContext) {
        colladaTraversalContext.initialize();
    }
}

