/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.ogc.collada.ColladaAccessor;
import gov.nasa.worldwind.ogc.collada.ColladaInput;
import gov.nasa.worldwind.ogc.collada.ColladaP;
import gov.nasa.worldwind.ogc.collada.ColladaSource;
import gov.nasa.worldwind.ogc.collada.ColladaVertices;
import gov.nasa.worldwind.util.Logging;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class ColladaAbstractGeometry
extends ColladaAbstractObject {
    public static final String DEFAULT_TEX_COORD_SEMANTIC = "TEXCOORD";
    public static final int COORDS_PER_VERTEX = 3;
    public static final int TEX_COORDS_PER_VERTEX = 2;
    protected List<ColladaInput> inputs = new ArrayList<ColladaInput>();

    protected abstract int getVerticesPerShape();

    public ColladaAbstractGeometry(String string) {
        super(string);
    }

    public List<ColladaInput> getInputs() {
        return this.inputs;
    }

    public int getCount() {
        return Integer.parseInt((String)this.getField("count"));
    }

    public String getMaterial() {
        return (String)this.getField("material");
    }

    public void getVertices(FloatBuffer floatBuffer) {
        this.getFloatFromAccessor(floatBuffer, this.getVertexAccessor(), "VERTEX", 3);
    }

    public void getNormals(FloatBuffer floatBuffer) {
        this.getFloatFromAccessor(floatBuffer, this.getNormalAccessor(), "NORMAL", 3);
    }

    public void getTextureCoordinates(FloatBuffer floatBuffer, String string) {
        if (string == null) {
            string = DEFAULT_TEX_COORD_SEMANTIC;
        }
        this.getFloatFromAccessor(floatBuffer, this.getTexCoordAccessor(string), string, 2);
    }

    protected void getFloatFromAccessor(FloatBuffer floatBuffer, ColladaAccessor colladaAccessor, String string, int n) {
        if (floatBuffer == null) {
            String string2 = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        int n2 = this.getVerticesPerShape();
        int n3 = this.getCount() * n2;
        if (floatBuffer.remaining() < n3 * n) {
            String string3 = Logging.getMessage("generic.BufferSize");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        int[] nArray = this.getIndices(string);
        float[] fArray = colladaAccessor.getFloats();
        for (int n4 : nArray) {
            floatBuffer.put(fArray, n4 * n, n);
        }
    }

    protected int[] getIndices(String string) {
        ColladaInput colladaInput = null;
        for (ColladaInput colladaInput2 : this.getInputs()) {
            if (!string.equals(colladaInput2.getSemantic())) continue;
            colladaInput = colladaInput2;
            break;
        }
        if (colladaInput == null) {
            return null;
        }
        ColladaP colladaP = (ColladaP)this.getField("p");
        int n = this.getVerticesPerShape();
        int n2 = colladaInput.getOffset();
        int[] nArray = colladaP.getIndices();
        int[] nArray2 = new int[this.getCount() * n];
        int n3 = 0;
        int n4 = this.getInputs().size();
        for (int i = 0; i < this.getCount(); ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = i * (n * n4) + j * n4;
                nArray2[n3++] = nArray[n5 + n2];
            }
        }
        return nArray2;
    }

    public ColladaAccessor getVertexAccessor() {
        String string = null;
        for (ColladaInput colladaAbstractObject2 : this.getInputs()) {
            if (!"VERTEX".equals(colladaAbstractObject2.getSemantic())) continue;
            string = colladaAbstractObject2.getSource();
            break;
        }
        if (string == null) {
            return null;
        }
        Object object = null;
        ColladaVertices colladaVertices = (ColladaVertices)this.getRoot().resolveReference(string);
        for (ColladaInput colladaInput : colladaVertices.getInputs()) {
            if (!"POSITION".equals(colladaInput.getSemantic())) continue;
            object = colladaInput.getSource();
            break;
        }
        if (object == null) {
            return null;
        }
        ColladaSource colladaSource = (ColladaSource)this.getRoot().resolveReference((String)object);
        return colladaSource != null ? colladaSource.getAccessor() : null;
    }

    public ColladaAccessor getNormalAccessor() {
        String string = null;
        for (ColladaInput colladaInput : this.getInputs()) {
            if (!"NORMAL".equals(colladaInput.getSemantic())) continue;
            string = colladaInput.getSource();
            break;
        }
        if (string == null) {
            return null;
        }
        ColladaSource colladaSource = (ColladaSource)this.getRoot().resolveReference(string);
        return colladaSource != null ? colladaSource.getAccessor() : null;
    }

    public ColladaAccessor getTexCoordAccessor(String string) {
        if (string == null) {
            string = DEFAULT_TEX_COORD_SEMANTIC;
        }
        String string2 = null;
        for (ColladaInput colladaInput : this.getInputs()) {
            if (!string.equals(colladaInput.getSemantic())) continue;
            string2 = colladaInput.getSource();
            break;
        }
        if (string2 == null) {
            return null;
        }
        ColladaSource colladaSource = (ColladaSource)this.getRoot().resolveReference(string2);
        return colladaSource != null ? colladaSource.getAccessor() : null;
    }

    @Override
    public void setField(String string, Object object) {
        if (string.equals("input")) {
            this.inputs.add((ColladaInput)object);
        } else {
            super.setField(string, object);
        }
    }
}

