/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc;

import gov.nasa.worldwind.ogc.OGCContactInformation;
import gov.nasa.worldwind.ogc.OGCOnlineResource;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.StringSetXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OGCServiceInformation
extends AbstractXMLEventParser {
    protected QName NAME;
    protected QName TITLE;
    protected QName ABSTRACT;
    protected QName FEES;
    protected QName ACCESS_CONSTRAINTS;
    protected QName KEYWORD_LIST;
    protected QName KEYWORD;
    protected QName ONLINE_RESOURCE;
    protected QName CONTACT_INFORMATION;
    protected String serviceName;
    protected String serviceTitle;
    protected String serviceAbstract;
    protected String fees;
    protected String accessConstraints;
    protected Set<String> keywords;
    protected OGCOnlineResource onlineResource;
    protected OGCContactInformation contactInformation;

    public OGCServiceInformation(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.NAME = new QName(this.getNamespaceURI(), "Name");
        this.TITLE = new QName(this.getNamespaceURI(), "Title");
        this.ABSTRACT = new QName(this.getNamespaceURI(), "Abstract");
        this.FEES = new QName(this.getNamespaceURI(), "Fees");
        this.ACCESS_CONSTRAINTS = new QName(this.getNamespaceURI(), "AccessConstraints");
        this.KEYWORD_LIST = new QName(this.getNamespaceURI(), "KeywordList");
        this.KEYWORD = new QName(this.getNamespaceURI(), "Keyword");
        this.ONLINE_RESOURCE = new QName(this.getNamespaceURI(), "OnlineResource");
        this.CONTACT_INFORMATION = new QName(this.getNamespaceURI(), "ContactInformation");
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        AbstractXMLEventParser abstractXMLEventParser = null;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.ONLINE_RESOURCE)) {
            abstractXMLEventParser = new OGCOnlineResource(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CONTACT_INFORMATION)) {
            abstractXMLEventParser = new OGCContactInformation(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.KEYWORD_LIST)) {
            abstractXMLEventParser = new StringSetXMLEventParser(this.getNamespaceURI(), this.KEYWORD);
        }
        return xMLEventParserContext.allocate(xMLEvent, abstractXMLEventParser);
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object;
        XMLEventParser xMLEventParser;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.NAME)) {
            this.setServiceName(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.TITLE)) {
            this.setServiceTitle(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ABSTRACT)) {
            this.setServiceAbstract(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.FEES)) {
            this.setFees(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ACCESS_CONSTRAINTS)) {
            this.setAccessConstraints(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.KEYWORD_LIST)) {
            Object object2;
            XMLEventParser xMLEventParser2 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser2 != null && (object2 = xMLEventParser2.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object2 instanceof StringSetXMLEventParser) {
                this.setKeywords(((StringSetXMLEventParser)object2).getStrings());
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ONLINE_RESOURCE)) {
            Object object3;
            XMLEventParser xMLEventParser3 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser3 != null && (object3 = xMLEventParser3.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object3 instanceof OGCOnlineResource) {
                this.setOnlineResource((OGCOnlineResource)object3);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CONTACT_INFORMATION) && (xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent)) != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof OGCContactInformation) {
            this.setContactInformation((OGCContactInformation)object);
        }
    }

    public OGCContactInformation getContactInformation() {
        return this.contactInformation;
    }

    protected void setContactInformation(OGCContactInformation oGCContactInformation) {
        this.contactInformation = oGCContactInformation;
    }

    public OGCOnlineResource getOnlineResource() {
        return this.onlineResource;
    }

    protected void setOnlineResource(OGCOnlineResource oGCOnlineResource) {
        this.onlineResource = oGCOnlineResource;
    }

    public Set<String> getKeywords() {
        if (this.keywords != null) {
            return this.keywords;
        }
        return Collections.emptySet();
    }

    protected void setKeywords(Set<String> set) {
        this.keywords = set;
    }

    public String getAccessConstraints() {
        return this.accessConstraints;
    }

    protected void setAccessConstraints(String string) {
        this.accessConstraints = string;
    }

    public String getFees() {
        return this.fees;
    }

    protected void setFees(String string) {
        this.fees = string;
    }

    public String getServiceAbstract() {
        return this.serviceAbstract;
    }

    protected void setServiceAbstract(String string) {
        this.serviceAbstract = string;
    }

    public String getServiceTitle() {
        return this.serviceTitle;
    }

    protected void setServiceTitle(String string) {
        this.serviceTitle = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    protected void setServiceName(String string) {
        this.serviceName = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ServiceName: ").append(this.serviceName != null ? this.serviceName : "none").append("\n");
        stringBuilder.append("ServiceTitle: ").append(this.serviceTitle != null ? this.serviceTitle : "none").append("\n");
        stringBuilder.append("ServiceAbstract: ").append(this.serviceAbstract != null ? this.serviceAbstract : "none").append("\n");
        stringBuilder.append("Fees: ").append(this.fees != null ? this.fees : "none").append("\n");
        stringBuilder.append("AccessConstraints: ").append(this.accessConstraints != null ? this.accessConstraints : "none").append("\n");
        this.keywordsToString(stringBuilder);
        stringBuilder.append("OnlineResource: ").append(this.onlineResource != null ? this.onlineResource : "none").append("\n");
        stringBuilder.append(this.contactInformation != null ? this.contactInformation : "none").append("\n");
        return stringBuilder.toString();
    }

    protected void keywordsToString(StringBuilder stringBuilder) {
        stringBuilder.append("Keywords: ");
        if (this.getKeywords().size() == 0) {
            stringBuilder.append(" none");
        } else {
            for (String string : this.getKeywords()) {
                stringBuilder.append(string != null ? string : "null").append(", ");
            }
        }
        stringBuilder.append("\n");
    }
}

