/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc;

import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OGCAddress
extends AbstractXMLEventParser {
    protected QName ADDRESS_TYPE;
    protected QName ADDRESS;
    protected QName CITY;
    protected QName STATE_OR_PROVINCE;
    protected QName POST_CODE;
    protected QName COUNTRY;
    protected String addressType;
    protected String address;
    protected String city;
    protected String stateOrProvince;
    protected String postCode;
    protected String country;

    public OGCAddress(String string) {
        super(string);
        this.initialize();
    }

    protected void initialize() {
        this.ADDRESS_TYPE = new QName(this.getNamespaceURI(), "AddressType");
        this.ADDRESS = new QName(this.getNamespaceURI(), "Address");
        this.CITY = new QName(this.getNamespaceURI(), "City");
        this.STATE_OR_PROVINCE = new QName(this.getNamespaceURI(), "StateOrProvince");
        this.POST_CODE = new QName(this.getNamespaceURI(), "PostCode");
        this.COUNTRY = new QName(this.getNamespaceURI(), "Country");
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.ADDRESS_TYPE)) {
            this.setAddressType(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ADDRESS)) {
            this.setAddress(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CITY)) {
            this.setCity(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.STATE_OR_PROVINCE)) {
            this.setStateOrProvince(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.POST_CODE)) {
            this.setPostCode(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.COUNTRY)) {
            this.setCountry(xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]));
        }
    }

    public String getAddressType() {
        return this.addressType;
    }

    protected void setAddressType(String string) {
        this.addressType = string;
    }

    public String getAddress() {
        return this.address;
    }

    protected void setAddress(String string) {
        this.address = string;
    }

    public String getCity() {
        return this.city;
    }

    protected void setCity(String string) {
        this.city = string;
    }

    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    protected void setStateOrProvince(String string) {
        this.stateOrProvince = string;
    }

    public String getPostCode() {
        return this.postCode;
    }

    protected void setPostCode(String string) {
        this.postCode = string;
    }

    public String getCountry() {
        return this.country;
    }

    protected void setCountry(String string) {
        this.country = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AddressType: ").append(this.addressType != null ? this.addressType : "none").append(" ");
        stringBuilder.append("Address: ").append(this.address != null ? this.address : "none").append(" ");
        stringBuilder.append("City: ").append(this.city != null ? this.city : "none").append(" ");
        stringBuilder.append("StateOrProvince: ").append(this.stateOrProvince != null ? this.stateOrProvince : "none").append(" ");
        stringBuilder.append("PostCode: ").append(this.postCode != null ? this.postCode : "none").append(" ");
        stringBuilder.append("Country: ").append(this.country != null ? this.country : "none");
        return stringBuilder.toString();
    }
}

