/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.mercator;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.layers.mercator.MercatorSector;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.TileKey;

public class MercatorTextureTile
extends TextureTile {
    private MercatorSector mercatorSector;

    public MercatorTextureTile(MercatorSector mercatorSector, Level level, int n, int n2) {
        super(mercatorSector, level, n, n2);
        this.mercatorSector = mercatorSector;
    }

    public MercatorTextureTile[] createSubTiles(Level level) {
        if (level == null) {
            String string = Logging.getMessage("nullValue.LevelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getMercatorSector().getMinLatPercent();
        double d2 = this.getMercatorSector().getMaxLatPercent();
        double d3 = d + (d2 - d) / 2.0;
        Angle angle = this.getSector().getMinLongitude();
        Angle angle2 = this.getSector().getMaxLongitude();
        Angle angle3 = Angle.midAngle(angle, angle2);
        String string = level.getCacheName();
        int n = level.getLevelNumber();
        int n2 = this.getRow();
        int n3 = this.getColumn();
        MercatorTextureTile[] mercatorTextureTileArray = new MercatorTextureTile[4];
        TileKey tileKey = new TileKey(n, 2 * n2, 2 * n3, string);
        MercatorTextureTile mercatorTextureTile = this.getTileFromMemoryCache(tileKey);
        mercatorTextureTileArray[0] = mercatorTextureTile != null ? mercatorTextureTile : new MercatorTextureTile(new MercatorSector(d, d3, angle, angle3), level, 2 * n2, 2 * n3);
        tileKey = new TileKey(n, 2 * n2, 2 * n3 + 1, string);
        mercatorTextureTile = this.getTileFromMemoryCache(tileKey);
        mercatorTextureTileArray[1] = mercatorTextureTile != null ? mercatorTextureTile : new MercatorTextureTile(new MercatorSector(d, d3, angle3, angle2), level, 2 * n2, 2 * n3 + 1);
        tileKey = new TileKey(n, 2 * n2 + 1, 2 * n3, string);
        mercatorTextureTile = this.getTileFromMemoryCache(tileKey);
        mercatorTextureTileArray[2] = mercatorTextureTile != null ? mercatorTextureTile : new MercatorTextureTile(new MercatorSector(d3, d2, angle, angle3), level, 2 * n2 + 1, 2 * n3);
        tileKey = new TileKey(n, 2 * n2 + 1, 2 * n3 + 1, string);
        mercatorTextureTile = this.getTileFromMemoryCache(tileKey);
        mercatorTextureTileArray[3] = mercatorTextureTile != null ? mercatorTextureTile : new MercatorTextureTile(new MercatorSector(d3, d2, angle3, angle2), level, 2 * n2 + 1, 2 * n3 + 1);
        return mercatorTextureTileArray;
    }

    @Override
    protected MercatorTextureTile getTileFromMemoryCache(TileKey tileKey) {
        return (MercatorTextureTile)WorldWind.getMemoryCache(MercatorTextureTile.class.getName()).getObject(tileKey);
    }

    public MercatorSector getMercatorSector() {
        return this.mercatorSector;
    }
}

