/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AbstractGraticuleLayer;
import gov.nasa.worldwind.layers.Earth.UTMBaseGraticuleLayer;
import gov.nasa.worldwind.layers.GraticuleRenderingParams;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class UTMGraticuleLayer
extends UTMBaseGraticuleLayer {
    public static final String GRATICULE_UTM_GRID = "Graticule.UTM.Grid";
    public static final String GRATICULE_100000M = "Graticule.100000m";
    public static final String GRATICULE_10000M = "Graticule.10000m";
    public static final String GRATICULE_1000M = "Graticule.1000m";
    public static final String GRATICULE_100M = "Graticule.100m";
    public static final String GRATICULE_10M = "Graticule.10m";
    public static final String GRATICULE_1M = "Graticule.1m";
    protected static final int MIN_CELL_SIZE_PIXELS = 40;
    protected static final int GRID_ROWS = 8;
    protected static final int GRID_COLS = 60;
    protected GraticuleTile[][] gridTiles = new GraticuleTile[8][60];

    public UTMGraticuleLayer() {
        this.initRenderingParams();
        this.setPickEnabled(false);
        this.setName(Logging.getMessage("layers.Earth.UTMGraticule.Name"));
        this.metricScaleSupport.setMaxResolution(1000000.0);
    }

    @Override
    protected void initRenderingParams() {
        GraticuleRenderingParams graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.WHITE);
        graticuleRenderingParams.setValue("LabelColor", Color.WHITE);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-16"));
        this.setRenderingParams(GRATICULE_UTM_GRID, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.GREEN);
        graticuleRenderingParams.setValue("LabelColor", Color.GREEN);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-14"));
        this.setRenderingParams(GRATICULE_100000M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0, 102, 255));
        graticuleRenderingParams.setValue("LabelColor", new Color(0, 102, 255));
        this.setRenderingParams(GRATICULE_10000M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.CYAN);
        graticuleRenderingParams.setValue("LabelColor", Color.CYAN);
        this.setRenderingParams(GRATICULE_1000M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0, 153, 153));
        graticuleRenderingParams.setValue("LabelColor", new Color(0, 153, 153));
        this.setRenderingParams(GRATICULE_100M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(102, 255, 204));
        graticuleRenderingParams.setValue("LabelColor", new Color(102, 255, 204));
        this.setRenderingParams(GRATICULE_10M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(153, 153, 255));
        graticuleRenderingParams.setValue("LabelColor", new Color(153, 153, 255));
        this.setRenderingParams(GRATICULE_1M, graticuleRenderingParams);
    }

    protected String[] getOrderedTypes() {
        return new String[]{GRATICULE_UTM_GRID, GRATICULE_100000M, GRATICULE_10000M, GRATICULE_1000M, GRATICULE_100M, GRATICULE_10M, GRATICULE_1M};
    }

    @Override
    protected String getTypeFor(int n) {
        if (n >= 500000) {
            return GRATICULE_UTM_GRID;
        }
        if (n >= 100000) {
            return GRATICULE_100000M;
        }
        if (n >= 10000) {
            return GRATICULE_10000M;
        }
        if (n >= 1000) {
            return GRATICULE_1000M;
        }
        if (n >= 100) {
            return GRATICULE_100M;
        }
        if (n >= 10) {
            return GRATICULE_10M;
        }
        if (n >= 1) {
            return GRATICULE_1M;
        }
        return null;
    }

    @Override
    protected void clear(DrawContext drawContext) {
        super.clear(drawContext);
        this.applyTerrainConformance();
        this.metricScaleSupport.clear();
        this.metricScaleSupport.computeZone(drawContext);
    }

    private void applyTerrainConformance() {
        String[] stringArray;
        for (String string : stringArray = this.getOrderedTypes()) {
            double d = string.equals(GRATICULE_UTM_GRID) ? 20.0 : this.polylineTerrainConformance;
            this.getRenderingParams(string).setValue("GraticuleLineConformance", d);
        }
    }

    @Override
    protected void selectRenderables(DrawContext drawContext) {
        this.selectUTMRenderables(drawContext);
        this.metricScaleSupport.selectRenderables(drawContext);
    }

    protected void selectUTMRenderables(DrawContext drawContext) {
        ArrayList<GraticuleTile> arrayList = this.getVisibleTiles(drawContext);
        if (arrayList.size() > 0) {
            for (GraticuleTile graticuleTile : arrayList) {
                graticuleTile.selectRenderables(drawContext);
            }
        }
    }

    protected ArrayList<GraticuleTile> getVisibleTiles(DrawContext drawContext) {
        Rectangle2D rectangle2D;
        ArrayList<GraticuleTile> arrayList = new ArrayList<GraticuleTile>();
        Sector sector = drawContext.getVisibleSector();
        if (sector != null && (rectangle2D = this.getGridRectangleForSector(sector)) != null) {
            int n = (int)rectangle2D.getY();
            while ((double)n <= rectangle2D.getY() + rectangle2D.getHeight()) {
                int n2 = (int)rectangle2D.getX();
                while ((double)n2 <= rectangle2D.getX() + rectangle2D.getWidth()) {
                    if (this.gridTiles[n][n2] == null) {
                        this.gridTiles[n][n2] = new GraticuleTile(this.getGridSector(n, n2));
                    }
                    if (this.gridTiles[n][n2].isInView(drawContext)) {
                        arrayList.add(this.gridTiles[n][n2]);
                    } else {
                        this.gridTiles[n][n2].clearRenderables();
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return arrayList;
    }

    private Rectangle2D getGridRectangleForSector(Sector sector) {
        int n = this.getGridColumn(sector.getMinLongitude().degrees);
        int n2 = this.getGridColumn(sector.getMaxLongitude().degrees);
        int n3 = this.getGridRow(sector.getMinLatitude().degrees);
        int n4 = this.getGridRow(sector.getMaxLatitude().degrees);
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    private Sector getGridSector(int n, int n2) {
        double d = 21.0;
        double d2 = 6.0;
        double d3 = n == 0 ? -80.0 : -84.0 + d * (double)n;
        double d4 = -84.0 + d * (double)(n + 1);
        double d5 = -180.0 + d2 * (double)n2;
        double d6 = d5 + d2;
        return Sector.fromDegrees(d3, d4, d5, d6);
    }

    private int getGridColumn(double d) {
        double d2 = 6.0;
        int n = (int)Math.floor((d + 180.0) / d2);
        return Math.min(n, 59);
    }

    private int getGridRow(double d) {
        double d2 = 21.0;
        int n = (int)Math.floor((d + 84.0) / d2);
        return Math.max(0, Math.min(n, 7));
    }

    protected void clearTiles() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 60; ++j) {
                if (this.gridTiles[i][j] == null) continue;
                this.gridTiles[i][j].clearRenderables();
                this.gridTiles[i][j] = null;
            }
        }
    }

    protected class GraticuleTile {
        private Sector sector;
        private int zone;
        private String hemisphere;
        private ArrayList<AbstractGraticuleLayer.GridElement> gridElements;
        private ArrayList<UTMBaseGraticuleLayer.SquareZone> squares;

        public GraticuleTile(Sector sector) {
            this.sector = sector;
            this.zone = UTMGraticuleLayer.this.getGridColumn(this.sector.getCentroid().getLongitude().degrees) + 1;
            this.hemisphere = this.sector.getCentroid().latitude.degrees > 0.0 ? "gov.nasa.worldwind.avkey.North" : "gov.nasa.worldwdind.avkey.South";
        }

        public Extent getExtent(Globe globe, double d) {
            return Sector.computeBoundingCylinder(globe, d, this.sector);
        }

        public boolean isInView(DrawContext drawContext) {
            return UTMGraticuleLayer.this.viewFrustum.intersects(this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration()));
        }

        public double getSizeInPixels(DrawContext drawContext) {
            View view = drawContext.getView();
            Vec4 vec4 = UTMGraticuleLayer.this.getSurfacePoint(drawContext, this.sector.getCentroid().getLatitude(), this.sector.getCentroid().getLongitude());
            double d = view.getEyePoint().distanceTo3(vec4);
            double d2 = this.sector.getDeltaLatRadians() * drawContext.getGlobe().getRadius();
            return d2 / view.computePixelSizeAtDistance(d);
        }

        public void selectRenderables(DrawContext drawContext) {
            if (this.gridElements == null) {
                this.createRenderables();
            }
            int n = 500000;
            String string = UTMGraticuleLayer.this.getTypeFor(n);
            for (AbstractGraticuleLayer.GridElement object : this.gridElements) {
                if (!object.isInView(drawContext)) continue;
                UTMGraticuleLayer.this.addRenderable(object.renderable, string);
            }
            if (this.getSizeInPixels(drawContext) / 10.0 < 80.0) {
                return;
            }
            if (this.squares == null) {
                this.createSquares();
            }
            for (UTMBaseGraticuleLayer.SquareZone squareZone : this.squares) {
                if (squareZone.isInView(drawContext)) {
                    squareZone.selectRenderables(drawContext, drawContext.getVisibleSector());
                    continue;
                }
                squareZone.clearRenderables();
            }
        }

        public void clearRenderables() {
            if (this.gridElements != null) {
                this.gridElements.clear();
                this.gridElements = null;
            }
            if (this.squares != null) {
                for (UTMBaseGraticuleLayer.SquareZone squareZone : this.squares) {
                    squareZone.clearRenderables();
                }
                this.squares.clear();
                this.squares = null;
            }
        }

        private void createSquares() {
            try {
                UTMCoord uTMCoord = UTMCoord.fromLatLon(this.sector.getMinLatitude(), this.sector.getCentroid().getLongitude(), UTMGraticuleLayer.this.globe);
                double d = uTMCoord.getNorthing();
                uTMCoord = UTMCoord.fromLatLon(this.sector.getMaxLatitude(), this.sector.getCentroid().getLongitude(), UTMGraticuleLayer.this.globe);
                double d2 = uTMCoord.getNorthing();
                d2 = d2 == 0.0 ? 1.0E7 : d2;
                uTMCoord = UTMCoord.fromLatLon(this.sector.getMinLatitude(), this.sector.getMinLongitude(), UTMGraticuleLayer.this.globe);
                double d3 = uTMCoord.getEasting();
                uTMCoord = UTMCoord.fromLatLon(this.sector.getMaxLatitude(), this.sector.getMinLongitude(), UTMGraticuleLayer.this.globe);
                d3 = uTMCoord.getEasting() < d3 ? uTMCoord.getEasting() : d3;
                double d4 = 1000000.0 - d3;
                this.squares = UTMGraticuleLayer.this.createSquaresGrid(this.zone, this.hemisphere, this.sector, d3, d4, d, d2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void createRenderables() {
            this.gridElements = new ArrayList();
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.clear();
            arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMinLongitude(), 0.0));
            arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMinLongitude(), 0.0));
            Object object = UTMGraticuleLayer.this.createLineRenderable(arrayList, 1);
            Sector sector = new Sector(this.sector.getMinLatitude(), this.sector.getMaxLatitude(), this.sector.getMinLongitude(), this.sector.getMinLongitude());
            AbstractGraticuleLayer.GridElement gridElement = new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_Line");
            gridElement.value = this.sector.getMinLongitude().degrees;
            this.gridElements.add(gridElement);
            if (this.sector.getMinLatitude().degrees == -80.0 || this.sector.getMinLatitude().degrees == 0.0) {
                arrayList.clear();
                arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMinLongitude(), 0.0));
                arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMaxLongitude(), 0.0));
                object = UTMGraticuleLayer.this.createLineRenderable(arrayList, 1);
                sector = new Sector(this.sector.getMinLatitude(), this.sector.getMinLatitude(), this.sector.getMinLongitude(), this.sector.getMaxLongitude());
                gridElement = new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_Line");
                gridElement.value = this.sector.getMinLatitude().degrees;
                this.gridElements.add(gridElement);
            }
            if (this.sector.getMaxLatitude().degrees == 84.0) {
                arrayList.clear();
                arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMinLongitude(), 0.0));
                arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMaxLongitude(), 0.0));
                object = UTMGraticuleLayer.this.createLineRenderable(arrayList, 1);
                sector = new Sector(this.sector.getMaxLatitude(), this.sector.getMaxLatitude(), this.sector.getMinLongitude(), this.sector.getMaxLongitude());
                gridElement = new AbstractGraticuleLayer.GridElement(sector, object, "GridElement_Line");
                gridElement.value = this.sector.getMaxLatitude().degrees;
                this.gridElements.add(gridElement);
            }
            if (this.hasLabel()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.zone).append("gov.nasa.worldwind.avkey.North".equals(this.hemisphere) ? "N" : "S");
                UserFacingText userFacingText = new UserFacingText(stringBuilder.toString(), new Position(this.sector.getCentroid(), 0.0));
                this.gridElements.add(new AbstractGraticuleLayer.GridElement(this.sector, userFacingText, "GridElement_GridZoneLabel"));
            }
        }

        private boolean hasLabel() {
            double d = -40.0;
            boolean bl = this.sector.getMinLatitude().degrees < d && d <= this.sector.getMaxLatitude().degrees;
            double d2 = 42.0;
            boolean bl2 = this.sector.getMinLatitude().degrees < d2 && d2 <= this.sector.getMaxLatitude().degrees;
            return bl || bl2;
        }
    }
}

