/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.event.BulkRetrievalEvent;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.RetrievalService;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class BasicTiledImageLayerBulkDownloader
extends BulkRetrievalThread {
    protected static final int MAX_TILE_COUNT_PER_REGION = 200;
    protected static final long DEFAULT_AVERAGE_FILE_SIZE = 350000L;
    protected final BasicTiledImageLayer layer;
    protected final int level;
    protected ArrayList<TextureTile> missingTiles;

    public BasicTiledImageLayerBulkDownloader(BasicTiledImageLayer basicTiledImageLayer, Sector sector, double d, BulkRetrievalListener bulkRetrievalListener) {
        super(basicTiledImageLayer, sector, d, basicTiledImageLayer.getDataFileStore(), bulkRetrievalListener);
        this.layer = basicTiledImageLayer;
        this.level = this.layer.computeLevelForResolution(sector, d);
    }

    public BasicTiledImageLayerBulkDownloader(BasicTiledImageLayer basicTiledImageLayer, Sector sector, double d, FileStore fileStore, BulkRetrievalListener bulkRetrievalListener) {
        super(basicTiledImageLayer, sector, d, fileStore, bulkRetrievalListener);
        this.layer = basicTiledImageLayer;
        this.level = this.layer.computeLevelForResolution(sector, d);
    }

    @Override
    public void run() {
        try {
            this.progress.setTotalCount(this.estimateMissingTilesCount(20));
            this.progress.setTotalSize(this.progress.getTotalCount() * this.estimateAverageTileSize());
            for (int i = 0; i <= this.level; ++i) {
                if (this.layer.getLevels().isLevelEmpty(i)) continue;
                int n = this.computeRegionDivisions(this.sector, i, 200);
                Iterator<Sector> iterator = this.getRegionIterator(this.sector, n);
                while (iterator.hasNext()) {
                    Sector sector = iterator.next();
                    this.missingTiles = this.getMissingTilesInSector(sector, i);
                    while (this.missingTiles.size() > 0) {
                        this.submitMissingTilesRequests();
                        if (this.missingTiles.size() <= 0) continue;
                        Thread.sleep(this.RETRIEVAL_SERVICE_POLL_DELAY);
                    }
                }
            }
            this.progress.setTotalCount(this.progress.getCurrentCount());
            this.progress.setTotalSize(this.progress.getCurrentSize());
        }
        catch (InterruptedException interruptedException) {
            String string = Logging.getMessage("generic.BulkRetrievalInterrupted", this.layer.getName());
            Logging.logger().log(java.util.logging.Level.WARNING, string, interruptedException);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionDuringBulkRetrieval", this.layer.getName());
            Logging.logger().severe(string);
            throw new RuntimeException(string);
        }
    }

    protected synchronized void submitMissingTilesRequests() throws InterruptedException {
        RetrievalService retrievalService = WorldWind.getRetrievalService();
        int n = 0;
        while (this.missingTiles.size() > n && retrievalService.isAvailable()) {
            Thread.sleep(1L);
            TextureTile textureTile = this.missingTiles.get(n);
            if (this.layer.getLevels().isResourceAbsent(textureTile)) {
                this.removeAbsentTile(textureTile);
                continue;
            }
            URL uRL = this.fileStore.findFile(textureTile.getPath(), false);
            if (uRL != null) {
                this.removeRetrievedTile(textureTile);
                continue;
            }
            this.layer.retrieveRemoteTexture(textureTile, this.createBulkDownloadPostProcessor(textureTile));
            ++n;
        }
    }

    protected BasicTiledImageLayer.DownloadPostProcessor createBulkDownloadPostProcessor(TextureTile textureTile) {
        return new BulkDownloadPostProcessor(textureTile, this.layer, this.fileStore);
    }

    protected void callRetrievalListeners(Retriever retriever, TextureTile textureTile) {
        String string = retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful") ? BulkRetrievalEvent.RETRIEVAL_SUCCEEDED : BulkRetrievalEvent.RETRIEVAL_FAILED;
        super.callRetrievalListeners(new BulkRetrievalEvent(this.layer, string, textureTile.getPath()));
    }

    protected synchronized void removeRetrievedTile(TextureTile textureTile) {
        this.missingTiles.remove(textureTile);
        this.progress.setCurrentCount(this.progress.getCurrentCount() + 1L);
        this.progress.setCurrentSize(this.progress.getCurrentSize() + this.estimateAverageTileSize());
        this.progress.setLastUpdateTime(System.currentTimeMillis());
        this.normalizeProgress();
    }

    protected synchronized void removeAbsentTile(TextureTile textureTile) {
        this.missingTiles.remove(textureTile);
        this.progress.setTotalCount(this.progress.getTotalCount() - 1L);
        this.progress.setTotalSize(this.progress.getTotalSize() - this.estimateAverageTileSize());
        this.progress.setLastUpdateTime(System.currentTimeMillis());
        this.normalizeProgress();
    }

    protected void normalizeProgress() {
        if (this.progress.getTotalCount() < this.progress.getCurrentCount()) {
            this.progress.setTotalCount(this.progress.getCurrentCount());
            this.progress.setTotalSize(this.progress.getCurrentSize());
        }
    }

    protected long getEstimatedMissingDataSize() {
        long l = this.estimateMissingTilesCount(6);
        long l2 = this.estimateAverageTileSize();
        return l * l2;
    }

    protected long estimateMissingTilesCount(int n) {
        int n2;
        int n3 = this.layer.computeLevelForResolution(this.sector, this.resolution);
        long l = 0L;
        for (n2 = 0; n2 <= n3; ++n2) {
            if (this.layer.getLevels().isLevelEmpty(n2)) continue;
            l += this.layer.countImagesInSector(this.sector, n2);
        }
        n2 = this.computeRegionDivisions(this.sector, n3, 36);
        Sector[] sectorArray = this.computeRandomRegions(this.sector, n2, n);
        long l2 = 0L;
        long l3 = 0L;
        try {
            if (sectorArray.length < n) {
                l3 = this.layer.countImagesInSector(this.sector, n3);
                l2 = this.getMissingTilesInSector(this.sector, n3).size();
            } else {
                for (Sector sector : sectorArray) {
                    l3 += this.layer.countImagesInSector(sector, n3);
                    l2 += (long)this.getMissingTilesInSector(sector, n3).size();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return 0L;
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionDuringDataSizeEstimate", this.layer.getName());
            Logging.logger().severe(string);
            throw new RuntimeException(string);
        }
        return (long)((double)l * ((double)l2 / (double)l3));
    }

    protected int computeRegionDivisions(Sector sector, int n, int n2) {
        long l = this.layer.countImagesInSector(sector, n);
        if (l <= (long)n2) {
            return 1;
        }
        return (int)Math.ceil(Math.sqrt((double)l / (double)n2));
    }

    protected Sector[] computeRandomRegions(Sector sector, int n, int n2) {
        if (n2 > n * n) {
            return sector.subdivide(n);
        }
        double d = sector.getDeltaLat().degrees / (double)n;
        double d2 = sector.getDeltaLon().degrees / (double)n;
        ArrayList<Sector> arrayList = new ArrayList<Sector>(n2);
        Random random = new Random();
        while (arrayList.size() < n2) {
            int n3;
            int n4 = random.nextInt(n);
            Sector sector2 = Sector.fromDegrees(sector.getMinLatitude().degrees + d * (double)n4, sector.getMinLatitude().degrees + d * (double)n4 + d, sector.getMinLongitude().degrees + d2 * (double)(n3 = random.nextInt(n)), sector.getMinLongitude().degrees + d2 * (double)n3 + d2);
            if (arrayList.contains(sector2)) continue;
            arrayList.add(sector2);
        }
        return arrayList.toArray(new Sector[n2]);
    }

    protected Iterator<Sector> getRegionIterator(final Sector sector, final int n) {
        final double d = sector.getDeltaLat().degrees / (double)n;
        final double d2 = sector.getDeltaLon().degrees / (double)n;
        return new Iterator<Sector>(){
            int row = 0;
            int col = 0;

            @Override
            public boolean hasNext() {
                return this.row < n;
            }

            @Override
            public Sector next() {
                Sector sector2 = Sector.fromDegrees(sector.getMinLatitude().degrees + d * (double)this.row, sector.getMinLatitude().degrees + d * (double)this.row + d, sector.getMinLongitude().degrees + d2 * (double)this.col, sector.getMinLongitude().degrees + d2 * (double)this.col + d2);
                ++this.col;
                if (this.col >= n) {
                    this.col = 0;
                    ++this.row;
                }
                return sector2;
            }

            @Override
            public void remove() {
            }
        };
    }

    protected ArrayList<TextureTile> getMissingTilesInSector(Sector sector, int n) throws InterruptedException {
        TextureTile[][] textureTileArray;
        ArrayList<TextureTile> arrayList = new ArrayList<TextureTile>();
        TextureTile[][] textureTileArray2 = textureTileArray = this.layer.getTilesInSector(sector, n);
        int n2 = textureTileArray2.length;
        for (int i = 0; i < n2; ++i) {
            TextureTile[] textureTileArray3;
            for (TextureTile textureTile : textureTileArray3 = textureTileArray2[i]) {
                Thread.sleep(1L);
                if (textureTile == null || this.isTileLocalOrAbsent(textureTile)) continue;
                arrayList.add(textureTile);
            }
        }
        return arrayList;
    }

    protected boolean isTileLocalOrAbsent(TextureTile textureTile) {
        if (this.layer.getLevels().isResourceAbsent(textureTile)) {
            return true;
        }
        URL uRL = this.fileStore.findFile(textureTile.getPath(), false);
        return uRL != null && !this.layer.isTextureFileExpired(textureTile, uRL, this.fileStore);
    }

    protected long estimateAverageTileSize() {
        Object object;
        Long l = (Long)this.layer.getValue("gov.nasa.worldwind.avkey.AverageTileSize");
        if (l != null) {
            return l;
        }
        long l2 = 0L;
        long l3 = 0L;
        Level level = this.layer.getLevels().getFirstLevel();
        while (level.isEmpty() && !level.equals(this.layer.getLevels().getLastLevel())) {
            level = this.layer.getLevels().getLevel(level.getLevelNumber() + 1);
        }
        File file = new File(this.fileStore.getWriteLocation(), level.getPath());
        if (file.exists()) {
            for (File file2 : object = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                long l4 = this.computeAverageTileSize(file2);
                if (l4 > 0L) {
                    l2 += l4;
                    ++l3;
                }
                if (l3 >= 2L) break;
            }
        }
        object = Long.valueOf(350000L);
        if (l3 > 0L && l2 > 0L) {
            object = l2 / l3;
            this.layer.setValue("gov.nasa.worldwind.avkey.AverageTileSize", object);
        }
        return object.longValue();
    }

    protected long computeAverageTileSize(File file) {
        File[] fileArray;
        long l = 0L;
        int n = 0;
        for (File file2 : fileArray = file.listFiles()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                l += (long)fileInputStream.available();
                fileInputStream.close();
                ++n;
            }
            catch (IOException iOException) {
                n += 0;
            }
        }
        return n > 0 ? l / (long)n : 0L;
    }

    protected class BulkDownloadPostProcessor
    extends BasicTiledImageLayer.DownloadPostProcessor {
        public BulkDownloadPostProcessor(TextureTile textureTile, BasicTiledImageLayer basicTiledImageLayer, FileStore fileStore) {
            super(textureTile, basicTiledImageLayer, fileStore);
        }

        @Override
        public ByteBuffer run(Retriever retriever) {
            ByteBuffer byteBuffer = super.run(retriever);
            if (retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                BasicTiledImageLayerBulkDownloader.this.removeRetrievedTile(this.tile);
            }
            if (BasicTiledImageLayerBulkDownloader.this.hasRetrievalListeners()) {
                BasicTiledImageLayerBulkDownloader.this.callRetrievalListeners(retriever, this.tile);
            }
            return byteBuffer;
        }
    }
}

