/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.coords.TMCoord;
import gov.nasa.worldwind.globes.Globe;

class UTMCoordConverter {
    public static final double CLARKE_A = 6378206.4;
    public static final double CLARKE_B = 6356583.8;
    public static final double CLARKE_F = 0.0033900753040885176;
    public static final double WGS84_A = 6378137.0;
    public static final double WGS84_F = 0.0033528106647474805;
    public static final int UTM_NO_ERROR = 0;
    public static final int UTM_LAT_ERROR = 1;
    public static final int UTM_LON_ERROR = 2;
    public static final int UTM_EASTING_ERROR = 4;
    public static final int UTM_NORTHING_ERROR = 8;
    public static final int UTM_ZONE_ERROR = 16;
    public static final int UTM_HEMISPHERE_ERROR = 32;
    public static final int UTM_ZONE_OVERRIDE_ERROR = 64;
    public static final int UTM_A_ERROR = 128;
    public static final int UTM_INV_F_ERROR = 256;
    public static final int UTM_TM_ERROR = 512;
    private static final double PI = Math.PI;
    private static final double MIN_LAT = -1.43116998663535;
    private static final double MAX_LAT = 1.5009831567151233;
    private static final int MIN_EASTING = 100000;
    private static final int MAX_EASTING = 900000;
    private static final int MIN_NORTHING = 0;
    private static final int MAX_NORTHING = 10000000;
    private final Globe globe;
    private double UTM_a = 6378137.0;
    private double UTM_f = 0.0033528106647474805;
    private long UTM_Override = 0L;
    private double Easting;
    private double Northing;
    private String Hemisphere;
    private int Zone;
    private double Latitude;
    private double Longitude;
    private double Central_Meridian;

    UTMCoordConverter(Globe globe) {
        this.globe = globe;
        if (globe != null) {
            double d = globe.getEquatorialRadius();
            double d2 = (globe.getEquatorialRadius() - globe.getPolarRadius()) / globe.getEquatorialRadius();
            this.setUTMParameters(d, d2, 0L);
        }
    }

    UTMCoordConverter(double d, double d2) {
        this.globe = null;
        this.setUTMParameters(d, d2, 0L);
    }

    private long setUTMParameters(double d, double d2, long l) {
        double d3 = 1.0 / d2;
        long l2 = 0L;
        if (d <= 0.0) {
            l2 |= 0x80L;
        }
        if (d3 < 250.0 || d3 > 350.0) {
            l2 |= 0x100L;
        }
        if (l < 0L || l > 60L) {
            l2 |= 0x40L;
        }
        if (l2 == 0L) {
            this.UTM_a = d;
            this.UTM_f = d2;
            this.UTM_Override = l;
        }
        return l2;
    }

    public long convertGeodeticToUTM(double d, double d2) {
        long l = 0L;
        double d3 = 0.0;
        double d4 = 500000.0;
        double d5 = 0.0;
        double d6 = 0.9996;
        if (d < -1.43116998663535 || d > 1.5009831567151233) {
            l |= 1L;
        }
        if (d2 < -Math.PI || d2 > Math.PI * 2) {
            l |= 2L;
        }
        if (l == 0L) {
            if (d2 < 0.0) {
                d2 += 6.283185307279586;
            }
            long l2 = (long)(d * 180.0 / Math.PI);
            long l3 = (long)(d2 * 180.0 / Math.PI);
            long l4 = d2 < Math.PI ? (long)(31.0 + d2 * 180.0 / Math.PI / 6.0) : (long)(d2 * 180.0 / Math.PI / 6.0 - 29.0);
            if (l4 > 60L) {
                l4 = 1L;
            }
            if (l2 > 55L && l2 < 64L && l3 > -1L && l3 < 3L) {
                l4 = 31L;
            }
            if (l2 > 55L && l2 < 64L && l3 > 2L && l3 < 12L) {
                l4 = 32L;
            }
            if (l2 > 71L && l3 > -1L && l3 < 9L) {
                l4 = 31L;
            }
            if (l2 > 71L && l3 > 8L && l3 < 21L) {
                l4 = 33L;
            }
            if (l2 > 71L && l3 > 20L && l3 < 33L) {
                l4 = 35L;
            }
            if (l2 > 71L && l3 > 32L && l3 < 42L) {
                l4 = 37L;
            }
            if (this.UTM_Override != 0L) {
                if (l4 == 1L && this.UTM_Override == 60L) {
                    l4 = this.UTM_Override;
                } else if (l4 == 60L && this.UTM_Override == 1L) {
                    l4 = this.UTM_Override;
                } else if (l4 - 1L <= this.UTM_Override && this.UTM_Override <= l4 + 1L) {
                    l4 = this.UTM_Override;
                } else {
                    l = 64L;
                }
            }
            if (l == 0L) {
                this.Central_Meridian = l4 >= 31L ? (double)(6L * l4 - 183L) * Math.PI / 180.0 : (double)(6L * l4 + 177L) * Math.PI / 180.0;
                this.Zone = (int)l4;
                if (d < 0.0) {
                    d5 = 1.0E7;
                    this.Hemisphere = "gov.nasa.worldwdind.avkey.South";
                } else {
                    this.Hemisphere = "gov.nasa.worldwind.avkey.North";
                }
                try {
                    TMCoord tMCoord = TMCoord.fromLatLon(Angle.fromRadians(d), Angle.fromRadians(d2), this.globe, this.UTM_a, this.UTM_f, Angle.fromRadians(d3), Angle.fromRadians(this.Central_Meridian), d4, d5, d6);
                    this.Easting = tMCoord.getEasting();
                    this.Northing = tMCoord.getNorthing();
                    if (this.Easting < 100000.0 || this.Easting > 900000.0) {
                        l = 4L;
                    }
                    if (this.Northing < 0.0 || this.Northing > 1.0E7) {
                        l |= 8L;
                    }
                }
                catch (Exception exception) {
                    l = 512L;
                }
            }
        }
        return l;
    }

    public double getEasting() {
        return this.Easting;
    }

    public double getNorthing() {
        return this.Northing;
    }

    public String getHemisphere() {
        return this.Hemisphere;
    }

    public int getZone() {
        return this.Zone;
    }

    public long convertUTMToGeodetic(long l, String string, double d, double d2) {
        long l2 = 0L;
        double d3 = 0.0;
        double d4 = 500000.0;
        double d5 = 0.0;
        double d6 = 0.9996;
        if (l < 1L || l > 60L) {
            l2 |= 0x10L;
        }
        if (!string.equals("gov.nasa.worldwdind.avkey.South") && !string.equals("gov.nasa.worldwind.avkey.North")) {
            l2 |= 0x20L;
        }
        if (d2 < 0.0 || d2 > 1.0E7) {
            l2 |= 8L;
        }
        if (l2 == 0L) {
            this.Central_Meridian = l >= 31L ? (double)(6L * l - 183L) * Math.PI / 180.0 : (double)(6L * l + 177L) * Math.PI / 180.0;
            if (string.equals("gov.nasa.worldwdind.avkey.South")) {
                d5 = 1.0E7;
            }
            try {
                TMCoord tMCoord = TMCoord.fromTM(d, d2, this.globe, Angle.fromRadians(d3), Angle.fromRadians(this.Central_Meridian), d4, d5, d6);
                this.Latitude = tMCoord.getLatitude().radians;
                this.Longitude = tMCoord.getLongitude().radians;
                if (this.Latitude < -1.43116998663535 || this.Latitude > 1.5009831567151233) {
                    l2 |= 8L;
                }
            }
            catch (Exception exception) {
                l2 = 512L;
            }
        }
        return l2;
    }

    public double getLatitude() {
        return this.Latitude;
    }

    public double getLongitude() {
        return this.Longitude;
    }

    public double getCentralMeridian() {
        return this.Central_Meridian;
    }

    public static LatLon convertWGS84ToNAD27(Angle angle, Angle angle2) {
        double d = -12.0;
        double d2 = 130.0;
        double d3 = 190.0;
        double d4 = -69.40000000037253;
        double d5 = -3.7264639341037104E-5;
        double d6 = angle.radians;
        double d7 = angle2.radians;
        double d8 = 0.0033900753039287634;
        double d9 = 2.0 * d8 - Math.pow(d8, 2.0);
        double d10 = 6378206.4 / Math.sqrt(1.0 - d9 * Math.pow(Math.sin(d6), 2.0));
        double d11 = 6378206.4 * (1.0 - d9) / Math.pow(1.0 - d9 * Math.pow(Math.sin(d6), 2.0), 1.5);
        double d12 = (-1.0 * d * Math.sin(d7) + d2 * Math.cos(d7)) / (d10 * Math.cos(d6));
        double d13 = (-1.0 * d * Math.sin(d6) * Math.cos(d7) - d2 * Math.sin(d6) * Math.sin(d7) + d3 * Math.cos(d6) + d4 * (d10 * d9 * Math.sin(d6) * Math.cos(d6)) / 6378206.4 + d5 * (d11 * 6378206.4 / 6356583.8 + d10 * 6356583.8 / 6378206.4) * Math.sin(d6) * Math.cos(d6)) / d11;
        return LatLon.fromRadians(d6 - d13, d7 - d12);
    }
}

