/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;

public class Quaternion {
    public static final Quaternion IDENTITY = new Quaternion(0.0, 0.0, 0.0, 1.0);
    public final double x;
    public final double y;
    public final double z;
    public final double w;
    private static final int NUM_ELEMENTS = 4;
    private int hashCode;
    private static final Double PositiveZero = 0.0;
    private static final Double NegativeZero = -0.0;

    public Quaternion(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Quaternion quaternion = (Quaternion)object;
        return this.x == quaternion.x && this.y == quaternion.y && this.z == quaternion.z && this.w == quaternion.w;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            long l = Double.doubleToLongBits(this.x);
            int n = (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.y);
            n = 31 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.z);
            n = 31 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.w);
            this.hashCode = n = 31 * n + (int)(l ^ l >>> 32);
        }
        return this.hashCode;
    }

    public static Quaternion fromArray(double[] dArray, int n) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length - n < 4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(dArray[0 + n], dArray[1 + n], dArray[2 + n], dArray[3 + n]);
    }

    public final double[] toArray(double[] dArray, int n) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length - n < 4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        dArray[0 + n] = this.x;
        dArray[1 + n] = this.y;
        dArray[2 + n] = this.z;
        dArray[3 + n] = this.w;
        return dArray;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.x).append(", ");
        stringBuilder.append(this.y).append(", ");
        stringBuilder.append(this.z).append(", ");
        stringBuilder.append(this.w);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getW() {
        return this.w;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public final double w() {
        return this.w;
    }

    public static Quaternion fromAxisAngle(Angle angle, Vec4 vec4) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Quaternion.fromAxisAngle(angle, vec4.x, vec4.y, vec4.z, true);
    }

    public static Quaternion fromAxisAngle(Angle angle, double d, double d2, double d3) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Quaternion.fromAxisAngle(angle, d, d2, d3, true);
    }

    private static Quaternion fromAxisAngle(Angle angle, double d, double d2, double d3, boolean bl) {
        double d4;
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bl && !Quaternion.isZero(d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3)) && d4 != 1.0) {
            d /= d4;
            d2 /= d4;
            d3 /= d4;
        }
        d4 = angle.sinHalfAngle();
        double d5 = angle.cosHalfAngle();
        return new Quaternion(d * d4, d2 * d4, d3 * d4, d5);
    }

    public static Quaternion fromMatrix(Matrix matrix) {
        double d;
        double d2;
        double d3;
        double d4;
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d5 = 1.0 + matrix.m11 + matrix.m22 + matrix.m33;
        if (d5 > 1.0E-8) {
            double d6 = 2.0 * Math.sqrt(d5);
            d4 = (matrix.m32 - matrix.m23) / d6;
            d3 = (matrix.m13 - matrix.m31) / d6;
            d2 = (matrix.m21 - matrix.m12) / d6;
            d = d6 / 4.0;
        } else if (matrix.m11 > matrix.m22 && matrix.m11 > matrix.m33) {
            double d7 = 2.0 * Math.sqrt(1.0 + matrix.m11 - matrix.m22 - matrix.m33);
            d4 = d7 / 4.0;
            d3 = (matrix.m21 + matrix.m12) / d7;
            d2 = (matrix.m13 + matrix.m31) / d7;
            d = (matrix.m32 - matrix.m23) / d7;
        } else if (matrix.m22 > matrix.m33) {
            double d8 = 2.0 * Math.sqrt(1.0 + matrix.m22 - matrix.m11 - matrix.m33);
            d4 = (matrix.m21 + matrix.m12) / d8;
            d3 = d8 / 4.0;
            d2 = (matrix.m32 + matrix.m23) / d8;
            d = (matrix.m13 - matrix.m31) / d8;
        } else {
            double d9 = 2.0 * Math.sqrt(1.0 + matrix.m33 - matrix.m11 - matrix.m22);
            d4 = (matrix.m13 + matrix.m31) / d9;
            d3 = (matrix.m32 + matrix.m23) / d9;
            d2 = d9 / 4.0;
            d = (matrix.m21 - matrix.m12) / d9;
        }
        return new Quaternion(d4, d3, d2, d);
    }

    public static Quaternion fromRotationXYZ(Angle angle, Angle angle2, Angle angle3) {
        if (angle == null || angle2 == null || angle3 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cosHalfAngle();
        double d2 = angle2.cosHalfAngle();
        double d3 = angle3.cosHalfAngle();
        double d4 = angle.sinHalfAngle();
        double d5 = angle2.sinHalfAngle();
        double d6 = angle3.sinHalfAngle();
        double d7 = d * d2 * d3 + d4 * d5 * d6;
        double d8 = d4 * d2 * d3 - d * d5 * d6;
        double d9 = d * d5 * d3 + d4 * d2 * d6;
        double d10 = d * d2 * d6 - d4 * d5 * d3;
        return new Quaternion(d8, d9, d10, d7);
    }

    public static Quaternion fromLatLon(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cosHalfAngle();
        double d2 = angle2.cosHalfAngle();
        double d3 = angle.sinHalfAngle();
        double d4 = angle2.sinHalfAngle();
        double d5 = d * d2;
        double d6 = d * d4;
        double d7 = d3 * d2;
        double d8 = 0.0 - d3 * d4;
        return new Quaternion(d6, d7, d8, d5);
    }

    public final Quaternion add(Quaternion quaternion) {
        if (quaternion == null) {
            String string = Logging.getMessage("nullValue.QuaternionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(this.x + quaternion.x, this.y + quaternion.y, this.z + quaternion.z, this.w + quaternion.w);
    }

    public final Quaternion subtract(Quaternion quaternion) {
        if (quaternion == null) {
            String string = Logging.getMessage("nullValue.QuaternionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(this.x - quaternion.x, this.y - quaternion.y, this.z - quaternion.z, this.w - quaternion.w);
    }

    public final Quaternion multiplyComponents(double d) {
        return new Quaternion(this.x * d, this.y * d, this.z * d, this.w * d);
    }

    public final Quaternion multiply(Quaternion quaternion) {
        if (quaternion == null) {
            String string = Logging.getMessage("nullValue.QuaternionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(this.w * quaternion.x + this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y, this.w * quaternion.y + this.y * quaternion.w + this.z * quaternion.x - this.x * quaternion.z, this.w * quaternion.z + this.z * quaternion.w + this.x * quaternion.y - this.y * quaternion.x, this.w * quaternion.w - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z);
    }

    public final Quaternion divideComponents(double d) {
        if (Quaternion.isZero(d)) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(this.x / d, this.y / d, this.z / d, this.w / d);
    }

    public final Quaternion divideComponents(Quaternion quaternion) {
        if (quaternion == null) {
            String string = Logging.getMessage("nullValue.QuaternionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(this.x / quaternion.x, this.y / quaternion.y, this.z / quaternion.z, this.w / quaternion.w);
    }

    public final Quaternion getConjugate() {
        return new Quaternion(0.0 - this.x, 0.0 - this.y, 0.0 - this.z, this.w);
    }

    public final Quaternion getNegative() {
        return new Quaternion(0.0 - this.x, 0.0 - this.y, 0.0 - this.z, 0.0 - this.w);
    }

    public final double getLength() {
        return Math.sqrt(this.getLengthSquared());
    }

    public final double getLengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final Quaternion normalize() {
        double d = this.getLength();
        if (Quaternion.isZero(d)) {
            return this;
        }
        return new Quaternion(this.x / d, this.y / d, this.z / d, this.w / d);
    }

    public final double dot(Quaternion quaternion) {
        if (quaternion == null) {
            String string = Logging.getMessage("nullValue.QuaternionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
    }

    public final Quaternion getInverse() {
        double d = this.getLength();
        if (Quaternion.isZero(d)) {
            return this;
        }
        return new Quaternion((0.0 - this.x) / d, (0.0 - this.y) / d, (0.0 - this.z) / d, this.w / d);
    }

    public static Quaternion mix(double d, Quaternion quaternion, Quaternion quaternion2) {
        if (quaternion == null || quaternion2 == null) {
            String string = Logging.getMessage("nullValue.QuaternionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            return quaternion;
        }
        if (d > 1.0) {
            return quaternion2;
        }
        double d2 = 1.0 - d;
        return new Quaternion(quaternion.x * d2 + quaternion2.x * d, quaternion.y * d2 + quaternion2.y * d, quaternion.z * d2 + quaternion2.z * d, quaternion.w * d2 + quaternion2.w * d);
    }

    public static Quaternion slerp(double d, Quaternion quaternion, Quaternion quaternion2) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        if (quaternion == null || quaternion2 == null) {
            String string = Logging.getMessage("nullValue.QuaternionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            return quaternion;
        }
        if (d > 1.0) {
            return quaternion2;
        }
        double d8 = quaternion.dot(quaternion2);
        if (d8 < 0.0) {
            d8 = 0.0 - d8;
            d7 = 0.0 - quaternion2.x;
            d6 = 0.0 - quaternion2.y;
            d5 = 0.0 - quaternion2.z;
            d4 = 0.0 - quaternion2.w;
        } else {
            d7 = quaternion2.x;
            d6 = quaternion2.y;
            d5 = quaternion2.z;
            d4 = quaternion2.w;
        }
        if (1.0 - d8 > 1.0E-4) {
            double d9 = Math.acos(d8);
            double d10 = Math.sin(d9);
            d3 = Math.sin((1.0 - d) * d9) / d10;
            d2 = Math.sin(d * d9) / d10;
        } else {
            d3 = 1.0 - d;
            d2 = d;
        }
        return new Quaternion(quaternion.x * d3 + d7 * d2, quaternion.y * d3 + d6 * d2, quaternion.z * d3 + d5 * d2, quaternion.w * d3 + d4 * d2);
    }

    public final Angle getAngle() {
        double d;
        double d2 = this.w;
        double d3 = this.getLength();
        if (!Quaternion.isZero(d3) && d3 != 1.0) {
            d2 /= d3;
        }
        if (Double.isNaN(d = 2.0 * Math.acos(d2))) {
            return null;
        }
        return Angle.fromRadians(d);
    }

    public final Vec4 getAxis() {
        double d;
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.getLength();
        if (!Quaternion.isZero(d5) && d5 != 1.0) {
            d2 /= d5;
            d3 /= d5;
            d4 /= d5;
        }
        if (!Quaternion.isZero(d = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4)) && d != 1.0) {
            d2 /= d;
            d3 /= d;
            d4 /= d;
        }
        return new Vec4(d2, d3, d4);
    }

    public final Angle getRotationX() {
        double d = Math.atan2(2.0 * this.x * this.w - 2.0 * this.y * this.z, 1.0 - 2.0 * (this.x * this.x) - 2.0 * (this.z * this.z));
        if (Double.isNaN(d)) {
            return null;
        }
        return Angle.fromRadians(d);
    }

    public final Angle getRotationY() {
        double d = Math.atan2(2.0 * this.y * this.w - 2.0 * this.x * this.z, 1.0 - 2.0 * this.y * this.y - 2.0 * this.z * this.z);
        if (Double.isNaN(d)) {
            return null;
        }
        return Angle.fromRadians(d);
    }

    public final Angle getRotationZ() {
        double d = Math.asin(2.0 * this.x * this.y + 2.0 * this.z * this.w);
        if (Double.isNaN(d)) {
            return null;
        }
        return Angle.fromRadians(d);
    }

    public final LatLon getLatLon() {
        double d = Math.asin(2.0 * this.y * this.w - 2.0 * this.x * this.z);
        double d2 = Math.atan2(2.0 * this.y * this.z + 2.0 * this.x * this.w, this.w * this.w - this.x * this.x - this.y * this.y + this.z * this.z);
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return null;
        }
        return LatLon.fromRadians(d, d2);
    }

    private static boolean isZero(double d) {
        return PositiveZero.compareTo(d) == 0 || NegativeZero.compareTo(d) == 0;
    }
}

