/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Quaternion;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import java.awt.geom.Point2D;

public class Matrix {
    public static final Matrix IDENTITY = new Matrix(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    public final double m11;
    public final double m12;
    public final double m13;
    public final double m14;
    public final double m21;
    public final double m22;
    public final double m23;
    public final double m24;
    public final double m31;
    public final double m32;
    public final double m33;
    public final double m34;
    public final double m41;
    public final double m42;
    public final double m43;
    public final double m44;
    protected static final double EPSILON = 1.0E-6;
    protected static final double NEAR_ZERO_THRESHOLD = 1.0E-8;
    private static final int NUM_ELEMENTS = 16;
    private final boolean isOrthonormalTransform;
    private int hashCode;
    private static final Double POSITIVE_ZERO = 0.0;
    private static final Double NEGATIVE_ZERO = -0.0;

    public Matrix(double d) {
        this(d, 0.0, 0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0, 0.0, d);
    }

    public Matrix(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, false);
    }

    Matrix(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, boolean bl) {
        this.m11 = d;
        this.m12 = d2;
        this.m13 = d3;
        this.m14 = d4;
        this.m21 = d5;
        this.m22 = d6;
        this.m23 = d7;
        this.m24 = d8;
        this.m31 = d9;
        this.m32 = d10;
        this.m33 = d11;
        this.m34 = d12;
        this.m41 = d13;
        this.m42 = d14;
        this.m43 = d15;
        this.m44 = d16;
        this.isOrthonormalTransform = bl;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Matrix matrix = (Matrix)object;
        return this.m11 == matrix.m11 && this.m12 == matrix.m12 && this.m13 == matrix.m13 && this.m14 == matrix.m14 && this.m21 == matrix.m21 && this.m22 == matrix.m22 && this.m23 == matrix.m23 && this.m24 == matrix.m24 && this.m31 == matrix.m31 && this.m32 == matrix.m32 && this.m33 == matrix.m33 && this.m34 == matrix.m34 && this.m41 == matrix.m41 && this.m42 == matrix.m42 && this.m43 == matrix.m43 && this.m44 == matrix.m44;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            long l = Double.doubleToLongBits(this.m11);
            int n = (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m12);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m13);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m14);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m21);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m22);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m23);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m24);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m31);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m32);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m33);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m34);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m41);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m42);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m43);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.m44);
            this.hashCode = n = 29 * n + (int)(l ^ l >>> 32);
        }
        return this.hashCode;
    }

    public static Matrix fromArray(double[] dArray, int n, boolean bl) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length - n < 16) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bl) {
            return new Matrix(dArray[0 + n], dArray[1 + n], dArray[2 + n], dArray[3 + n], dArray[4 + n], dArray[5 + n], dArray[6 + n], dArray[7 + n], dArray[8 + n], dArray[9 + n], dArray[10 + n], dArray[11 + n], dArray[12 + n], dArray[13 + n], dArray[14 + n], dArray[15 + n]);
        }
        return new Matrix(dArray[0 + n], dArray[4 + n], dArray[8 + n], dArray[12 + n], dArray[1 + n], dArray[5 + n], dArray[9 + n], dArray[13 + n], dArray[2 + n], dArray[6 + n], dArray[10 + n], dArray[14 + n], dArray[3 + n], dArray[7 + n], dArray[11 + n], dArray[15 + n]);
    }

    public final double[] toArray(double[] dArray, int n, boolean bl) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length - n < 16) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bl) {
            dArray[0 + n] = this.m11;
            dArray[1 + n] = this.m12;
            dArray[2 + n] = this.m13;
            dArray[3 + n] = this.m14;
            dArray[4 + n] = this.m21;
            dArray[5 + n] = this.m22;
            dArray[6 + n] = this.m23;
            dArray[7 + n] = this.m24;
            dArray[8 + n] = this.m31;
            dArray[9 + n] = this.m32;
            dArray[10 + n] = this.m33;
            dArray[11 + n] = this.m34;
            dArray[12 + n] = this.m41;
            dArray[13 + n] = this.m42;
            dArray[14 + n] = this.m43;
            dArray[15 + n] = this.m44;
        } else {
            dArray[0 + n] = this.m11;
            dArray[4 + n] = this.m12;
            dArray[8 + n] = this.m13;
            dArray[12 + n] = this.m14;
            dArray[1 + n] = this.m21;
            dArray[5 + n] = this.m22;
            dArray[9 + n] = this.m23;
            dArray[13 + n] = this.m24;
            dArray[2 + n] = this.m31;
            dArray[6 + n] = this.m32;
            dArray[10 + n] = this.m33;
            dArray[14 + n] = this.m34;
            dArray[3 + n] = this.m41;
            dArray[7 + n] = this.m42;
            dArray[11 + n] = this.m43;
            dArray[15 + n] = this.m44;
        }
        return dArray;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.m11).append(", ").append(this.m12).append(", ").append(this.m13).append(", ").append(this.m14);
        stringBuilder.append(", \r\n");
        stringBuilder.append(this.m21).append(", ").append(this.m22).append(", ").append(this.m23).append(", ").append(this.m24);
        stringBuilder.append(", \r\n");
        stringBuilder.append(this.m31).append(", ").append(this.m32).append(", ").append(this.m33).append(", ").append(this.m34);
        stringBuilder.append(", \r\n");
        stringBuilder.append(this.m41).append(", ").append(this.m42).append(", ").append(this.m43).append(", ").append(this.m44);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public final double getM11() {
        return this.m11;
    }

    public final double getM12() {
        return this.m12;
    }

    public final double getM13() {
        return this.m13;
    }

    public final double getM14() {
        return this.m14;
    }

    public final double getM21() {
        return this.m21;
    }

    public final double getM22() {
        return this.m22;
    }

    public final double getM23() {
        return this.m23;
    }

    public final double getM24() {
        return this.m24;
    }

    public final double getM31() {
        return this.m31;
    }

    public final double getM32() {
        return this.m32;
    }

    public final double getM33() {
        return this.m33;
    }

    public final double getM34() {
        return this.m34;
    }

    public final double getM41() {
        return this.m41;
    }

    public final double getM42() {
        return this.m42;
    }

    public final double getM43() {
        return this.m43;
    }

    public final double getM44() {
        return this.m44;
    }

    public final double m11() {
        return this.m11;
    }

    public final double m12() {
        return this.m12;
    }

    public final double m13() {
        return this.m13;
    }

    public final double m14() {
        return this.m14;
    }

    public final double m21() {
        return this.m21;
    }

    public final double m22() {
        return this.m22;
    }

    public final double m23() {
        return this.m23;
    }

    public final double m24() {
        return this.m24;
    }

    public final double m31() {
        return this.m31;
    }

    public final double m32() {
        return this.m32;
    }

    public final double m33() {
        return this.m33;
    }

    public final double m34() {
        return this.m34;
    }

    public final double m41() {
        return this.m41;
    }

    public final double m42() {
        return this.m42;
    }

    public final double m43() {
        return this.m43;
    }

    public final double m44() {
        return this.m44;
    }

    public static Matrix fromAxes(Vec4[] vec4Array) {
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.AxesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array.length < 3) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", vec4Array.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array[0] == null || vec4Array[1] == null || vec4Array[2] == null) {
            String string = Logging.getMessage("nullValue.AxesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = vec4Array[0].normalize3();
        Vec4 vec42 = vec4.cross3(vec4Array[1]).normalize3();
        Vec4 vec43 = vec42.cross3(vec4).normalize3();
        return new Matrix(vec4.x, vec43.x, vec42.x, 0.0, vec4.y, vec43.y, vec42.y, 0.0, vec4.z, vec43.z, vec42.z, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromAxisAngle(Angle angle, Vec4 vec4) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Matrix.fromAxisAngle(angle, vec4.x, vec4.y, vec4.z, true);
    }

    public static Matrix fromAxisAngle(Angle angle, double d, double d2, double d3) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Matrix.fromAxisAngle(angle, d, d2, d3, true);
    }

    private static Matrix fromAxisAngle(Angle angle, double d, double d2, double d3, boolean bl) {
        double d4;
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bl && !Matrix.isZero(d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3)) && d4 != 1.0) {
            d /= d4;
            d2 /= d4;
            d3 /= d4;
        }
        d4 = angle.cos();
        double d5 = angle.sin();
        double d6 = 1.0 - d4;
        return new Matrix(d4 + d6 * d * d, d6 * d * d2 - d5 * d3, d6 * d * d3 + d5 * d2, 0.0, d6 * d * d2 + d5 * d3, d4 + d6 * d2 * d2, d6 * d2 * d3 - d5 * d, 0.0, d6 * d * d3 - d5 * d2, d6 * d2 * d3 + d5 * d, d4 + d6 * d3 * d3, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromQuaternion(Quaternion quaternion) {
        if (quaternion == null) {
            String string = Logging.getMessage("nullValue.QuaternionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Matrix.fromQuaternion(quaternion.x, quaternion.y, quaternion.z, quaternion.w, true);
    }

    private static Matrix fromQuaternion(double d, double d2, double d3, double d4, boolean bl) {
        double d5;
        if (bl && !Matrix.isZero(d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3 + d4 * d4)) && d5 != 1.0) {
            d /= d5;
            d2 /= d5;
            d3 /= d5;
            d4 /= d5;
        }
        return new Matrix(1.0 - 2.0 * d2 * d2 - 2.0 * d3 * d3, 2.0 * d * d2 - 2.0 * d3 * d4, 2.0 * d * d3 + 2.0 * d2 * d4, 0.0, 2.0 * d * d2 + 2.0 * d3 * d4, 1.0 - 2.0 * d * d - 2.0 * d3 * d3, 2.0 * d2 * d3 - 2.0 * d * d4, 0.0, 2.0 * d * d3 - 2.0 * d2 * d4, 2.0 * d2 * d3 + 2.0 * d * d4, 1.0 - 2.0 * d * d - 2.0 * d2 * d2, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromRotationXYZ(Angle angle, Angle angle2, Angle angle3) {
        if (angle == null || angle2 == null || angle3 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cos();
        double d2 = angle2.cos();
        double d3 = angle3.cos();
        double d4 = angle.sin();
        double d5 = angle2.sin();
        double d6 = angle3.sin();
        return new Matrix(d2 * d3, -d2 * d6, d5, 0.0, d4 * d5 * d3 + d * d6, -(d4 * d5 * d6) + d * d3, -d4 * d2, 0.0, -(d * d5 * d3) + d4 * d6, d * d5 * d6 + d4 * d3, d * d2, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromRotationX(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cos();
        double d2 = angle.sin();
        return new Matrix(1.0, 0.0, 0.0, 0.0, 0.0, d, -d2, 0.0, 0.0, d2, d, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromRotationY(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cos();
        double d2 = angle.sin();
        return new Matrix(d, 0.0, d2, 0.0, 0.0, 1.0, 0.0, 0.0, -d2, 0.0, d, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromRotationZ(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cos();
        double d2 = angle.sin();
        return new Matrix(d, -d2, 0.0, 0.0, d2, d, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromScale(double d) {
        return Matrix.fromScale(d, d, d);
    }

    public static Matrix fromScale(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Matrix.fromScale(vec4.x, vec4.y, vec4.z);
    }

    public static Matrix fromScale(double d, double d2, double d3) {
        return new Matrix(d, 0.0, 0.0, 0.0, 0.0, d2, 0.0, 0.0, 0.0, 0.0, d3, 0.0, 0.0, 0.0, 0.0, 1.0, false);
    }

    public static Matrix fromTranslation(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Matrix.fromTranslation(vec4.x, vec4.y, vec4.z);
    }

    public static Matrix fromTranslation(double d, double d2, double d3) {
        return new Matrix(1.0, 0.0, 0.0, d, 0.0, 1.0, 0.0, d2, 0.0, 0.0, 1.0, d3, 0.0, 0.0, 0.0, 1.0, true);
    }

    public static Matrix fromSkew(Angle angle, Angle angle2) {
        double d = 1000000.0;
        double d2 = 1000000.0;
        if (angle.getRadians() < 1.0E-6 && angle2.getRadians() < 1.0E-6) {
            d = 0.0;
            d2 = 0.0;
        } else {
            if (Math.abs(Math.tan(angle.getRadians())) > 1.0E-6) {
                d = 1.0 / Math.tan(angle.getRadians());
            }
            if (Math.abs(Math.tan(angle2.getRadians())) > 1.0E-6) {
                d2 = 1.0 / Math.tan(angle2.getRadians());
            }
        }
        return new Matrix(1.0, 0.0, -d, 0.0, 0.0, 1.0, -d2, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, false);
    }

    public static Matrix fromLocalOrientation(Vec4 vec4, Vec4[] vec4Array) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.OriginIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.AxesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array.length < 3) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", vec4Array.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array[0] == null || vec4Array[1] == null || vec4Array[2] == null) {
            String string = Logging.getMessage("nullValue.AxesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Matrix.fromTranslation(vec4).multiply(Matrix.fromAxes(vec4Array));
    }

    public static Matrix fromViewLookAt(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (vec4 == null || vec42 == null || vec43 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4.distanceTo3(vec42) <= 1.0E-6) {
            String string = Logging.getMessage("Geom.EyeAndCenterInvalid", vec4, vec42);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec44.normalize3();
        Vec4 vec46 = vec45.cross3(vec43);
        if ((vec46 = vec46.normalize3()).getLength3() <= 1.0E-6) {
            String string = Logging.getMessage("Geom.UpAndLineOfSightInvalid", vec43, vec44);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec47 = vec46.cross3(vec45);
        vec47 = vec47.normalize3();
        Matrix matrix = new Matrix(vec46.x, vec46.y, vec46.z, 0.0, vec47.x, vec47.y, vec47.z, 0.0, -vec45.x, -vec45.y, -vec45.z, 0.0, 0.0, 0.0, 0.0, 1.0, true);
        Matrix matrix2 = Matrix.fromTranslation(-vec4.x, -vec4.y, -vec4.z);
        return matrix.multiply(matrix2);
    }

    public static Matrix fromModelLookAt(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (vec4 == null || vec42 == null || vec43 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4.distanceTo3(vec42) <= 1.0E-6) {
            String string = Logging.getMessage("Geom.EyeAndCenterInvalid", vec4, vec42);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec44.normalize3();
        Vec4 vec46 = vec43.cross3(vec45);
        if ((vec46 = vec46.normalize3()).getLength3() <= 1.0E-6) {
            String string = Logging.getMessage("Geom.UpAndLineOfSightInvalid", vec43, vec44);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec47 = vec45.cross3(vec46);
        vec47 = vec47.normalize3();
        Matrix matrix = new Matrix(vec46.x, vec47.x, vec45.x, 0.0, vec46.y, vec47.y, vec45.y, 0.0, vec46.z, vec47.z, vec45.z, 0.0, 0.0, 0.0, 0.0, 1.0, true);
        Matrix matrix2 = Matrix.fromTranslation(vec4.x, vec4.y, vec4.z);
        return matrix2.multiply(matrix);
    }

    public static Matrix fromPerspective(Angle angle, double d, double d2, double d3, double d4) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d5 = angle.degrees;
        if (d5 <= 0.0 || d5 > 180.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "horizontalFieldOfView=" + d5);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "viewportWidth=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "viewportHeight=" + d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "near=" + d3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d4 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "far=" + d4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d4 <= d3) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "far=" + d4 + ",near=" + d3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d6 = 1.0 / angle.tanHalfAngle();
        return new Matrix(d6, 0.0, 0.0, 0.0, 0.0, d6 * d / d2, 0.0, 0.0, 0.0, 0.0, -(d4 + d3) / (d4 - d3), -(2.0 * d4 * d3) / (d4 - d3), 0.0, 0.0, -1.0, 0.0);
    }

    public static Matrix fromPerspective(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d4 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d4 <= d3) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Matrix(2.0 / d, 0.0, 0.0, 0.0, 0.0, 2.0 * d3 / d2, 0.0, 0.0, 0.0, 0.0, -(d4 + d3) / (d4 - d3), -(2.0 * d4 * d3) / (d4 - d3), 0.0, 0.0, -1.0, 0.0);
    }

    public static Matrix fromOrthographic(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d4 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d4 <= d3) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Matrix(2.0 / d, 0.0, 0.0, 0.0, 0.0, 2.0 / d2, 0.0, 0.0, 0.0, 0.0, -2.0 / (d4 - d3), -(d4 + d3) / (d4 - d3), 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix fromOrthographic2D(double d, double d2) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Matrix(2.0 / d, 0.0, 0.0, 0.0, 0.0, 2.0 / d2, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix fromImageToGeographic(int n, int n2, Sector sector) {
        if (n < 1 || n2 < 1) {
            String string = Logging.getMessage("generic.InvalidImageSize", n, n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = sector.getDeltaLonDegrees() / (double)n;
        double d2 = -sector.getDeltaLatDegrees() / (double)n2;
        double d3 = sector.getMinLongitude().degrees;
        double d4 = sector.getMaxLatitude().degrees;
        return new Matrix(d, 0.0, d3, 0.0, 0.0, d2, d4, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static Matrix fromImageToGeographic(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Double d = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.XPixelSize");
        Double d2 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.YCoefficient");
        Double d3 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.XCoefficient");
        Double d4 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.YPixelSize");
        Double d5 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.XLocation");
        Double d6 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.YLocation");
        if (d == null || d3 == null || d5 == null || d2 == null || d4 == null || d6 == null) {
            return null;
        }
        return new Matrix(d, d3, d5, 0.0, d2, d4, d6, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static Matrix fromGeographicToImage(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Double d = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.XPixelSize");
        Double d2 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.YCoefficient");
        Double d3 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.XCoefficient");
        Double d4 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.YPixelSize");
        Double d5 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.XLocation");
        Double d6 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.worldFile.YLocation");
        if (d == null || d3 == null || d5 == null || d2 == null || d4 == null || d6 == null) {
            return null;
        }
        if (d3 == 0.0 && d2 == 0.0) {
            return new Matrix(1.0 / d, 0.0, -d5.doubleValue() / d, 0.0, 0.0, 1.0 / d4, -d6.doubleValue() / d4, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        double d7 = d2 - d4 * d / d3;
        double d8 = -d4.doubleValue() / (d3 * d7);
        double d9 = 1.0 / d7;
        double d10 = d4 * d5 / (d3 * d7) - d6 / d7;
        double d11 = d4 - d2 * d3 / d;
        double d12 = -d2.doubleValue() / (d * d11);
        double d13 = 1.0 / d11;
        double d14 = d2 * d5 / (d * d11) - d6 / d11;
        return new Matrix(d8, d9, d10, 0.0, d12, d13, d14, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static Matrix fromImageToGeographic(Point2D[] point2DArray, LatLon[] latLonArray) {
        if (point2DArray == null) {
            String string = Logging.getMessage("nullValue.ImagePointsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLonArray == null) {
            String string = Logging.getMessage("nullValue.GeoPointsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (point2DArray.length < 3) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "imagePoints.length < 3");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLonArray.length < 3) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "geoPoints.length < 3");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLonArray[0].getLatitude().degrees;
        double d2 = latLonArray[1].getLatitude().degrees;
        double d3 = latLonArray[2].getLatitude().degrees;
        double d4 = latLonArray[0].getLongitude().degrees;
        double d5 = latLonArray[1].getLongitude().degrees;
        double d6 = latLonArray[2].getLongitude().degrees;
        double d7 = point2DArray[0].getX();
        double d8 = point2DArray[1].getX();
        double d9 = point2DArray[2].getX();
        double d10 = point2DArray[0].getY();
        double d11 = point2DArray[1].getY();
        double d12 = point2DArray[2].getY();
        double d13 = d9 - d7 - (d8 - d7) * (d12 - d10) / (d11 - d10);
        double d14 = 1.0 / d13 * (d6 - d4 - (d5 - d4) * (d12 - d10) / (d11 - d10));
        double d15 = (d5 - d4) / (d11 - d10) - d14 * (d8 - d7) / (d11 - d10);
        double d16 = d4 - d14 * d7 - d15 * d10;
        double d17 = d9 - d7 - (d8 - d7) * (d12 - d10) / (d11 - d10);
        double d18 = 1.0 / d17 * (d3 - d - (d2 - d) * (d12 - d10) / (d11 - d10));
        double d19 = (d2 - d) / (d11 - d10) - d18 * (d8 - d7) / (d11 - d10);
        double d20 = d - d18 * d7 - d19 * d10;
        return new Matrix(d14, d15, d16, 0.0, d18, d19, d20, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static Matrix fromGeographicToImage(Point2D[] point2DArray, LatLon[] latLonArray) {
        if (point2DArray == null) {
            String string = Logging.getMessage("nullValue.ImagePointsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLonArray == null) {
            String string = Logging.getMessage("nullValue.GeoPointsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (point2DArray.length < 3) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "imagePoints.length < 3");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLonArray.length < 3) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "geoPoints.length < 3");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLonArray[0].getLatitude().degrees;
        double d2 = latLonArray[1].getLatitude().degrees;
        double d3 = latLonArray[2].getLatitude().degrees;
        double d4 = latLonArray[0].getLongitude().degrees;
        double d5 = latLonArray[1].getLongitude().degrees;
        double d6 = latLonArray[2].getLongitude().degrees;
        double d7 = point2DArray[0].getX();
        double d8 = point2DArray[1].getX();
        double d9 = point2DArray[2].getX();
        double d10 = point2DArray[0].getY();
        double d11 = point2DArray[1].getY();
        double d12 = point2DArray[2].getY();
        double d13 = d6 - d4 - (d5 - d4) * (d3 - d) / (d2 - d);
        double d14 = 1.0 / d13 * (d9 - d7 - (d8 - d7) * (d3 - d) / (d2 - d));
        double d15 = (d8 - d7) / (d2 - d) - d14 * (d5 - d4) / (d2 - d);
        double d16 = d7 - d14 * d4 - d15 * d;
        double d17 = d6 - d4 - (d5 - d4) * (d3 - d) / (d2 - d);
        double d18 = 1.0 / d17 * (d12 - d10 - (d11 - d10) * (d3 - d) / (d2 - d));
        double d19 = (d11 - d10) / (d2 - d) - d18 * (d5 - d4) / (d2 - d);
        double d20 = d10 - d18 * d4 - d19 * d;
        return new Matrix(d14, d15, d16, 0.0, d18, d19, d20, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static Matrix fromGeographicToViewport(Sector sector, int n, int n2, int n3, int n4) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n3 <= 0) {
            String string = Logging.getMessage("Geom.WidthInvalid", n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n4 <= 0) {
            String string = Logging.getMessage("Geom.HeightInvalid", n4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = IDENTITY;
        matrix = matrix.multiply(Matrix.fromTranslation(-n, -n2, 0.0));
        matrix = matrix.multiply(Matrix.fromScale((double)n3 / sector.getDeltaLonDegrees(), (double)n4 / sector.getDeltaLatDegrees(), 1.0));
        matrix = matrix.multiply(Matrix.fromTranslation(-sector.getMinLongitude().degrees, -sector.getMinLatitude().degrees, 0.0));
        return matrix;
    }

    public static Matrix fromViewportToGeographic(Sector sector, int n, int n2, int n3, int n4) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n3 <= 0) {
            String string = Logging.getMessage("Geom.WidthInvalid", n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n4 <= 0) {
            String string = Logging.getMessage("Geom.HeightInvalid", n4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = IDENTITY;
        matrix = matrix.multiply(Matrix.fromTranslation(sector.getMinLongitude().degrees, sector.getMinLatitude().degrees, 0.0));
        matrix = matrix.multiply(Matrix.fromScale(sector.getDeltaLonDegrees() / (double)n3, sector.getDeltaLatDegrees() / (double)n4, 1.0));
        matrix = matrix.multiply(Matrix.fromTranslation(n, n2, 0.0));
        return matrix;
    }

    public static Matrix fromCovarianceOfVertices(Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = Vec4.computeAveragePoint(iterable);
        if (vec4 == null) {
            return null;
        }
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (Vec4 vec42 : iterable) {
            if (vec42 == null) continue;
            ++n;
            d += (vec42.x - vec4.x) * (vec42.x - vec4.x);
            d2 += (vec42.y - vec4.y) * (vec42.y - vec4.y);
            d3 += (vec42.z - vec4.z) * (vec42.z - vec4.z);
            d4 += (vec42.x - vec4.x) * (vec42.y - vec4.y);
            d5 += (vec42.x - vec4.x) * (vec42.z - vec4.z);
            d6 += (vec42.y - vec4.y) * (vec42.z - vec4.z);
        }
        if (n == 0) {
            return null;
        }
        return new Matrix(d / (double)n, d4 / (double)n, d5 / (double)n, 0.0, d4 / (double)n, d2 / (double)n, d6 / (double)n, 0.0, d5 / (double)n, d6 / (double)n, d3 / (double)n, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static Matrix fromCovarianceOfVertices(BufferWrapper bufferWrapper, int n) {
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.CoordinatesAreNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 3) {
            String string = Logging.getMessage("generic.StrideIsInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = Vec4.computeAveragePoint3(bufferWrapper, n);
        if (vec4 == null) {
            return null;
        }
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i <= bufferWrapper.length() - n; i += n) {
            double d7 = bufferWrapper.getDouble(i);
            double d8 = bufferWrapper.getDouble(i + 1);
            double d9 = bufferWrapper.getDouble(i + 2);
            ++n2;
            d += (d7 - vec4.x) * (d7 - vec4.x);
            d2 += (d8 - vec4.y) * (d8 - vec4.y);
            d3 += (d9 - vec4.z) * (d9 - vec4.z);
            d4 += (d7 - vec4.x) * (d8 - vec4.y);
            d5 += (d7 - vec4.x) * (d9 - vec4.z);
            d6 += (d8 - vec4.y) * (d9 - vec4.z);
        }
        if (n2 == 0) {
            return null;
        }
        return new Matrix(d / (double)n2, d4 / (double)n2, d5 / (double)n2, 0.0, d4 / (double)n2, d2 / (double)n2, d6 / (double)n2, 0.0, d5 / (double)n2, d6 / (double)n2, d3 / (double)n2, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static void computeEigensystemFromSymmetricMatrix3(Matrix matrix, double[] dArray, Vec4[] vec4Array) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix.m12 != matrix.m21 || matrix.m13 != matrix.m31 || matrix.m23 != matrix.m32) {
            String string = Logging.getMessage("generic.MatrixNotSymmetric", matrix);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = matrix.m11;
        double d2 = matrix.m12;
        double d3 = matrix.m13;
        double d4 = matrix.m22;
        double d5 = matrix.m23;
        double d6 = matrix.m33;
        double[][] dArray2 = new double[3][3];
        dArray2[2][2] = 1.0;
        dArray2[1][1] = 1.0;
        dArray2[0][0] = 1.0;
        for (int i = 0; !(i >= 32 || Math.abs(d2) < 1.0E-10 && Math.abs(d3) < 1.0E-10 && Math.abs(d5) < 1.0E-10); ++i) {
            int n;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            double d13;
            if (d2 != 0.0) {
                d13 = (d4 - d) * 0.5 / d2;
                d12 = d13 * d13;
                d11 = d12 + 1.0;
                d10 = d11 != d12 ? (d13 < 0.0 ? -1.0 : 1.0) * (Math.sqrt(d11) - Math.abs(d13)) : 0.5 / d13;
                d9 = 1.0 / Math.sqrt(d10 * d10 + 1.0);
                d8 = d9 * d10;
                d -= d10 * d2;
                d4 += d10 * d2;
                d2 = 0.0;
                d7 = d9 * d3 - d8 * d5;
                d5 = d8 * d3 + d9 * d5;
                d3 = d7;
                for (n = 0; n < 3; ++n) {
                    d7 = d9 * dArray2[n][0] - d8 * dArray2[n][1];
                    dArray2[n][1] = d8 * dArray2[n][0] + d9 * dArray2[n][1];
                    dArray2[n][0] = d7;
                }
            }
            if (d3 != 0.0) {
                d13 = (d6 - d) * 0.5 / d3;
                d12 = d13 * d13;
                d11 = d12 + 1.0;
                d10 = d11 != d12 ? (d13 < 0.0 ? -1.0 : 1.0) * (Math.sqrt(d11) - Math.abs(d13)) : 0.5 / d13;
                d9 = 1.0 / Math.sqrt(d10 * d10 + 1.0);
                d8 = d9 * d10;
                d -= d10 * d3;
                d6 += d10 * d3;
                d3 = 0.0;
                d7 = d9 * d2 - d8 * d5;
                d5 = d8 * d2 + d9 * d5;
                d2 = d7;
                for (n = 0; n < 3; ++n) {
                    d7 = d9 * dArray2[n][0] - d8 * dArray2[n][2];
                    dArray2[n][2] = d8 * dArray2[n][0] + d9 * dArray2[n][2];
                    dArray2[n][0] = d7;
                }
            }
            if (d5 == 0.0) continue;
            d13 = (d6 - d4) * 0.5 / d5;
            d12 = d13 * d13;
            d11 = d12 + 1.0;
            d10 = d11 != d12 ? (d13 < 0.0 ? -1.0 : 1.0) * (Math.sqrt(d11) - Math.abs(d13)) : 0.5 / d13;
            d9 = 1.0 / Math.sqrt(d10 * d10 + 1.0);
            d8 = d9 * d10;
            d4 -= d10 * d5;
            d6 += d10 * d5;
            d5 = 0.0;
            d7 = d9 * d2 - d8 * d3;
            d3 = d8 * d2 + d9 * d3;
            d2 = d7;
            for (n = 0; n < 3; ++n) {
                d7 = d9 * dArray2[n][1] - d8 * dArray2[n][2];
                dArray2[n][2] = d8 * dArray2[n][1] + d9 * dArray2[n][2];
                dArray2[n][1] = d7;
            }
        }
        dArray[0] = d;
        dArray[1] = d4;
        dArray[2] = d6;
        vec4Array[0] = new Vec4(dArray2[0][0], dArray2[1][0], dArray2[2][0]);
        vec4Array[1] = new Vec4(dArray2[0][1], dArray2[1][1], dArray2[2][1]);
        vec4Array[2] = new Vec4(dArray2[0][2], dArray2[1][2], dArray2[2][2]);
    }

    public final Matrix add(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Matrix(this.m11 + matrix.m11, this.m12 + matrix.m12, this.m13 + matrix.m13, this.m14 + matrix.m14, this.m21 + matrix.m21, this.m22 + matrix.m22, this.m23 + matrix.m23, this.m24 + matrix.m24, this.m31 + matrix.m31, this.m32 + matrix.m32, this.m33 + matrix.m33, this.m34 + matrix.m34, this.m41 + matrix.m41, this.m42 + matrix.m42, this.m43 + matrix.m43, this.m44 + matrix.m44);
    }

    public final Matrix subtract(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Matrix(this.m11 - matrix.m11, this.m12 - matrix.m12, this.m13 - matrix.m13, this.m14 - matrix.m14, this.m21 - matrix.m21, this.m22 - matrix.m22, this.m23 - matrix.m23, this.m24 - matrix.m24, this.m31 - matrix.m31, this.m32 - matrix.m32, this.m33 - matrix.m33, this.m34 - matrix.m34, this.m41 - matrix.m41, this.m42 - matrix.m42, this.m43 - matrix.m43, this.m44 - matrix.m44);
    }

    public final Matrix multiplyComponents(double d) {
        return new Matrix(this.m11 * d, this.m12 * d, this.m13 * d, this.m14 * d, this.m21 * d, this.m22 * d, this.m23 * d, this.m24 * d, this.m31 * d, this.m32 * d, this.m33 * d, this.m34 * d, this.m41 * d, this.m42 * d, this.m43 * d, this.m44 * d);
    }

    public final Matrix multiply(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Matrix(this.m11 * matrix.m11 + this.m12 * matrix.m21 + this.m13 * matrix.m31 + this.m14 * matrix.m41, this.m11 * matrix.m12 + this.m12 * matrix.m22 + this.m13 * matrix.m32 + this.m14 * matrix.m42, this.m11 * matrix.m13 + this.m12 * matrix.m23 + this.m13 * matrix.m33 + this.m14 * matrix.m43, this.m11 * matrix.m14 + this.m12 * matrix.m24 + this.m13 * matrix.m34 + this.m14 * matrix.m44, this.m21 * matrix.m11 + this.m22 * matrix.m21 + this.m23 * matrix.m31 + this.m24 * matrix.m41, this.m21 * matrix.m12 + this.m22 * matrix.m22 + this.m23 * matrix.m32 + this.m24 * matrix.m42, this.m21 * matrix.m13 + this.m22 * matrix.m23 + this.m23 * matrix.m33 + this.m24 * matrix.m43, this.m21 * matrix.m14 + this.m22 * matrix.m24 + this.m23 * matrix.m34 + this.m24 * matrix.m44, this.m31 * matrix.m11 + this.m32 * matrix.m21 + this.m33 * matrix.m31 + this.m34 * matrix.m41, this.m31 * matrix.m12 + this.m32 * matrix.m22 + this.m33 * matrix.m32 + this.m34 * matrix.m42, this.m31 * matrix.m13 + this.m32 * matrix.m23 + this.m33 * matrix.m33 + this.m34 * matrix.m43, this.m31 * matrix.m14 + this.m32 * matrix.m24 + this.m33 * matrix.m34 + this.m34 * matrix.m44, this.m41 * matrix.m11 + this.m42 * matrix.m21 + this.m43 * matrix.m31 + this.m44 * matrix.m41, this.m41 * matrix.m12 + this.m42 * matrix.m22 + this.m43 * matrix.m32 + this.m44 * matrix.m42, this.m41 * matrix.m13 + this.m42 * matrix.m23 + this.m43 * matrix.m33 + this.m44 * matrix.m43, this.m41 * matrix.m14 + this.m42 * matrix.m24 + this.m43 * matrix.m34 + this.m44 * matrix.m44, this.isOrthonormalTransform && matrix.isOrthonormalTransform);
    }

    public final Matrix divideComponents(double d) {
        if (Matrix.isZero(d)) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Matrix(this.m11 / d, this.m12 / d, this.m13 / d, this.m14 / d, this.m21 / d, this.m22 / d, this.m23 / d, this.m24 / d, this.m31 / d, this.m32 / d, this.m33 / d, this.m34 / d, this.m41 / d, this.m42 / d, this.m43 / d, this.m44 / d);
    }

    public final Matrix divideComponents(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Matrix(this.m11 / matrix.m11, this.m12 / matrix.m12, this.m13 / matrix.m13, this.m14 / matrix.m14, this.m21 / matrix.m21, this.m22 / matrix.m22, this.m23 / matrix.m23, this.m24 / matrix.m24, this.m31 / matrix.m31, this.m32 / matrix.m32, this.m33 / matrix.m33, this.m34 / matrix.m34, this.m41 / matrix.m41, this.m42 / matrix.m42, this.m43 / matrix.m43, this.m44 / matrix.m44);
    }

    public final Matrix negate() {
        return new Matrix(0.0 - this.m11, 0.0 - this.m12, 0.0 - this.m13, 0.0 - this.m14, 0.0 - this.m21, 0.0 - this.m22, 0.0 - this.m23, 0.0 - this.m24, 0.0 - this.m31, 0.0 - this.m32, 0.0 - this.m33, 0.0 - this.m34, 0.0 - this.m41, 0.0 - this.m42, 0.0 - this.m43, 0.0 - this.m44, this.isOrthonormalTransform);
    }

    public final Vec4 transformBy3(Matrix matrix, double d, double d2, double d3) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(matrix.m11 * d + matrix.m12 * d2 + matrix.m13 * d3, matrix.m21 * d + matrix.m22 * d2 + matrix.m23 * d3, matrix.m31 * d + matrix.m32 * d2 + matrix.m33 * d3);
    }

    public final double getDeterminant() {
        double d = 0.0;
        d += this.m11 * (this.m22 * (this.m33 * this.m44 - this.m43 * this.m34) - this.m23 * (this.m32 * this.m44 - this.m42 * this.m34) + this.m24 * (this.m32 * this.m43 - this.m42 * this.m33));
        d -= this.m12 * (this.m21 * (this.m33 * this.m44 - this.m43 * this.m34) - this.m23 * (this.m31 * this.m44 - this.m41 * this.m34) + this.m24 * (this.m31 * this.m43 - this.m41 * this.m33));
        d += this.m13 * (this.m21 * (this.m32 * this.m44 - this.m42 * this.m34) - this.m22 * (this.m31 * this.m44 - this.m41 * this.m34) + this.m24 * (this.m31 * this.m42 - this.m41 * this.m32));
        return d -= this.m14 * (this.m21 * (this.m32 * this.m43 - this.m42 - this.m33) - this.m22 * (this.m31 * this.m43 - this.m41 * this.m33) + this.m23 * (this.m31 * this.m42 - this.m41 * this.m32));
    }

    public final Matrix getTranspose() {
        return new Matrix(this.m11, this.m21, this.m31, this.m41, this.m12, this.m22, this.m32, this.m42, this.m13, this.m23, this.m33, this.m43, this.m14, this.m24, this.m34, this.m44, false);
    }

    public final double getTrace() {
        return this.m11 + this.m22 + this.m33 + this.m44;
    }

    public final Matrix getInverse() {
        if (this.isOrthonormalTransform) {
            return Matrix.computeTransformInverse(this);
        }
        return Matrix.computeGeneralInverse(this);
    }

    private static Matrix computeTransformInverse(Matrix matrix) {
        return new Matrix(matrix.m11, matrix.m21, matrix.m31, 0.0 - matrix.m11 * matrix.m14 - matrix.m21 * matrix.m24 - matrix.m31 * matrix.m34, matrix.m12, matrix.m22, matrix.m32, 0.0 - matrix.m12 * matrix.m14 - matrix.m22 * matrix.m24 - matrix.m32 * matrix.m34, matrix.m13, matrix.m23, matrix.m33, 0.0 - matrix.m13 * matrix.m14 - matrix.m23 * matrix.m24 - matrix.m33 * matrix.m34, 0.0, 0.0, 0.0, 1.0, false);
    }

    private static Matrix computeGeneralInverse(Matrix matrix) {
        double[][] dArray = new double[4][4];
        dArray[0][0] = matrix.m11;
        dArray[0][1] = matrix.m12;
        dArray[0][2] = matrix.m13;
        dArray[0][3] = matrix.m14;
        dArray[1][0] = matrix.m21;
        dArray[1][1] = matrix.m22;
        dArray[1][2] = matrix.m23;
        dArray[1][3] = matrix.m24;
        dArray[2][0] = matrix.m31;
        dArray[2][1] = matrix.m32;
        dArray[2][2] = matrix.m33;
        dArray[2][3] = matrix.m34;
        dArray[3][0] = matrix.m41;
        dArray[3][1] = matrix.m42;
        dArray[3][2] = matrix.m43;
        dArray[3][3] = matrix.m44;
        int[] nArray = new int[4];
        double d = Matrix.ludcmp(dArray, nArray);
        for (int i = 0; i < 4; ++i) {
            d *= dArray[i][i];
        }
        if (Math.abs(d) < 1.0E-8) {
            return null;
        }
        double[][] dArray2 = new double[4][4];
        double[] dArray3 = new double[4];
        for (int i = 0; i < 4; ++i) {
            int n;
            for (n = 0; n < 4; ++n) {
                dArray3[n] = 0.0;
            }
            dArray3[i] = 1.0;
            Matrix.lubksb(dArray, nArray, dArray3);
            for (n = 0; n < 4; ++n) {
                dArray2[n][i] = dArray3[n];
            }
        }
        return new Matrix(dArray2[0][0], dArray2[0][1], dArray2[0][2], dArray2[0][3], dArray2[1][0], dArray2[1][1], dArray2[1][2], dArray2[1][3], dArray2[2][0], dArray2[2][1], dArray2[2][2], dArray2[2][3], dArray2[3][0], dArray2[3][1], dArray2[3][2], dArray2[3][3]);
    }

    private static void lubksb(double[][] dArray, int[] nArray, double[] dArray2) {
        int n;
        int n2 = -1;
        for (n = 0; n < 4; ++n) {
            int n3 = nArray[n];
            double d = dArray2[n3];
            dArray2[n3] = dArray2[n];
            if (n2 != -1) {
                for (int i = n2; i <= n - 1; ++i) {
                    d -= dArray[n][i] * dArray2[i];
                }
            } else if (d != 0.0) {
                n2 = n;
            }
            dArray2[n] = d;
        }
        for (n = 3; n >= 0; --n) {
            double d = dArray2[n];
            for (int i = n + 1; i < 4; ++i) {
                d -= dArray[n][i] * dArray2[i];
            }
            dArray2[n] = d / dArray[n][n];
        }
    }

    private static double ludcmp(double[][] dArray, int[] nArray) {
        double[] dArray2 = new double[4];
        double d = 1.0;
        for (int i = 0; i < 4; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < 4; ++j) {
                double d3;
                double d4 = Math.abs(dArray[i][j]);
                if (!(d3 > d2)) continue;
                d2 = d4;
            }
            if (d2 == 0.0) {
                return 0.0;
            }
            dArray2[i] = 1.0 / d2;
        }
        for (int i = 0; i < 4; ++i) {
            double d5;
            int n;
            for (int j = 0; j < i; ++j) {
                double d6 = dArray[j][i];
                for (int k = 0; k < j; ++k) {
                    d6 -= dArray[j][k] * dArray[k][i];
                }
                dArray[j][i] = d6;
            }
            double d7 = 0.0;
            int n2 = -1;
            for (n = i; n < 4; ++n) {
                double d8;
                double d9 = dArray[n][i];
                for (int j = 0; j < i; ++j) {
                    d9 -= dArray[n][j] * dArray[j][i];
                }
                dArray[n][i] = d9;
                d5 = dArray2[n] * Math.abs(d9);
                if (!(d8 >= d7)) continue;
                d7 = d5;
                n2 = n;
            }
            if (i != n2) {
                for (n = 0; n < 4; ++n) {
                    d5 = dArray[n2][n];
                    dArray[n2][n] = dArray[i][n];
                    dArray[i][n] = d5;
                }
                d = -d;
                dArray2[n2] = dArray2[i];
            }
            nArray[i] = n2;
            if (dArray[i][i] == 0.0) {
                dArray[i][i] = 1.0E-20;
            }
            if (i == 3) continue;
            d5 = 1.0 / dArray[i][i];
            for (n = i + 1; n < 4; ++n) {
                double[] dArray3 = dArray[n];
                int n3 = i;
                dArray3[n3] = dArray3[n3] * d5;
            }
        }
        return d;
    }

    public final Angle getRotationX() {
        double d = Math.asin(this.m13);
        double d2 = Math.cos(d);
        if (Matrix.isZero(d2)) {
            return null;
        }
        double d3 = Math.abs(d2) > 0.005 ? Math.atan2(-this.m23 / d2, this.m33 / d2) : 0.0;
        if (Double.isNaN(d3)) {
            return null;
        }
        return Angle.fromRadians(d3);
    }

    public final Angle getRotationY() {
        double d = Math.asin(this.m13);
        if (Double.isNaN(d)) {
            return null;
        }
        return Angle.fromRadians(d);
    }

    public final Angle getRotationZ() {
        double d = Math.asin(this.m13);
        double d2 = Math.cos(d);
        if (Matrix.isZero(d2)) {
            return null;
        }
        double d3 = Math.abs(d2) > 0.005 ? Math.atan2(-this.m12 / d2, this.m11 / d2) : Math.atan2(this.m21, this.m22);
        if (Double.isNaN(d3)) {
            return null;
        }
        return Angle.fromRadians(d3);
    }

    public final Angle getKMLRotationX() {
        double d = Math.asin(-this.m23);
        if (Double.isNaN(d)) {
            return null;
        }
        return Angle.fromRadians(-d);
    }

    public final Angle getKMLRotationY() {
        double d = Math.asin(-this.m23);
        if (Double.isNaN(d)) {
            return null;
        }
        double d2 = d < 1.5707963267948966 ? (d > -1.5707963267948966 ? Math.atan2(this.m13, this.m33) : -Math.atan2(-this.m12, this.m11)) : Math.atan2(-this.m12, this.m11);
        if (Double.isNaN(d2)) {
            return null;
        }
        return Angle.fromRadians(-d2);
    }

    public final Angle getKMLRotationZ() {
        double d = Math.asin(-this.m23);
        if (Double.isNaN(d)) {
            return null;
        }
        double d2 = d < 1.5707963267948966 && d > -1.5707963267948966 ? Math.atan2(this.m21, this.m22) : 0.0;
        if (Double.isNaN(d2)) {
            return null;
        }
        return Angle.fromRadians(-d2);
    }

    public final Vec4 getTranslation() {
        return new Vec4(this.m14, this.m24, this.m34);
    }

    private static boolean isZero(double d) {
        return POSITIVE_ZERO.compareTo(d) == 0 || NEGATIVE_ZERO.compareTo(d) == 0;
    }
}

