/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LatLon {
    public static final LatLon ZERO = new LatLon(Angle.ZERO, Angle.ZERO);
    public final Angle latitude;
    public final Angle longitude;

    public static LatLon fromRadians(double d, double d2) {
        return new LatLon(Math.toDegrees(d), Math.toDegrees(d2));
    }

    public static LatLon fromDegrees(double d, double d2) {
        return new LatLon(d, d2);
    }

    private LatLon(double d, double d2) {
        this.latitude = Angle.fromDegrees(d);
        this.longitude = Angle.fromDegrees(d2);
    }

    public LatLon(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = angle;
        this.longitude = angle2;
    }

    public LatLon(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = latLon.latitude;
        this.longitude = latLon.longitude;
    }

    public final Angle getLatitude() {
        return this.latitude;
    }

    public final Angle getLongitude() {
        return this.longitude;
    }

    public double[] asDegreesArray() {
        return new double[]{this.getLatitude().degrees, this.getLongitude().degrees};
    }

    public double[] asRadiansArray() {
        return new double[]{this.getLatitude().radians, this.getLongitude().radians};
    }

    public static LatLon interpolate(String string, double d, LatLon latLon, LatLon latLon2) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathTypeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (latLon == null || latLon2 == null) {
            String string3 = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string.equals("gov.nasa.worldwind.avkey.GreatCircle")) {
            return LatLon.interpolateGreatCircle(d, latLon, latLon2);
        }
        if (string.equals("gov.nasa.worldwind.avkey.RhumbLine") || string.equals("gov.nasa.worldwind.avkey.Loxodrome")) {
            return LatLon.interpolateRhumb(d, latLon, latLon2);
        }
        return LatLon.interpolate(d, latLon, latLon2);
    }

    public static LatLon interpolate(double d, LatLon latLon, LatLon latLon2) {
        Line line;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (LatLon.equals(latLon, latLon2)) {
            return latLon;
        }
        try {
            line = Line.fromSegment(new Vec4(latLon.getLongitude().radians, latLon.getLatitude().radians, 0.0), new Vec4(latLon2.getLongitude().radians, latLon2.getLatitude().radians, 0.0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return latLon;
        }
        Vec4 vec4 = line.getPointAt(d);
        return LatLon.fromRadians(vec4.y(), vec4.x);
    }

    public static LatLon interpolateGreatCircle(double d, LatLon latLon, LatLon latLon2) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (LatLon.equals(latLon, latLon2)) {
            return latLon;
        }
        double d2 = WWMath.clamp(d, 0.0, 1.0);
        Angle angle = LatLon.greatCircleAzimuth(latLon, latLon2);
        Angle angle2 = LatLon.greatCircleDistance(latLon, latLon2);
        Angle angle3 = Angle.fromDegrees(d2 * angle2.degrees);
        return LatLon.greatCircleEndPosition(latLon, angle, angle3);
    }

    public static LatLon interpolateRhumb(double d, LatLon latLon, LatLon latLon2) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (LatLon.equals(latLon, latLon2)) {
            return latLon;
        }
        double d2 = WWMath.clamp(d, 0.0, 1.0);
        Angle angle = LatLon.rhumbAzimuth(latLon, latLon2);
        Angle angle2 = LatLon.rhumbDistance(latLon, latLon2);
        Angle angle3 = Angle.fromDegrees(d2 * angle2.degrees);
        return LatLon.rhumbEndPosition(latLon, angle, angle3);
    }

    public static Angle greatCircleDistance(LatLon latLon, LatLon latLon2) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().radians;
        double d2 = latLon.getLongitude().radians;
        double d3 = latLon2.getLatitude().radians;
        double d4 = latLon2.getLongitude().radians;
        if (d == d3 && d2 == d4) {
            return Angle.ZERO;
        }
        double d5 = Math.sin((d3 - d) / 2.0);
        double d6 = Math.sin((d4 - d2) / 2.0);
        double d7 = d5 * d5 + Math.cos(d) * Math.cos(d3) * d6 * d6;
        double d8 = 2.0 * Math.asin(Math.sqrt(d7));
        return Double.isNaN(d8) ? Angle.ZERO : Angle.fromRadians(d8);
    }

    public static Angle greatCircleAzimuth(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = latLon.getLatitude().radians;
        double d3 = latLon.getLongitude().radians;
        double d4 = latLon2.getLatitude().radians;
        double d5 = latLon2.getLongitude().radians;
        if (d2 == d4 && d3 == d5) {
            return Angle.ZERO;
        }
        if (d3 == d5) {
            return d2 > d4 ? Angle.POS180 : Angle.ZERO;
        }
        double d6 = Math.cos(d4) * Math.sin(d5 - d3);
        double d7 = Math.atan2(d6, d = Math.cos(d2) * Math.sin(d4) - Math.sin(d2) * Math.cos(d4) * Math.cos(d5 - d3));
        return Double.isNaN(d7) ? Angle.ZERO : Angle.fromRadians(d7);
    }

    public static LatLon greatCircleEndPosition(LatLon latLon, Angle angle, Angle angle2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().radians;
        double d2 = latLon.getLongitude().radians;
        double d3 = angle.radians;
        double d4 = angle2.radians;
        if (d4 == 0.0) {
            return latLon;
        }
        double d5 = Math.asin(Math.sin(d) * Math.cos(d4) + Math.cos(d) * Math.sin(d4) * Math.cos(d3));
        double d6 = d2 + Math.atan2(Math.sin(d4) * Math.sin(d3), Math.cos(d) * Math.cos(d4) - Math.sin(d) * Math.sin(d4) * Math.cos(d3));
        if (Double.isNaN(d5) || Double.isNaN(d6)) {
            return latLon;
        }
        return new LatLon(Angle.fromRadians(d5).normalizedLatitude(), Angle.fromRadians(d6).normalizedLongitude());
    }

    public static LatLon greatCircleEndPosition(LatLon latLon, double d, double d2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return LatLon.greatCircleEndPosition(latLon, Angle.fromRadians(d), Angle.fromRadians(d2));
    }

    public static LatLon[] greatCircleExtremeLocations(LatLon latLon, Angle angle) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LocationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AzimuthIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().radians;
        double d2 = angle.radians;
        double d3 = -Math.tan(d) / Math.cos(d2);
        double d4 = Math.atan(d3);
        Angle angle2 = Angle.fromRadians(d4 + 1.5707963267948966);
        Angle angle3 = Angle.fromRadians(d4 - 1.5707963267948966);
        return new LatLon[]{LatLon.greatCircleEndPosition(latLon, angle, angle2), LatLon.greatCircleEndPosition(latLon, angle, angle3)};
    }

    public static LatLon[] greatCircleArcExtremeLocations(LatLon latLon, LatLon latLon2) {
        LatLon[] latLonArray;
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.BeginIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = Logging.getMessage("nullValue.EndIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon object2 = null;
        LatLon object3 = null;
        double d = Angle.POS90.degrees;
        double d2 = Angle.NEG90.degrees;
        for (LatLon object4 : Arrays.asList(latLon, latLon2)) {
            if (d >= object4.getLatitude().degrees) {
                d = object4.getLatitude().degrees;
                object2 = object4;
            }
            if (!(d2 <= object4.getLatitude().degrees)) continue;
            d2 = object4.getLatitude().degrees;
            object3 = object4;
        }
        Angle angle = LatLon.greatCircleAzimuth(latLon, latLon2);
        Angle angle2 = LatLon.greatCircleDistance(latLon, latLon2);
        for (LatLon latLon3 : latLonArray = LatLon.greatCircleExtremeLocations(latLon, angle)) {
            Angle angle3 = LatLon.greatCircleAzimuth(latLon, latLon3);
            Angle angle4 = LatLon.greatCircleDistance(latLon, latLon3);
            if (Math.signum(angle3.degrees) != Math.signum(angle.degrees) || !(angle4.degrees >= 0.0) || !(angle4.degrees <= angle2.degrees)) continue;
            if (d >= latLon3.getLatitude().degrees) {
                d = latLon3.getLatitude().degrees;
                object2 = latLon3;
            }
            if (!(d2 <= latLon3.getLatitude().degrees)) continue;
            d2 = latLon3.getLatitude().degrees;
            object3 = latLon3;
        }
        return new LatLon[]{object2, object3};
    }

    public static LatLon[] greatCircleArcExtremeLocations(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = null;
        LatLon latLon2 = null;
        LatLon latLon3 = null;
        for (LatLon latLon4 : iterable) {
            if (latLon3 != null) {
                LatLon[] latLonArray = LatLon.greatCircleArcExtremeLocations(latLon3, latLon4);
                if (latLonArray == null) continue;
                if (latLon == null || latLon.getLatitude().degrees > latLonArray[0].getLatitude().degrees) {
                    latLon = latLonArray[0];
                }
                if (latLon2 == null || latLon2.getLatitude().degrees < latLonArray[1].getLatitude().degrees) {
                    latLon2 = latLonArray[1];
                }
            }
            latLon3 = latLon4;
        }
        return new LatLon[]{latLon, latLon2};
    }

    public static Angle rhumbDistance(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = latLon.getLatitude().radians;
        double d3 = latLon.getLongitude().radians;
        double d4 = latLon2.getLatitude().radians;
        double d5 = latLon2.getLongitude().radians;
        if (d2 == d4 && d3 == d5) {
            return Angle.ZERO;
        }
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        double d8 = Math.log(Math.tan(d4 / 2.0 + 0.7853981633974483) / Math.tan(d2 / 2.0 + 0.7853981633974483));
        double d9 = d6 / d8;
        if (Double.isNaN(d8) || Double.isNaN(d9)) {
            d9 = Math.cos(d2);
        }
        if (Math.abs(d7) > Math.PI) {
            d7 = d7 > 0.0 ? -(Math.PI * 2 - d7) : Math.PI * 2 + d7;
        }
        return Double.isNaN(d = Math.sqrt(d6 * d6 + d9 * d9 * d7 * d7)) ? Angle.ZERO : Angle.fromRadians(d);
    }

    public static Angle rhumbAzimuth(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = latLon.getLatitude().radians;
        double d3 = latLon.getLongitude().radians;
        double d4 = latLon2.getLatitude().radians;
        double d5 = latLon2.getLongitude().radians;
        if (d2 == d4 && d3 == d5) {
            return Angle.ZERO;
        }
        double d6 = d5 - d3;
        double d7 = Math.log(Math.tan(d4 / 2.0 + 0.7853981633974483) / Math.tan(d2 / 2.0 + 0.7853981633974483));
        if (Math.abs(d6) > Math.PI) {
            d6 = d6 > 0.0 ? -(Math.PI * 2 - d6) : Math.PI * 2 + d6;
        }
        return Double.isNaN(d = Math.atan2(d6, d7)) ? Angle.ZERO : Angle.fromRadians(d);
    }

    public static LatLon rhumbEndPosition(LatLon latLon, Angle angle, Angle angle2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().radians;
        double d2 = latLon.getLongitude().radians;
        double d3 = angle.radians;
        double d4 = angle2.radians;
        if (d4 == 0.0) {
            return latLon;
        }
        double d5 = d + d4 * Math.cos(d3);
        double d6 = Math.log(Math.tan(d5 / 2.0 + 0.7853981633974483) / Math.tan(d / 2.0 + 0.7853981633974483));
        double d7 = (d5 - d) / d6;
        if (Double.isNaN(d6) || Double.isNaN(d7) || Double.isInfinite(d7)) {
            d7 = Math.cos(d);
        }
        double d8 = d4 * Math.sin(d3) / d7;
        if (Math.abs(d5) > 1.5707963267948966) {
            d5 = d5 > 0.0 ? Math.PI - d5 : -Math.PI - d5;
        }
        double d9 = (d2 + d8 + Math.PI) % (Math.PI * 2) - Math.PI;
        if (Double.isNaN(d5) || Double.isNaN(d9)) {
            return latLon;
        }
        return new LatLon(Angle.fromRadians(d5).normalizedLatitude(), Angle.fromRadians(d9).normalizedLongitude());
    }

    public static LatLon rhumbEndPosition(LatLon latLon, double d, double d2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return LatLon.rhumbEndPosition(latLon, Angle.fromRadians(d), Angle.fromRadians(d2));
    }

    public static Angle linearDistance(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = latLon.getLatitude().radians;
        double d3 = latLon.getLongitude().radians;
        double d4 = latLon2.getLatitude().radians;
        double d5 = latLon2.getLongitude().radians;
        if (d2 == d4 && d3 == d5) {
            return Angle.ZERO;
        }
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        if (Math.abs(d7) > Math.PI) {
            d7 = d7 > 0.0 ? -(Math.PI * 2 - d7) : Math.PI * 2 + d7;
        }
        return Double.isNaN(d = Math.hypot(d6, d7)) ? Angle.ZERO : Angle.fromRadians(d);
    }

    public static Angle linearAzimuth(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = latLon.getLatitude().radians;
        double d3 = latLon.getLongitude().radians;
        double d4 = latLon2.getLatitude().radians;
        double d5 = latLon2.getLongitude().radians;
        if (d2 == d4 && d3 == d5) {
            return Angle.ZERO;
        }
        double d6 = d5 - d3;
        double d7 = d4 - d2;
        if (Math.abs(d6) > Math.PI) {
            d6 = d6 > 0.0 ? -(Math.PI * 2 - d6) : Math.PI * 2 + d6;
        }
        return Double.isNaN(d = Math.atan2(d6, d7)) ? Angle.ZERO : Angle.fromRadians(d);
    }

    public static LatLon linearEndPosition(LatLon latLon, Angle angle, Angle angle2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().radians;
        double d2 = latLon.getLongitude().radians;
        double d3 = angle.radians;
        double d4 = angle2.radians;
        if (d4 == 0.0) {
            return latLon;
        }
        double d5 = d + d4 * Math.cos(d3);
        if (Math.abs(d5) > 1.5707963267948966) {
            d5 = d5 > 0.0 ? Math.PI - d5 : -Math.PI - d5;
        }
        double d6 = (d2 + d4 * Math.sin(d3) + Math.PI) % (Math.PI * 2) - Math.PI;
        if (Double.isNaN(d5) || Double.isNaN(d6)) {
            return latLon;
        }
        return new LatLon(Angle.fromRadians(d5).normalizedLatitude(), Angle.fromRadians(d6).normalizedLongitude());
    }

    public static Angle getAverageDistance(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = 0.0;
        int n = 0;
        for (LatLon latLon : iterable) {
            for (LatLon latLon2 : iterable) {
                if (latLon == latLon2) continue;
                double d2 = LatLon.rhumbDistance((LatLon)latLon, (LatLon)latLon2).radians;
                d += d2;
                ++n;
            }
        }
        return n == 0 ? Angle.ZERO : Angle.fromRadians(d / (double)n);
    }

    public LatLon add(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.normalizedLatitude(this.latitude.add(latLon.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.add(latLon.longitude));
        return new LatLon(angle, angle2);
    }

    public LatLon subtract(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.normalizedLatitude(this.latitude.subtract(latLon.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.subtract(latLon.longitude));
        return new LatLon(angle, angle2);
    }

    public LatLon add(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.normalizedLatitude(this.latitude.add(position.getLatitude()));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.add(position.getLongitude()));
        return new LatLon(angle, angle2);
    }

    public LatLon subtract(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.normalizedLatitude(this.latitude.subtract(position.getLatitude()));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.subtract(position.getLongitude()));
        return new LatLon(angle, angle2);
    }

    public static boolean locationsCrossDateLine(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = null;
        for (LatLon latLon2 : iterable) {
            double d;
            if (latLon != null && Math.signum(latLon.getLongitude().degrees) != Math.signum(latLon2.getLongitude().degrees) && (d = Math.abs(latLon.getLongitude().degrees - latLon2.getLongitude().degrees)) > 180.0 && d < 360.0) {
                return true;
            }
            latLon = latLon2;
        }
        return false;
    }

    public static boolean locationsCrossDateline(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LocationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Math.signum(latLon.getLongitude().degrees) != Math.signum(latLon2.getLongitude().degrees) && (d = Math.abs(latLon.getLongitude().degrees - latLon2.getLongitude().degrees)) > 180.0 && d < 360.0;
    }

    public static List<LatLon> makeDatelineCrossingLocationsPositive(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends LatLon> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon : iterable) {
            if (latLon == null) continue;
            if (latLon.getLongitude().degrees < 0.0) {
                arrayList.add(LatLon.fromDegrees(latLon.getLatitude().degrees, latLon.getLongitude().degrees + 360.0));
                continue;
            }
            arrayList.add(latLon);
        }
        return arrayList;
    }

    public LatLon parseLatLon(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        String string = String.format("Lat %7.4f\u00b0", this.getLatitude().getDegrees());
        String string2 = String.format("Lon %7.4f\u00b0", this.getLongitude().getDegrees());
        return "(" + string + ", " + string2 + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LatLon latLon = (LatLon)object;
        if (!this.latitude.equals(latLon.latitude)) {
            return false;
        }
        return this.longitude.equals(latLon.longitude);
    }

    public static boolean equals(LatLon latLon, LatLon latLon2) {
        return latLon.getLatitude().equals(latLon2.getLatitude()) && latLon.getLongitude().equals(latLon2.getLongitude());
    }

    public int hashCode() {
        int n = this.latitude.hashCode();
        n = 29 * n + this.longitude.hashCode();
        return n;
    }

    public static Angle ellipsoidalForwardAzimuth(LatLon latLon, LatLon latLon2, double d, double d2) {
        double d3;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d4 = (d - d2) / d;
        double d5 = Math.atan((1.0 - d4) * Math.tan(latLon.latitude.radians));
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        double d8 = Math.atan((1.0 - d4) * Math.tan(latLon2.latitude.radians));
        double d9 = Math.cos(d8);
        double d10 = Math.sin(d8);
        double d11 = d3 = latLon2.longitude.subtract((Angle)latLon.longitude).radians;
        double d12 = Math.sin(d11);
        double d13 = Math.cos(d11);
        double d14 = Double.MAX_VALUE;
        int n = 0;
        while (Math.abs(d11 - d14) > 1.0E-12 && n++ < 100) {
            d14 = d11;
            double d15 = Math.sqrt(Math.pow(d9 * d12, 2.0) + Math.pow(d6 * d10 - d7 * d9 * d13, 2.0));
            double d16 = d7 * d10 + d6 * d9 * d13;
            double d17 = Math.atan2(d15, d16);
            double d18 = d6 * d9 * d12 / d15;
            double d19 = 1.0 - d18 * d18;
            double d20 = Math.abs(d19) < 1.0E-6 ? 0.0 : d16 - 2.0 * d7 * d10 / d19;
            double d21 = d4 / 16.0 * d19 * (4.0 + d4 * (4.0 - 3.0 * d19));
            d11 = d3 + (1.0 - d21) * d4 * d18 * (d17 + d21 * d15 * (d20 + d21 * d16 * (-1.0 + 2.0 * d20)));
            d12 = Math.sin(d11);
            d13 = Math.cos(d11);
        }
        return Angle.fromRadians(Math.atan2(d9 * d12, d6 * d10 - d7 * d9 * d13));
    }

    public static double ellipsoidalDistance(LatLon latLon, LatLon latLon2, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11 = (d - d2) / d;
        double d12 = 1.0 - d11;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d13 = latLon.getLatitude().radians;
        double d14 = latLon2.getLatitude().radians;
        double d15 = d12 * Math.sin(d13) / Math.cos(d13);
        double d16 = d12 * Math.sin(d14) / Math.cos(d14);
        double d17 = 1.0 / Math.sqrt(d15 * d15 + 1.0);
        double d18 = d17 * d15;
        double d19 = 1.0 / Math.sqrt(d16 * d16 + 1.0);
        double d20 = d17 * d19;
        double d21 = d20 * d16;
        double d22 = d21 * d15;
        double d23 = latLon.getLongitude().radians;
        double d24 = latLon2.getLongitude().radians;
        double d25 = d24 - d23;
        do {
            double d26 = Math.sin(d25);
            double d27 = Math.cos(d25);
            d15 = d19 * d26;
            d16 = d21 - d18 * d19 * d27;
            d8 = Math.sqrt(d15 * d15 + d16 * d16);
            d7 = d20 * d27 + d22;
            d6 = Math.atan2(d8, d7);
            double d28 = d20 * d26 / d8;
            d5 = -d28 * d28 + 1.0;
            d4 = d22 + d22;
            if (d5 > 0.0) {
                d4 = -d4 / d5 + d7;
            }
            d3 = d4 * d4 * 2.0 - 1.0;
            d9 = ((-3.0 * d5 + 4.0) * d11 + 4.0) * d5 * d11 / 16.0;
            d10 = d25;
            d25 = ((d3 * d7 * d9 + d4) * d8 * d9 + d6) * d28;
        } while (Math.abs(d10 - (d25 = (1.0 - d9) * d25 * d11 + d24 - d23)) > 5.0E-14);
        d25 = Math.sqrt((1.0 / d12 / d12 - 1.0) * d5 + 1.0) + 1.0;
        d25 = (d25 - 2.0) / d25;
        d9 = 1.0 - d25;
        d9 = (d25 * d25 / 4.0 + 1.0) / d9;
        d10 = (0.375 * d25 * d25 - 1.0) * d25;
        d25 = d3 * d7;
        d20 = 1.0 - d3 - d3;
        d20 = ((((d8 * d8 * 4.0 - 3.0) * d20 * d4 * d10 / 6.0 - d25) * d10 / 4.0 + d4) * d8 * d10 + d6) * d9 * d * d12;
        return d20;
    }

    public static List<LatLon> computeShiftedLocations(Position position, Position position2, Iterable<? extends LatLon> iterable) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon : iterable) {
            Angle angle = LatLon.greatCircleDistance(position, latLon);
            Angle angle2 = LatLon.greatCircleAzimuth(position, latLon);
            arrayList.add(Position.greatCircleEndPosition((LatLon)position2, angle2, angle));
        }
        return arrayList;
    }
}

