/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFFeature;
import gov.nasa.worldwind.formats.vpf.VPFPrimitiveData;
import gov.nasa.worldwind.formats.vpf.VPFSymbolAttributes;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.VecBufferSequence;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;

public class VPFSurfaceArea
extends SurfacePolygon {
    protected VPFFeature feature;
    protected VPFPrimitiveData primitiveData;
    protected VecBufferSequence buffer;
    protected LatLon referenceLocation;
    protected Object interiorDisplayListCacheKey = new Object();

    public VPFSurfaceArea(VPFFeature vPFFeature, VPFPrimitiveData vPFPrimitiveData) {
        this.feature = vPFFeature;
        this.primitiveData = vPFPrimitiveData;
        this.buffer = VPFSurfaceArea.computeAreaFeatureCoords(vPFFeature, vPFPrimitiveData);
        this.referenceLocation = vPFFeature.getBounds().toSector().getCentroid();
    }

    protected static VecBufferSequence computeAreaFeatureCoords(VPFFeature vPFFeature, VPFPrimitiveData vPFPrimitiveData) {
        int n = VPFSurfaceArea.traverseAreaEdges(vPFFeature, vPFPrimitiveData, null);
        final IntBuffer intBuffer = IntBuffer.wrap(new int[n]);
        VPFSurfaceArea.traverseAreaEdges(vPFFeature, vPFPrimitiveData, new EdgeListener(){

            @Override
            public void nextEdge(int n, VPFPrimitiveData.EdgeInfo edgeInfo) {
                intBuffer.put(n);
            }
        });
        intBuffer.rewind();
        VecBufferSequence vecBufferSequence = vPFPrimitiveData.getPrimitiveCoords("edg");
        return (VecBufferSequence)vecBufferSequence.slice(intBuffer.array(), 0, n);
    }

    protected static int traverseAreaEdges(VPFFeature vPFFeature, VPFPrimitiveData vPFPrimitiveData, EdgeListener edgeListener) {
        int n = 0;
        String string = vPFFeature.getFeatureClass().getPrimitiveTableName();
        for (int n2 : vPFFeature.getPrimitiveIds()) {
            VPFPrimitiveData.FaceInfo faceInfo = (VPFPrimitiveData.FaceInfo)vPFPrimitiveData.getPrimitiveInfo(string, n2);
            VPFPrimitiveData.Ring ring = faceInfo.getOuterRing();
            n += VPFSurfaceArea.traverseRingEdges(ring, vPFPrimitiveData, edgeListener);
            for (VPFPrimitiveData.Ring ring2 : faceInfo.getInnerRings()) {
                n += VPFSurfaceArea.traverseRingEdges(ring2, vPFPrimitiveData, edgeListener);
            }
        }
        return n;
    }

    protected static int traverseRingEdges(VPFPrimitiveData.Ring ring, VPFPrimitiveData vPFPrimitiveData, EdgeListener edgeListener) {
        int n = 0;
        for (int n2 : ring.edgeId) {
            VPFPrimitiveData.EdgeInfo edgeInfo = (VPFPrimitiveData.EdgeInfo)vPFPrimitiveData.getPrimitiveInfo("edg", n2);
            if (edgeInfo.isOnTileBoundary()) continue;
            if (edgeListener != null) {
                edgeListener.nextEdge(n2, edgeInfo);
            }
            ++n;
        }
        return n;
    }

    @Override
    protected List<Sector> computeSectors(Globe globe) {
        Sector sector = this.feature.getBounds().toSector();
        if (sector == null || sector.equals(Sector.EMPTY_SECTOR)) {
            return null;
        }
        return Arrays.asList(sector);
    }

    @Override
    public Iterable<? extends LatLon> getLocations() {
        return this.buffer.getLocations();
    }

    @Override
    public void setLocations(Iterable<? extends LatLon> iterable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.referenceLocation, 0.0);
    }

    @Override
    protected void applyModelviewTransform(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        Matrix matrix = surfaceTileDrawContext.getModelviewMatrix();
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMultMatrixd(matrix.toArray(new double[16], 0, false), 0);
    }

    @Override
    protected ShapeAttributes createActiveAttributes() {
        return new VPFSymbolAttributes();
    }

    @Override
    protected void determineActiveGeometry(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
    }

    @Override
    protected void drawInterior(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.applyInteriorState(drawContext, surfaceTileDrawContext, this.getActiveAttributes(), this.getInteriorTexture(), LatLon.ZERO);
        int[] nArray = (int[])drawContext.getGpuResourceCache().get(this.interiorDisplayListCacheKey);
        if (nArray == null) {
            nArray = new int[]{gL2.glGenLists(1), 1};
            gL2.glNewList(nArray[0], 4864);
            Integer n = this.tessellateInterior(drawContext);
            gL2.glEndList();
            if (n == null) {
                gL2.glDeleteLists(nArray[0], nArray[1]);
                nArray = null;
            } else {
                drawContext.getGpuResourceCache().put(this.interiorDisplayListCacheKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.DisplayList", n.intValue());
            }
        }
        if (nArray != null) {
            gL2.glCallList(nArray[0]);
        }
    }

    @Override
    protected void drawOutline(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        this.applyOutlineState(drawContext, this.getActiveAttributes());
        this.buffer.bindAsVertexBuffer(drawContext);
        this.buffer.multiDrawArrays(drawContext, 3);
    }

    @Override
    protected WWTexture getInteriorTexture() {
        if (this.getActiveAttributes().getImageSource() == null) {
            this.texture = null;
        } else if (this.texture == null || this.texture.getImageSource() != this.getActiveAttributes().getImageSource()) {
            this.texture = new BasicWWTexture(this.getActiveAttributes().getImageSource(), ((VPFSymbolAttributes)this.getActiveAttributes()).isMipMapIconImage());
        }
        return this.texture;
    }

    @Override
    protected Integer tessellateInteriorVertices(GLUtessellator gLUtessellator) {
        GLU.gluTessProperty(gLUtessellator, 100140, 100133.0);
        GLU.gluTessBeginPolygon(gLUtessellator, null);
        int n = 0;
        String string = this.feature.getFeatureClass().getPrimitiveTableName();
        for (int n2 : this.feature.getPrimitiveIds()) {
            VPFPrimitiveData.FaceInfo faceInfo = (VPFPrimitiveData.FaceInfo)this.primitiveData.getPrimitiveInfo(string, n2);
            Integer n3 = this.tessellateRing(gLUtessellator, faceInfo.getOuterRing());
            if (n3 != null) {
                n += n3.intValue();
            }
            for (VPFPrimitiveData.Ring ring : faceInfo.getInnerRings()) {
                n3 = this.tessellateRing(gLUtessellator, ring);
                if (n3 == null) continue;
                n += n3.intValue();
            }
        }
        GLU.gluTessEndPolygon(gLUtessellator);
        return n;
    }

    protected Integer tessellateRing(GLUtessellator gLUtessellator, VPFPrimitiveData.Ring ring) {
        GLU.gluTessBeginContour(gLUtessellator);
        VecBufferSequence vecBufferSequence = this.primitiveData.getPrimitiveCoords("edg");
        int n = ring.getNumEdges();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            VecBuffer vecBuffer = vecBufferSequence.subBuffer(ring.getEdgeId(i));
            Iterable<double[]> iterable = ring.getEdgeOrientation(i) < 0 ? vecBuffer.getReverseCoords(3) : vecBuffer.getCoords(3);
            for (double[] dArray : iterable) {
                GLU.gluTessVertex(gLUtessellator, dArray, 0, dArray);
                n2 += 12;
            }
        }
        GLU.gluTessEndContour(gLUtessellator);
        return n2;
    }

    @Override
    protected void handleUnsuccessfulInteriorTessellation(DrawContext drawContext) {
        super.handleUnsuccessfulInteriorTessellation(drawContext);
        this.buffer = VecBufferSequence.emptyVecBufferSequence(2);
        this.onShapeChanged();
    }

    protected static interface EdgeListener {
        public void nextEdge(int var1, VPFPrimitiveData.EdgeInfo var2);
    }
}

