/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFSymbolAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class VPFLegendSupport {
    public BufferedImage createLegendImage(VPFSymbolAttributes vPFSymbolAttributes, int n, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (vPFSymbolAttributes.getFeatureType()) {
            case POINT: {
                this.drawPointLegend(vPFSymbolAttributes, graphics2D, n, n2, n3);
                break;
            }
            case LINE: {
                this.drawLineLegend(vPFSymbolAttributes, graphics2D, n, n2, n3);
                break;
            }
            case AREA: {
                this.drawAreaLegend(vPFSymbolAttributes, graphics2D, n, n2, n3);
            }
        }
        return bufferedImage;
    }

    protected void drawPointLegend(VPFSymbolAttributes vPFSymbolAttributes, Graphics2D graphics2D, int n, int n2, int n3) {
        if (vPFSymbolAttributes.getIconImageSource() == null) {
            return;
        }
        BufferedImage bufferedImage = this.getImage(vPFSymbolAttributes.getIconImageSource());
        if (bufferedImage != null) {
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            int n6 = n - n3 * 2;
            int n7 = n2 - n3 * 2;
            float f = n4 > n6 ? (float)n6 / (float)n4 : 1.0f;
            float f2 = n5 > n7 ? (float)n7 / (float)n5 : 1.0f;
            float f3 = Math.min(f, f2);
            n4 = (int)((float)n4 * f3);
            n5 = (int)((float)n5 * f3);
            int n8 = n4 < n6 ? n3 + (n6 - n4) / 2 : n3;
            int n9 = n5 < n7 ? n3 + (n7 - n5) / 2 : n3;
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage, n8, n9, n4, n5, null);
        }
    }

    protected void drawLineLegend(VPFSymbolAttributes vPFSymbolAttributes, Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.setStroke(this.getStroke(vPFSymbolAttributes));
        graphics2D.setPaint(vPFSymbolAttributes.getOutlineMaterial().getDiffuse());
        graphics2D.drawLine(n3, n2 / 2, n - n3, n2 / 2);
    }

    protected void drawAreaLegend(VPFSymbolAttributes vPFSymbolAttributes, Graphics2D graphics2D, int n, int n2, int n3) {
        if (vPFSymbolAttributes.isDrawInterior()) {
            graphics2D.setPaint(this.getFillPaint(vPFSymbolAttributes, n, n2));
            graphics2D.fillRect(n3, n3, n - n3 * 2, n2 - n3 * 2);
        }
        if (vPFSymbolAttributes.isDrawOutline()) {
            graphics2D.setStroke(this.getStroke(vPFSymbolAttributes));
            graphics2D.setPaint(vPFSymbolAttributes.getOutlineMaterial().getDiffuse());
            graphics2D.drawRect(n3, n3, n - n3 * 2, n2 - n3 * 2);
        }
    }

    protected Stroke getStroke(VPFSymbolAttributes vPFSymbolAttributes) {
        BasicStroke basicStroke;
        float f = (float)vPFSymbolAttributes.getOutlineWidth() + 0.5f;
        if (vPFSymbolAttributes.getOutlineStippleFactor() > 0) {
            int n;
            ArrayList<Float> arrayList = new ArrayList<Float>();
            short s = vPFSymbolAttributes.getOutlineStipplePattern();
            int n2 = 0;
            int n3 = 1;
            for (int i = 0; i < 16; ++i) {
                int n4 = n = (s << i & 0x8000) > 0 ? 1 : 0;
                if (n != n3) {
                    arrayList.add(Float.valueOf(n2));
                    n2 = vPFSymbolAttributes.getOutlineStippleFactor();
                    n3 = n;
                    continue;
                }
                n2 += vPFSymbolAttributes.getOutlineStippleFactor();
            }
            arrayList.add(Float.valueOf(n2));
            float[] fArray = new float[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                fArray[n] = ((Float)arrayList.get(n)).floatValue();
            }
            basicStroke = new BasicStroke(f, 1, 1, 10.0f, fArray, 0.0f);
        } else {
            basicStroke = new BasicStroke(f);
        }
        return basicStroke;
    }

    protected Paint getFillPaint(VPFSymbolAttributes vPFSymbolAttributes, int n, int n2) {
        if (vPFSymbolAttributes.getImageSource() == null) {
            return vPFSymbolAttributes.getInteriorMaterial().getDiffuse();
        }
        BufferedImage bufferedImage = this.getImage(vPFSymbolAttributes.getImageSource());
        if (bufferedImage != null) {
            return new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        return vPFSymbolAttributes.getInteriorMaterial().getDiffuse();
    }

    protected BufferedImage getImage(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            Object object2 = WWIO.getFileOrResourceAsStream(string, this.getClass());
            if (object2 == null || object2 instanceof Exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionAttemptingToReadImageFile", object2 != null ? object2 : string);
                return null;
            }
            try {
                return ImageIO.read((InputStream)object2);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionAttemptingToReadImageFile", string);
                return null;
            }
        }
        if (object instanceof BufferedImage) {
            return (BufferedImage)object;
        }
        return null;
    }
}

